package gov.va.med.mhv.usermgmt.util.mvi;

import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlOptions;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.mvi.xsd.AD;
import gov.va.med.mhv.mvi.xsd.ActClassControlAct;
import gov.va.med.mhv.mvi.xsd.CD;
import gov.va.med.mhv.mvi.xsd.CE;
import gov.va.med.mhv.mvi.xsd.COCTMT090100UV01AssignedPerson;
import gov.va.med.mhv.mvi.xsd.COCTMT090100UV01Person;
import gov.va.med.mhv.mvi.xsd.CS;
import gov.va.med.mhv.mvi.xsd.CommunicationFunctionType;
import gov.va.med.mhv.mvi.xsd.EN;
import gov.va.med.mhv.mvi.xsd.EntityClassDevice;
import gov.va.med.mhv.mvi.xsd.II;
import gov.va.med.mhv.mvi.xsd.INT;
import gov.va.med.mhv.mvi.xsd.IVLTS;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Device;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Receiver;
import gov.va.med.mhv.mvi.xsd.MCCIMT000100UV01Sender;
import gov.va.med.mhv.mvi.xsd.PRPAIN201305UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201305UV02Document.PRPAIN201305UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201305UV02QUQIMT021001UV01ControlActProcess;
import gov.va.med.mhv.mvi.xsd.PRPAMT201306UV02LivingSubjectAdministrativeGender;
import gov.va.med.mhv.mvi.xsd.PRPAMT201306UV02LivingSubjectBirthTime;
import gov.va.med.mhv.mvi.xsd.PRPAMT201306UV02LivingSubjectId;
import gov.va.med.mhv.mvi.xsd.PRPAMT201306UV02LivingSubjectName;
import gov.va.med.mhv.mvi.xsd.PRPAMT201306UV02ParameterList;
import gov.va.med.mhv.mvi.xsd.PRPAMT201306UV02PatientAddress;
import gov.va.med.mhv.mvi.xsd.PRPAMT201306UV02QueryByParameter;
import gov.va.med.mhv.mvi.xsd.QUQIMT021001UV01DataEnterer;
import gov.va.med.mhv.mvi.xsd.TS;
import gov.va.med.mhv.mvi.xsd.XActMoodIntentEvent;
import gov.va.med.mhv.usermgmt.common.enums.GenderEnumeration;
import gov.va.med.mhv.usermgmt.service.handler.MviProperties;

@Component
public class CreateMVIPatientSearchRequest {

	private final Logger log = LogManager.getLogger(CreateMVIPatientSearchRequest.class);

	@SuppressWarnings("rawtypes")
	public Object createPatientSearchXMLRequest(UserProfile userProfile, MviProperties properties, String versionInfo) {
		if (properties.getIsMviMockSearchEnabled())
			return createMockPatientSearchXMLRequest();

		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
		String dataEntererId = "";
		String given = "";
		String family = "";
		
		if(versionInfo != null) {
			String[] versionProps = versionInfo.split(",");
			for (String prop : versionProps) {
				if(prop.startsWith("dataEntererId")) {
					dataEntererId = prop.split("=")[1];
				} else if(prop.startsWith("given")) {
					given = prop.split("=")[1];
				} else if(prop.startsWith("family")) {
					family = prop.split("=")[1];
				}
			}
		}
		
		PRPAIN201305UV02Document root1305Doc = PRPAIN201305UV02Document.Factory.newInstance();
		PRPAIN201305UV02 root1305Req = root1305Doc.addNewPRPAIN201305UV02();

		root1305Req.setITSVersion(MviConstants.MVI_XML_REQ_ITS_VERSION);
		/*
		<urn:id root="2.16.840.1.113883.3.933" extension="MCID-12345"/>
			<urn:creationTime value="20070428150301 "/>
			<urn:interactionId root="2.16.840.1.113883.1.6"
		 */
		II rootId = root1305Req.addNewId();
		rootId.setRoot(properties.getMviRootId());

		String mcidExtension = MviUtil.getMCIDExtension();
		long mcidUniqValue = MviUtil.getUniqueId();

		rootId.setExtension(mcidExtension + String.valueOf(mcidUniqValue));

		TS creationTime = root1305Req.addNewCreationTime();
		creationTime.setValue(MviUtil.getCreationTime());

		II interactionId = root1305Req.addNewInteractionId();
		interactionId.setRoot(properties.getMviInteractionId());
		interactionId.setExtension(MviConstants.MVI_INTERACTION_SEARCH_TYPE);
		/*
		    <urn:processingCode code="T "/>
		    <urn:processingModeCode code="R "/>
		    <urn:acceptAckCode code="AL "/>
		 */
		CS processingCode = root1305Req.addNewProcessingCode();
		if (properties.getMviEnvType().equalsIgnoreCase("prod"))
			processingCode.setCode(MviConstants.MVI_PROCESSING_PROD_CODE);
		else
			processingCode.setCode(MviConstants.MVI_PROCESSING_NONPROD_CODE);
		CS processingModeCode = root1305Req.addNewProcessingModeCode();
		processingModeCode.setCode(MviConstants.MVI_PROCESSING_MODE_CODE);

		CS acceptAckCode = root1305Req.addNewAcceptAckCode();
		acceptAckCode.setCode(MviConstants.MVI_ACCEPT_ACK_CODE);
		/*
		<urn:receiver typeCode="RCV">
		    <urn:device classCode="DEV" determinerCode="INSTANCE">
		        <urn:id root="2.16.840.1.113883.4.349 "/>
		        <urn:telecom value="https://example.org/PatientFeed"/>
		    </urn:device>
		</urn:receiver>
		 */
		MCCIMT000100UV01Receiver receiver = root1305Req.addNewReceiver();
		receiver.setTypeCode(CommunicationFunctionType.RCV);
		MCCIMT000100UV01Device device = receiver.addNewDevice();
		device.setClassCode(EntityClassDevice.DEV);
		device.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		II deviceId = device.addNewId();
		deviceId.setRoot(properties.getVaOidValue());
		// TEL deviceTelecom = device.addNewTelecom();
		// deviceTelecom.setValue("http://servicelocation/PDQuery");

		/*
		<urn:sender typeCode="SND">
		    <urn:device classCode="DEV" determinerCode="INSTANCE">
		        <urn:id extension="200MH " root="2.16.840.1.113883.3.933"/>
		    </urn:device>
		</urn:sender>
		 */
		MCCIMT000100UV01Sender sender = root1305Req.addNewSender();
		sender.setTypeCode(CommunicationFunctionType.SND);
		MCCIMT000100UV01Device senderDevice = sender.addNewDevice();
		senderDevice.setClassCode(EntityClassDevice.DEV);
		senderDevice.setDeterminerCode(MviConstants.MVI_DETERMINER_CODE);
		II senderId = senderDevice.addNewId();
		senderId.setExtension(properties.getMviReceivingFacilityId());
		senderId.setRoot(properties.getMviRootId());

		/*
		<urn:controlActProcess classCode="CACT" moodCode="EVN">
		<urn:code codeSystem="2.16.840.1.113883.1.6" code="PRPA_TE201305UV02"/>
		<urn:queryByParameter>

		 */
		PRPAIN201305UV02QUQIMT021001UV01ControlActProcess controlActProcess = root1305Req.addNewControlActProcess();
		root1305Req.setControlActProcess(controlActProcess);
		controlActProcess.setClassCode(ActClassControlAct.CACT);
		controlActProcess.setMoodCode(XActMoodIntentEvent.EVN);
		
		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
		if(versionInfo != null) {
			QUQIMT021001UV01DataEnterer dataEnterer = controlActProcess.addNewDataEnterer();
			dataEnterer.setContextControlCode("AP");
			dataEnterer.setTypeCode("ENT");
			COCTMT090100UV01AssignedPerson assignedPersons = dataEnterer.addNewAssignedPerson();
			assignedPersons.setClassCode("ASSIGNED");
			
			II assignedPersonDataEntererId = assignedPersons.addNewId();
			
			if(dataEntererId != null && dataEntererId.length() > 0) {
				assignedPersonDataEntererId.setExtension(dataEntererId);
			}

			assignedPersonDataEntererId.setRoot(properties.getMviRootId());
			
			COCTMT090100UV01Person assignedPerson = assignedPersons.addNewAssignedPerson();
			assignedPerson.setDeterminerCode("INSTANCE");
			assignedPerson.setClassCode("PSN");
			EN en = assignedPerson.addNewName();
			if(given != null && given.length() > 0) {
				en.addGiven(given);
			}
			
			if(family != null && family.length() > 0) {
				en.addFamily(family);
			}
		}
		
		CD controlCode = controlActProcess.addNewCode();
		controlCode.setCodeSystem(properties.getMviInteractionId());
		controlCode.setCode(MviConstants.MVI_SEARCH_CONTROL_CODE);

		/*
		<urn:queryId root="2.16.840.1.113883.3.933" extension="18204"/>
		<urn:statusCode code="new"/>
		<urn:initialQuantity value="1"/>
		 */
		PRPAMT201306UV02QueryByParameter controlQueryParameter = controlActProcess.addNewQueryByParameter();
		II controlQueryId = controlQueryParameter.addNewQueryId();
		controlQueryId.setRoot(properties.getMviRootId());
		controlQueryId.setExtension(String.valueOf(mcidUniqValue));

		CS controlStatusCode = controlQueryParameter.addNewStatusCode();
		controlStatusCode.setCode(MviConstants.MVI_NEW_STATUS_CODE);
		INT initialQuantity = controlQueryParameter.addNewInitialQuantity();
		initialQuantity.setValue(new BigInteger("1"));
		CS modifyCode = controlQueryParameter.addNewModifyCode();
		modifyCode.setCode("MVI.COMP1");
		PRPAMT201306UV02ParameterList parameterList = controlQueryParameter.addNewParameterList();

		/*
		<livingSubjectAdministrativeGender>
		<value code="M" />
		<semanticsText>LivingSubject.administrativeGender</semanticsText>
		</livingSubjejctAdministrativeGender>
		*/
		PRPAMT201306UV02LivingSubjectAdministrativeGender adminGender = parameterList.addNewLivingSubjectAdministrativeGender();
		CE genderCode = adminGender.addNewValue();
		if (userProfile.getGender().equalsIgnoreCase(GenderEnumeration.MALE.getDescription()))
			genderCode.setCode(MviConstants.MVI_MALE_GENDER_CODE);
		else if (userProfile.getGender().equalsIgnoreCase(GenderEnumeration.FEMALE.getDescription()))
			genderCode.setCode(MviConstants.MVI_FEMALE_GENDER_CODE);
		adminGender.setSemanticsText(MviConstants.MVI_LIVING_SUB_ADMIN_GENDER);
		/*
		<livingSubjectBirthTime>
			<value value="19550512" />
			<semanticsText>LivingSubject..birthTime</semanticsText>
		</livingSubjectBirthTime>
		*/
		PRPAMT201306UV02LivingSubjectBirthTime livingSubjectBirthTime = parameterList.addNewLivingSubjectBirthTime();
		IVLTS birthTimeValue = livingSubjectBirthTime.addNewValue();
		SimpleDateFormat dateformatYYYYMMDD = new SimpleDateFormat("yyyyMMdd");
		StringBuilder nowYYYYMMDD = new StringBuilder(dateformatYYYYMMDD.format(userProfile.getBirthDate()));
		birthTimeValue.setValue(nowYYYYMMDD.toString());
		livingSubjectBirthTime.setSemanticsText(MviConstants.MVI_LIVING_SUB_BIRTHTIME);
		/*
		<livingSubjectId>
			<value root="2.16.840.1.113883.4.1" extension="111223333" />
		</livingSubjectId>
		*/
		PRPAMT201306UV02LivingSubjectId livingSubjectId = parameterList.addNewLivingSubjectId();
		II subjectId = livingSubjectId.addNewValue();
		subjectId.setRoot(properties.getMviUsssaIdentifierId());
		String formattedSSN = userProfile.getSsn().replaceAll("[\\s\\-()]", "");
		subjectId.setExtension(formattedSSN);
		// subjectId.setExtension("014193804");
		livingSubjectId.setSemanticsText(MviConstants.MVI_LIVING_SUB_SSN_ID);
		/*
		<livingSubjectName>
		<value use="L">
		    <given>Clark</given>
		    <given>Micheal</given>
		    <prefix>Dr.</prefix>
		    <suffix>IV</suffix>
		    <family>Kent</family>
		</value>
		<semanticsText>LivingSubject.name</semanticsText>
		</livingSubjectName>
		*/
		PRPAMT201306UV02LivingSubjectName livingSubjectName = parameterList.addNewLivingSubjectName();
		EN subjectValue = livingSubjectName.addNewValue();
		List<String> nameTypelist = new ArrayList<String>();
		nameTypelist.add("L");
		subjectValue.setUse(nameTypelist);
		String givenName1 = userProfile.getFirstName();
		String[] givenNameArray;
		if (null != userProfile.getMiddleName() && userProfile.getMiddleName().length() > 0) {
			String givenName2 = userProfile.getMiddleName();
			givenNameArray = new String[] {
				givenName1, givenName2
			};
		} else
			givenNameArray = new String[] {
				givenName1
			};
		subjectValue.setGivenArray(givenNameArray);
		if (userProfile.getTitle() != null) {
			String prefix = userProfile.getTitle();
			String[] prefixArray = new String[] {
				prefix
			};
			subjectValue.setPrefixArray(prefixArray);
		}
		if (userProfile.getSuffix() != null) {
			String suffix = userProfile.getSuffix();
			String[] suffixArray = new String[] {
				suffix
			};
			subjectValue.setSuffixArray(suffixArray);
		}

		String familyName = userProfile.getLastName();
		String[] familyNameArray = new String[] {
			familyName
		};
		subjectValue.setFamilyArray(familyNameArray);
		livingSubjectName.setSemanticsText(MviConstants.MVI_LIVING_SUB_NAME);
		/*
		<patientAddress>
		<value use="PHYS">
		    <streetAddressLine>Street1</streetAddressLine>
		    <streetAddressLine>Street2</streetAddressLine>
		    <streetAddressLine>Street3</streetAddressLine>
		    <streetAddressLine>Street4</streetAddressLine>
		    <city>Miami</city>
		    <state>FL</state>
		    <postalCode>33123</postalCode>
		    <country>USA</country>
		</value>
		<semanticsText />
		</patientAddress>
		*/

		// Printing the Request XML For fine output
		XmlOptions options = new XmlOptions();
		options.put(XmlOptions.LOAD_LINE_NUMBERS);
		options.setSavePrettyPrint();
		options.setSavePrettyPrintIndent(4);
		if (log.isDebugEnabled()) {
			log.debug("MVI Patient Search Request 1305Doc \n" + root1305Doc.xmlText(options));
		}

		// TEST the validity of an XML
		List validationErrors = new ArrayList();
		options.setErrorListener(validationErrors);

		boolean valid = root1305Doc.validate(options);
		if (valid) {
			if (log.isDebugEnabled()) {
				log.debug("Its valid 1305 Search Request xml");
			}
		} else {
			// CR1964 - Make sure that the code doesn't go into the infinite loop.
			Iterator itr = validationErrors.iterator();
			if (log.isDebugEnabled()) {
				while (itr.hasNext()) {
					log.error("Not a valid 1305 Search xml : " + itr.next().toString());
				}
			}
		}
		return root1305Doc.xmlText();
	}

	@SuppressWarnings("rawtypes")
	public Object createMockPatientSearchXMLRequest() {

		PRPAIN201305UV02Document root1305Doc = PRPAIN201305UV02Document.Factory.newInstance();
		PRPAIN201305UV02 root1305Req = root1305Doc.addNewPRPAIN201305UV02();

		root1305Req.setITSVersion("XML_1.0");

		II rootId = root1305Req.addNewId();
		rootId.setRoot("2.16.840.1.113883.3.933");
		rootId.setExtension("MCID-12345");

		TS creationTime = root1305Req.addNewCreationTime();
		creationTime.setValue("20070428150301");

		II interactionId = root1305Req.addNewInteractionId();
		interactionId.setRoot("2.16.840.1.113883.1.6");
		interactionId.setExtension("PRPA_IN201305UV02");

		CS processingCode = root1305Req.addNewProcessingCode();
		processingCode.setCode("T");
		CS processingModeCode = root1305Req.addNewProcessingModeCode();
		processingModeCode.setCode("T");

		CS acceptAckCode = root1305Req.addNewAcceptAckCode();
		acceptAckCode.setCode("AL");

		MCCIMT000100UV01Receiver receiver = root1305Req.addNewReceiver();
		receiver.setTypeCode(CommunicationFunctionType.RCV);
		MCCIMT000100UV01Device device = receiver.addNewDevice();
		device.setClassCode(EntityClassDevice.DEV);
		device.setDeterminerCode("INSTANCE");
		II deviceId = device.addNewId();
		deviceId.setRoot("2.16.840.1.113883.4.349");
		// TEL deviceTelecom = device.addNewTelecom();
		// deviceTelecom.setValue("http://servicelocation/PDQuery");

		MCCIMT000100UV01Sender sender = root1305Req.addNewSender();
		sender.setTypeCode(CommunicationFunctionType.SND);
		MCCIMT000100UV01Device senderDevice = sender.addNewDevice();
		senderDevice.setClassCode(EntityClassDevice.DEV);
		senderDevice.setDeterminerCode("INSTANCE");
		II senderId = senderDevice.addNewId();
		senderId.setExtension("200MH");
		senderId.setRoot("2.16.840.1.113883.3.933");

		PRPAIN201305UV02QUQIMT021001UV01ControlActProcess controlActProcess = root1305Req.addNewControlActProcess();
		root1305Req.setControlActProcess(controlActProcess);
		controlActProcess.setClassCode(ActClassControlAct.CACT);
		controlActProcess.setMoodCode(XActMoodIntentEvent.EVN);
		CD controlCode = controlActProcess.addNewCode();
		controlCode.setCodeSystem("2.16.840.1.113883.1.6");
		controlCode.setCode("PRPA_TE201305UV02");

		PRPAMT201306UV02QueryByParameter controlQueryParameter = controlActProcess.addNewQueryByParameter();
		II controlQueryId = controlQueryParameter.addNewQueryId();
		controlQueryId.setRoot("2.16.840.1.113883.3.933");
		controlQueryId.setExtension("18204");

		CS controlStatusCode = controlQueryParameter.addNewStatusCode();
		controlStatusCode.setCode("new");
		INT initialQuantity = controlQueryParameter.addNewInitialQuantity();
		initialQuantity.setValue(new BigInteger("1"));
		CS modifyCode = controlQueryParameter.addNewModifyCode();
		modifyCode.setCode("MVI.COMP1");
		PRPAMT201306UV02ParameterList parameterList = controlQueryParameter.addNewParameterList();

		/*
		<livingSubjectAdministrativeGender>
		<value code="M" />
		<semanticsText>LivingSubject.administrativeGender</semanticsText>
		</livingSubjejctAdministrativeGender>
		*/
		PRPAMT201306UV02LivingSubjectAdministrativeGender adminGender = parameterList.addNewLivingSubjectAdministrativeGender();
		CE genderCode = adminGender.addNewValue();
		genderCode.setCode("M");
		adminGender.setSemanticsText("LivingSubject.administrativeGender");
		/*
		<livingSubjectBirthTime>
			<value value="19550512" />
			<semanticsText>LivingSubject..birthTime</semanticsText>
		</livingSubjectBirthTime>
		*/
		PRPAMT201306UV02LivingSubjectBirthTime livingSubjectBirthTime = parameterList.addNewLivingSubjectBirthTime();
		IVLTS birthTimeValue = livingSubjectBirthTime.addNewValue();
		birthTimeValue.setValue("19190811");
		livingSubjectBirthTime.setSemanticsText("LivingSubject.birthTime");
		/*
		<livingSubjectId>
			<value root="2.16.840.1.113883.4.1" extension="111223333" />
		</livingSubjectId>
		*/
		PRPAMT201306UV02LivingSubjectId livingSubjectId = parameterList.addNewLivingSubjectId();
		II subjectId = livingSubjectId.addNewValue();
		subjectId.setRoot("2.16.840.1.113883.4.1");
		subjectId.setExtension("014193804");
		livingSubjectId.setSemanticsText("LivingSubject.id");
		/*
		<livingSubjectName>
		<value use="L">
		    <given>Clark</given>
		    <given>Micheal</given>
		    <prefix>Dr.</prefix>
		    <suffix>IV</suffix>
		    <family>Kent</family>
		</value>
		<semanticsText>LivingSubject.name</semanticsText>
		</livingSubjectName>
		*/
		PRPAMT201306UV02LivingSubjectName livingSubjectName = parameterList.addNewLivingSubjectName();
		EN subjectValue = livingSubjectName.addNewValue();
		List<String> nameTypelist = new ArrayList<String>();
		nameTypelist.add("L");
		subjectValue.setUse(nameTypelist);
		String givenName1 = "OTTO";
		String[] givenNameArray = new String[] {
			givenName1
		};
		subjectValue.setGivenArray(givenNameArray);
		String prefix = "Dr.";
		String[] prefixArray = new String[] {
			prefix
		};
		subjectValue.setPrefixArray(prefixArray);
		String suffix = "IV";
		String[] suffixArray = new String[] {
			suffix
		};
		subjectValue.setSuffixArray(suffixArray);
		String familyName = "Garg";
		String[] familyNameArray = new String[] {
			familyName
		};
		subjectValue.setFamilyArray(familyNameArray);
		livingSubjectName.setSemanticsText("LivingSubject.name");
		/*
		<patientAddress>
		<value use="PHYS">
		    <streetAddressLine>Street1</streetAddressLine>
		    <streetAddressLine>Street2</streetAddressLine>
		    <streetAddressLine>Street3</streetAddressLine>
		    <streetAddressLine>Street4</streetAddressLine>
		    <city>Miami</city>
		    <state>FL</state>
		    <postalCode>33123</postalCode>
		    <country>USA</country>
		</value>
		<semanticsText />
		</patientAddress>
		*/
		PRPAMT201306UV02PatientAddress patientAddress = parameterList.addNewPatientAddress();
		AD patientAddressValue = patientAddress.addNewValue();
		List<String> addrlist = new ArrayList<String>();
		addrlist.add("PHYS");
		patientAddressValue.setUse(addrlist);
		String streetAddressLine1 = "88 TRAIN ST";
		// String streetAddressLine2="Street1";
		String[] streetAddressLineArray = new String[] {
			streetAddressLine1
		};
		patientAddressValue.setStreetAddressLineArray(streetAddressLineArray);
		String addressCity = "DORCHESTER";
		String[] addressCityArray = new String[] {
			addressCity
		};
		patientAddressValue.setCityArray(addressCityArray);
		String addressState = "MA";
		String[] addressStateArray = new String[] {
			addressState
		};
		patientAddressValue.setStateArray(addressStateArray);
		String addressPostalCode = "02122";
		String[] addressPostalCodeArray = new String[] {
			addressPostalCode
		};
		patientAddressValue.setPostalCodeArray(addressPostalCodeArray);
		String addressCountry = "USA";
		String[] addressCountryArray = new String[] {
			addressCountry
		};
		patientAddressValue.setCountryArray(addressCountryArray);

		patientAddress.setSemanticsText("LivingSubject.patientAddress");

		// Printing the Request XML For fine output
		XmlOptions options = new XmlOptions();
		options.put(XmlOptions.LOAD_LINE_NUMBERS);
		options.setSavePrettyPrint();
		options.setSavePrettyPrintIndent(4);
		if (log.isDebugEnabled())
			log.debug("\n" + root1305Doc.xmlText(options));

		// TEST the validity of an XML
		List validationErrors = new ArrayList();
		options.setErrorListener(validationErrors);

		boolean valid = root1305Doc.validate(options);
		if (valid) {
			if (log.isDebugEnabled())
				log.debug("Its valid 1305 Search Request xml");
		} else {
			Iterator itr = validationErrors.iterator();
			if (log.isDebugEnabled()) {
				while (itr.hasNext()) {
					log.error("Not a valid xml file : " + itr.next().toString());
				}
			}
		}
		return root1305Doc.xmlText();
	}
}
