/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.model.UserProfileDeactivationReason;
import gov.va.med.mhv.usermgmt.data.repository.UserProfileDeactivationReasonRepository;

@Component
public class UserProfileDeactivationUtils {

	private static final Log log = LogFactory.getLog(UserProfileDeactivationUtils.class);

	//TODO: need to load the below static values from a property file??
	public static final String STATE_CHANGED_BY_SYSTEM = "System";

	public static final String MPI_PATIENT_MERGE_NAME = "MVI Merge Request";

	public static final String MULTIPLE_ACCOUNTS_RESOLUTION_NAME = "Multiple MHV Accounts Resolution";

	// JAZZ Defect# 20309: If there four or more traits update, DO NOT Update
	// the user and deactivate the user.
	public static final String A31_POSSIBLE_ICN_MISMATCH_DO_NOT_REACTIVATE_NAME = "A31 possible ICN Mismatch (do not reactivate)";

	public static final String A43_POSSIBLE_ICN_MISMATCH_DO_NOT_REACTIVATE_NAME =
		"A43 possible ICN Mismatch due to patient having same ICN as another patient - (Do Not Reactivate)";

	@Autowired
	private UserProfileDeactivationReasonRepository reasonRepository;

	public UserProfileDeactivationReason findReason(String name, ResponseUtil response) {
		return findReason(name, false, response);
	}

	private UserProfileDeactivationReason findReason(String name, boolean createIfNotFound, ResponseUtil response) {
		Precondition.assertNotBlank("name", name);

		UserProfileDeactivationReason reason = null;

		try {
			reason = reasonRepository.findUserProfileDeactivationReasonByName(name);
		} catch (Exception e) {
			log.error("Unable to load UserProfileDeactivationReason with name '" + name + "'.", e);
			response.setFailure(false);
			response.setFailureMessage(e.getMessage());
			return null;
		}

		if (reason != null) {
			return reason;
		}

		if (createIfNotFound) {
			// create a reason instance, if it doen't exists
			reason = new UserProfileDeactivationReason();
			reason.setName(name);
			try {
				reasonRepository.save(reason);
			} catch (Exception e) {
				log.error("Unable to store UserProfileDeactivationReason with name '" + name + "'.", e);
				response.setFailure(false);
				response.setFailureMessage(e.getMessage());
				return null;
			}

			if (reason != null) {
				return reason;
			}
		}
		log.fatal("Unable to find and/or create UserProfileDeactivationReason " + "with name '" + name + "'.");
		return null; // unreachable
	}
}
