package gov.va.med.mhv.usermgmt.util;

import java.io.Serializable;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

@Component
@PropertySource("classpath:usermgmt.messages.properties")
public class MessagesUtil implements Serializable {

	private static final long serialVersionUID = -1914395000054957031L;

	@Value("${mvi.basic.success.response.summary}")
	private String mviBasicSuccessResponse;

	@Value("${mvi.advanced.success.response.summary}")
	private String mviAdvancedSuccessResponse;

	@Value("${mvi.update.advanced.success.response.summary}")
	private String mviUpdateAdvancedSuccessResponse;

	@Value("${mvi.update.parse.response.issue.summary}")
	private String mviUpdateParseResponseIssue;

	@Value("${patient.is.not.uncorrelated.summary}")
	private String patientIsNotUncorrelated;

	@Value("${patient.is.not.correlated.summary}")
	private String patientIsNotCorrelated;

	@Value("${patient.is.not.pending.correlation.summary}")
	private String patientIsNotPendingCorrelation;

	@Value("${patient.is.not.pending.uncorrelation.summary}")
	private String patientIsNotPendingUncorrelation;

	@Value("${mvi.helpdesk.correlationremoval.success.summary}")
	private String mviHelpdeskCorrelationremovalSuccess;

	@Value("${mvi.helpdesk.correlationremoval.error.summary}")
	private String mviHelpdeskCorrelationremovalError;

	@Value("${mvi.ipa.match.keyattributes.null.error.summary}")
	private String mviIpaMatchKeyattributesNullError;

	@Value("${mvi.ipa.match.duplicate.error.summary}")
	private String mviIpaMatchDuplicateError;

	@Value("${mvi.ipa.match.communication.error.summary}")
	private String mviIpaMatchCommunicationError;

	@Value("${mvi.ipa.match.error.summary}")
	private String mviIpaMatchError;

	@Value("${mvi.ipa.correlation.success.summary}")
	private String mviIpaCorrelationSuccess;

	@Value("${facility.not.found.summary}")
	private String facilityNotFound;

	@Value("${facility.multiple.found.summary}")
	private String facilityMultipleFound;

	@Value("${mvi.ipa.correlation.error.summary}")
	private String mviIpaCorrelationError;

	@Value("${mvi.ipa.match.icn.duplicate.error.summary}")
	private String mviIpaMatchIcnDuplicateError;

	@Value("${mvi.ipa.match.error.userprofile.save.summary}")
	private String mviIpaMatchErrorUserprofileSave;

	@Value("${mvi.ipa.match.queryerror.error.summary}")
	private String mviIpaMatchQueryerrorError;

	@Value("${mvi.ipa.match.applicationerror.error.summary}")
	private String mviIpaMatchApplicationerrorError;

	// @Value("${ipa.patient.not.found.summary}")
	// private String patientNotFound;

	@Value("${patient.duplicate.entries.summary}")
	private String duplicatePatients;

	@Value("${patient.registry.access.error.summary}")
	private String patientRegistryAccessError;

	@Value("${patient.not.found.summary}")
	private String patientNotFound;

	@Value("${mvi.parse.response.ae.issue.summary}")
	private String mviParseResponseAeIssue;

	@Value("${mvi.parse.response.issue.summary}")
	private String mviParseResponseIssue;

	@Value("${mvi.parse.response.ae.issue.reg.summary}")
	private String mviParseResponseAeIssueReg;

	@Value("${mvi.update.advanced.failure.response.summary}")
	private String mviUpdateAdvancedFailureResponse;

	@Value("${mvi.patient.not.found.summary}")
	private String mviPatientNotFound;

	@Value("${mvi.advanced.account.exist.summary}")
	private String mviAdvancedAccountExist;

	@Value("${mvi.ipa.correlation.communication.error.summary}")
	private String mviIpaCorrelationCommunicationError;

	@Value("${mvi.ipa.uncorrelation.error.summary}")
	private String mviIpaUncorrelationError;

	@Value("${mvi.ipa.uncorrelation.success.summary}")
	private String mviIpaUncorrelationSuccess;

	@Value("${user.does.not.exist.summary}")
	private String userDoesNotExist;

	@Value("${unknown.exception.occurred.summary}")
	private String unknownExceptionOccurred;

	@Value("${mvi.ipa.match.notfound.error.summary}")
	private String mviIpaMatchNotfoundError;

	@Value("${user.already.exists.summary}")
	private String userAlreadyExists;

	@Value("${employee.search.failed.summary}")
	private String employeeSearchFailed;

	@Value("${mvi.multi.trait.update.error.invalidate.error.reason.missing.summary}")
	private String mviMultiTraitUpdateErrorInvalidateErrorReasonMissing;

	@Value("${mvi.multi.trait.update.error.invalidate.fail.summary}")
	private String mviMultiTraitUpdateErrorInvalidateFail;

	// TODO: Fix error message
	@Value("${mvi.helpdesk.devalidate.error.reason.missing.summary}")
	private String mviHelpdeskDevalidateErrorReasonMissing;

	// TODO: Fix error message
	@Value("${mvi.helpdesk.devalidate.error.description.missing.summary}")
	private String mviHelpdeskDevalidateErrorDescriptionMissing;

	@Value("${imprecise.birth.date}")
	private String impreciseBirthDate;

	public String getPatientIsNotUncorrelated() {
		return patientIsNotUncorrelated;
	}

	public String getPatientIsNotCorrelated() {
		return patientIsNotCorrelated;
	}

	public void setPatientIsNotCorrelated(String patientIsNotCorrelated) {
		this.patientIsNotCorrelated = patientIsNotCorrelated;
	}

	public String getPatientIsNotPendingCorrelation() {
		return patientIsNotPendingCorrelation;
	}

	public void setPatientIsNotPendingCorrelation(String patientIsNotPendingCorrelation) {
		this.patientIsNotPendingCorrelation = patientIsNotPendingCorrelation;
	}

	public String getPatientIsNotPendingUncorrelation() {
		return patientIsNotPendingUncorrelation;
	}

	public void setPatientIsNotPendingUncorrelation(String patientIsNotPendingUncorrelation) {
		this.patientIsNotPendingUncorrelation = patientIsNotPendingUncorrelation;
	}

	public String getDuplicatePatients() {
		return duplicatePatients;
	}

	public void setDuplicatePatients(String duplicatePatients) {
		this.duplicatePatients = duplicatePatients;
	}

	public String getPatientRegistryAccessError() {
		return patientRegistryAccessError;
	}

	public void setPatientRegistryAccessError(String patientRegistryAccessError) {
		this.patientRegistryAccessError = patientRegistryAccessError;
	}

	public String getPatientNotFound() {
		return patientNotFound;
	}

	public void setPatientNotFound(String patientNotFound) {
		this.patientNotFound = patientNotFound;
	}

	public String getMviParseResponseAeIssue() {
		return mviParseResponseAeIssue;
	}

	public void setMviParseResponseAeIssue(String mviParseResponseAeIssue) {
		this.mviParseResponseAeIssue = mviParseResponseAeIssue;
	}

	public String getMviParseResponseIssue() {
		return mviParseResponseIssue;
	}

	public void setMviParseResponseIssue(String mviParseResponseIssue) {
		this.mviParseResponseIssue = mviParseResponseIssue;
	}

	public String getMviUpdateAdvancedFailureResponse() {
		return mviUpdateAdvancedFailureResponse;
	}

	public void setMviUpdateAdvancedFailureResponse(String mviUpdateAdvancedFailureResponse) {
		this.mviUpdateAdvancedFailureResponse = mviUpdateAdvancedFailureResponse;
	}

	public String getMviPatientNotFound() {
		return mviPatientNotFound;
	}

	public void setMviPatientNotFound(String mviPatientNotFound) {
		this.mviPatientNotFound = mviPatientNotFound;
	}

	public String getMviAdvancedAccountExist() {
		return mviAdvancedAccountExist;
	}

	public void setMviAdvancedAccountExist(String mviAdvancedAccountExist) {
		this.mviAdvancedAccountExist = mviAdvancedAccountExist;
	}

	public String getMviIpaCorrelationCommunicationError() {
		return mviIpaCorrelationCommunicationError;
	}

	public void setMviIpaCorrelationCommunicationError(String mviIpaCorrelationCommunicationError) {
		this.mviIpaCorrelationCommunicationError = mviIpaCorrelationCommunicationError;
	}

	public String getMviIpaUncorrelationError() {
		return mviIpaUncorrelationError;
	}

	public void setMviIpaUncorrelationError(String mviIpaUncorrelationError) {
		this.mviIpaUncorrelationError = mviIpaUncorrelationError;
	}

	public String getMviIpaUncorrelationSuccess() {
		return mviIpaUncorrelationSuccess;
	}

	public void setMviIpaUncorrelationSuccess(String mviIpaUncorrelationSuccess) {
		this.mviIpaUncorrelationSuccess = mviIpaUncorrelationSuccess;
	}

	public String getUserDoesNotExist() {
		return userDoesNotExist;
	}

	public void setUserDoesNotExist(String userDoesNotExist) {
		this.userDoesNotExist = userDoesNotExist;
	}

	public String getUnknownExceptionOccurred() {
		return unknownExceptionOccurred;
	}

	public void setUnknownExceptionOccurred(String unknownExceptionOccurred) {
		this.unknownExceptionOccurred = unknownExceptionOccurred;
	}

	public String getUserAlreadyExists() {
		return userAlreadyExists;
	}

	public void setUserAlreadyExists(String userAlreadyExists) {
		this.userAlreadyExists = userAlreadyExists;
	}

	public String getEmployeeSearchFailed() {
		return employeeSearchFailed;
	}

	public void setEmployeeSearchFailed(String employeeSearchFailed) {
		this.employeeSearchFailed = employeeSearchFailed;
	}

	public void setPatientIsNotUncorrelated(String patientIsNotUncorrelated) {
		this.patientIsNotUncorrelated = patientIsNotUncorrelated;
	}

	public void setMviBasicSuccessResponse(String mviBasicSuccessResponse) {
		this.mviBasicSuccessResponse = mviBasicSuccessResponse;
	}

	public String getMviBasicSuccessResponse() {
		return mviBasicSuccessResponse;
	}

	public String getMviUpdateAdvancedSuccessResponse() {
		return mviUpdateAdvancedSuccessResponse;
	}

	public void setMviUpdateAdvancedSuccessResponse(String mviUpdateAdvancedSuccessResponse) {
		this.mviUpdateAdvancedSuccessResponse = mviUpdateAdvancedSuccessResponse;
	}

	public String getMviUpdateParseResponseIssue() {
		return mviUpdateParseResponseIssue;
	}

	public void setMviUpdateParseResponseIssue(String mviUpdateParseResponseIssue) {
		this.mviUpdateParseResponseIssue = mviUpdateParseResponseIssue;
	}

	public String getMviHelpdeskCorrelationremovalSuccess() {
		return mviHelpdeskCorrelationremovalSuccess;
	}

	public void setMviHelpdeskCorrelationremovalSuccess(String mviHelpdeskCorrelationremovalSuccess) {
		this.mviHelpdeskCorrelationremovalSuccess = mviHelpdeskCorrelationremovalSuccess;
	}

	public String getMviHelpdeskCorrelationremovalError() {
		return mviHelpdeskCorrelationremovalError;
	}

	public void setMviHelpdeskCorrelationremovalError(String mviHelpdeskCorrelationremovalError) {
		this.mviHelpdeskCorrelationremovalError = mviHelpdeskCorrelationremovalError;
	}

	public String getMviIpaMatchKeyattributesNullError() {
		return mviIpaMatchKeyattributesNullError;
	}

	public void setMviIpaMatchKeyattributesNullError(String mviIpaMatchKeyattributesNullError) {
		this.mviIpaMatchKeyattributesNullError = mviIpaMatchKeyattributesNullError;
	}

	public String getMviIpaMatchDuplicateError() {
		return mviIpaMatchDuplicateError;
	}

	public void setMviIpaMatchDuplicateError(String mviIpaMatchDuplicateError) {
		this.mviIpaMatchDuplicateError = mviIpaMatchDuplicateError;
	}

	public String getMviIpaMatchCommunicationError() {
		return mviIpaMatchCommunicationError;
	}

	public void setMviIpaMatchCommunicationError(String mviIpaMatchCommunicationError) {
		this.mviIpaMatchCommunicationError = mviIpaMatchCommunicationError;
	}

	public String getMviIpaMatchNotfoundError() {
		return mviIpaMatchNotfoundError;
	}

	public void setMviIpaMatchNotfoundError(String mviIpaMatchNotfoundError) {
		this.mviIpaMatchNotfoundError = mviIpaMatchNotfoundError;
	}

	public String getMviIpaMatchError() {
		return mviIpaMatchError;
	}

	public void setMviIpaMatchError(String mviIpaMatchError) {
		this.mviIpaMatchError = mviIpaMatchError;
	}

	public String getMviIpaCorrelationSuccess() {
		return mviIpaCorrelationSuccess;
	}

	public void setMviIpaCorrelationSuccess(String mviIpaCorrelationSuccess) {
		this.mviIpaCorrelationSuccess = mviIpaCorrelationSuccess;
	}

	public String getFacilityNotFound() {
		return facilityNotFound;
	}

	public void setFacilityNotFound(String facilityNotFound) {
		this.facilityNotFound = facilityNotFound;
	}

	public String getFacilityMultipleFound() {
		return facilityMultipleFound;
	}

	public void setFacilityMultipleFound(String facilityMultipleFound) {
		this.facilityMultipleFound = facilityMultipleFound;
	}

	public String getMviIpaCorrelationError() {
		return mviIpaCorrelationError;
	}

	public void setMviIpaCorrelationError(String mviIpaCorrelationError) {
		this.mviIpaCorrelationError = mviIpaCorrelationError;
	}

	public String getMviIpaMatchIcnDuplicateError() {
		return mviIpaMatchIcnDuplicateError;
	}

	public void setMviIpaMatchIcnDuplicateError(String mviIpaMatchIcnDuplicateError) {
		this.mviIpaMatchIcnDuplicateError = mviIpaMatchIcnDuplicateError;
	}

	public String getMviIpaMatchErrorUserprofileSave() {
		return mviIpaMatchErrorUserprofileSave;
	}

	public void setMviIpaMatchErrorUserprofileSave(String mviIpaMatchErrorUserprofileSave) {
		this.mviIpaMatchErrorUserprofileSave = mviIpaMatchErrorUserprofileSave;
	}

	public String getMviIpaMatchQueryerrorError() {
		return mviIpaMatchQueryerrorError;
	}

	public void setMviIpaMatchQueryerrorError(String mviIpaMatchQueryerrorError) {
		this.mviIpaMatchQueryerrorError = mviIpaMatchQueryerrorError;
	}

	public String getMviIpaMatchApplicationerrorError() {
		return mviIpaMatchApplicationerrorError;
	}

	public void setMviIpaMatchApplicationerrorError(String mviIpaMatchApplicationerrorError) {
		this.mviIpaMatchApplicationerrorError = mviIpaMatchApplicationerrorError;
	}

	public String getMviMultiTraitUpdateErrorInvalidateErrorReasonMissing() {
		return mviMultiTraitUpdateErrorInvalidateErrorReasonMissing;
	}

	public void setMviMultiTraitUpdateErrorInvalidateErrorReasonMissing(String mviMultiTraitUpdateErrorInvalidateErrorReasonMissing) {
		this.mviMultiTraitUpdateErrorInvalidateErrorReasonMissing = mviMultiTraitUpdateErrorInvalidateErrorReasonMissing;
	}

	public String getMviMultiTraitUpdateErrorInvalidateFail() {
		return mviMultiTraitUpdateErrorInvalidateFail;
	}

	public void setMviMultiTraitUpdateErrorInvalidateFail(String mviMultiTraitUpdateErrorInvalidateFail) {
		this.mviMultiTraitUpdateErrorInvalidateFail = mviMultiTraitUpdateErrorInvalidateFail;
	}

	public String getMviHelpdeskDevalidateErrorReasonMissing() {
		return mviHelpdeskDevalidateErrorReasonMissing;
	}

	public void setMviHelpdeskDevalidateErrorReasonMissing(String mviHelpdeskDevalidateErrorReasonMissing) {
		this.mviHelpdeskDevalidateErrorReasonMissing = mviHelpdeskDevalidateErrorReasonMissing;
	}

	public String getMviHelpdeskDevalidateErrorDescriptionMissing() {
		return mviHelpdeskDevalidateErrorDescriptionMissing;
	}

	public void setMviHelpdeskDevalidateErrorDescriptionMissing(String mviHelpdeskDevalidateErrorDescriptionMissing) {
		this.mviHelpdeskDevalidateErrorDescriptionMissing = mviHelpdeskDevalidateErrorDescriptionMissing;
	}

	public String getMviAdvancedSuccessResponse() {
		return mviAdvancedSuccessResponse;
	}

	public void setMviAdvancedSuccessResponse(String mviAdvancedSuccessResponse) {
		this.mviAdvancedSuccessResponse = mviAdvancedSuccessResponse;
	}

	public String getMviParseResponseAeIssueReg() {
		return mviParseResponseAeIssueReg;
	}

	public void setMviParseResponseAeIssueReg(String mviParseResponseAeIssueReg) {
		this.mviParseResponseAeIssueReg = mviParseResponseAeIssueReg;
	}

	public String getImpreciseBirthDate() {
		return impreciseBirthDate;
	}

	public void setImpreciseBirthDate(String impreciseBirthDate) {
		this.impreciseBirthDate = impreciseBirthDate;
	}
}
