/**
 *
 */
package gov.va.med.mhv.usermgmt.util;

import static gov.va.med.mhv.usermgmt.common.enums.ExtractType.ALLERGY;
import static gov.va.med.mhv.usermgmt.common.enums.ExtractType.APPOINTMENTS;
import static gov.va.med.mhv.usermgmt.common.enums.ExtractType.CHEMISTRYHEMATOLOGY;

import gov.va.med.mhv.usermgmt.common.enums.ExtractType;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public final class ExtractTypeUtils {

    public static boolean isChemistryHematology(ExtractType extractType) {
        Precondition.assertNotNull("extractType", extractType);
        return CHEMISTRYHEMATOLOGY.equals(extractType);
    }

    public static boolean isAllergy(ExtractType extractType) {
        Precondition.assertNotNull("extractType", extractType);
        return ALLERGY.equals(extractType);
    }

    public static boolean isAppointments(ExtractType extractType) {
        Precondition.assertNotNull("extractType", extractType);
        return APPOINTMENTS.equals(extractType);
    }

    public static boolean isAppointments(String extractType) {
        Precondition.assertNotNull("extractType", extractType);
        return APPOINTMENTS.getName().equals(extractType);
    }

	public static ExtractType[] getAllExtractTypes() {
    	return ExtractType.values();
    }

    private ExtractTypeUtils() {
    }

}
