/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import static gov.va.med.mhv.usermgmt.common.enums.AccessPermission.CREATE;
import static gov.va.med.mhv.usermgmt.common.enums.AccessPermission.DELETE;
import static gov.va.med.mhv.usermgmt.common.enums.AccessPermission.DISABLED;
import static gov.va.med.mhv.usermgmt.common.enums.AccessPermission.EXECUTE;
import static gov.va.med.mhv.usermgmt.common.enums.AccessPermission.READ;
import static gov.va.med.mhv.usermgmt.common.enums.AccessPermission.UPDATE;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.mhv.usermgmt.common.enums.AccessPermission;

/**
 * @author Rob Proper (Aquilent Inc.)
 */
//TODO: revisit the class
public final class AccessPermissionUtils {

	private static final Log LOG = LogFactory.getLog(AccessPermissionUtils.class);

	private static final Long DISABLED_PERMISSION = createMask(new AccessPermission[] {
		DISABLED
	});

	public static boolean isDisabled(AccessPermission accessDomain) {
		Precondition.assertNotNull("accessDomain", accessDomain);
		return DISABLED.equals(accessDomain);
	}

	public static boolean isDisabled(String accessDomain) {
		Precondition.assertNotNull("accessDomain", accessDomain);
		return DISABLED.getName().equals(accessDomain);
	}

	public static boolean isDisabled(int accessDomain) {
		return DISABLED.getValue() == accessDomain;
	}

	public static boolean isCreate(AccessPermission accessDomain) {
		Precondition.assertNotNull("accessDomain", accessDomain);
		return CREATE.equals(accessDomain);
	}

	public static boolean isCreate(String accessDomain) {
		Precondition.assertNotNull("accessDomain", accessDomain);
		return CREATE.getName().equals(accessDomain);
	}

	public static boolean isCreate(int accessDomain) {
		return CREATE.getValue() == accessDomain;
	}

	public static boolean isRead(AccessPermission accessDomain) {
		Precondition.assertNotNull("accessDomain", accessDomain);
		return READ.equals(accessDomain);
	}

	public static boolean isRead(String accessDomain) {
		Precondition.assertNotNull("accessDomain", accessDomain);
		return READ.getName().equals(accessDomain);
	}

	public static boolean isRead(int accessDomain) {
		return READ.getValue() == accessDomain;
	}

	public static boolean isUpdate(AccessPermission accessDomain) {
		Precondition.assertNotNull("accessDomain", accessDomain);
		return UPDATE.equals(accessDomain);
	}

	public static boolean isUpdate(String accessDomain) {
		Precondition.assertNotNull("accessDomain", accessDomain);
		return UPDATE.getName().equals(accessDomain);
	}

	public static boolean isUpdate(int accessDomain) {
		return UPDATE.getValue() == accessDomain;
	}

	public static boolean isDelete(AccessPermission accessDomain) {
		Precondition.assertNotNull("accessDomain", accessDomain);
		return DELETE.equals(accessDomain);
	}

	public static boolean isDelete(String accessDomain) {
		Precondition.assertNotNull("accessDomain", accessDomain);
		return DELETE.getName().equals(accessDomain);
	}

	public static boolean isDelete(int accessDomain) {
		return DELETE.getValue() == accessDomain;
	}

	public static boolean isExecute(AccessPermission accessDomain) {
		Precondition.assertNotNull("accessDomain", accessDomain);
		return EXECUTE.equals(accessDomain);
	}

	public static boolean isExecute(String accessDomain) {
		Precondition.assertNotNull("accessDomain", accessDomain);
		return EXECUTE.getName().equals(accessDomain);
	}

	public static boolean isExecute(int accessDomain) {
		return EXECUTE.getValue() == accessDomain;
	}

	public static Long createMask(AccessPermission[] permissions) {
		long combined = 0;
		for (AccessPermission permission : permissions) {
			if (permission != null) {
				combined |= permission.getValue();
			}
		}
		return combined;
	}

	public static int getPermissionValue(AccessPermission permission) {
		return (permission != null) ? permission.getValue() : 0;
	}

	public static boolean hasPermission(AccessPermission permission, Long permissions) {
		LOG.debug("getPermissionValue(permission): " + getPermissionValue(permission));
		LOG.debug("permissions: " + permissions);
		return hasPermission(getPermissionValue(permission), permissions);
	}

	public static boolean hasPermissions(Long permissions, Long hasPermissions) {
		return hasPermission(getPermissionValue(hasPermissions), permissions);
	}

	public static boolean hasPermissions(Long permissions, AccessPermission[] hasPermissions) {
		if ((hasPermissions == null) || (permissions == null)) {
			return false;
		}
		for (AccessPermission permission : hasPermissions) {
			if (!hasPermission(permission, permissions)) {
				return false;
			}
		}
		return true;
	}

	public static String describe(Long permissions) {
		StringBuilder builder = new StringBuilder();
		builder.append(DescriptionBuilder.Properties.COLLECTION_OPEN);
		if (permissions != null) {
			boolean first = true;
			for (AccessPermission permission : AccessPermission.values()) {
				if (hasPermission(permission, permissions)) {
					if (first) {
						first = false;
					} else {
						builder.append(DescriptionBuilder.Properties.SEPARATOR);
					}
					builder.append(permission.getName());
				}
			}
		}
		builder.append(DescriptionBuilder.Properties.COLLECTION_CLOSE);
		return builder.toString();
	}

	public static int getPermissionValue(Long permissions) {
		return (permissions != null) ? permissions.intValue() : 0;
	}

	private static boolean hasPermission(int value, Long permissions) {
		return ((value & filterDisabled(permissions)) == value);
	}

	private static int filterDisabled(Long permissions) {
		final int permissionsValue = ((permissions != null) ? permissions.intValue() : 0);
		return ((DISABLED.getValue() & permissionsValue) == DISABLED.getValue()) ? DISABLED_PERMISSION.intValue() : permissionsValue;
	}

	/**
     * 
     */
	private AccessPermissionUtils() {
	}

}
