/**
 * 
 */
package gov.va.med.mhv.usermgmt.util;

import java.util.Collection;

import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import gov.va.med.mhv.common.data.model.AccessRole;
import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.usermgmt.common.enums.AccessDomainEnum;
import gov.va.med.mhv.usermgmt.common.enums.AccessPermission;
import gov.va.med.mhv.usermgmt.data.model.AccessControl;
import gov.va.med.mhv.usermgmt.data.model.AccessFeature;
import gov.va.med.mhv.usermgmt.data.model.AccessRoleAccessControl;
import gov.va.med.mhv.usermgmt.data.model.UserProfileAccessControl;

/**
 * @author Rob Proper (Aquilent Inc.)
 */
// TODO: revisit the class
public final class AccessControlUtils {

	private static final Log log = LogFactory.getLog(AccessControlUtils.class);

	public static boolean hasAccess(AccessDomainEnum domain, String featureName, AccessPermission permission, AccessControl accessControl) {
//		return (accessControl != null) && (hasFeature(domain, featureName, accessControl)) &&
//			AccessPermissionUtils.hasPermission(permission, accessControl.getPermissions());
		return true;
	}

	public static boolean hasAccess(AccessDomainEnum domain, String featureName, AccessPermission permission, Collection<AccessControl> accessControls) {
//		log.debug("Entered AccessControlUtils::hasAccess");
//		if (accessControls != null) {
//			log.debug("accessControls != null");
//			for (AccessControl accessControl : accessControls) {
//				if (hasFeature(domain, featureName, accessControl)) {
//					log.debug("Entered hasAccess::hasFeature");
//					return AccessPermissionUtils.hasPermission(permission, accessControl.getPermissions());
//				}
//			}
//		}

		return false;
	}

	public static boolean hasAccess(AccessFeature feature, AccessPermission permission, AccessControl accessControl) {
//		return (accessControl != null) && (hasFeature(feature, accessControl)) &&
//			AccessPermissionUtils.hasPermission(permission, accessControl.getPermissions());
		return true;
	}

	public static boolean hasAccess(AccessFeature feature, Long permissions, AccessControl accessControl) {
//		return (accessControl != null) && (hasFeature(feature, accessControl)) &&
//			AccessPermissionUtils.hasPermissions(permissions, accessControl.getPermissions());
		return true;
	}

	public static boolean hasAccess(AccessFeature feature, AccessPermission permission, Collection<AccessControl> accessControls) {
		if (accessControls != null) {
			for (AccessControl accessControl : accessControls) {
				if (hasFeature(feature, accessControl)) {
					return AccessPermissionUtils.hasPermission(permission, accessControl.getPermissions());
				}
			}
		}

		return false;
	}

	public static boolean hasAccess(AccessFeature feature, Long permissions, Collection<AccessControl> accessControls) {
		if (accessControls != null) {
			for (AccessControl accessControl : accessControls) {
				if (hasFeature(feature, accessControl)) {
					return AccessPermissionUtils.hasPermissions(accessControl.getPermissions(), permissions);
				}
			}
		}
		return false;
	}

	public static boolean hasAccess(AccessFeature feature, AccessPermission[] permissions, Collection<AccessControl> accessControls) {
		if (accessControls != null) {
			for (AccessControl accessControl : accessControls) {
				if (hasFeature(feature, accessControl)) {
					return AccessPermissionUtils.hasPermissions(accessControl.getPermissions(), permissions);
				}
			}
		}
		return false;
	}

	public static boolean hasFeature(AccessFeature feature, AccessControl accessControl) {
		Precondition.assertNotNull("feature", feature);
		Precondition.assertNotNull("accessControl", accessControl);
		Precondition.assertNotNull("accessControl.feature", accessControl.getFeature());
		// TODO:: verify
		AccessDomainEnum accessDomain = AccessDomainEnum.valueOf(feature.getAccessDomain().getName());
		return hasFeature(accessDomain, feature.getName(), accessControl);
	}

	public static boolean hasFeature(AccessDomainEnum domain, String featureName, AccessControl accessControl) {
		log.debug("Entered hasFeature()");
		Precondition.assertNotNull("domain", domain);
		Precondition.assertNotBlank("featureName", featureName);
		Precondition.assertNotNull("accessControl", accessControl);
		Precondition.assertNotNull("accessControl.feature", accessControl.getFeature());
		log.debug("accessControl.getFeature().getAccessDomain(): " + accessControl.getFeature().getAccessDomain());
		log.debug("domain: " + domain);
		log.debug("accessControl.getFeature().getName(): " + featureName);
		return accessControl.getFeature().getAccessDomain().equals(domain) && accessControl.getFeature().getName().equals(featureName);
	}

	public static boolean isForRole(AccessRole role, AccessControl accessControl) {
		Precondition.assertNotNull("role", role);
		Precondition.assertNotNull("role.id", role.getId());
		Precondition.assertNotNull("accessControl", accessControl);
		Precondition.assertNotNull("accessControl.roleId", accessControl.getRoleId());
		return role.getId().equals(accessControl.getRoleId());
	}

	public static boolean isForUserProfile(UserProfile userProfile, AccessControl accessControl) {
		Precondition.assertNotNull("userProfile", userProfile);
		Precondition.assertNotNull("userProfile.id", userProfile.getId());
		Precondition.assertNotNull("accessControl", accessControl);
		Precondition.assertNotNull("accessControl.roleId", accessControl.getUserProfileId());
		return userProfile.getId().equals(accessControl.getUserProfileId());
	}

	public static String describe(Collection<AccessControl> accessControls) {
		StringBuilder builder = new StringBuilder();
		builder.append(DescriptionBuilder.Properties.COLLECTION_OPEN);
		if (accessControls != null) {
			boolean first = true;
			for (AccessControl accessControl : accessControls) {
				if (first) {
					first = false;
				} else {
					builder.append(DescriptionBuilder.Properties.SEPARATOR);
				}
				builder.append(describe(accessControl));
			}
		}
		builder.append(DescriptionBuilder.Properties.COLLECTION_CLOSE);
		return builder.toString();
	}

	public static String describe(AccessControl accessControl) {
		StringBuilder builder = new StringBuilder();
		if (accessControl != null) {
			builder.append("AccessControl");
			builder.append(Integer.toHexString(accessControl.hashCode()));
			builder.append(DescriptionBuilder.Properties.PROPERTY_LIST_OPEN);
			builder.append("feature=");
			builder.append(describe(accessControl.getFeature()));
			builder.append(DescriptionBuilder.Properties.PROPERTY_SEPARATOR);
			builder.append("permissions=");
			builder.append(AccessPermissionUtils.describe(accessControl.getPermissions()));
			if (accessControl.getRoleId() != null) {
				builder.append(DescriptionBuilder.Properties.PROPERTY_SEPARATOR);
				builder.append("roleId=");
				builder.append(accessControl.getRoleId());
			}
			if (accessControl.getUserProfileId() != null) {
				builder.append(DescriptionBuilder.Properties.PROPERTY_SEPARATOR);
				builder.append("userProfileId=");
				builder.append(accessControl.getUserProfileId());
			}
			builder.append(DescriptionBuilder.Properties.PROPERTY_LIST_CLOSE);
		} else {
			builder.append("<No AccessControl>");
		}
		return builder.toString();
	}

	public static String describe(AccessRoleAccessControl accessControl) {
		StringBuilder builder = new StringBuilder();
		if (accessControl != null) {
			builder.append("AccessRoleAccessControl");
			builder.append(Integer.toHexString(accessControl.hashCode()));
			builder.append(DescriptionBuilder.Properties.PROPERTY_LIST_OPEN);
			builder.append("feature=");
			builder.append(describe(accessControl.getAccessFeature()));
			builder.append(DescriptionBuilder.Properties.PROPERTY_SEPARATOR);
			builder.append("permissions=");
			builder.append(AccessPermissionUtils.describe(accessControl.getPermissions()));
			builder.append(DescriptionBuilder.Properties.PROPERTY_SEPARATOR);
			builder.append("role=");
			builder.append(describe(accessControl.getAccessRole()));
			builder.append(DescriptionBuilder.Properties.PROPERTY_LIST_CLOSE);
		} else {
			builder.append("<No AccessRoleAccessControl>");
		}
		return builder.toString();
	}

	public static String describe(UserProfileAccessControl accessControl) {
		StringBuilder builder = new StringBuilder();
		if (accessControl != null) {
			builder.append("UserProfileAccessControl");
			builder.append(Integer.toHexString(accessControl.hashCode()));
			builder.append(DescriptionBuilder.Properties.PROPERTY_LIST_OPEN);
			builder.append("feature=");
			builder.append(describe(accessControl.getAccessFeature()));
			builder.append(DescriptionBuilder.Properties.PROPERTY_SEPARATOR);
			builder.append("permissions=");
			builder.append(AccessPermissionUtils.describe(accessControl.getPermissions()));
			builder.append(DescriptionBuilder.Properties.PROPERTY_SEPARATOR);
			builder.append("userProfile=");
			builder.append(describe(accessControl.getUserProfile()));
			builder.append(DescriptionBuilder.Properties.PROPERTY_LIST_CLOSE);
		} else {
			builder.append("<No UserProfileAccessControl>");
		}
		return builder.toString();
	}

	public static String describe(AccessFeature feature) {
		return (feature != null) ? feature.getAccessDomain() + "::" + feature.getName() : "<No feature>";
	}

	public static String describe(AccessRole role) {
		return (role != null) ? role.getName() + " (isDefaultPatientRole=" + BooleanUtils.isTrue(role.getIsDefaultPatientRole()) + ")" : "<No role>";
	}

	private static String describe(UserProfile userProfile) {
		return (userProfile != null) ? userProfile.getUserName() : "<No user profile>";
	}
}
