package gov.va.med.mhv.usermgmt.service.handler;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;

public class SOAPMviMessageHandler implements SOAPHandler<SOAPMessageContext> {

	private static final Log log = LogFactory.getLog(SOAPMviMessageHandler.class);
	private GenericMessageHandler genMesgHandler;

	public SOAPMviMessageHandler() {

	}

	public SOAPMviMessageHandler(GenericMessageHandler genMesgHandler) {
		this.genMesgHandler = genMesgHandler;
	}

	public Set<QName> getHeaders() {
		// TODO Auto-generated method stub
		return null;
	}

	public void close(MessageContext arg0) {
	}

	public boolean handleFault(SOAPMessageContext smc) {
		// log Message toLogFile;

		return true;
	}

	public boolean handleMessage(SOAPMessageContext smc) {

		Boolean outboundProperty = (Boolean) smc.get(MessageContext.MESSAGE_OUTBOUND_PROPERTY);

		SOAPMessage soapMessage = smc.getMessage();

		try {
			SOAPEnvelope soapEnv = soapMessage.getSOAPPart().getEnvelope();
			SOAPHeader soapHeader = soapEnv.getHeader();
			SOAPBody soapBody = soapEnv.getBody();
			if (outboundProperty) {
				// if no header, add one
				if (soapHeader == null) {
					soapHeader = soapEnv.addHeader();
					// throw exception
					// generateSOAPErrMessage(soapMsg, "No SOAP header.");
					// Uncomment and modify if security element required in SOAP
					// Header
					// addSecurityElement(soapHeader);
				}
			}

			// genMesgHandler.setRawXml(null);
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			PrintStream ps = new PrintStream(baos);
			soapMessage.writeTo(ps);

			// genMesgHandler.setRawXml(baos.toString());
			// setResponseXML(baos.toString(),soapMessage.getMimeHeaders());
			if (!outboundProperty)
				setResponseXML(soapMessage);
		} catch (Exception e) {
			log.error("Exception in handler: ", e);
		}
		return true;
	}

	private void setResponseXML(SOAPMessage soapMessage) {
		try {
			/*
			ByteArrayInputStream is = new ByteArrayInputStream(rawXML.getBytes());
			MessageFactory mf = MessageFactory.newInstance();
			SOAPMessage soapMessage = mf.createMessage(mimeHeaders, is);
			*/
			Document doc = extractContentAsDoc(soapMessage.getSOAPBody());
			Source source = new DOMSource((Document) doc);
			StringWriter stringWriter = new StringWriter();
			Result result = new StreamResult(stringWriter);
			TransformerFactory factory = TransformerFactory.newInstance();
			Transformer transformer = factory.newTransformer();
			transformer.transform(source, result);

			genMesgHandler.setRawXml(stringWriter.getBuffer().toString());
		} catch (Exception e) {
			e.printStackTrace();
			// throw new RuntimeException(e);
		}

	}

	private Document extractContentAsDoc(SOAPBody soapBody) {
		Document document;
		DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
		factory.setNamespaceAware(true);
		DocumentBuilder builder = null;
		try {
			builder = factory.newDocumentBuilder();
		}
		catch (ParserConfigurationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		document = builder.newDocument();

		org.w3c.dom.Element element;

		// org.w3c.dom.Element headerRootElem =document.createElement(s)();

		Iterator childElements = soapBody.getChildElements();
		org.w3c.dom.Node domNode = null;

		domNode = (org.w3c.dom.Node) childElements.next();
		org.w3c.dom.Element headerRootElem = (org.w3c.dom.Element) document.importNode(domNode, true);
		while (childElements.hasNext()) {
			domNode = (org.w3c.dom.Node) childElements.next();
			element = (org.w3c.dom.Element) document.importNode(domNode, true);
			headerRootElem.appendChild(element);
		}
		document.appendChild(headerRootElem);
		return document;
	}

	private void addSecurityElement(SOAPHeader soapHeader) {
		try {
			// Name name = (Name)
			// SOAPFactory.newInstance().createName("userName");
			SOAPElement security = soapHeader.addChildElement("Security", "wsse", "http://wsse-namespace");

			SOAPElement usernameToken = security.addChildElement("UsernameToken", "wsse");
			// usernameToken.addAttribute(name, "http://xsu namespace");

			SOAPElement username = usernameToken.addChildElement("Username", "wsse");
			username.addTextNode("TestUser");

			SOAPElement password = usernameToken.addChildElement("Password", "wsse");
			password.setAttribute("Type", "password Type");
			password.addTextNode("TestPassword");
		}
		catch (Exception e) {
			e.printStackTrace();
		}

	}

}
