package gov.va.med.mhv.usermgmt.service.handler;

import java.io.Serializable;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;

@Component
@PropertySource("classpath:/${MHV_ENV_PROPERTY}.usermgmt.service.properties")
public class MviProperties implements Serializable {

	private static final long serialVersionUID = 3267951548902626919L;

	@Value("${mvi.enabled}")
	private boolean isMviEnabled;

	@Value("${mhv.basic.user.static.url}")
	private String basicUrl;
	
	@Value("${mhv.advanced.user.static.url}")
	private String advancedUrl;

	@Value("${mhv.contact.static.url}")
	private String contactMhvUrl;

	@Value("${mhv.contact.logged.static.url}")
	private String contactLoggedMhvUrl;

	@Value("${mhv.targer.new.window}")
	private String targetWindow;

	@Value("${mhv.contact.admin.static.url}")
	private String contactAdminMhvUrl;

	@Value("${mhv.forgot.user.id.static.url}")
	private String forgotUserIdUrl;

	@Value("${mhv.forgot.password.static.url}")
	private String forgotPasswordUrl;

	@Value("${mhv.basic.accountType}")
	private String basicAcctType;

	@Value("${mhv.advanced.accountType}")
	private String advancedAcctType;

	@Value("${mvi.wsdlurl}")
	private String mviWsdlUrl;

	@Value("${mvi.connect.timeout}")
	private Integer mviConnectTimeout;

	@Value("${mvi.request.timeout}")
	private Integer mviRequestTimeout;

	@Value("${mvi.property.reload}")
	private Boolean isReloadRequired;

	@Value("${mvi.env.type}")
	private String mviEnvType;

	@Value("${mvi.mock.search.enabled}")
	private Boolean isMviMockSearchEnabled;

	@Value("${mvi.mock.getcorrespond.enabled}")
	private Boolean isMviMockCorrespondingEnabled;

	@Value("${mvi.mock.correlation.enabled}")
	private Boolean isMviMockCorrelationEnabled;

	@Value("${mvi.mock.searchbyedipi.enabled}")
	private Boolean isMviMockSearchByEdipiEnabled;

	@Value("${mvi.interaction.id}")
	private String mviInteractionId;

	@Value("${va.oid.value}")
	private String vaOidValue;

	@Value("${mvi.root.id}")
	private String mviRootId;

	@Value("${mvi.receiving.facility}")
	private String mviReceivingFacilityId;

	@Value("${mvi.usssa.identifier.id}")
	private String mviUsssaIdentifierId;

	@Value("${mvi.facility.assigning.authority}")
	private String mviFacilityAssignAuthority;

	@Value("${mvi.patient.identifier}")
	private String mviPatientIdentifier;

	@Value("${mvi.national.identifier}")
	private String mviNationalIdentifier;

	@Value("${mvi.edipi.identifier}")
	private String mviEdipiIdentifier;

	@Value("${mvi.prod.dodroot.id}")
	private String mviProdDodrootId;

	@Value("${mvi.nonprod.dodroot.id}")
	private String mviNonprodDodrootId;

	@Value("${dod.assigning.authority}")
	private String dodAssigningAuthority;

	@Value("${dod.facility.assigning}")
	private String dodFacilityAssigning;

	@Value("${mvi.facilities.update.max.count}")
	private int mviFacilitiesUpdateMaxCount;

	@Value("${vapii.user.id.type}")
	private String vapiiUserIdType;
	
	@Value("${vapii.formurl}")
	private String vapiiFormurl;
	
	@Value("${use.fccx.login}")
	private Boolean useFccxLogin;
	
	@Value("${vapii.wsdlurl}")
	private Resource vapiiWsdlResource;
	
	@Value("${sre.autologinurl}")
	private String sreAutLoginUrl;
	
	@Value("${sre.anonymousurl}")
	private String sreAnonymousUrl;
	
	public boolean isMviEnabled() {
		return isMviEnabled;
	}

	public void setMviEnabled(boolean isMviEnabled) {
		this.isMviEnabled = isMviEnabled;
	}
	
	public String getBasicUrl() {
		return basicUrl;
	}
	
	public void setBasicUrl(String basicUrl) {
		this.basicUrl = basicUrl;
	}

	public String getAdvancedUrl() {
		return advancedUrl;
	}

	public void setAdvancedUrl(String advancedUrl) {
		this.advancedUrl = advancedUrl;
	}

	public String getContactMhvUrl() {
		return contactMhvUrl;
	}

	public void setContactMhvUrl(String contactMhvUrl) {
		this.contactMhvUrl = contactMhvUrl;
	}

	public String getContactLoggedMhvUrl() {
		return contactLoggedMhvUrl;
	}

	public void setContactLoggedMhvUrl(String contactLoggedMhvUrl) {
		this.contactLoggedMhvUrl = contactLoggedMhvUrl;
	}

	public String getTargetWindow() {
		return targetWindow;
	}

	public void setTargetWindow(String targetWindow) {
		this.targetWindow = targetWindow;
	}

	public String getContactAdminMhvUrl() {
		return contactAdminMhvUrl;
	}

	public void setContactAdminMhvUrl(String contactAdminMhvUrl) {
		this.contactAdminMhvUrl = contactAdminMhvUrl;
	}

	public String getForgotUserIdUrl() {
		return forgotUserIdUrl;
	}

	public void setForgotUserIdUrl(String forgotUserIdUrl) {
		this.forgotUserIdUrl = forgotUserIdUrl;
	}

	public String getForgotPasswordUrl() {
		return forgotPasswordUrl;
	}

	public void setForgotPasswordUrl(String forgotPasswordUrl) {
		this.forgotPasswordUrl = forgotPasswordUrl;
	}

	public String getBasicAcctType() {
		return basicAcctType;
	}

	public void setBasicAcctType(String basicAcctType) {
		this.basicAcctType = basicAcctType;
	}

	public String getAdvancedAcctType() {
		return advancedAcctType;
	}

	public void setAdvancedAcctType(String advancedAcctType) {
		this.advancedAcctType = advancedAcctType;
	}

	public String getMviWsdlUrl() {
		return mviWsdlUrl;
	}

	public void setMviWsdlUrl(String mviWsdlUrl) {
		this.mviWsdlUrl = mviWsdlUrl;
	}

	public Integer getMviConnectTimeout() {
		return mviConnectTimeout;
	}

	public void setMviConnectTimeout(Integer mviConnectTimeout) {
		this.mviConnectTimeout = mviConnectTimeout;
	}

	public Integer getMviRequestTimeout() {
		return mviRequestTimeout;
	}

	public void setMviRequestTimeout(Integer mviRequestTimeout) {
		this.mviRequestTimeout = mviRequestTimeout;
	}

	public Boolean getIsReloadRequired() {
		return isReloadRequired;
	}

	public void setIsReloadRequired(Boolean isReloadRequired) {
		this.isReloadRequired = isReloadRequired;
	}

	public String getMviEnvType() {
		return mviEnvType;
	}

	public void setMviEnvType(String mviEnvType) {
		this.mviEnvType = mviEnvType;
	}

	public Boolean getIsMviMockSearchEnabled() {
		return isMviMockSearchEnabled;
	}

	public void setIsMviMockSearchEnabled(Boolean isMviMockSearchEnabled) {
		this.isMviMockSearchEnabled = isMviMockSearchEnabled;
	}

	public Boolean getIsMviMockCorrespondingEnabled() {
		return isMviMockCorrespondingEnabled;
	}

	public void setIsMviMockCorrespondingEnabled(Boolean isMviMockCorrespondingEnabled) {
		this.isMviMockCorrespondingEnabled = isMviMockCorrespondingEnabled;
	}

	public Boolean getIsMviMockCorrelationEnabled() {
		return isMviMockCorrelationEnabled;
	}

	public void setIsMviMockCorrelationEnabled(Boolean isMviMockCorrelationEnabled) {
		this.isMviMockCorrelationEnabled = isMviMockCorrelationEnabled;
	}

	public Boolean getIsMviMockSearchByEdipiEnabled() {
		return isMviMockSearchByEdipiEnabled;
	}

	public void setIsMviMockSearchByEdipiEnabled(Boolean isMviMockSearchByEdipiEnabled) {
		this.isMviMockSearchByEdipiEnabled = isMviMockSearchByEdipiEnabled;
	}

	public String getMviInteractionId() {
		return mviInteractionId;
	}

	public void setMviInteractionId(String mviInteractionId) {
		this.mviInteractionId = mviInteractionId;
	}

	public String getVaOidValue() {
		return vaOidValue;
	}

	public void setVaOidValue(String vaOidValue) {
		this.vaOidValue = vaOidValue;
	}

	public String getMviRootId() {
		return mviRootId;
	}

	public void setMviRootId(String mviRootId) {
		this.mviRootId = mviRootId;
	}

	public String getMviReceivingFacilityId() {
		return mviReceivingFacilityId;
	}

	public void setMviReceivingFacilityId(String mviReceivingFacilityId) {
		this.mviReceivingFacilityId = mviReceivingFacilityId;
	}

	public String getMviUsssaIdentifierId() {
		return mviUsssaIdentifierId;
	}

	public void setMviUsssaIdentifierId(String mviUsssaIdentifierId) {
		this.mviUsssaIdentifierId = mviUsssaIdentifierId;
	}

	public String getMviFacilityAssignAuthority() {
		return mviFacilityAssignAuthority;
	}

	public void setMviFacilityAssignAuthority(String mviFacilityAssignAuthority) {
		this.mviFacilityAssignAuthority = mviFacilityAssignAuthority;
	}

	public String getMviPatientIdentifier() {
		return mviPatientIdentifier;
	}

	public void setMviPatientIdentifier(String mviPatientIdentifier) {
		this.mviPatientIdentifier = mviPatientIdentifier;
	}

	public String getMviNationalIdentifier() {
		return mviNationalIdentifier;
	}

	public void setMviNationalIdentifier(String mviNationalIdentifier) {
		this.mviNationalIdentifier = mviNationalIdentifier;
	}

	public String getMviEdipiIdentifier() {
		return mviEdipiIdentifier;
	}

	public void setMviEdipiIdentifier(String mviEdipiIdentifier) {
		this.mviEdipiIdentifier = mviEdipiIdentifier;
	}

	public String getMviProdDodrootId() {
		return mviProdDodrootId;
	}

	public void setMviProdDodrootId(String mviProdDodrootId) {
		this.mviProdDodrootId = mviProdDodrootId;
	}

	public String getMviNonprodDodrootId() {
		return mviNonprodDodrootId;
	}

	public void setMviNonprodDodrootId(String mviNonprodDodrootId) {
		this.mviNonprodDodrootId = mviNonprodDodrootId;
	}

	public String getDodAssigningAuthority() {
		return dodAssigningAuthority;
	}

	public void setDodAssigningAuthority(String dodAssigningAuthority) {
		this.dodAssigningAuthority = dodAssigningAuthority;
	}

	public String getDodFacilityAssigning() {
		return dodFacilityAssigning;
	}

	public void setDodFacilityAssigning(String dodFacilityAssigning) {
		this.dodFacilityAssigning = dodFacilityAssigning;
	}

	public int getMviFacilitiesUpdateMaxCount() {
		return mviFacilitiesUpdateMaxCount;
	}

	public void setMviFacilitiesUpdateMaxCount(int mviFacilitiesUpdateMaxCount) {
		this.mviFacilitiesUpdateMaxCount = mviFacilitiesUpdateMaxCount;
	}

	public String getVapiiUserIdType() {
		return vapiiUserIdType;
	}

	public void setVapiiUserIdType(String vapiiUserIdType) {
		this.vapiiUserIdType = vapiiUserIdType;
	}

	public Boolean getUseFccxLogin() {
		return useFccxLogin;
	}

	public void setUseFccxLogin(Boolean useFccxLogin) {
		this.useFccxLogin = useFccxLogin;
	}

	public String getVapiiFormurl() {
		return vapiiFormurl;
	}

	public void setVapiiFormurl(String vapiiFormurl) {
		this.vapiiFormurl = vapiiFormurl;
	}

	public Resource getVapiiWsdlResource() {
		return vapiiWsdlResource;
	}

	public String getSreAutLoginUrl() {
		return sreAutLoginUrl;
	}

	public void setSreAutLoginUrl(String sreAutLoginUrl) {
		this.sreAutLoginUrl = sreAutLoginUrl;
	}

	public void setVapiiWsdlResource(Resource vapiiWsdlResource) {
		this.vapiiWsdlResource = vapiiWsdlResource;
	}

	public String getSreAnonymousUrl() {
		return sreAnonymousUrl;
	}

	public void setSreAnonymousUrl(String sreAnonymousUrl) {
		this.sreAnonymousUrl = sreAnonymousUrl;
	}
}
