package gov.va.med.mhv.usermgmt.service.handler;

import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;

import javax.xml.namespace.QName;
import javax.xml.ws.Binding;
import javax.xml.ws.BindingProvider;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.oit.oed.DNS  VAIdMPort;

@Component
public class MviInvocationUtilHandler implements GenericMessageHandler{
	
	private static final Logger log = LogManager.getLogger(MviInvocationUtilHandler.class);
	
	@Autowired
	private MviProperties mviProperties;
	
	// Configuration Properties
	//MviProperties properties = MviProperties.getInstance();
	//public static final String wsdlURL="http://DNS   dev203f.vha.med.DNS   :8110/psim_webservice/IdMWebService?WSDL";
	//public static final String wsdlURL="http://DNS   .commserv.healthevet.DNS   :7930/psim_webservice/PSIMWebService?WSDL";
	public static final String namespace ="http://DNS  oed.oit.DNS   ";
	public static final String serviceName="VAIdM";
	public static final String portName="VAIdMPort";

	private String wsdlURL;
	private String rawXML;
		
	public MviInvocationUtilHandler() {
		//this.wsdlURL = wsdlURL;
		//this.rawXML = rawXML;
	}
	
	public String invokeMvi(String requestType, Object reqXML) {

		//QName serviceQN = new QName(namespace, serviceName);
		String finalSoapBody = null;
		SOAPMviHandlerResolver handlerResolver = new SOAPMviHandlerResolver(this);

		try {
			long startTime = System.currentTimeMillis();
			VAIdMPort mviProxy = getVAIdMPort(handlerResolver);
			long endTime = System.currentTimeMillis();
			if (log.isDebugEnabled())
				log.debug("Time taken to execute getVAIdMPort: " + (endTime - startTime) + " ms");
			if (mviProxy != null) {
				// Object response = mviProxy.PRPA_IN201305UV02(createStubRequest());
				Class c = mviProxy.getClass();
				// Class c = Class.forName("gov.va.oit.oed.DNS  VAIdMPort");
				Method method = c.getMethod(requestType, new Class[] {
					Object.class
				});
				Object response = method.invoke(mviProxy, reqXML);

				/*
				if (log.isDebugEnabled()) {
					log.debug("OBJ: " + response.toString());
					log.debug("RAWXML: " + this.rawXML);
				}
				
				int startIndex = this.rawXML.indexOf("<idm:PRPA_");
				int endIndex = this.rawXML.indexOf("</env:Body>");
				finalSoapBody = this.rawXML.substring(startIndex, endIndex);
				finalSoapBody = this.rawXML;

				if (log.isDebugEnabled()) {
					log.debug("Local Raw XML: " + this.rawXML);
					log.debug("finalSoapBody: " + finalSoapBody);
				}*/
				
				finalSoapBody = this.rawXML;
				if(log.isDebugEnabled()) {
					log.debug("Local Raw XML: " + this.rawXML);
					log.debug("finalSoapBody: " + finalSoapBody);
				}
				return finalSoapBody;
			}
		} catch (Exception e) {
			log.error("Error in invokeMvi() : ", e);
			return "ERROR";
		}

		return finalSoapBody;
	}
	
	/*
	private enum ENVTYPES { DEV("dev"), INTB("intb"), SYSTEST("systest"), PREPROD("preprod"), PROD("prod"); 
		private String envValue;
    	private ENVTYPES(String value) {
    		this.envValue = value;
    	}
    	public String value(){
    		return envValue;
    		}
	};
	*/

	public VAIdMPort getVAIdMPort(SOAPMviHandlerResolver handlerResolver) throws MalformedURLException, Exception{

		javax.xml.ws.Service service = null;
		
		if (log.isDebugEnabled()) {
			log.debug("mviProperties.getMviWsdlUrl() " + mviProperties.getMviWsdlUrl());
		}
		
		wsdlURL = mviProperties.getMviWsdlUrl();
		
		/*
		if(properties.getIsMviProdEnv()) {
			wsdlURL = properties.getMviProdWsdlurl();
		}
		else
			wsdlURL = properties.getMviTestWsdlurl();
		
		String envType = properties.getMviEnvType();
		ENVTYPES selectedEnv = null;
		 for (ENVTYPES envTypes: ENVTYPES.values()) {
			 if(envTypes.value().equalsIgnoreCase(envType))
				 selectedEnv = envTypes;
		 }
		//ENVTYPES envTypes	= ENVTYPES.(envType);
 		switch (selectedEnv) {
			case DEV:
				wsdlURL = properties.getMviDevWsdlurl();
				break;
			case INTB:
				wsdlURL = properties.getMviIntbWsdlurl();
				break;	
			case SYSTEST:	
				wsdlURL = properties.getMviSysTestWsdlurl();
				break;
			case PREPROD:	
				wsdlURL = properties.getMviPreProdWsdlurl();
				break;
			case PROD:	
				wsdlURL = properties.getMviProdWsdlurl();
				break;
			default:	
 		}
 		*/
//		if (mviProxy.get() == null || properties.getIsReloadRequired()) {
			
			ThreadLocal<VAIdMPort> port = new ThreadLocal<VAIdMPort>();;
			
			QName portQN = new QName(namespace, portName);
			QName serviceQN= new QName(namespace, serviceName);
			Integer conn_timeout = mviProperties.getMviConnectTimeout();
			Integer req_timeout = mviProperties.getMviRequestTimeout();
	
			try {
				long startTime1 = System.currentTimeMillis();
				service = javax.xml.ws.Service.create(new URL(wsdlURL), serviceQN);
				long startTime2 = System.currentTimeMillis();
				if(log.isDebugEnabled())
					log.debug("Time taken to execute 1st Step: " +(startTime2-startTime1));
				service.setHandlerResolver(handlerResolver);
				port.set((VAIdMPort)service.getPort(portQN, VAIdMPort.class));
				long startTime3 = System.currentTimeMillis();
				if(log.isDebugEnabled())
					log.debug("Time taken to execute 2nd Step: " +(startTime3-startTime2));
				//BindingProvider bindingProvider = (BindingProvider)service;
				//final Binding binding = bindingProvider.getBinding();
				Binding binding = ((BindingProvider)port.get()).getBinding();
								
				//Connection Timeout in millisecond
				((BindingProvider)port.get()).getRequestContext().put("com.sun.xml.ws.connect.timeout", conn_timeout * 1000);
	
				//Request Timeout in millisecond
				((BindingProvider)port.get()).getRequestContext().put("com.sun.xml.ws.request.timeout", req_timeout * 1000);
				
				/*
				List<Handler> handlerList = binding.getHandlerChain();
				if (handlerList == null)
					handlerList = new ArrayList<Handler>();
	
				handlerList.add(new gov.va.med.mhv.usermgmt.service.handler.SOAPMviMessageHandler(this));
				handlerList.add(new SOAPMviLoggingHandler());
				binding.setHandlerChain(handlerList);
				*/
				
			} catch (Exception e) {
				log.error("Error in accessing MVI web service : ", e);
				return null;
			}
			
//		mviProxy = port;
//		return port.get();
//		}
//		else 
//		return mviProxy.get();
		return port.get();		

	}
	
	public String getRawXML() {
		return rawXML;
	}
	
	public void setRawXml(String xml) {
		this.rawXML = xml;
	}
}
