package gov.va.med.mhv.usermgmt.service.handler;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlValidationError;

import gov.va.med.mhv.mvi.xsd.CS;
import gov.va.med.mhv.mvi.xsd.II;
import gov.va.med.mhv.mvi.xsd.MCCIIN000002UV01Document;
import gov.va.med.mhv.mvi.xsd.MCCIIN000002UV01Document.MCCIIN000002UV01;
import gov.va.med.mhv.mvi.xsd.MCCIMT000200UV01Acknowledgement;
import gov.va.med.mhv.mvi.xsd.MCCIMT000200UV01AcknowledgementDetail;
import gov.va.med.mhv.mvi.xsd.MCCIMT000300UV01Acknowledgement;
import gov.va.med.mhv.mvi.xsd.PRPAIN201301UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201301UV02Document.PRPAIN201301UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201302UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201302UV02Document.PRPAIN201302UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201305UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201305UV02Document.PRPAIN201305UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201306UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201306UV02Document.PRPAIN201306UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201306UV02MFMIMT700711UV01Subject1;
import gov.va.med.mhv.mvi.xsd.PRPAIN201309UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201309UV02Document.PRPAIN201309UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201310UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201310UV02Document.PRPAIN201310UV02;
import gov.va.med.mhv.mvi.xsd.PRPAMT201310UV02Patient;
import gov.va.med.mhv.usermgmt.util.mvi.MviRequestTypeEnum;

public class MVIMessageParser {

	private static final Logger log = LogManager.getLogger(MVIMessageParser.class);

	public static String receivedMVINameSpace = "xmlns:idm=\"http://DNS  oed.oit.DNS   \"";
	// public static String
	// requiredNameSpace="xmlns:idm=\"urn:hl7-org:v3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
	public static String requiredNameSpace = "xmlns:idm=\"urn:hl7-org:v3\"";

	public static String MVIXSINameSpace = "xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"";
	public static String MVIEMPTYNameSpace = " ";

	List<XmlValidationError> validationErrors = null;
	XmlOptions voptions = null;

	public MVIMessageParser() {
		validationErrors = new ArrayList<XmlValidationError>();
		voptions = new XmlOptions();
		voptions.setErrorListener(validationErrors);
		voptions.put(XmlOptions.LOAD_LINE_NUMBERS);
		voptions.setSavePrettyPrint();
		voptions.setSavePrettyPrintIndent(4);
	}

	public static enum ResponseCode {
		NF(1), AE(2), OK(3), QE(4);

		private int value;

		private ResponseCode(int value) {
			this.value = value;
		}
	};

	public Object mVIMessageParser(String requestType, String searchReqXML, String responseXML) {
		
		if (responseXML != null && !responseXML.equalsIgnoreCase("ERROR")) {

			if (log.isDebugEnabled()) {
				log.info("About to Parse XML of Type" + requestType);
			}
			responseXML = createReplaceXMLNameSpace(responseXML);

			if (requestType.equals(MviRequestTypeEnum.SEARCH_TYPE.getReqType())) {
				return mVISearchMessageParser(searchReqXML, responseXML);
			} else if (requestType.equals(MviRequestTypeEnum.ADDCORRELATION_TYPE.getReqType())) {
				return mVICorrelationMessageParser(searchReqXML, responseXML);
			} else if (requestType.equals(MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType())) {
				return mVIGetCorrespondingMessageParser(searchReqXML, responseXML);
			} else if (requestType.equals(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType())) {
				// MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - Adding
				// authentication parser
				return mVIAuthenticateMessageParser(searchReqXML, responseXML);
			} else if (requestType.equals(MviRequestTypeEnum.SEARCHBY_EDIPI_TYPE.getReqType())) {
				return mVIGetCorrespondingMessageParser(searchReqXML, responseXML);
			} else {
				return null;
			}
		} else {
			log.error("Response from MVI is NULL for REQ: " + requestType);
			return null;
		}

	}

	public PRPAIN201306UV02 mVISearchMessageParser(String reqXML, String responseXML) {

		PRPAIN201306UV02Document root1306ResDoc = null;
		PRPAIN201306UV02 root1306Res = null;
		PRPAIN201305UV02Document reqXmlObjDocRoot = null;
		PRPAIN201305UV02 reqXmlObj = null;
		MCCIMT000300UV01Acknowledgement acknowledgement = null;

		try {
			reqXmlObjDocRoot = PRPAIN201305UV02Document.Factory.parse(reqXML);
			reqXmlObj = reqXmlObjDocRoot.getPRPAIN201305UV02();

			root1306ResDoc = PRPAIN201306UV02Document.Factory.parse(responseXML);
			boolean valid = root1306ResDoc.validate(voptions);
			
			if (valid) {
				if (log.isDebugEnabled()) {
					log.debug("Its valid SEARCH Response from MVI");
				}
				
				root1306Res = root1306ResDoc.getPRPAIN201306UV02();
				if (log.isDebugEnabled()) {
					log.debug(root1306ResDoc.xmlText(voptions));
				}

				CS queryResponseCode = root1306Res.getControlActProcess().getQueryAck().getQueryResponseCode();
				MCCIMT000300UV01Acknowledgement[] acknowledgementArray = root1306Res.getAcknowledgementArray();
				acknowledgement = acknowledgementArray[0];

				ResponseCode code = ResponseCode.valueOf(queryResponseCode.getCode());
				
				switch (code) {
				case NF:
					if (log.isDebugEnabled()) {
						log.debug("**********USER NOT FOUND*********");
					}
					break;
				case AE:
					if (log.isDebugEnabled()) {
						log.debug("************Application Error*************");
					}
					break;
				case QE:
					if (log.isDebugEnabled()) {
						log.debug("*********Max Results Exceeded*************");
					}
					break;
				case OK:
					if (log.isDebugEnabled()) {
						log.debug("***********Response is Good so as User***********");
					}
					
					PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = root1306Res.getControlActProcess().getSubjectArray();
					PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
					PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
					II idArray[] = patient.getIdArray();
					II patientId = idArray[0];
					String patientICNIdentifier = patientId.getExtension();
					String[] patientICNArray = patientICNIdentifier.split("\\^");
					
					if (log.isDebugEnabled()) {
						log.debug("ICN IS: " + patientICNArray[0]);
					}
					
					break;
				}
			} else {
				log.error("Not valid Response from MVI");
				for (XmlValidationError validationError : validationErrors) {
					log.error(validationError);
				}
			}
		} catch (XmlException e) {
			log.error("Error in mVISearchMessageParser ", e);
			return null;

		} catch (Exception e) {
			log.error("Error in mVISearchMessageParser ", e);
			return null;
		}
		
		String mcidUniqValueSent = null;
		String mcidUniqValueRecd = null;
		
		if (reqXmlObj != null && root1306Res != null) {
			mcidUniqValueSent = reqXmlObj.getId().getExtension();
			mcidUniqValueRecd = acknowledgement.getTargetMessage().getId().getExtension();
		}
		
		if (mcidUniqValueSent != null && mcidUniqValueRecd != null && mcidUniqValueSent.equals(mcidUniqValueRecd)) {
			if (log.isDebugEnabled()) {
				log.debug("root1306Res " + root1306Res);
			}
			return root1306Res;
		} else {
			log.error("MCID Mismatch has occured: " + mcidUniqValueSent + " " + mcidUniqValueRecd);
			return null;
		}
	}

	public PRPAIN201310UV02 mVIGetCorrespondingMessageParser(String reqXML, String responseXML) {

		PRPAIN201310UV02Document root1310ResDoc = null;
		PRPAIN201310UV02 root1310Res = null;

		PRPAIN201309UV02Document reqXmlObjDocRoot = null;
		PRPAIN201309UV02 reqXmlObj = null;
		MCCIMT000300UV01Acknowledgement acknowledgement = null;

		try {
			reqXmlObjDocRoot = PRPAIN201309UV02Document.Factory.parse(reqXML);
			reqXmlObj = reqXmlObjDocRoot.getPRPAIN201309UV02();

			root1310ResDoc = PRPAIN201310UV02Document.Factory.parse(responseXML);

			boolean valid = root1310ResDoc.validate(voptions);
			if (valid) {
				if (log.isDebugEnabled()) {
					log.debug("Its valid GET CORRESPONDING Response from MVI");
				}
				
				root1310Res = root1310ResDoc.getPRPAIN201310UV02();
				if (log.isDebugEnabled()) {
					log.debug("\n" + root1310ResDoc.xmlText(voptions));
				}
				
				MCCIMT000300UV01Acknowledgement[] acknowledgementArray = root1310Res.getAcknowledgementArray();
				acknowledgement = acknowledgementArray[0];

				CS queryResponseCode = root1310Res.getControlActProcess().getQueryAck().getQueryResponseCode();

				ResponseCode code = ResponseCode.valueOf(queryResponseCode.getCode());
				switch (code) {
				case NF:
					if (log.isDebugEnabled())
						log.debug("**********ICN NOT FOUND*********");
					break;
				case AE:
					if (log.isDebugEnabled())
						log.debug("************Application Error*************");
					MCCIMT000300UV01Acknowledgement[] ackArray = root1310Res.getAcknowledgementArray();
					if (log.isDebugEnabled())
						log.debug("**" + ackArray[0].getAcknowledgementDetailArray(0).getText());
					break;
				case QE:
					if (log.isDebugEnabled())
						log.debug("*********Max Results Exceeded*************");
					break;
				case OK:
					if (log.isDebugEnabled())
						log.debug("***********Response is Good so as ICN***********");
					break;
				}

			} else {
				log.error("Not valid Response from MVI");
				for (XmlValidationError validationError : validationErrors) {
					log.error(validationError);
				}
			}
		} catch (XmlException e) {
			log.error("Error in mVIGetCorrespondingMessageParser ", e);
			return null;
		}
		
		String mcidUniqValueSent = null;
		String mcidUniqValueRecd = null;
		
		if (reqXmlObj != null && acknowledgement != null) {
			mcidUniqValueSent = reqXmlObj.getId().getExtension();
			mcidUniqValueRecd = acknowledgement.getTargetMessage().getId().getExtension();
		}
		if (mcidUniqValueSent != null && mcidUniqValueRecd != null && mcidUniqValueSent.equals(mcidUniqValueRecd)) {
			return root1310Res;
		} else {
			log.error("MCID Mismatch has occured: " + mcidUniqValueSent + " " + mcidUniqValueRecd);
			return null;
		}
	}

	/*
	 * MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - Adding authentication parser 
	 */
	public MCCIIN000002UV01 mVIAuthenticateMessageParser(String reqXML, String responseXML) {
		return mVIAuthenticationMessageParser(reqXML, responseXML);
	}

	public MCCIIN000002UV01 mVICorrelationMessageParser(String reqXML, String responseXML) {

		MCCIIN000002UV01Document root1302ResDoc = null;
		MCCIIN000002UV01 root1302Res = null;

		PRPAIN201301UV02Document reqXmlObjDocRoot = null;
		PRPAIN201301UV02 reqXmlObj = null;

		MCCIMT000200UV01Acknowledgement acknowledgement = null;

		try {
			// responseXML = createReplaceXMLNameSpace(responseXML);

			reqXmlObjDocRoot = PRPAIN201301UV02Document.Factory.parse(reqXML);
			reqXmlObj = reqXmlObjDocRoot.getPRPAIN201301UV02();

			root1302ResDoc = MCCIIN000002UV01Document.Factory.parse(responseXML);
			// root1302ResDoc = MCCIIN000002UV01Document.Factory.parse(createResponseXML());
			boolean valid = root1302ResDoc.validate(voptions);
			if (valid) {
				if (log.isDebugEnabled()) {
					log.debug("Its valid CORRELATION Response from MVI");
				}
				
				root1302Res = root1302ResDoc.getMCCIIN000002UV01();
				if (log.isDebugEnabled()) {
					log.debug("\n" + root1302ResDoc.xmlText(voptions));
				}
				
				MCCIMT000200UV01Acknowledgement[] acknowledgementArray = root1302Res.getAcknowledgementArray();

				// Array should have only 1 ACK
				// for (int i =0; i<=acknowledgementArray.length; i++) {
				acknowledgement = acknowledgementArray[0];
				// }

				if (acknowledgement.getTypeCode().getCode().equals("AA")) {
					if (log.isDebugEnabled()) {
						log.debug("APPLICATION ACCEPT FOR ADDCORRELATION");
					}
					MCCIMT000200UV01AcknowledgementDetail[] acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();

					MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail = acknowledgementDetailArray[0];
				} else { 
					if (log.isDebugEnabled()) {
						log.debug("APPLICATION NOT ACCEPT");
					}
				}
			} else {
				log.error("Not valid Response from MVI");
				for (XmlValidationError validationError : validationErrors) {
					log.error(validationError);
				}
			}
		} catch (Throwable t) {
			log.error("Error in mVICorrelationMessageParser " + t);
			return null;
		}
		
		String mcidUniqValueSent = null;
		String mcidUniqValueRecd = null;
		if (reqXmlObj != null && acknowledgement != null) {
			mcidUniqValueSent = reqXmlObj.getId().getExtension();
			mcidUniqValueRecd = acknowledgement.getTargetMessage().getId().getExtension();
		}
		if (mcidUniqValueSent != null && mcidUniqValueRecd != null && mcidUniqValueSent.equals(mcidUniqValueRecd)) {
			return root1302Res;
		} else {
			log.error("MCID Mismatch has occured: " + mcidUniqValueSent + " " + mcidUniqValueRecd);
			return null;
		}
	}

	public MCCIIN000002UV01 mVIAuthenticationMessageParser(String reqXML, String responseXML) {

		MCCIIN000002UV01Document root1302ResDoc = null;
		MCCIIN000002UV01 root1302Res = null;

		PRPAIN201302UV02Document reqXmlObjDocRoot = null;
		PRPAIN201302UV02 reqXmlObj = null;

		MCCIMT000200UV01Acknowledgement acknowledgement = null;

		try {
			// responseXML = createReplaceXMLNameSpace(responseXML);
			reqXmlObjDocRoot = PRPAIN201302UV02Document.Factory.parse(reqXML);
			reqXmlObj = reqXmlObjDocRoot.getPRPAIN201302UV02();

			root1302ResDoc = MCCIIN000002UV01Document.Factory.parse(responseXML);
			// root1302ResDoc = MCCIIN000002UV01Document.Factory.parse(createResponseXML());
			boolean valid = root1302ResDoc.validate(voptions);
			if (valid) {
				if (log.isDebugEnabled()) {
					log.debug("Its valid CORRELATION Response from MVI");
				}
				root1302Res = root1302ResDoc.getMCCIIN000002UV01();
				if (log.isDebugEnabled()) {
					log.debug("\n" + root1302ResDoc.xmlText(voptions));
				}
				MCCIMT000200UV01Acknowledgement[] acknowledgementArray = root1302Res.getAcknowledgementArray();

				// Array should have only 1 ACK
				// for (int i =0; i<=acknowledgementArray.length; i++) {
				acknowledgement = acknowledgementArray[0];
				// }

				if (acknowledgement.getTypeCode().getCode().equals("AA")) {
					if (log.isDebugEnabled())
						log.debug("APPLICATION ACCEPT FOR ADDCORRELATION");
					MCCIMT000200UV01AcknowledgementDetail[] acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();

					MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail = acknowledgementDetailArray[0];
				} else if (log.isDebugEnabled())
					log.debug("APPLICATION NOT ACCEPT");
			} else {
				log.error("Not valid Response from MVI");
				for (XmlValidationError validationError : validationErrors) {
					log.error(validationError);
				}
			}
		} catch (XmlException e) {
			log.error("Error in mVIAuthenticationMessageParser ", e);
			return null;
		}
		
		String mcidUniqValueSent = null;
		String mcidUniqValueRecd = null;
		if (reqXmlObj != null && acknowledgement != null) {
			mcidUniqValueSent = reqXmlObj.getId().getExtension();
			mcidUniqValueRecd = acknowledgement.getTargetMessage().getId().getExtension();
		}
		if (mcidUniqValueSent != null && mcidUniqValueRecd != null && mcidUniqValueSent.equals(mcidUniqValueRecd)) {
			return root1302Res;
		} else {
			log.error("MCID Mismatch has occured: " + mcidUniqValueSent + " " + mcidUniqValueRecd);
			return null;
		}
	}

	public String createResponseXML() {

		// Provided by MVI Team
		/*
		String reqXML= "<idm:MCCI_IN000002UV01 xmlns:idm=\"http://DNS  oed.oit.DNS   \" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"urn:hl7-org:v3 ../../schema/HL7V3/NE2008/multicacheschemas/MCCI_IN000002UV01.xsd\" xmlns=\"urn:hl7-org:v3\" ITSVersion=\"XML_1.0\">"
			+ "<id root=\"2.999.999.999.999.2\" extension=\"MCID-1208221644445981323028791\"/>"
			+ "<creationTime value=\"20120822164444-0400\"/>"
			+ "<interactionId root=\"2.16.840.1.113883.1.6\" extension=\"MCCI_IN000002UV01\"/>"
			+ "<processingCode code=\"T\"/>"
			+ "<processingModeCode code=\"T\"/>"
			+ "<acceptAckCode code=\"NE\"/>"
			+ "<receiver typeCode=\"RCV\">"
		    + "<device classCode=\"DEV\" determinerCode=\"INSTANCE\">"
		    + "<id root=\"PSIM_TOOLS\" extension=\"200MH\"/>"
		    + "</device>"
		    + "</receiver>"
		    + "<sender typeCode=\"SND\">"
		    + "<device classCode=\"DEV\" determinerCode=\"INSTANCE\">"
		    + "<id root=\"2.16.840.1.113883.4.349\"/>"
		    + "</device>"
		    + "</sender>"
		    + "<acknowledgement>"
		    + "<typeCode code=\"AA\"/>"
		    + "<targetMessage>"
		    + "<id root=\"22a0f9e0-4454-11dc-a6be-3603d6866807\" extension=\"MCID-ADD-COR-1111\"/>"
		    + "</targetMessage>"
		    + "<acknowledgementDetail>"
		    + "<code codeSystemName=\"MVI\" displayName=\"IEN\" code=\"100000939^PI^523^USVHA\"/>"
		    +    "<text><![CDATA[Correlation Added to MVI]]></text>"
		    + "</acknowledgementDetail>"
		    + "</acknowledgement>"
		    + "</idm:MCCI_IN000002UV01>";
		 */

		// Customize element namespace mismatch expected "urn:hl7-org:v3" got
		// "http://DNS  oed.oit.DNS   "

		String reqXML =
			"<idm:MCCI_IN000002UV01 xmlns:idm=\"http://DNS  oed.oit.DNS   \" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"urn:hl7-org:v3 ../../schema/HL7V3/NE2008/multicacheschemas/MCCI_IN000002UV01.xsd\" xmlns=\"urn:hl7-org:v3\" ITSVersion=\"XML_1.0\">"
				+ "<id root=\"2.999.999.999.999.2\" extension=\"MCID-1208221644445981323028791\"/>"
				+ "<creationTime value=\"20120822164444-0400\"/>"
				+ "<interactionId root=\"2.16.840.1.113883.1.6\" extension=\"MCCI_IN000002UV01\"/>"
				+ "<processingCode code=\"T\"/>"
				+ "<processingModeCode code=\"T\"/>"
				+ "<acceptAckCode code=\"NE\"/>"
				+ "<receiver typeCode=\"RCV\">"
				+ "<device classCode=\"DEV\" determinerCode=\"INSTANCE\">"
				+ "<id root=\"2.16.840.1.113883.4.349\" extension=\"200MH\"/>"
				+ "</device>"
				+ "</receiver>"
				+ "<sender typeCode=\"SND\">"
				+ "<device classCode=\"DEV\" determinerCode=\"INSTANCE\">"
				+ "<id root=\"2.16.840.1.113883.4.349\"/>"
				+ "</device>"
				+ "</sender>"
				+ "<acknowledgement>"
				+ "<typeCode code=\"AA\"/>"
				+ "<targetMessage>"
				+ "<id root=\"22a0f9e0-4454-11dc-a6be-3603d6866807\" extension=\"MCID-ADD-COR-1111\"/>"
				+ "</targetMessage>"
				+ "<acknowledgementDetail>"
				+ "<code codeSystemName=\"MVI\" displayName=\"IEN\" code=\"100000939^PI^523^USVHA\"/>"
				+ "<text><![CDATA[Correlation Added to MVI]]></text>"
				+ "</acknowledgementDetail>" + "</acknowledgement>" + "</idm:MCCI_IN000002UV01>";

		// Hacking to replace the namespace
		reqXML = createReplaceXMLNameSpace(reqXML);
		return reqXML;
	}

	public static String createReplaceXMLNameSpace(String reqXML) {
		return StringUtils.replace(reqXML, receivedMVINameSpace, requiredNameSpace);
	}
}
