/**
 * 
 */
package gov.va.med.mhv.usermgmt.service;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;

/**
 * @author DNS   egberb
 *
 */
public class PatientWebServiceImpl implements PatientWebService {
	
	private static final Logger LOG = LogManager.getLogger(PatientWebServiceImpl.class);

	@Autowired
	private PatientService patientService;

	/*
	 * (non-Javadoc)
	 * 
	 * @see
	 * gov.va.med.mhv.usermgmt.service.PatientWebService#getPatientByPatientId(
	 * java.lang.Long)
	 */
	@Override
	public PatientDTO getPatientByPatientId(Long patientId) throws MHVException {
		ResponseUtil<PatientDTO> response = new ResponseUtil<PatientDTO>();
		try {
			this.patientService.getPatientById(patientId, response);
		} catch (Exception ex) {
			String message = String.format("An unexpected error occurred while "
					+ "looking up patient record by patient identifier. Patient ID: %s", patientId);
			LOG.error(message, ex);
			throw new MHVException(message, ex);
		}
		
		if (response != null && response.isFailure()) {
			
			throw new MHVException(response.getInfoMessages(), response.getValidationErrors(), response.getFailureMessage());
		}

		return response.getPojoObject();
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see gov.va.med.mhv.usermgmt.service.PatientWebService#
	 * getPatientByUserProfileId(java.lang.Long)
	 */
	@Override
	public PatientDTO getPatientByUserProfileId(Long userProfileId) throws MHVException {
		ResponseUtil<PatientDTO> response = null;

		try {
			response = this.patientService.getPatientByUserProfileId(userProfileId);
		} catch (Exception e) {
			String message = String.format("An unexpected error occurred while "
					+ "looking up patient record by user profile ID. User Profile ID: %s", userProfileId);
			LOG.error(message, e);
			throw new MHVException(message, e);
		}

		if (response != null && response.isFailure()) {
			throw new MHVException(response.getInfoMessages(), response.getValidationErrors(), response.getFailureMessage());
		}

		return response.getPojoObject();
	}

}
