package gov.va.med.mhv.usermgmt.service;

import gov.va.med.mhv.usermgmt.main.registry.BaseMessage;
import gov.va.med.mhv.usermgmt.main.registry.EventId;
import gov.va.med.mhv.usermgmt.main.registry.FacilitiesChange;
import gov.va.med.mhv.usermgmt.main.registry.Patient;
import gov.va.med.mhv.usermgmt.main.registry.PersonalInfo;
import gov.va.med.mhv.usermgmt.main.registry.Result;
import gov.va.med.mhv.usermgmt.main.registry.Status;

public interface PatientCorrelationService {

	public abstract Status correlatePatient(Patient patient);

	public abstract Status uncorrelatePatient(Patient patient);

	public abstract Result processCorrelateNotification(EventId id,
			String type, Patient patient, Status status);

	public abstract Result processFacilitiesNotification(EventId id,
			String type, Patient patient, FacilitiesChange facilitiesChange);

	public abstract Result processPersonalNotification(EventId id, String type,
			Patient patient, PersonalInfo info);

	public abstract Result processPatientNotification(EventId id, String type,
			Patient fromPatient, Patient toPatient);

	public abstract Result processInboundTrace(EventId id, Patient patient,
			BaseMessage data);

}