package gov.va.med.mhv.usermgmt.service;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.model.Patient;
import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.usermgmt.service.handler.MviProperties;

/**
 * Provides business services for MVI Integration . Business services include
 * operations such as patient lookup, registry information changes and patient
 * (VistA) correlation. Generated Code - DO NOT MODIFY
 */
public interface MviIntegrationService {/* //extends ApplicationService {

*/

	/** Name which uniquely identifies the MviIntegration service. */
	//public static final String SERVICE_NAME = "gov.va.med.mhv.usermgmt.MviIntegrationService";

	/**
	 * Execute the GetEdipiFromMVI operation
	 *
	 * @param patient
	 * @return
	 */
	public String getEdipiFromMVI(Patient patient);

	/**
	 * Execute the DeletePersonFromCorrelationForIPA operation
	 *
	 * @param patient
	 * @param userProfile
	 * @param adminUserName
	 * @param response
	 */
	public void deletePersonFromCorrelationForIPA(Patient patient, UserProfile userProfile, String adminUserName, ResponseUtil response);

	/**
	 * Execute the SearchPersonInMVIForUSAA operation
	 *
	 * @param firstName
	 * @param middleName
	 * @param lastName
	 * @param birthDate
	 * @param gender
	 * @param ssn
	 * @return PatientServiceResponse
	 */
	public void searchPersonInMVIForUSAA(String fName, String mName, String lName, String DOB, String gender, String SSN, ResponseUtil response);

	/**
	 * Execute the AddPersonForCorrelationForIPA operation
	 *
	 * @param patient
	 * @param userProfile
	 * @param adminUserName
	 * @return PatientServiceResponse
	 */
	public void addPersonForCorrelationForIPA(Patient patient, UserProfile userProfile, String adminUserName, ResponseUtil response, String versionInfo);

	/**
	 * Execute the UpdateTreatmentFacilitiesForExistingPatients operation
	 *
	 * @param patient
	 * @return PatientServiceResponse
	 */
	public void updateTreatmentFacilitiesForExistingPatients(Patient patient, ResponseUtil response);

	/**
	 * Execute the RemoveCorrelationInMVI operation
	 *
	 * @param patient
	 * @param userProfile
	 * @param adminUserName
	 * @return PatientServiceResponse
	 */
	public void removeCorrelationInMVI(Patient patient, UserProfile userProfile, String adminUserName, ResponseUtil response);

	/**
	 * Execute the MviAuthenticate operation
	 *
	 * @param patient
	 * @param userProfile
	 * @param authenticate
	 * @param batch
	 * @return BooleanServiceResponse
	 */
	public void mviAuthenticate(Patient patient, UserProfile userProfile, Boolean authenticate, Boolean batch, ResponseUtil response, String versionInfo);

	/**
	 * Execute the DeletePersonFromCorrelationForHelpDesk operation
	 *
	 * @param patient
	 * @param userProfile
	 * @param adminUserName
	 * @return PatientServiceResponse
	 */
	public void deletePersonFromCorrelationForHelpDesk(Patient patient, UserProfile userProfile, String adminUserName, ResponseUtil response);

	/**
	 * Execute the SearchPersonInMVI operation
	 *
	 * @param userProfile
	 * @param atRegistration
	 * @return PatientServiceResponse
	 */
	public void searchPersonInMVI(UserProfile userProfile, Boolean atRegistration, ResponseUtil respons, String versionInfo);

	/*/**
	 * Execute the UpdateUserProfile operation
	 *
	 * @param userProfile
	 * @return PatientServiceResponse
	 *//*
		public PatientServiceResponse updateUserProfile(UserProfile userProfile);

		*/

	/**
	 * Execute the SearchPersonInMVIByICN operation
	 *
	 * @param icn
	 * @return PatientServiceResponse
	 */
	public void searchPersonInMVIByICN(String icn, ResponseUtil response);

	/**
	 * Execut the SearchPersonInMVIByICNAccountSync operation
	 *
	 *  @param icn
	 *  @param response
	 */
	public void searchPersonInMVIByICNAccountSync(String icn, ResponseUtil response);

	/**
	 * Execute the MviUnauthenticateUncorrelateForBatch operation
	 *
	 * @param patient
	 * @param userProfile
	 * @param adminUserName
	 * @return BooleanServiceResponse
	 */
	public void mviUnauthenticateUncorrelateForBatch(Patient patient, UserProfile userProfile, String adminUserName, ResponseUtil response);

	/**
	 * Execute the MatchPersonInIPA operation
	 *
	 * @param userProfile
	 * @return PatientServiceResponse
	 */
	public void matchPersonInIPA(UserProfile userProfile, ResponseUtil response, MviProperties mviProperties, String versionInfo);

	/**
	 * Execute the ForceUncorrelation operation
	 *
	 * @param patient
	 * @param userProfile
	 * @param adminUserName
	 * @return PatientServiceResponse
	 */
	public void forceUncorrelation(Patient patient, UserProfile userProfile, String adminUserName, ResponseUtil response);

	/**
	 * Execute the SearchPersonInMVIForDSLogon operation
	 *
	 * @param edipiValue
	 * @return PatientServiceResponse
	 */
	public void searchPersonInMVIForDSLogon(String edipiValue, ResponseUtil response);

	/**
	 *
	 * @param userProfile
	 * @param fccxIcn
	 * @param response
	 */
	public void createPatientForFccx(UserProfile userProfile, String fccxIcn, ResponseUtil response);
}
