package gov.va.med.mhv.usermgmt.service;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.model.Patient;
import gov.va.med.mhv.common.data.model.UserProfile;


/**
 * Provides Async business services for MVI Integration.  
 * Business services include operations such as correlation.
 *
 */
public interface MviAsyncIntegrationService {	
	
	/**
	 * System will try to match them with MVI and move them to PREREQUISITE Complete if everything goes fine.
	 *
	 * @param userProfile  
	 * @return VoidServiceResponse
	 */
	public void existingUserWithPendingDataMismatch(UserProfile userProfile, ResponseUtil response);

	/**
	 * Execute the MviAuthenticate operation
	 *
	 * @param patient  
	 * @param userProfile  
	 * @param authenticate  
	 * @param batch  
	 * @return void
	 */
	public void mviAuthenticate(Patient patient, UserProfile userProfile, Boolean authenticate, Boolean batch, String versionInfo);

	/**
	 * Execute the AddPersonForCorrelation operation
	 *
	 * @param patient  
	 * @param userProfile  
	 * @param isRegistration  
	 * @return void
	 */
	public void addPersonForCorrelation(Patient patient, UserProfile userProfile, Boolean isRegistration, ResponseUtil response, String versionInfo);

	/**
	 * Execute the MviUnauthenticateUncorrelateForBatch operation
	 *
	 * @param patient  
	 * @param userProfile  
	 * @param adminUserName  
	 * @return void
	 */
	public void mviUnauthenticateUncorrelateForBatch(Patient patient, UserProfile userProfile, String adminUserName, String versionInfo);
}
