package gov.va.med.mhv.usermgmt.service;

import java.util.List;

import gov.va.med.mhv.common.data.model.FacilityInfo;


public interface FacilityInfoService {

	/**
	 * Save the FacilityInfo
	 *
	 * @param entity FacilityInfo to save
	 * @return FacilityInfo The saved FacilityInfo
	 */
	public FacilityInfo saveFacilityInfo(FacilityInfo facilityInfo);
	
	/**
	 * Delete the FacilityInfo
	 *
	 * @param entity FacilityInfo to delete
	 * @return FacilityInfo The deleted FacilityInfo
	 */
	//public FacilityInfoBO delete(FacilityInfoPK pk);
	
	/**
	 * Find the FacilityInfo by primary key fields
	 *
	 * @param pk The primary key for the FacilityInfo
	 * @return FacilityInfo The retrieved FacilityInfo
	 */
	//public FacilityInfoBO findByPrimaryKey(FacilityInfoPK pk);

	/**
	 * Execute the getAllFacilityInfos query
	 *
	 * @return List of FacilityInfos
	 */	 
	public List<FacilityInfo> getAllFacilityInfos();

	/**
	 * Execute the queryByStationNumber query
	 *
	 * @param stationNumber The stationNumber
	 * @return List of FacilityInfos
	 */	 
	public List<FacilityInfo> queryByStationNumber(String stationNumber);
}
