
package gov.va.med.mhv.usermgmt.main.service.validator;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;

import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.dto.ContactDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.core.validate.EmailValidator;
import gov.va.med.mhv.core.validate.SSNValidator;
import gov.va.med.mhv.core.validate.Validations;
import gov.va.med.mhv.core.validate.Validator;
import gov.va.med.mhv.core.validate.ZipCodeValidator;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.BloodTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.CountryEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.GenderEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.MaritalStatusEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.PasswordHintQuestionsEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.StateEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.SuffixEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.TitleEnumeration;
import gov.va.med.mhv.usermgmt.data.model.UserPasswordHistory;
import gov.va.med.mhv.usermgmt.data.repository.UserPasswordHistoryRepository;
import gov.va.med.mhv.usermgmt.data.repository.UserProfileRepository;
import gov.va.med.mhv.usermgmt.messages.UserManagementMessages;
import gov.va.med.mhv.usermgmt.service.handler.MviProperties;
import gov.va.med.mhv.usermgmt.util.PasswordUtil;

@Component
public class UserProfileValidator extends Validator {

	private static Logger log = LogManager.getLogger(UserProfileValidator.class);
	
	public static final int ADDRESSSTREET1_MAX_LENGTH = 100;
	public static final int ADDRESSSTREET2_MAX_LENGTH = 100;
	public static final int ALTERNATEADDRESSPROVINCE_MAX_LENGTH = 50;
	public static final int ADDRESSCITY_MAX_LENGTH = 100;
	public static final int USERNAME_MIN_LENGTH = 6;
	public static final int USERNAME_MAX_LENGTH = 12;
	public static final int ALTERNATEADDRESSPOSTALCODE_MAX_LENGTH = 10;
	public static final int ADDRESSPOSTALCODE_MAX_LENGTH = 10;
	public static final int CONTACTINFOHOMEPHONE_MAX_LENGTH = 20;
	public static final int CONTACTINFOMOBILEPHONE_MAX_LENGTH = 20;
	public static final int CONTACTINFOWORKPHONE_MAX_LENGTH = 20;
	public static final int CONTACTINFOPAGER_MAX_LENGTH = 20;
	public static final int ALTERNATEADDRESSCITY_MAX_LENGTH = 100;
	public static final int USERALIAS_MAX_LENGTH = 50;
	public static final int ALTERNATEADDRESSSTREET1_MAX_LENGTH = 100;
	public static final int PROOFLEVEL_MAX_LENGTH = 1;
	public static final int ADDRESSPROVINCE_MAX_LENGTH = 50;
	public static final int MHVID_MAX_LENGTH = 12;
	public static final int ALTERNATEADDRESSSTREET2_MAX_LENGTH = 100;
	public static final int CURRENTOCCUPATION_MAX_LENGTH = 50;
	public static final int CONTACTINFOFAX_MAX_LENGTH = 20;

	private static Set<Character> SPECIAL_CHARS = createSpecialChars();

	private static final Set<Character> createSpecialChars() {
		Set<Character> specialChars = new HashSet<Character>( 32);
		specialChars.add( new Character( '!' ) );
		specialChars.add( new Character( '@' ) );
		specialChars.add( new Character( '#' ) );
		specialChars.add( new Character( '$' ) );
		specialChars.add( new Character( '%' ) );
		specialChars.add( new Character( '&' ) );
		specialChars.add( new Character( '*' ) );
		specialChars.add( new Character( '|' ) );
		specialChars.add( new Character( '?' ) );
		specialChars.add( new Character( '.' ) );
		specialChars.add( new Character( '_' ) );
		specialChars.add( new Character( '/' ) );
		specialChars.add( new Character( '<' ) );
		specialChars.add( new Character( '>' ) );
		specialChars.add( new Character( ';' ) );
		specialChars.add( new Character( ':' ) );
		specialChars.add( new Character( '"' ) );
		specialChars.add( new Character( '\\' ) );
		specialChars.add( new Character( '=' ) );
		specialChars.add( new Character( '+' ) );
		specialChars.add( new Character( '-' ) );
		specialChars.add( new Character( '`' ) );
		specialChars.add( new Character( '~' ) );
		specialChars.add( new Character( ')' ) );
		specialChars.add( new Character( '(' ) );
		specialChars.add( new Character( ',' ) );
		specialChars.add( new Character( '\'' ) );
		specialChars.add( new Character( '{' ) );
		specialChars.add( new Character( '}' ) );
		//CR1256 to add ^ [ and ] as special characters
		specialChars.add( new Character( '^' ) );
		specialChars.add( new Character( '[' ) );
		specialChars.add( new Character( ']' ) );
		return specialChars;
	}	
	
	@Autowired
	private UserProfileRepository userProfileRepository;
	
	@Autowired
	private MviProperties mviProperties;
	
	@Autowired
	private UserPasswordHistoryRepository passwordHistoryRepository;

	public void addError(ResponseUtil response, String errorKey, String value) {
		response.getValidationErrors().put(errorKey, String.format(getProperties().getProperty(errorKey), value));
	}
	
	/**
	 * Executes all reference-level validations
	 */
	//TODO: Fix Me - UserProfileBaseBO
	/* 
	protected void referenceValidation() {
		super.referenceValidation();
		
		validateDeactivationReason();

	}*/
	
	public void userProfileUpdateValidations(ResponseUtil response, UserProfileDTO profileDto, boolean isRegistration) {

		fieldValidation(response, profileDto, isRegistration);

		// no errors in initial field validations, then perform complex
		// validations
		if (response.getValidationErrors() == null || response.getValidationErrors().size() == 0) {
			complexValidation(response, profileDto, isRegistration);
		}
	}
	
	public void complexValidation(ResponseUtil response, UserProfileDTO userProfileDto, boolean isRegistration) {

		LinkedHashMap<String, String> validationErrors = response.getValidationErrors();

		validateUniqueUser(isRegistration, userProfileDto, validationErrors);
		validatePasswordHintQuestions(userProfileDto, validationErrors);
		validatePasswordHintAnswers(userProfileDto, validationErrors);
		validateStateAndProvinceAndCountry(userProfileDto, validationErrors);
		validateContactMethodProvided(userProfileDto, validationErrors);
		validateRequiredPatientInfo(userProfileDto, validationErrors);
		validatePostalCode(userProfileDto, validationErrors);
		validateHealthInterests(userProfileDto, validationErrors);
		validateEmailForReminders(userProfileDto, validationErrors);
		//validateAtMostOnePrimaryEmergencyContact(userProfileDto,validationErrors);

		response.setValidationErrors(validationErrors);
		/*if (validationErrors.size() > 0) {
			throw new RuntimeException("Invalid UserProfile Data");
		}*/
	}

	/**
	 * Executes all field-level validations
	 */
	public void fieldValidation(ResponseUtil response, UserProfileDTO userProfileDto, boolean isRegistration) {

		// super.fieldValidation();
		LinkedHashMap<String, String> validationErrors = response.getValidationErrors();

		validateFirstName(userProfileDto, validationErrors);
		validateMiddleName(userProfileDto, validationErrors);
		validateLastName(userProfileDto, validationErrors);
		validateGender(userProfileDto, validationErrors);
		validateBirthDate(userProfileDto, validationErrors);
		validateUserType(userProfileDto, validationErrors);
		validateSsn(userProfileDto, validationErrors);
		validateConfSsn(userProfileDto, validationErrors);
		validateMatchingSSN(userProfileDto, validationErrors);
		validateAddressCountry(userProfileDto, validationErrors);
		// validateAddressStreet1(userProfileDto, validationErrors);
		// validateAddressStreet2(userProfileDto, validationErrors);
		// validateAddressCity(userProfileDto, validationErrors);
		// validateAddressPostalCode(userProfileDto, validationErrors);
		validateAddress(userProfileDto, validationErrors);
		validateAddressProvince(userProfileDto, validationErrors);
		validateUserName(userProfileDto, validationErrors);
		validatePasswordHintAnswer1(userProfileDto, validationErrors);
		validatePasswordHintAnswer2(userProfileDto, validationErrors);
		validateTermAndConditionAcceptance(userProfileDto, validationErrors);
		
		validateCreatedDate(userProfileDto, validationErrors);
		validateInterestHeart(userProfileDto, validationErrors);
		validateIsHealthCareProvider(userProfileDto, validationErrors);
		validateIsEmployee(userProfileDto, validationErrors);
		validateIsPatientAdvocate(userProfileDto, validationErrors);
		validateAutoAuthDate(userProfileDto, validationErrors);
		validateProofInstitutionId(userProfileDto, validationErrors);
		validateInterestStress(userProfileDto, validationErrors);
		validateInterestPTSD(userProfileDto, validationErrors);
		validateInterestDepression(userProfileDto, validationErrors);
		validateEmailHealthAwareness(userProfileDto, validationErrors);
		validatePhysicalProof(userProfileDto, validationErrors);
		// validateAlternateAddressStreet1(userProfileDto, validationErrors);
		// validateAlternateAddressStreet2(userProfileDto, validationErrors);
		// validateAlternateAddressCity(userProfileDto, validationErrors);
		// validateAlternateAddressState(userProfileDto, validationErrors);
		// validateAddressState(userProfileDto, validationErrors);
		// validateAlternateAddressCountry(userProfileDto, validationErrors);
		// validateAlternateAddressPostalCode(userProfileDto, validationErrors);
		// validateAlternateAddressProvince(userProfileDto, validationErrors);
		validateBloodType(userProfileDto.getBloodType(), validationErrors);
		validateIsPatient(userProfileDto, validationErrors);
		
		validateInterestDiabetes(userProfileDto, validationErrors);
		validateLockDate(userProfileDto, validationErrors);
		validateInterestSmoking(userProfileDto, validationErrors);
		validateProofLevelDate(userProfileDto, validationErrors);
		validateIsMPIControlled(userProfileDto, validationErrors);
		validateContactInfoEmail(userProfileDto, validationErrors);
		validateMatchingEmails(isRegistration, userProfileDto, validationErrors);
		validatePasswordHintQuestion1(userProfileDto, validationErrors);
		validatePasswordHintQuestion2(userProfileDto, validationErrors);
		validateRxAgreementSigned(userProfileDto, validationErrors);
		validateContactInfoHomePhone(userProfileDto, validationErrors);
		validateContactInfoMobilePhone(userProfileDto, validationErrors);
		validateContactInfoWorkPhone(userProfileDto, validationErrors);
		validateContactInfoPager(userProfileDto, validationErrors);
		validatePasswordLastChanged(userProfileDto, validationErrors);
		validateConfirmationLockOut(userProfileDto, validationErrors);
		validateTitle(userProfileDto.getName().getTitle(), validationErrors);
		validateInterestExercise(userProfileDto, validationErrors);
		validateMaritalStatus(userProfileDto.getMaritalStatus(), validationErrors);
		validateInterestAlcohol(userProfileDto, validationErrors);
		validatePasswordLockOut(userProfileDto, validationErrors);
		validateUserAlias(userProfileDto, validationErrors);
		validateAutoAuth(userProfileDto, validationErrors);
		validateEmailCredentials(userProfileDto, validationErrors);
		validateInterestReminder(userProfileDto, validationErrors);
		validateDeathDate(userProfileDto, validationErrors);
		//validateSuffix(userProfileDto.getName().getSuffix(), validationErrors);
		validateIsOrganDonor(userProfileDto, validationErrors);
		validateIsAdministrator(userProfileDto, validationErrors);
		validateAcceptTerms(userProfileDto, validationErrors);
		validateProofLevel(userProfileDto, validationErrors);
		validateTemporaryPassword(userProfileDto, validationErrors);
		validateAcceptSMTerms(userProfileDto, validationErrors);
		validateRxAgreementDate(userProfileDto, validationErrors);
		validateAcceptDisclaimer(userProfileDto, validationErrors);
		validateOrientationVideoView(userProfileDto, validationErrors);
		validateInterestMilitaryRelated(userProfileDto, validationErrors);
		validateLockCount(userProfileDto, validationErrors);
		validateCurrentLogin(userProfileDto, validationErrors);
		validateIsVeteran(userProfileDto, validationErrors);
		validateMhvId(userProfileDto, validationErrors);
		validateAcceptPrivacy(userProfileDto, validationErrors);
		validateInterestDiet(userProfileDto, validationErrors);
		validateContactInfoContactMethod(userProfileDto, validationErrors);
		validateEhrAccess(userProfileDto, validationErrors);
		validateCurrentOccupation(userProfileDto, validationErrors);
		validateInterestBloodPressure(userProfileDto, validationErrors);
		validateParticipationFormSign(userProfileDto, validationErrors);
		validateIsOther(userProfileDto, validationErrors);
		validateLastLogin(userProfileDto, validationErrors);
		validateContactInfoFax(userProfileDto, validationErrors);

		response.setValidationErrors(validationErrors);
		// call field validation on children:

		/*	for ( EmergencyContactDTO emergencyContact : userProfileDto.getEmergencyContacts())
		{
			ecValidator.fieldValidation(response, emergencyContact);
		}
		 */
		/*Set emergencyContactSet = userProfileDto.getEmergencyContacts();
		if ((emergencyContactSet != null) && (emergencyContactSet.size() > 0)) {
			EmergencyContact ec;
			Iterator emergencyContactIterator = emergencyContactSet.iterator();
			while (emergencyContactIterator.hasNext()) {
				child = (EmergencyContactBO)emergencyContactIterator.next();
				child.fieldValidation();
			}

		}*/

	}
	
	public void validateUserCredentials(ResponseUtil response, UserProfileDTO userProfileDto) {

		LinkedHashMap<String, String> validationErrors = response.getValidationErrors();
		
		validateUserName(userProfileDto, validationErrors);
		validatePassword(userProfileDto, validationErrors);
		
		response.setValidationErrors(validationErrors);
	}	
	

	private void validateMatchingSSN(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String ssn = (null == userProfileDto.getSsn()) ? "" : userProfileDto.getSsn();
		String confSsn = (null == userProfileDto.getConfSsn()) ? "" : userProfileDto.getConfSsn();
		
		// check for a value to validate:
		if ( (ssn == null || ssn.trim().length() == 0) && (confSsn == null || confSsn.trim().length() == 0)) {
			// nothing to validate
			return;
		}
		
		if (!ssn.trim().equalsIgnoreCase(confSsn.trim())) {
			validationErrors.put(UserManagementMessages.SSN_DOES_NOT_MATCH, getProperties().getProperty(UserManagementMessages.SSN_DOES_NOT_MATCH));
		}
	}

	private void validateMatchingEmails(Boolean isRegistration, UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {
		
		if (!isRegistration) {
			// nothing to validate if request it not from registration
			return;
		}
		
		String email = (null == userProfileDto.getContact().getEmail()) ? "" : userProfileDto.getContact().getEmail();
		String confEmail = (null == userProfileDto.getConfEmail()) ? "" : userProfileDto.getConfEmail();
		
		// check for a value to validate:
		if ((email == null || email.trim().length() == 0) && (confEmail == null || confEmail.trim().length() == 0)) {
			// nothing to validate
			return;
		}
		
		if (!email.trim().equalsIgnoreCase(confEmail.trim())) {
			validationErrors.put(UserManagementMessages.EMAIL_DO_NOT_MATCH, getProperties().getProperty(UserManagementMessages.EMAIL_DO_NOT_MATCH));
		}
	}

	private void validateAddress(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		validateCountry(userProfileDto.getAddress().getCountry(), validationErrors);
		validateStreetAddress1(userProfileDto.getAddress().getAddress1(), validationErrors);
		validateStreetAddress2(userProfileDto.getAddress().getAddress2(), validationErrors);
		validateCity(userProfileDto.getAddress().getCity(), validationErrors);
		validateState(userProfileDto, validationErrors);
		validateZip(userProfileDto.getAddress().getZip(), validationErrors);
	}

	private void validateZip(String zip, LinkedHashMap<String, String> validationErrors) {

		Validations.validateMaximumLength("zip", zip, 10, true, validationErrors);
	}

	private void validateState(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		if (userProfileDto.getAddress().getCountry() != null && CountryEnumeration.UNITED_STATES.getDescription().equals(userProfileDto.getAddress().getCountry())) {

			if (null == userProfileDto.getAddress().getState() || userProfileDto.getAddress().getState().length() == 0) {
				validationErrors.put(UserManagementMessages.STATE_REQUIRED, getProperties().getProperty(UserManagementMessages.STATE_REQUIRED));
				return;
			}
			String state = userProfileDto.getAddress().getState();
			boolean valid = false;
			if (Validations.hasValue(state)) {
				for (StateEnumeration s : StateEnumeration.values()) {
					if (s.getDescription().equals(state)) {
						valid = true;
						break;
					}
				}
				if (!valid) {
					validationErrors.put(UserManagementMessages.INVALID_STATE, getProperties().getProperty(UserManagementMessages.INVALID_STATE));
				}
			}
		}
	}

	private void validateCity(String city, LinkedHashMap<String, String> validationErrors) {

		Validations.validateMaximumLength("city", city, 100, true, validationErrors);
	}

	private void validateCountry(String country, LinkedHashMap<String, String> validationErrors) {

		if (!Validations.hasValue(country)) {
			validationErrors.put(UserManagementMessages.COUNTRY_REQUIRED, getProperties().getProperty(UserManagementMessages.COUNTRY_REQUIRED));
		}
		else {
			boolean valid = false;
			for (CountryEnumeration c : CountryEnumeration.values()) {
				if (c.getDescription().equals(country)) {
					valid = true;
					break;
				}
			}
			if (!valid) {
				validationErrors.put(UserManagementMessages.INVALID_COUNTRY, getProperties().getProperty(UserManagementMessages.INVALID_COUNTRY));
			}
		}
	}

	private void validateStreetAddress2(String address2, LinkedHashMap<String, String> validationErrors) {

		Validations.validateMaximumLength("address2", address2, 100, false, validationErrors);
	}

	private void validateStreetAddress1(String address1, LinkedHashMap<String, String> validationErrors) {

		Validations.validateMaximumLength("address1", address1, 100, true, validationErrors);
	}

	// Moved code
	private void validateMiddleName(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		if (BooleanUtils.isTrue(userProfileDto.getIsMPIControlled())) {
			// if MPI controlled validation should be skipped
			return;
		}
		if (userProfileDto.getName().getMiddleName() == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates interestHeart
	 */
	protected void validateInterestHeart(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getInterestHeart();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates mhvId
	 */
	protected void validateMhvId(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getMhvId();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		// check max length
		Validations.validateMaxLength("mhvId", value, MHVID_MAX_LENGTH, validationErrors);
	}

	/**
	 * Validates createdDate
	 */
	protected void validateCreatedDate(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Date value = userProfileDto.getCreatedDate();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates isMPIControlled
	 */
	protected void validateIsMPIControlled(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getIsMPIControlled();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}
	
	/**
	 * Validates First Name
	 */
	protected void validateFirstName(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getName().getFirstName();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			Validations.validateRequired("First Name", value, validationErrors);
			return;
		}

	}
	
	/**
	 * Validates Last Name
	 */
	private void validateLastName(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		if (BooleanUtils.isTrue(userProfileDto.getIsMPIControlled())) {
			// if MPI controlled validation should be skipped
			// but ensure value is not null
			return;
		}
		String value = userProfileDto.getName().getLastName();
		
		if (value == null || value.trim().length() == 0) {
			Validations.validateRequired("Last Name", value, validationErrors);
			return;
		}
		
	}

	// US8.16 & US7.16 - Last name is not blank and contains no numbers.
	// The method to check the if there is a digit in a string.
	private boolean containsDigit(String str) {

		for (int i = 0; i < str.length(); i++) {
			if (Character.isDigit(str.charAt(i))) {
				return true;
			}
		}
		return false;

	}

	private void validateUniqueUser(boolean isRegistration, UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		if (!isRegistration) {
			// nothing to validate if request it not from registration
			return;
		}

		if (BooleanUtils.isTrue(userProfileDto.getIsMPIControlled())) {
			// if MPI controlled validation should be skipped
			return;
		}
		String lastName = StringUtils.upperCase(userProfileDto.getName().getLastName());

		// Defect 135253 - If the user account is created 2nd time and if we try
		// to deactivate the 2nd time, it will fail but no error message.
		if (lastName.endsWith("DELETED") || lastName.endsWith("DECEASED")) {
			return;
		}

		boolean isProfileByNameBirthDateSsnExcludeId = false;
		boolean isProfileByNameBirthDateSsn = false;
		String firstName = userProfileDto.getName().getFirstName();
		lastName = userProfileDto.getName().getLastName();
		Date birthDate = userProfileDto.getBirthDate();
		String ssn = userProfileDto.getSsn();
		Long userProfileId = userProfileDto.getId();

		if (userProfileRepository.getProfileByNameBirthDateSsnExcludeId(firstName, lastName, birthDate, ssn, userProfileId).size() > 0) {
			isProfileByNameBirthDateSsnExcludeId = true;
		}

		if (userProfileRepository.getProfileByNameBirthDateSsn(firstName, lastName, birthDate, ssn).size() > 0) {
			isProfileByNameBirthDateSsn = true;
		}

		if (userProfileDto.getId() != null) {
			if (isProfileByNameBirthDateSsnExcludeId) {
				validationErrors.put(UserManagementMessages.USER_ALREADY_IN_USE, 
					String.format(getProperties().getProperty(UserManagementMessages.USER_ALREADY_IN_USE), 
						mviProperties.getForgotUserIdUrl(), mviProperties.getTargetWindow(), 
						mviProperties.getForgotPasswordUrl(), mviProperties.getTargetWindow(),
						mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
				return;
			} else {
				return;
			}
		} else if (isProfileByNameBirthDateSsn) {
			validationErrors.put(UserManagementMessages.USER_ALREADY_IN_USE, 
				String.format(getProperties().getProperty(UserManagementMessages.USER_ALREADY_IN_USE), 
					mviProperties.getForgotUserIdUrl(), mviProperties.getTargetWindow(),
					mviProperties.getForgotPasswordUrl(), mviProperties.getTargetWindow(),
					mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
			return;
		}

		// if valid results found, user by this name already exists, so this is
		// an error
		if (isRegistration) {
			String userName = userProfileDto.getUserName();
			if (userName == null || userName.trim().length() == 0) {
				Validations.validateRequired("User ID ", userName, validationErrors);
				return;
			}

			userName = StringUtils.lowerCase(userName);

			UserProfile userProfile = null;
			try {
				userProfile = userProfileRepository.findByUserName(userName);
			} catch (Exception e) {
				log.error("Error in invoking userProfileRepository.findByUserName for : " + userName, e);
			}
			// if valid results found, user by this name already exists, so this
			// is an error
			if (null != userProfile) {
				validationErrors.put(
					UserManagementMessages.USER_ALREADY_EXISTS, String.format(this.getErrorMessage(UserManagementMessages.USER_ALREADY_EXISTS), userName));
			}
		}
	}

	/**
	 * Validates Birth Date
	 */
	protected void validateBirthDate(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Date value = userProfileDto.getBirthDate();
		// check requiredness:
		if (value == null) {
			Validations.validateRequired("birthDate", null, validationErrors);

			// no need to continue:
			return;
		}
	}

	private void validateRequiredPatientInfo(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		if (BooleanUtils.isTrue(userProfileDto.getIsMPIControlled())) {
			// if MPI controlled validation should be skipped
			// but ensure value is not null
			return;
		}
		if (userProfileDto.getIsPatient()) {
			if (StringUtils.isBlank(userProfileDto.getSsn())) {
				// Typically SSN should be given
				// TODO:
				validationErrors.put(
					UserManagementMessages.SSN_REQUIRED_FOR_PATIENT, getProperties().getProperty(UserManagementMessages.SSN_REQUIRED_FOR_PATIENT));
			}
		}
		else if (userProfileDto.getIsVeteran()) {
			// US8.15 & US7.15 - SSN is required if Relationship to VA is or has
			// changed to Veteran and/or VA Patient.
			if (StringUtils.isBlank(userProfileDto.getSsn())) {
				// Typically SSN should be given
				// TODO:
				validationErrors.put(
					UserManagementMessages.SSN_REQUIRED_FOR_VETERAN, getProperties().getProperty(UserManagementMessages.SSN_REQUIRED_FOR_VETERAN));
			}
		}
	}

	private void validatePasswordHintQuestions(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		if ((userProfileDto.getPasswordHintQuestion1() == null) || (userProfileDto.getPasswordHintQuestion2() == null)) {
			return;
		}

		if (userProfileDto.getPasswordHintQuestion1().equals(userProfileDto.getPasswordHintQuestion2())) {
			// TODO:
			validationErrors.put(UserManagementMessages.HINTS_MUST_DIFFER, getProperties().getProperty(UserManagementMessages.HINTS_MUST_DIFFER));
		}
	}
	
	// CR2161 and CR2162 Kumar,Vyasa started here
	public void validatePasswordHintAnswers(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		if ((userProfileDto.getPasswordHintAnswer1() == null) || (userProfileDto.getPasswordHintAnswer2() == null)) {
			return;
		}
		if (userProfileDto.getPasswordHintAnswer1().trim().equalsIgnoreCase(userProfileDto.getPasswordHintAnswer2().trim())) {
			validationErrors.put(UserManagementMessages.HINTS_ANSWER_MUST_DIFFER, getProperties().getProperty(UserManagementMessages.HINTS_ANSWER_MUST_DIFFER));
		}
	}

	private void validateStateAndProvinceAndCountry(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		if (StringUtils.isNotBlank(userProfileDto.getAddress().getProvince()) && (userProfileDto.getAddress().getState() != null)) {
			// TODO:
			validationErrors.put(UserManagementMessages.PROVINCE_OR_STATE, getProperties().getProperty(UserManagementMessages.PROVINCE_OR_STATE));
		}

		if (userProfileDto.getAddress().getCountry() != null) {
			if (CountryEnumeration.UNITED_STATES.getDescription().equals(userProfileDto.getAddress().getCountry())) {
				if (userProfileDto.getAddress().getState() == null) {
					// TODO:
					validationErrors.put(UserManagementMessages.STATE_REQUIRED, getProperties().getProperty(UserManagementMessages.STATE_REQUIRED));
				}
			}
			else if (CountryEnumeration.CANADA.getDescription().equals(userProfileDto.getAddress().getCountry())) {
				if (StringUtils.isBlank(userProfileDto.getAddress().getProvince())) {
					// TODO:
					validationErrors.put(UserManagementMessages.PROVINCE_REQUIRED, getProperties().getProperty(UserManagementMessages.PROVINCE_REQUIRED));
				}
			}
		}
		else if ((userProfileDto.getAddress().getState() != null) || StringUtils.isNotBlank(userProfileDto.getAddress().getProvince())) {
			// TODO:
			validationErrors.put(UserManagementMessages.COUNTRY_REQUIRED, getProperties().getProperty(UserManagementMessages.COUNTRY_REQUIRED));
		}
	}

	private void validatePostalCode(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		if ((userProfileDto.getAddress().getCountry() != null) && StringUtils.isNotBlank(userProfileDto.getAddress().getZip()) &&
			userProfileDto.getAddress().getCountry().equals(CountryEnumeration.UNITED_STATES.getDescription())) {
			// Validator zipCodeValidator = new ZipCodeValidator();

			if (!ZipCodeValidator.isValid(userProfileDto.getAddress().getZip())) {
				// TODO:
				validationErrors.put(UserManagementMessages.INVALID_ZIP_CODE, getProperties().getProperty(UserManagementMessages.INVALID_ZIP_CODE));
			}
			/*
			 * getMessages().addMessages(zipCodeValidator.validate(
			 * userProfileDto.getAddressPostalCode(), new String []
			 * {"addressPostalCode"}, new Object [] {"addressPostalCode"}));
			 */
			// TODO:
			// validationErrors.put(zipCodeValidator.validate(userProfileDto.getAddressPostalCode(),
			// "addressPostalCode");
		}
	}

	private void validateContactMethodProvided(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {
		
		if (userProfileDto.getContact().getContactMethod() == null) {
			return;
		}
		
		ContactDTO contact = userProfileDto.getContact();
		String contactMethodMethodName = "get" + contact.getContactMethod();
		
		try {
			Method contactMethodMethod = contact.getClass().getDeclaredMethod(contactMethodMethodName, (Class[]) null);
			String contactNumber = (String) contactMethodMethod.invoke(contact, (Object[]) null);
			if (StringUtils.isBlank(contactNumber)) {
				// TODO:
				validationErrors.put(
					UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED, getProperties().getProperty(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED));
			}
		}
		catch (Exception e) {
			validationErrors.put(
				UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED, getProperties().getProperty(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED));
		}

	}

	/**
	 * Validates proofLevelDate
	 */
	protected void validateProofLevelDate(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Date value = userProfileDto.getProofLevelDate();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	private void validateTermAndConditionAcceptance(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		if ((userProfileDto.getAcceptTerms() == null) || !userProfileDto.getAcceptTerms().booleanValue()) {
			// TODO:
			validationErrors.put(UserManagementMessages.MUST_ACCEPT_TERMS, getProperties().getProperty(UserManagementMessages.MUST_ACCEPT_TERMS));
		}

		if ((userProfileDto.getAcceptPrivacy() == null) || !userProfileDto.getAcceptPrivacy().booleanValue()) {
			// TODO:
			/*
			 * addError(UserManagementMessages.MUST_ACCEPT_PRIVACY, new Object[]
			 * {});
			 */
			validationErrors.put(UserManagementMessages.MUST_ACCEPT_PRIVACY, getProperties().getProperty(UserManagementMessages.MUST_ACCEPT_PRIVACY));
		}
	}

	private void validateHealthInterests(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		if (userProfileDto.getEmailHealthAwareness() != null && userProfileDto.getEmailHealthAwareness().booleanValue() &&
			StringUtils.isBlank(userProfileDto.getContact().getEmail())) {
			// TODO:
			validationErrors.put(
				UserManagementMessages.HEALTH_INTEREST_EMAIL_REQUIRED, getProperties().getProperty(UserManagementMessages.HEALTH_INTEREST_EMAIL_REQUIRED));
		}
	}

	private void validateEmailForReminders(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {
		if (userProfileDto.getRxTrackingEmailPref() != null && userProfileDto.getRxTrackingEmailPref().booleanValue() && StringUtils.isBlank(userProfileDto.getContact().getEmail())  ||
		   (userProfileDto.getHealthSummarySentEmailPref() != null && userProfileDto.getHealthSummarySentEmailPref().booleanValue() && StringUtils.isBlank(userProfileDto.getContact().getEmail())) || 
		   userProfileDto.getApptReminderEmailPref() != null && userProfileDto.getApptReminderEmailPref().booleanValue() && StringUtils.isBlank(userProfileDto.getContact().getEmail())  ||
			userProfileDto.getBbmiEmailPref() != null && userProfileDto.getBbmiEmailPref().booleanValue() && StringUtils.isBlank(userProfileDto.getContact().getEmail())
		   )
		{
			validationErrors.put(UserManagementMessages.NOTIFICATIONS_EMAIL_REQUIRED, getProperties().getProperty(UserManagementMessages.NOTIFICATIONS_EMAIL_REQUIRED));
		}
	}

	/*
	private void validateAtMostOnePrimaryEmergencyContact(
			UserProfileDTO userProfileDto,
			LinkedHashMap<String, String> validationErrors) {
		int numberOfPrimaryContacts = 0;
		Set contacts = userProfileDto.getEmergencyContacts();
		if (contacts != null) {
			for (Object c : contacts) {
				if (BooleanUtils
						.isTrue(((EmergencyContactBO) c).getIsPrimary())) {
					numberOfPrimaryContacts++;
				}
			}
		}

		if (numberOfPrimaryContacts > 1) {
			// TODO:
			// validationErrors.put(MessageKeys.TOO_MANY_PRIMARY_CONTACTS,
			// "TOO_MANY_PRIMARY_CONTACTS");
		}
	}*/

	/**
	 * Generates a random integral number
	 * 
	 * @return int The value of the randomly generated number.
	 */
	private static int getRandomDigit() {

		int num = new Double(Math.random() * 10).intValue();
		return num;
	}

	/**
	 * Generates a random number with specified length.
	 * 
	 * @return String Generated random number with specified length.
	 */
	public static String generateRandomNumber(int len) {

		StringBuffer sb = new StringBuffer(len);

		for (int i = 0; i < len; i++) {
			sb.append(getRandomDigit());
		}
		return sb.toString();
	}

	public boolean isPatient(Boolean value) {

		return (value == null) ? false : value.booleanValue();
	}

	public boolean isVeteran(Boolean value) {

		return (value == null) ? false : value.booleanValue();
	}

	public boolean isAdministrator(Boolean value) {

		return (value == null) ? false : value.booleanValue();
	}

	public boolean isEmployee(Boolean value) {

		return (value == null) ? false : value.booleanValue();
	}

	public boolean isPatientAdvocate(Boolean value) {

		return (value == null) ? false : value.booleanValue();
	}

	public boolean isHealthCareProvider(Boolean value) {

		return (value == null) ? false : value.booleanValue();
	}

	public boolean isOther(Boolean value) {

		return (value == null) ? false : value.booleanValue();
	}

	private void validateUserType(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		if (isPatient(userProfileDto.getIsPatient()) || isVeteran(userProfileDto.getIsVeteran()) || isEmployee(userProfileDto.getIsEmployee()) ||
			isOther(userProfileDto.getIsOther()) || isPatientAdvocate(userProfileDto.getIsPatientAdvocate()) ||
			isHealthCareProvider(userProfileDto.getIsHealthCareProvider()) || isAdministrator(userProfileDto.getIsAdministrator())) {
			return;
		}
		// TODO: Geetha : Set a valid message from a Constants class
		// response.getValidationErrors().put(UserManagementMessages.MISSING_USER_TYPE,
		// new Object[] {});
		validationErrors.put(UserManagementMessages.MISSING_USER_TYPE, getProperties().getProperty(UserManagementMessages.MISSING_USER_TYPE));

	}

	/**
	 * Validates isHealthCareProvider
	 */
	protected void validateIsHealthCareProvider(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getIsHealthCareProvider();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates Country
	 */
	protected void validateAddressCountry(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getAddress().getCountry();
		// check requiredness:
		if (value == null || value.trim().length() == 0) {
			Validations.validateRequired("addressCountry", value, validationErrors);

			// no need to continue:
			return;
		}

		boolean valid = false;
		if (Validations.hasValue(value)) {
			for (CountryEnumeration s : CountryEnumeration.values()) {
				if (s.getDescription().equals(value)) {
					valid = true;
					break;
				}
			}
			if (!valid) {
				validationErrors.put(UserManagementMessages.INVALID_COUNTRY, getProperties().getProperty(UserManagementMessages.INVALID_COUNTRY));
			}
		}
	}

	/**
	 * Validates isEmployee
	 */
	protected void validateIsEmployee(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getIsEmployee();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates Email
	 */
	protected void validateContactInfoEmail(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getContact().getEmail();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}

		if (!EmailValidator.isValid(value)) {
			validationErrors.put(UserManagementMessages.INVALID_EMAIL, getProperties().getProperty(UserManagementMessages.INVALID_EMAIL));
		}
	}

	/**
	 * Validates Blood Type
	 */
	protected void validateBloodType(String value, LinkedHashMap<String, String> validationErrors) {

		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}

		boolean valid = false;
		if (Validations.hasValue(value)) {
			for (BloodTypeEnumeration s : BloodTypeEnumeration.values()) {
				if (s.toString().equals(value)) {
					valid = true;
					break;
				}
			}
			if (!valid) {
				validationErrors.put(UserManagementMessages.INVALID_BLOODTYPE, getProperties().getProperty(UserManagementMessages.INVALID_BLOODTYPE));
			}
		}
	}

	/**
	 * Validates Address 1
	 */
	protected void validateAddressStreet1(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getAddress().getAddress1();
		// check requiredness:
		if (value == null || value.trim().length() == 0) {
			Validations.validateRequired("addressStreet1", value, validationErrors);

			// no need to continue:
			return;
		}
		// check max length
		Validations.validateMaxLength("addressStreet1", value, ADDRESSSTREET1_MAX_LENGTH, validationErrors);
	}

	/**
	 * Validates isPatientAdvocate
	 */
	protected void validateIsPatientAdvocate(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getIsPatientAdvocate();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates autoAuthDate
	 */
	protected void validateAutoAuthDate(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Date value = userProfileDto.getAutoAuthDate();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates User Name
	 */
	protected void validateUserName(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getUserName();
		// check requiredness:
		if (value == null || value.trim().length() == 0) {
			Validations.validateRequired("UserName", value, validationErrors);

			// no need to continue:
			return;
		}
		// check min length
		Validations.validateMinLength("UserName", value, USERNAME_MIN_LENGTH, validationErrors);
		// check max length
		Validations.validateMaxLength("UserName", value, USERNAME_MAX_LENGTH, validationErrors);
		
		if( ! StringUtils.isAlphanumeric( value ) ) {
			validationErrors.put(UserManagementMessages.USERNAME_NOT_ALPHANUMERIC, getProperties().getProperty(UserManagementMessages.USERNAME_NOT_ALPHANUMERIC));
		}
	}
	
	public void validatePassword(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {
		String userName = userProfileDto.getUserName();
		String password = userProfileDto.getPassword();
		String confirmPassword = userProfileDto.getConfPassword();
		
		boolean blankValues = false;
		if( StringUtils.isBlank( password ) ) {
			Validations.validateRequired("Password", password, validationErrors);
			blankValues = true;
		}
		if( StringUtils.isBlank( confirmPassword ) ) {
			Validations.validateRequired("Confirm password", password, validationErrors);
			blankValues = true;
		}
		if( !password.equals( confirmPassword ) ) {
			validationErrors.put(UserManagementMessages.PASSWORD_NOT_CONFIRM, getProperties().getProperty(UserManagementMessages.PASSWORD_NOT_CONFIRM));
			blankValues = true;
		}
		if( blankValues ) {
			return;
		}

		if( password.equals( userName ) ) {
			validationErrors.put(UserManagementMessages.USERNAME_PASSWORD_EQUAL, getProperties().getProperty(UserManagementMessages.USERNAME_PASSWORD_EQUAL));
		}

		if( password.length() < 8 || password.length() > 12 ) {
			validationErrors.put(UserManagementMessages.PASSWORD_INVALID_LENGTH, getProperties().getProperty(UserManagementMessages.PASSWORD_INVALID_LENGTH));
		}

		if( StringUtils.contains( password, " " ) ) {
			validationErrors.put(UserManagementMessages.PASSWORD_SPACES_NOT_ALLOWED, getProperties().getProperty(UserManagementMessages.PASSWORD_SPACES_NOT_ALLOWED));
		}

		boolean hasSpecialChar = false;
		boolean hasDigit = false;
		boolean hasLetter = false;
		for( int i=0; i<password.length(); i++ ) {
			if( hasSpecialChar && hasDigit && hasLetter ) {
				break;
			}
			char c = password.charAt( i );
			if( !hasLetter && Character.isLetter( c ) ) {
				hasLetter = true;
			}
			else if( !hasDigit && Character.isDigit( c ) ) {
				hasDigit = true;
			}
			else if( !hasSpecialChar && SPECIAL_CHARS.contains( new Character( c ) ) ) {
				hasSpecialChar = true;
			}
		}
		if( ! hasSpecialChar ) {
			validationErrors.put(UserManagementMessages.PASSWORD_NO_SPECIAL_CHAR, getProperties().getProperty(UserManagementMessages.PASSWORD_NO_SPECIAL_CHAR));
		}
		if( ! hasLetter ) {
			validationErrors.put(UserManagementMessages.PASSWORD_NO_LETTER, getProperties().getProperty(UserManagementMessages.PASSWORD_NO_LETTER));
		}
		if( ! hasDigit ) {
			validationErrors.put(UserManagementMessages.PASSWORD_NO_DIGIT, getProperties().getProperty(UserManagementMessages.PASSWORD_NO_DIGIT));
		}
		
		List<UserPasswordHistory> prevPasswords =passwordHistoryRepository.getPreviousPasswords(userProfileDto.getId());
		if(prevPasswords != null && prevPasswords.size() > 0){
			UserPasswordHistory prevPassword =prevPasswords.get(0);
			if(!prevPassword.getPassword().equalsIgnoreCase(PasswordUtil.digest(userProfileDto.getOldPassword(),"SHA"))){
				validationErrors.put(UserManagementMessages.CURRENT_PASSWORD_INVALID, getProperties().getProperty(UserManagementMessages.CURRENT_PASSWORD_INVALID));
			}
		}

		
		boolean matchOldPassword=false;
		if(validationErrors != null && validationErrors.size()== 0 ){
			Pageable topThree = new  PageRequest(0,3);
			List<UserPasswordHistory> passwordList=passwordHistoryRepository.getLastThreePasswords(userProfileDto.getId(), topThree);
			if(passwordList != null && passwordList.size() > 0){
				for(UserPasswordHistory history:passwordList){
					if(history.getPassword().equalsIgnoreCase(PasswordUtil.digest(userProfileDto.getPassword(),"SHA"))){
						matchOldPassword=true;
						break;
					}
				}
			}
		}
		
		if(matchOldPassword){
			validationErrors.put(UserManagementMessages.PASSWORD_USED, getProperties().getProperty(UserManagementMessages.PASSWORD_USED));
		}

	}
	

	/**
	 * Validates interestSmoking
	 */
	protected void validateInterestSmoking(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getInterestSmoking();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates Hint Question 1
	 */
	protected void validatePasswordHintQuestion1(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Integer value = userProfileDto.getPasswordHintQuestion1();
		// check requiredness:
		if (value == null) {
			validationErrors.put(UserManagementMessages.PASSQ1_REQUIRED, getProperties().getProperty(UserManagementMessages.PASSQ1_REQUIRED));
			
			// no need to continue:
			return;
		}

		// validate a valid enumeration value:
		boolean valid = false;
		for (PasswordHintQuestionsEnumeration s : PasswordHintQuestionsEnumeration.values()) {
			if (s.getValue() == value) {
				valid = true;
				break;
			}
		}
		if (!valid) {
			validationErrors.put(UserManagementMessages.INVALID_PASSQ1, getProperties().getProperty(UserManagementMessages.INVALID_PASSQ1));
		}
	}
	
	/**
	 * Validates Hint Question 2
	 */
	protected void validatePasswordHintQuestion2(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Integer value = userProfileDto.getPasswordHintQuestion1();
		// check requiredness:
		if (value == null) {
			validationErrors.put(UserManagementMessages.PASSQ2_REQUIRED, getProperties().getProperty(UserManagementMessages.PASSQ2_REQUIRED));

			// no need to continue:
			return;
		}

		// validate a valid enumeration value:
		boolean valid = false;
		for (PasswordHintQuestionsEnumeration s : PasswordHintQuestionsEnumeration.values()) {
			if (s.getValue() == value) {
				valid = true;
				break;
			}
		}
		if (!valid) {
			validationErrors.put(UserManagementMessages.INVALID_PASSQ2, getProperties().getProperty(UserManagementMessages.INVALID_PASSQ2));
		}
	}

	/**
	 * Validates rxAgreementSigned
	 */
	protected void validateRxAgreementSigned(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getRxAgreementSigned();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates proofInstitutionId
	 */
	protected void validateProofInstitutionId(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Integer value = userProfileDto.getProofInstitutionId();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates alternateAddressPostalCode
	 */
	protected void validateAlternateAddressPostalCode(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getAlternateAddressPostalCode();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		// check max length
		Validations.validateMaxLength("alternateAddressPostalCode", value, ALTERNATEADDRESSPOSTALCODE_MAX_LENGTH, validationErrors);
	}

	/**
	 * Validates Mobile Phone
	 */
	protected void validateContactInfoMobilePhone(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getContact().getMobilePhone();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		// check max length
		Validations.validateMaxLength("Mobile Phone", value, CONTACTINFOMOBILEPHONE_MAX_LENGTH, validationErrors);
	}

	/**
	 * Validates Hint Answer 1
	 */
	protected void validatePasswordHintAnswer1(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getPasswordHintAnswer1();
		// check requiredness:
		if (value == null || value.trim().length() == 0) {
			Validations.validateRequired("passwordHintAnswer1", value, validationErrors);

			// no need to continue:
			return;
		}
	}

	/**
	 * Validates interestStress
	 */
	protected void validateInterestStress(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getInterestStress();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates alternateAddressCity
	 */
	protected void validateAlternateAddressCity(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getAlternateAddressCity();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		// check max length
		Validations.validateMaxLength("alternateAddressCity", value, ALTERNATEADDRESSCITY_MAX_LENGTH, validationErrors);
	}

	/**
	 * Validates rxAgreementDate
	 */
	protected void validateRxAgreementDate(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Date value = userProfileDto.getRxAgreementDate();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates Fax
	 */
	protected void validateContactInfoFax(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getContact().getFax();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		// check max length
		Validations.validateMaxLength("Fax", value, CONTACTINFOFAX_MAX_LENGTH, validationErrors);
	}

	/**
	 * Validates interestPTSD
	 */
	protected void validateInterestPTSD(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getInterestPTSD();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates Province
	 */
	protected void validateAddressProvince(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getAddress().getProvince();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		// check max length
		Validations.validateMaxLength("addressProvince", value, ADDRESSPROVINCE_MAX_LENGTH, validationErrors);
	}

	/**
	 * Validates confirmationLockOut
	 */
	protected void validateConfirmationLockOut(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getConfirmationLockOut();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates alternateAddressState
	 */
	protected void validateAlternateAddressState(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String state = userProfileDto.getAlternateAddressState();
		if (!Validations.hasValue(state)) {
			validationErrors.put(UserManagementMessages.ALTR_STATE_REQUIRED, getProperties().getProperty(UserManagementMessages.ALTR_STATE_REQUIRED));
			return;
		}
		boolean valid = false;
		if (Validations.hasValue(state)) {
			for (StateEnumeration s : StateEnumeration.values()) {
				if (s.getDescription().equals(state)) {
					valid = true;
					break;
				}
			}
			if (!valid) {
				validationErrors.put(UserManagementMessages.INVALID_ALTR_STATE, getProperties().getProperty(UserManagementMessages.INVALID_ALTR_STATE));
			}
		}
	}
	
	/**
	 * Validates State
	 */
	protected void validateAddressState(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String state = userProfileDto.getAddressState();
		if (!Validations.hasValue(state)) {
			validationErrors.put(UserManagementMessages.ADDRSTATE_REQUIRED, getProperties().getProperty(UserManagementMessages.ADDRSTATE_REQUIRED));
			return;
		}
		boolean valid = false;
		if (Validations.hasValue(state)) {
			for (StateEnumeration s : StateEnumeration.values()) {
				if (s.getDescription().equals(state)) {
					valid = true;
					break;
				}
			}
			if (!valid) {
				validationErrors.put(UserManagementMessages.INVALID_ADDRSTATE, getProperties().getProperty(UserManagementMessages.INVALID_ADDRSTATE));
			}
		}
	}

	/**
	 * Validates Zip/Postal Code
	 */
	protected void validateAddressPostalCode(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getAddress().getZip();
		// check requiredness:
		if (value == null || value.trim().length() == 0) {
			Validations.validateRequired("addressPostalCode", value, validationErrors);

			// no need to continue:
			return;
		}
		// check max length
		Validations.validateMaxLength("addressPostalCode", value, ADDRESSPOSTALCODE_MAX_LENGTH, validationErrors);
	}

	/**
	 * Validates Home Phone
	 */
	protected void validateContactInfoHomePhone(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationError) {

		String value = userProfileDto.getContact().getHomePhone();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		// check max length
		Validations.validateMaxLength("Home Phone", value, CONTACTINFOHOMEPHONE_MAX_LENGTH, validationError);
	}

	/**
	 * Validates emailHealthAwareness
	 */
	protected void validateEmailHealthAwareness(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getEmailHealthAwareness();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates currentOccupation
	 */
	protected void validateCurrentOccupation(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getOccupation();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		// check max length
		Validations.validateMaxLength("currentOccupation", value, CURRENTOCCUPATION_MAX_LENGTH, validationErrors);
	}

	/**
	 * Validates Pager
	 */
	protected void validateContactInfoPager(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getContact().getPager();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		// check max length
		Validations.validateMaxLength("Pager", value, CONTACTINFOPAGER_MAX_LENGTH, validationErrors);
	}

	/**
	 * Validates lockDate
	 */
	protected void validateLockDate(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Date value = userProfileDto.getLockDate();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates Hint Answer 2
	 */
	protected void validatePasswordHintAnswer2(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getPasswordHintAnswer2();
		// check requiredness:
		if (value == null || value.trim().length() == 0) {
			Validations.validateRequired("passwordHintAnswer2", value, validationErrors);

			// no need to continue:
			return;
		}
	}

	/**
	 * Validates isAdministrator
	 */
	protected void validateIsAdministrator(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getIsAdministrator();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates userAlias
	 */
	protected void validateUserAlias(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getUserAlias();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		// check max length
		Validations.validateMaxLength("userAlias", value, USERALIAS_MAX_LENGTH, validationErrors);
	}

	/**
	 * Validates City
	 */
	protected void validateAddressCity(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getAddress().getCity();
		// check requiredness:
		if (value == null || value.trim().length() == 0) {
			Validations.validateRequired("addressCity", value, validationErrors);

			// no need to continue:
			return;
		}
		// check max length
		Validations.validateMaxLength("addressCity", value, ADDRESSCITY_MAX_LENGTH, validationErrors);
	}

	/**
	 * Validates Address 2
	 */
	protected void validateAddressStreet2(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getAddress().getAddress2();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		// check max length
		Validations.validateMaxLength("addressStreet2", value, ADDRESSSTREET2_MAX_LENGTH, validationErrors);
	}

	/**
	 * Validates interestDepression
	 */
	protected void validateInterestDepression(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getInterestDepression();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates Social Security Number
	 */
	protected void validateSsn(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getSsn();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		
		if (!SSNValidator.isValid(value)) {
			validationErrors.put(UserManagementMessages.INVALID_SSN, getProperties().getProperty(UserManagementMessages.INVALID_SSN));
		}
	}

	/**
	 * Validates Social Security Number
	 */
	protected void validateConfSsn(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getConfSsn();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		
		if (!SSNValidator.isValid(value)) {
			validationErrors.put(UserManagementMessages.INVALID_CONF_SSN, getProperties().getProperty(UserManagementMessages.INVALID_CONF_SSN));
		}
	}

	/**
	 * Validates Work Phone
	 */
	protected void validateContactInfoWorkPhone(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getContact().getWorkPhone();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		// check max length
		Validations.validateMaxLength("Work Phone", value, CONTACTINFOWORKPHONE_MAX_LENGTH, validationErrors);
	}

	/**
	 * Validates physicalProof
	 */
	protected void validatePhysicalProof(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getPhysicalProof();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates alternateAddressProvince
	 */
	protected void validateAlternateAddressProvince(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getAlternateAddressProvince();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		// check max length
		Validations.validateMaxLength("alternateAddressProvince", value, ALTERNATEADDRESSPROVINCE_MAX_LENGTH, validationErrors);
	}

	/**
	 * Validates isPatient
	 */
	protected void validateIsPatient(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getIsPatient();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**	
	 * Validates Gender
	 */
	protected void validateGender(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getGender();
		
		if (value == null || value.trim().length() == 0) {
			Validations.validateRequired("Gender", value, validationErrors);
			return;
		}
		
		boolean valid = false;
		if (Validations.hasValue(value)) {
			for (GenderEnumeration s : GenderEnumeration.values()) {
				if (s.getDescription().equals(value)) {
					valid = true;
					break;
				}
			}
			if (!valid) {
				validationErrors.put(UserManagementMessages.INVALID_GENDER, getProperties().getProperty(UserManagementMessages.INVALID_GENDER));
			}
		}
	}

	/**
	 * Validates interestDiabetes
	 */
	protected void validateInterestDiabetes(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getInterestDiabetes();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates passwordLastChanged
	 */
	protected void validatePasswordLastChanged(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Date value = userProfileDto.getPasswordLastChanged();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates Accept Privacy
	 */
	protected void validateAcceptPrivacy(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getAcceptPrivacy();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates interestBloodPressure
	 */
	protected void validateInterestBloodPressure(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getInterestBloodPressure();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates interestExercise
	 */
	protected void validateInterestExercise(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getInterestExercise();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates lockCount
	 */
	protected void validateLockCount(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Integer value = userProfileDto.getLockCount();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates isOrganDonor
	 */
	protected void validateIsOrganDonor(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getIsOrganDonor();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates alternateAddressStreet2
	 */
	protected void validateAlternateAddressStreet2(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getAlternateAddressStreet2();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		// check max length
		Validations.validateMaxLength("alternateAddressStreet2", value, ALTERNATEADDRESSSTREET2_MAX_LENGTH, validationErrors);
	}

	/**
	 * Validates Death Date
	 */
	protected void validateDeathDate(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Date value = userProfileDto.getDeathDate();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates interestAlcohol
	 */
	protected void validateInterestAlcohol(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getInterestAlcohol();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates isOther
	 */
	protected void validateIsOther(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getIsOther();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates emailCredentials
	 */
	protected void validateEmailCredentials(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getEmailCredentials();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates interestDiet
	 */
	protected void validateInterestDiet(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getInterestDiet();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates alternateAddressCountry
	 */
	protected void validateAlternateAddressCountry(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getAddress().getCountry();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}

		// validate a valid enumeration value:
		// String enumName = value.name();
		Validations.validateRequired("alternateAddressCountry", value, validationErrors);
	}

	/**
	 * Validates interestReminder
	 */
	protected void validateInterestReminder(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getInterestReminder();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates orientationVideoView
	 */
	protected void validateOrientationVideoView(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getOrientationVideoView();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates passwordLockOut
	 */
	protected void validatePasswordLockOut(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getPasswordLockOut();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates Accept SM Terms
	 */
	protected void validateAcceptSMTerms(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getAcceptSMTerms();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates Title
	 */
	private void validateTitle(String value, LinkedHashMap<String, String> validationErrors) {

		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}

		boolean valid = false;
		if (Validations.hasValue(value)) {
			for (TitleEnumeration s : TitleEnumeration.values()) {
				if (s.getDescription().equals(value)) {
					valid = true;
					break;
				}
			}
			if (!valid) {
				validationErrors.put(UserManagementMessages.INVALID_TITLE, getProperties().getProperty(UserManagementMessages.INVALID_TITLE));
			}
		}
	}

	/**
	 * Validates maritalStatus
	 */
	private void validateMaritalStatus(String value, LinkedHashMap<String, String> validationErrors) {

		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}

		boolean valid = false;
		if (Validations.hasValue(value)) {
			for (MaritalStatusEnumeration s : MaritalStatusEnumeration.values()) {
				if (s.getDescription().equals(value)) {
					valid = true;
					break;
				}
			}
			if (!valid) {
				validationErrors.put(UserManagementMessages.INVALID_MARITAL_STATUS, getProperties().getProperty(UserManagementMessages.INVALID_MARITAL_STATUS));
			}
		}
	}

	/**
	 * Validates alternateAddressStreet1
	 */
	protected void validateAlternateAddressStreet1(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getAlternateAddressStreet1();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}
		// check max length
		Validations.validateMaxLength("alternateAddressStreet1", value, ALTERNATEADDRESSSTREET1_MAX_LENGTH, validationErrors);
	}
	
	/**
	 * Validates currentLogin
	 */
	protected void validateCurrentLogin(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Date value = userProfileDto.getCurrentLogin();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates Suffix
	 */
	protected void validateSuffix(String value, LinkedHashMap<String, String> validationErrors) {

		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}

		boolean valid = false;
		if (Validations.hasValue(value)) {
			for (SuffixEnumeration s : SuffixEnumeration.values()) {
				if (s.getDescription().equals(value)) {
					valid = true;
					break;
				}
			}
			if (!valid) {
				validationErrors.put(UserManagementMessages.INVALID_SUFFIX, getProperties().getProperty(UserManagementMessages.INVALID_SUFFIX));
			}
		}
	}

	/**
	 * Validates participationFormSign
	 */
	protected void validateParticipationFormSign(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getParticipationFormSign();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates Accept Terms
	 */
	protected void validateAcceptTerms(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getAcceptTerms();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates interestMilitaryRelated
	 */
	protected void validateInterestMilitaryRelated(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getInterestMilitaryRelated();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates lastLogin
	 */
	protected void validateLastLogin(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Date value = userProfileDto.getLastLogin();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates Accept Disclaimer
	 */
	protected void validateAcceptDisclaimer(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getAcceptDisclaimer();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates temporaryPassword
	 */
	protected void validateTemporaryPassword(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getTemporaryPassword();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates ehrAccess
	 */
	protected void validateEhrAccess(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getEhrAccess();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}

	/**
	 * Validates Contact Method
	 */
	protected void validateContactInfoContactMethod(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		String value = userProfileDto.getContact().getContactMethod();
		// check requiredness:
		if (value == null || value.trim().length() == 0) {
			Validations.validateRequired("contactInfoContactMethod", value.toString(), validationErrors);

			// no need to continue:
			return;
		}

		// validate a valid enumeration value:
		// String enumName = value.name();
		// Validations.validateEnumeration( "contactInfoContactMethod", value,
		// ContactMethodEnumeration.valueOf(enumName),validationErrors );
	}

	/**
	 * Validates isVeteran
	 */
	protected void validateIsVeteran(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {

		Boolean value = userProfileDto.getIsVeteran();
		// check for a value to validate:
		if (value == null) {
			// nothing to validate
			return;
		}
	}
	
	/**
	 * Validates autoAuth
	 */
	protected void validateAutoAuth(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {
		Boolean value = userProfileDto.getAutoAuth();
		//check for a value to validate:
		if ( value == null ) {
			//nothing to validate
			return;
		}						
	}
	
	/**
	 * Validates proofLevel
	 */
	protected void validateProofLevel(UserProfileDTO userProfileDto, LinkedHashMap<String, String> validationErrors) {
		String value = userProfileDto.getProofLevel();
		//check for a value to validate:
		if ( value == null ) {
			//nothing to validate
			return;
		}						
		//check max length
		Validations.validateMaxLength("proofLevel", value, PROOFLEVEL_MAX_LENGTH, validationErrors);
	}
	
	public void validateHintAnswers(String answer1,String answer2, UserProfile userProfile ,ResponseUtil response) {
		LinkedHashMap<String, String> validationErrors = response.getValidationErrors();

		if(validationErrors == null) {
			validationErrors = new LinkedHashMap<String, String>();
		}
				
		if( userProfile == null) {
			validationErrors.put(UserManagementMessages.HINT_ANSWER_REQUIRED, getProperties().getProperty(UserManagementMessages.HINT_ANSWER_REQUIRED));
			
			validationErrors.put(UserManagementMessages.HINT_ANSWER_NO_MATCH, getProperties().getProperty(UserManagementMessages.HINT_ANSWER_NO_MATCH));
			response.setValidationErrors(validationErrors);
		}else {
			if( answer1 == null || answer1.length() == 0 || answer2 == null || answer2.length() == 0 ) {
			
			validationErrors.put(UserManagementMessages.HINT_ANSWER_REQUIRED, getProperties().getProperty(UserManagementMessages.HINT_ANSWER_REQUIRED));
			
			validationErrors.put(UserManagementMessages.HINT_ANSWER_NO_MATCH, getProperties().getProperty(UserManagementMessages.HINT_ANSWER_NO_MATCH));
			response.setValidationErrors(validationErrors);
			} else {
			if( answer1 != null && ! answer1.equalsIgnoreCase(userProfile.getPasswordHintAnswer1()) && answer2 != null && !answer2.equalsIgnoreCase(userProfile.getPasswordHintAnswer2()) )  {
				validationErrors.put(UserManagementMessages.HINT_ANSWER_REQUIRED, getProperties().getProperty(UserManagementMessages.HINT_ANSWER_REQUIRED));
				
				validationErrors.put(UserManagementMessages.HINT_ANSWER_NO_MATCH, getProperties().getProperty(UserManagementMessages.HINT_ANSWER_NO_MATCH));
				response.setValidationErrors(validationErrors);
			}
		}
	}
	}
	private String getErrorMessage(String errorKey) {
		return getProperties().getProperty(errorKey);
	}
}
