package gov.va.med.mhv.usermgmt.main.service.validator;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;

import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.dto.EmergencyContactDTO;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.core.validate.Validations;
import gov.va.med.mhv.core.validate.Validator;
import gov.va.med.mhv.usermgmt.common.enums.CountryEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.StateEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.SuffixEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.TitleEnumeration;
import gov.va.med.mhv.usermgmt.messages.UserManagementMessages;

@Component
public class EmergencyContactValidator extends Validator{
	
	
	public static final int ADDRESSSTREET1_MAX_LENGTH = 100;
	public static final int ADDRESSPROVINCE_MAX_LENGTH = 50;
	public static final int CONTACTINFOWORKPHONEEXT_MAX_LENGTH = 10;
	public static final int ADDRESSSTREET2_MAX_LENGTH = 100;
	public static final int ADDRESSPOSTALCODE_MAX_LENGTH = 10;
	public static final int ADDRESSCITY_MAX_LENGTH = 100;
	public static final int CONTACTINFOHOMEPHONE_MAX_LENGTH = 20;
	public static final int CONTACTINFOMOBILEPHONE_MAX_LENGTH = 20;
	public static final int CONTACTINFOWORKPHONE_MAX_LENGTH = 20;
	public static final int CONTACTINFOPAGER_MAX_LENGTH = 20;
	public static final int CONTACTINFOFAX_MAX_LENGTH = 20;
	
	
	protected void complexValidation(ResponseUtil response,
			EmergencyContactDTO emergencyContactDto) {
		LinkedHashMap<String, String> validationErrors = response.getValidationErrors();
		
		if (validationErrors == null || validationErrors.size() == 0) {
			validateStateAndProvinceAndCountry(emergencyContactDto,validationErrors);
			validateContactMethodProvided(emergencyContactDto,validationErrors);
		}
	}
	
	/**
	 * Executes all field-level validations
	 */
	public void fieldValidation(ResponseUtil response,
			EmergencyContactDTO emergencyContactDto) {	//	super.fieldValidation();
		LinkedHashMap<String, String> validationErrors = response.getValidationErrors();
//		validateAddress(emergencyContactDto, validationErrors);
		//validateAddressStreet1(emergencyContactDto, validationErrors);
//		validateTitle( emergencyContactDto.getTitle(),  validationErrors);
		//validateContactInfoEmail(emergencyContactDto, validationErrors);
//		validateIsPrimary(emergencyContactDto, validationErrors);
//		validateAddressProvince(emergencyContactDto, validationErrors);
		validateStateAndProvinceAndCountry(emergencyContactDto, validationErrors);
		//validateAddressState(emergencyContactDto, validationErrors);
//		validateContactInfoWorkPhoneExt(emergencyContactDto, validationErrors);
//		validateRelationship(emergencyContactDto, validationErrors);
		validateFirstName(emergencyContactDto, validationErrors);
		//validateAddressStreet2(emergencyContactDto, validationErrors);
		validateLastName(emergencyContactDto, validationErrors);
		//validateAddressPostalCode(emergencyContactDto, validationErrors);
		//validateAddressCountry(emergencyContactDto, validationErrors);
		//validateAddressCity(emergencyContactDto, validationErrors);
		//validateSuffix( emergencyContactDto.getSuffix(),  validationErrors);
//		validateMiddleName(emergencyContactDto, validationErrors);
		validateContactInfo(emergencyContactDto,  validationErrors);
		validatePriority(emergencyContactDto, validationErrors);
	}	
	
	private void validateContactInfo(EmergencyContactDTO emergencyContactDto,
			LinkedHashMap<String, String> validationErrors) {
		String value = emergencyContactDto.getContactInfoContactMethod();
		if( value == null || StringUtils.isBlank( value ) ) {
			validationErrors.put(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED,getProperties().getProperty(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED));
			return;
		}

		Validations.validateMaxLength("Home Phone", emergencyContactDto.getContactInfoHomePhone(), CONTACTINFOHOMEPHONE_MAX_LENGTH, validationErrors);
		Validations.validateMaxLength("Mobile Phone", emergencyContactDto.getContactInfoMobilePhone(), CONTACTINFOHOMEPHONE_MAX_LENGTH, validationErrors);
		Validations.validateMaxLength("Work Phone", emergencyContactDto.getContactInfoWorkPhone(), CONTACTINFOHOMEPHONE_MAX_LENGTH, validationErrors);
		Validations.validateMaxLength("Pager", emergencyContactDto.getContactInfoPager(), CONTACTINFOHOMEPHONE_MAX_LENGTH, validationErrors);
		Validations.validateMaxLength("Fax", emergencyContactDto.getContactInfoFax(), CONTACTINFOHOMEPHONE_MAX_LENGTH, validationErrors);
		validateContactInfoEmail(emergencyContactDto, validationErrors);
		
		if( "Home Phone".equals(value) ) {
			validateContactInfoHomePhone(emergencyContactDto, validationErrors);
			return;
		}
		if( "Mobile Phone".equals(value) ) {
			validateContactInfoMobilePhone(emergencyContactDto, validationErrors);
			return;
		}
		if( "Work Phone".equals(value) ) {
			validateContactInfoWorkPhone(emergencyContactDto, validationErrors);
			return;
		}
		if( "Pager".equals(value) ) {
			validateContactInfoPager(emergencyContactDto, validationErrors);
			return;
		}
		if( "Fax".equals(value) ) {
			validateContactInfoFax(emergencyContactDto, validationErrors);
			return;
		}
		if( "Email".equals(value) ) {
			validateContactInfoEmail(emergencyContactDto, validationErrors);
			return;
		}
		
	}
	
	private void validateStateAndProvinceAndCountry(EmergencyContactDTO emergencyContactDto,
			LinkedHashMap<String, String> validationErrors) {	
		if( StringUtils.isNotBlank( emergencyContactDto.getAddressProvince() ) && (emergencyContactDto.getAddressState() != null && !"state".equalsIgnoreCase(emergencyContactDto.getAddressState())) ) {
			validationErrors.put(UserManagementMessages.PROVINCE_OR_STATE,getProperties().getProperty(UserManagementMessages.PROVINCE_OR_STATE));
			//addError( UserManagementMessages.PROVINCE_OR_STATE, new Object[] {} );
		}
		
		if( emergencyContactDto.getAddressCountry() != null ) {
			if( CountryEnumeration.UNITED_STATES.getDescription().equals( emergencyContactDto.getAddressCountry() ) ) {
				if( emergencyContactDto.getAddressState() == null || emergencyContactDto.getAddressState().length() == 0 || emergencyContactDto.getAddressState().equalsIgnoreCase("state") ) {
					//addError( UserManagementMessages.STATE_REQUIRED, new Object[] {} );
					validationErrors.put(UserManagementMessages.STATE_REQUIRED,getProperties().getProperty(UserManagementMessages.STATE_REQUIRED));
				}
			}
			else if( CountryEnumeration.CANADA.getDescription().equals( emergencyContactDto.getAddressCountry() ) ){
				if( StringUtils.isBlank( emergencyContactDto.getAddressProvince() ) ) {
					//addError( UserManagementMessages.PROVINCE_REQUIRED, new Object[] {} );
					validationErrors.put(UserManagementMessages.PROVINCE_REQUIRED,getProperties().getProperty(UserManagementMessages.PROVINCE_REQUIRED));
				}
			}
		}
		else if( (emergencyContactDto.getAddressState() != null && "state".equalsIgnoreCase(emergencyContactDto.getAddressState())) || StringUtils.isNotBlank( emergencyContactDto.getAddressProvince() ) ) {
			//addError( UserManagementMessages.COUNTRY_REQUIRED, new Object[] {} );
			validationErrors.put(UserManagementMessages.COUNTRY_REQUIRED,getProperties().getProperty(UserManagementMessages.COUNTRY_REQUIRED));
		}		
	}
	
	
	private void validateAddress(EmergencyContactDTO emergencyContactDto, LinkedHashMap<String, String> validationErrors) {
		
		validateAddressCountry(emergencyContactDto, validationErrors);
		validateStreetAddress1(emergencyContactDto.getAddressStreet1(), validationErrors);
		validateStreetAddress2(emergencyContactDto.getAddressStreet2(), validationErrors);
		validateCity(emergencyContactDto.getAddressCity(), validationErrors);
		validateAddressState(emergencyContactDto, validationErrors);
		validateZip(emergencyContactDto.getAddressPostalCode(), validationErrors);
	}
	
	private void validateZip(String zip, LinkedHashMap<String, String> validationErrors) {

		Validations.validateMaximumLength("zip", zip, 10, true, validationErrors);
	}

	private void validateCity(String city, LinkedHashMap<String, String> validationErrors) {

		Validations.validateMaximumLength("city", city, 100, true, validationErrors);
	}


	/**
	 * Validates Suffix
	 */
	protected void validateSuffix(String value, LinkedHashMap<String, String> validationErrors) {

		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}

		boolean valid = false;
		if (Validations.hasValue(value)) {
			for (SuffixEnumeration s : SuffixEnumeration.values()) {
				if (s.getDescription().equals(value)) {
					valid = true;
					break;
				}
			}
			if (!valid) {
				validationErrors.put(UserManagementMessages.INVALID_SUFFIX, getProperties().getProperty(UserManagementMessages.INVALID_SUFFIX));
			}
		}
	}
	private void validateStreetAddress2(String address2, LinkedHashMap<String, String> validationErrors) {

		Validations.validateMaximumLength("address2", address2, 100, false, validationErrors);
	}

	private void validateStreetAddress1(String address1, LinkedHashMap<String, String> validationErrors) {

		Validations.validateMaximumLength("address1", address1, 100, true, validationErrors);
	}
	
	private void validateContactMethodProvided(EmergencyContactDTO emergencyContactDto,
			LinkedHashMap<String, String> validationErrors) {

		if( emergencyContactDto.getContactInfoContactMethod() == null ) {
			return;
		}
		
		String contactMethodMethodName = "getContactInfo" + emergencyContactDto.getContactInfoContactMethod();
		try {
			Method contactMethodMethod = getClass().getMethod( contactMethodMethodName, (Class[]) null );
			String contactNumber = (String) contactMethodMethod.invoke( this, (Object[]) null );
			if( StringUtils.isBlank( contactNumber ) ) {
				//addError( UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED, new Object[] {} );
				validationErrors.put(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED,getProperties().getProperty(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED));
			}
		} catch (Exception e) {
			//addError( UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED, new Object[] {} );
			validationErrors.put(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED,getProperties().getProperty(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED));
		}
		
	}	
	

	/**
	 * Validates Last Name
	 */
	private void validateLastName(EmergencyContactDTO emergencyContactDto, LinkedHashMap<String, String> validationErrors) {

		String value = emergencyContactDto.getLastName();
		
		if (value == null || value.trim().length() == 0) {
			Validations.validateRequired("Last Name", value, validationErrors);
			return;
		}
		
		if (value != null && containsDigit(value)) {
			// Validations.validateRequired(value, "lastName", "Last Name",
			// response.getValidationErrors());
			// Constants class
			validationErrors.put(UserManagementMessages.LAST_NAME_NUMBERS, getProperties().getProperty(UserManagementMessages.LAST_NAME_NUMBERS));

			return;
		}
	}
	
	
	
	/**
	 * Validates Work Phone Extension
	 */
	protected void validateContactInfoWorkPhoneExt(EmergencyContactDTO emergencyContactDto,
			LinkedHashMap<String, String> validationErrors) {
		String value = emergencyContactDto.getContactInfoWorkPhoneExt();
		//check for a value to validate:
		if ( value == null  || value.trim().length() == 0) {
			//nothing to validate
			return;
		}						
		//check max length
		Validations.validateMaxLength( "contactInfoWorkPhoneExt",value, CONTACTINFOWORKPHONEEXT_MAX_LENGTH,validationErrors);
	}	
	

	/**
	 * Validates First Name
	 */
	protected void validateFirstName(EmergencyContactDTO emergencyContactDto, LinkedHashMap<String, String> validationErrors) {

		String value = emergencyContactDto.getFirstName();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			Validations.validateRequired("First Name", value, validationErrors);
			return;
		}

		if (value != null && containsDigit(value)) {
			validationErrors.put(UserManagementMessages.FIRST_NAME_NUMBERS, getProperties().getProperty(UserManagementMessages.FIRST_NAME_NUMBERS));
			return;
		}
	}
	private boolean containsDigit(String str) {

		for (int i = 0; i < str.length(); i++) {
			if (Character.isDigit(str.charAt(i))) {
				return true;
			}
		}
		return false;

	}
	/**
	 * Validates priority
	 */
	protected void validatePriority(EmergencyContactDTO emergencyContactDto,
			LinkedHashMap<String, String> validationErrors) {
		Integer value = emergencyContactDto.getPriority();
		//check for a value to validate:
		if ( value == null ) {
			//nothing to validate
			return;
		}						
	}	
	/**
	 * Validates Address 1
	 */
	protected void validateAddressStreet1(EmergencyContactDTO emergencyContactDto ,
			LinkedHashMap<String, String> validationErrors) {
		String value = emergencyContactDto.getAddressStreet1();
		//check for a value to validate:
		if ( value == null ) {
			//nothing to validate
			return;
		}						
		//check max length
		Validations.validateMaxLength("addressStreet1",value, ADDRESSSTREET1_MAX_LENGTH,  validationErrors);
	}	
	
	/**
	 * Validates Mobile Phone
	 */
	protected void validateContactInfoMobilePhone(EmergencyContactDTO emergencyContactDto ,
			LinkedHashMap<String, String> validationErrors) {
		String value = emergencyContactDto.getContactInfoMobilePhone();
		//check for a value to validate:
		if ( value == null || value.trim().length() == 0) {
			if ("Mobile Phone".equals(emergencyContactDto.getContactInfoContactMethod())) {
				validationErrors.put(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED, getProperties().getProperty(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED));
				return;
			}
		}						
		//check max length
		Validations.validateMaxLength("Mobile Phone",  value, CONTACTINFOMOBILEPHONE_MAX_LENGTH, validationErrors);
	}	
	
	/**
	 * Validates Home Phone
	 */
	protected void validateContactInfoHomePhone(EmergencyContactDTO emergencyContactDto , LinkedHashMap<String, String> validationErrors) {

		String value = emergencyContactDto.getContactInfoHomePhone();
		// check for a value to validate:
		if (value == null || value.trim().length() == 0) {
			if ("Home Phone".equals(emergencyContactDto.getContactInfoContactMethod())) {
				validationErrors.put(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED, getProperties().getProperty(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED));
			return;
			}
		}
		// check max length
		Validations.validateMaxLength("Home Phone", value, CONTACTINFOHOMEPHONE_MAX_LENGTH, validationErrors);
	}
	
	
	/**
	 * Validates Middle name
	 */
	protected void validateMiddleName(EmergencyContactDTO emergencyContactDto ,
			LinkedHashMap<String, String> validationErrors) {
		String value = emergencyContactDto.getMiddleName();
		//check for a value to validate:
		if ( value == null ) {
			//nothing to validate
			return;
		}						
	}
	
	/**
	 * Validates Address 2
	 */
	protected void validateAddressStreet2(EmergencyContactDTO emergencyContactDto ,
			LinkedHashMap<String, String> validationErrors) {
		String value = emergencyContactDto.getAddressStreet2();
		//check for a value to validate:
		if ( value == null ) {
			//nothing to validate
			return;
		}						
		//check max length
		Validations.validateMaxLength("addressStreet2",value, ADDRESSSTREET2_MAX_LENGTH, validationErrors);
	}	
	
	
	/**
	 * Validates State
	 */
	protected void validateAddressState(EmergencyContactDTO emergencyContactDto, LinkedHashMap<String, String> validationErrors) {

		String state = emergencyContactDto.getAddressState();
		if (!Validations.hasValue(state)) {
			validationErrors.put(UserManagementMessages.ADDRSTATE_REQUIRED, getProperties().getProperty(UserManagementMessages.ADDRSTATE_REQUIRED));
			return;
		}
		boolean valid = false;
		if (Validations.hasValue(state)) {
			for (StateEnumeration s : StateEnumeration.values()) {
				if (s.getDescription().equals(state)) {
					valid = true;
					break;
				}
			}
			if (!valid) {
				validationErrors.put(UserManagementMessages.INVALID_ADDRSTATE, getProperties().getProperty(UserManagementMessages.INVALID_ADDRSTATE));
			}
		}
	}
	
	/**
	 * Validates Fax
	 */
	protected void validateContactInfoFax(EmergencyContactDTO emergencyContactDto ,
			LinkedHashMap<String, String> validationErrors) {
		String value = emergencyContactDto.getContactInfoFax();
		//check for a value to validate:
		if ( value == null || value.trim().length() == 0) {
			if ("Fax".equals(emergencyContactDto.getContactInfoContactMethod())) {
				validationErrors.put(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED, getProperties().getProperty(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED));
				return;
			}
		}						
		//check max length
		Validations.validateMaxLength( "Fax",value, CONTACTINFOFAX_MAX_LENGTH,validationErrors);
	}	


	
	/**
	 * Validates Work Phone
	 */
	protected void validateContactInfoWorkPhone(EmergencyContactDTO emergencyContactDto ,
			LinkedHashMap<String, String> validationErrors) {
		String value = emergencyContactDto.getContactInfoWorkPhone();
		//check for a value to validate:
		if ( value == null ) {
			if ("Work Phone".equals(emergencyContactDto.getContactInfoContactMethod())) {
				validationErrors.put(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED, getProperties().getProperty(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED));
				return;
			}
		}						
		//check max length
		Validations.validateMaxLength("Work Phone",value, CONTACTINFOWORKPHONE_MAX_LENGTH, validationErrors);
	}	
	
	/**
	 * Validates Pager
	 */
	protected void validateContactInfoPager(EmergencyContactDTO emergencyContactDto ,
			LinkedHashMap<String, String> validationErrors) {
		String value = emergencyContactDto.getContactInfoPager();
		//check for a value to validate:
		if ( value == null  || value.trim().length() == 0) {
			if ("Pager".equals(emergencyContactDto.getContactInfoContactMethod())) {
				validationErrors.put(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED, getProperties().getProperty(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED));
				return;
			}
		}						
		//check max length
		Validations.validateMaxLength( "Pager",value, CONTACTINFOPAGER_MAX_LENGTH, validationErrors);
	}	
	
	
	/**
	 * Validates Contact Method
	 */
	protected void validateContactInfoContactMethod(EmergencyContactDTO emergencyContactDto , LinkedHashMap<String, String> validationErrors) {

		String value = emergencyContactDto.getContactInfoContactMethod();
		// check requiredness:
		if (value == null || value.trim().length() == 0) {
			Validations.validateRequired("contactInfoContactMethod", value, validationErrors);

			// no need to continue:
			return;
		}

		// validate a valid enumeration value:
		// String enumName = value.name();
		// Validations.validateEnumeration( "contactInfoContactMethod", value,
		// ContactMethodEnumeration.valueOf(enumName),validationErrors );
	}
	
	/**
	 * Validates City
	 */
	protected void validateAddressCity(EmergencyContactDTO emergencyContactDto ,
			LinkedHashMap<String, String> validationErrors) {
		String value = emergencyContactDto.getAddressCity();
		//check for a value to validate:
		if ( value == null ) {
			//nothing to validate
			return;
		}						
		//check max length
		Validations.validateMaxLength( "addressCity",value, ADDRESSCITY_MAX_LENGTH, validationErrors);
	}	
	
	/**
	 * Validates Zip/Postal Code
	 */
	protected void validateAddressPostalCode(EmergencyContactDTO emergencyContactDto ,
			LinkedHashMap<String, String> validationErrors) {
		String value = emergencyContactDto.getAddressPostalCode();
		//check for a value to validate:
		if ( value == null ) {
			//nothing to validate
			return;
		}						
		//check max length
		Validations.validateMaxLength("addressPostalCode",value, ADDRESSPOSTALCODE_MAX_LENGTH, validationErrors);
	}	
	
	/**
	 * Validates relationship
	 */
	protected void validateRelationship(EmergencyContactDTO emergencyContactDto ,
			LinkedHashMap<String, String> validationErrors) {
		String value = emergencyContactDto.getRelationship();
		//check for a value to validate:
		if ( value == null || value.trim().length() == 0) {
			//nothing to validate
			return;
		}						
	}	
	/**
	 * Validates Title
	 */
	private void validateTitle(String value, LinkedHashMap<String, String> validationErrors) {

		if (value == null || value.trim().length() == 0) {
			// nothing to validate
			return;
		}

		boolean valid = false;
		if (Validations.hasValue(value)) {
			for (TitleEnumeration s : TitleEnumeration.values()) {
				if (s.getDescription().equals(value)) {
					valid = true;
					break;
				}
			}
			if (!valid) {
				validationErrors.put(UserManagementMessages.INVALID_TITLE, getProperties().getProperty(UserManagementMessages.INVALID_TITLE));
			}
		}
	}

	/**
	 * Validates Email
	 */
	//TODO:
	protected void validateContactInfoEmail(EmergencyContactDTO emergencyContactDto ,
			LinkedHashMap<String, String> validationErrors) {
		String value = emergencyContactDto.getContactInfoEmail();
		//check for a value to validate:
		if (null != value && value.length() > 0 && !value.contains("@") ) {
			validationErrors.put(UserManagementMessages.INVALID_EMAIL,getProperties().getProperty(UserManagementMessages.INVALID_EMAIL));
		}

		if ("Email".equals(emergencyContactDto.getContactInfoContactMethod())) {
			if ( value == null || value.length() == 0 ) {
				validationErrors.put(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED, getProperties().getProperty(UserManagementMessages.CONTACT_METHOD_NOT_SPECIFIED));
				return;
			}
		}
		
		//Validations.validateType(value, emailValidator, "contactInfoEmail", "Email", validationErrors);
	}	
	

	/**
	 * Validates Country
	 */
	protected void validateAddressCountry(EmergencyContactDTO emergencyContactDto ,LinkedHashMap<String, String> validationErrors) {

		String value = emergencyContactDto.getAddressCountry();
		// check requiredness:
		if (value == null || value.trim().length() == 0) {
			Validations.validateRequired("addressCountry", value, validationErrors);

			// no need to continue:
			return;
		}

		boolean valid = false;
		if (Validations.hasValue(value)) {
			for (CountryEnumeration s : CountryEnumeration.values()) {
				if (s.getDescription().equals(value)) {
					valid = true;
					break;
				}
			}
			if (!valid) {
				validationErrors.put(UserManagementMessages.INVALID_COUNTRY, getProperties().getProperty(UserManagementMessages.INVALID_COUNTRY));
			}
		}
		
	}
	
	/**
	 * Validates Province
	 */
	protected void validateAddressProvince(EmergencyContactDTO emergencyContactDto ,
			LinkedHashMap<String, String> validationErrors) {
		String value = emergencyContactDto.getAddressProvince();
		//check for a value to validate:
		if ( value == null || value.trim().length() == 0) {
			//nothing to validate
			return;
		}						
		//check max length
		Validations.validateMaxLength( "addressProvince", value, ADDRESSPROVINCE_MAX_LENGTH,validationErrors);
	}	

	/**
	 * Validates isPrimary
	 */
	protected void validateIsPrimary(EmergencyContactDTO emergencyContactDto ,
			LinkedHashMap<String, String> validationErrors) {
		Boolean value = emergencyContactDto.getIsPrimary();
		//check for a value to validate:
		if ( value == null ) {
			//nothing to validate
			return;
		}						
	}
}
