package gov.va.med.mhv.usermgmt.main.service.validator;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedHashMap;

import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.core.validate.Validations;
import gov.va.med.mhv.core.validate.Validator;
import gov.va.med.mhv.usermgmt.common.dto.ActivitySearchCriteriaDTO;
import gov.va.med.mhv.usermgmt.messages.UserManagementMessages;

@Component
public class ActivityValidator  extends Validator{
	
	public void  activitySearchValidations(ResponseUtil response, ActivitySearchCriteriaDTO searchCriteria){
		LinkedHashMap<String, String> validationErrors = response.getValidationErrors();
		if(searchCriteria.getFromDate() == null){
			Validations.validateRequired("From Date", null, validationErrors);
			return;
		}
		if(searchCriteria.getToDate() == null){
			Validations.validateRequired("To Date", null, validationErrors);
			return;
		}
		validateDateRange(searchCriteria,validationErrors);
	}

	private void validateDateRange(ActivitySearchCriteriaDTO searchCriteria,LinkedHashMap<String, String> validationErrors) {
		String fromDate= dateToString(searchCriteria.getFromDate(),"yyyyMMdd");
		String  toDate=dateToString(searchCriteria.getToDate(),"yyyyMMdd");
		Calendar cal =Calendar.getInstance();
		String currentDate = dateToString(cal.getTime(),"yyyyMMdd");
		cal.add(Calendar.YEAR, -1);
		String oldDate = dateToString(cal.getTime(),"yyyyMMdd");
		
		if(Integer.parseInt(fromDate) < Integer.parseInt(oldDate)     ||
		   Integer.parseInt(fromDate) > Integer.parseInt(currentDate) ||
		   Integer.parseInt(toDate) < Integer.parseInt(oldDate) ||
		   Integer.parseInt(toDate) > Integer.parseInt(currentDate) ||
		   (Integer.parseInt(fromDate) > Integer.parseInt(toDate))) {
			
			if(Integer.parseInt(fromDate) > Integer.parseInt(currentDate) ||
			   Integer.parseInt(toDate) > Integer.parseInt(currentDate)	){
				validationErrors.put(UserManagementMessages.ACTIVITY_SEARCH_FUTURE_RANGE, 
				getProperties().getProperty(UserManagementMessages.ACTIVITY_SEARCH_FUTURE_RANGE));
			}
			
			if(Integer.parseInt(fromDate) > Integer.parseInt(toDate)){
				validationErrors.put(UserManagementMessages.ACTIVITY_SEARCH_FROM_GREATER_TO, 
				getProperties().getProperty(UserManagementMessages.ACTIVITY_SEARCH_FROM_GREATER_TO));
			}
			
			if(Integer.parseInt(fromDate) < Integer.parseInt(oldDate) ||
			   Integer.parseInt(toDate) < Integer.parseInt(oldDate)){
				validationErrors.put(UserManagementMessages.ACTIVITY_SEARCH_INVALID_RANGE, 
				getProperties().getProperty(UserManagementMessages.ACTIVITY_SEARCH_INVALID_RANGE));
			}
		}
		
	}
	
	
	private static String dateToString (Date date,String format){
		String stringDate="";
		try{
			if(date != null){
			   SimpleDateFormat sdf = new SimpleDateFormat(format);
			   stringDate =sdf.format(date);
			}
		}catch(Exception e){
			throw new RuntimeException("Invalid Date format");
		}
		return stringDate;
	}

}
