package gov.va.med.mhv.usermgmt.main.service.impl;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.xml.namespace.QName;
import javax.xml.ws.soap.AddressingFeature.Responses;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.converter.PatientConverter;
import gov.va.med.mhv.common.data.converter.UserProfileConverter;
import gov.va.med.mhv.common.data.model.Patient;
import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.common.data.model.UserProfileDeactivationReason;
import gov.va.med.mhv.usermgmt.common.dto.EauthHashDTO;
import gov.va.med.mhv.usermgmt.common.dto.HealthInfoDTO;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.PatientCorrelationStatusEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.UserProfileActivationActionEnumeration;
import gov.va.med.mhv.usermgmt.converter.EauthHashConverter;
import gov.va.med.mhv.usermgmt.data.model.EauthHash;
import gov.va.med.mhv.usermgmt.data.model.EauthLog;
import gov.va.med.mhv.usermgmt.data.model.EmergencyContact;
import gov.va.med.mhv.usermgmt.data.model.HealthCareProvider;
import gov.va.med.mhv.usermgmt.data.model.HealthInsurances;
import gov.va.med.mhv.usermgmt.data.model.MviSyncCommonError;
import gov.va.med.mhv.usermgmt.data.model.TermsConditionsVerHistory;
import gov.va.med.mhv.usermgmt.data.model.UserAcceptTermsHistory;
import gov.va.med.mhv.usermgmt.data.model.UserPasswordHistory;
import gov.va.med.mhv.usermgmt.data.model.UserProfileDeactivationAudit;
import gov.va.med.mhv.usermgmt.data.repository.ActivityRepository;
import gov.va.med.mhv.usermgmt.data.repository.AllergiesRepository;
import gov.va.med.mhv.usermgmt.data.repository.EauthHashRepository;
import gov.va.med.mhv.usermgmt.data.repository.EauthLogRepository;
import gov.va.med.mhv.usermgmt.data.repository.EmergencyContactRepository;
import gov.va.med.mhv.usermgmt.data.repository.HealthCareProviderRepository;
import gov.va.med.mhv.usermgmt.data.repository.HealthInsurancesRepository;
import gov.va.med.mhv.usermgmt.data.repository.MviSyncCommonErrorRepository;
import gov.va.med.mhv.usermgmt.data.repository.PatientRepository;
import gov.va.med.mhv.usermgmt.data.repository.TermsConditionsVerHistoryRepository;
import gov.va.med.mhv.usermgmt.data.repository.UserAcceptTermsHistoryRepository;
import gov.va.med.mhv.usermgmt.data.repository.UserPasswordHistoryRepository;
import gov.va.med.mhv.usermgmt.data.repository.UserProfileRepository;
import gov.va.med.mhv.usermgmt.exception.MHVDuplicateUserException;
import gov.va.med.mhv.usermgmt.exception.MHVRuntimeException;
import gov.va.med.mhv.usermgmt.main.service.adapter.impl.MpiProperties;
import gov.va.med.mhv.usermgmt.main.service.validator.UserProfileValidator;
import gov.va.med.mhv.usermgmt.persist.UserEntryDao;
import gov.va.med.mhv.usermgmt.persist.exception.DuplicateEntryException;
import gov.va.med.mhv.usermgmt.service.AccessControlService;
import gov.va.med.mhv.usermgmt.service.ActivityService;
import gov.va.med.mhv.usermgmt.service.EmployeeSearchService;
import gov.va.med.mhv.usermgmt.service.MviAsyncIntegrationService;
import gov.va.med.mhv.usermgmt.service.PatientService;
import gov.va.med.mhv.usermgmt.service.UserProfileService;
import gov.va.med.mhv.usermgmt.service.handler.MviProperties;
import gov.va.med.mhv.usermgmt.util.MessagesUtil;
import gov.va.med.mhv.usermgmt.util.PasswordUtil;
import gov.va.med.mhv.usermgmt.util.PatientCorrelationStatusUtils;
import gov.va.med.mhv.usermgmt.util.Precondition;
import gov.va.med.mhv.usermgmt.util.mvi.MviUtil;
import gov.va.med.mhv.vapii.partnerservices.client.GetFormStatusForUserRequest;
import gov.va.med.mhv.vapii.partnerservices.client.GetFormStatusForUserResponse;
import gov.va.med.mhv.vapii.partnerservices.client.Message;
import gov.va.med.mhv.vapii.partnerservices.client.User;
import gov.va.med.mhv.vapii.partnerservices.client.UserIdType;
import gov.va.med.mhv.vapii.partnerservices.client.VapiiPartnerServicesService;

@Component
public class UserProfileServiceImpl implements UserProfileService {
	//Comment
	private static Logger log = LogManager.getLogger(UserProfileServiceImpl.class);

	@Autowired
	private UserProfileRepository userProfileRepository;

	@Autowired
	private ActivityService activityService;

	@Autowired
	private UserPasswordHistoryRepository userPasswdHistRepository;

	@Autowired
	private UserAcceptTermsHistoryRepository usrAcceptTermHistRepository;

	@Autowired
	private TermsConditionsVerHistoryRepository termsCondVerHistRepository;

	@Autowired
	private PatientRepository patientRepository;

	@Autowired
	private ActivityRepository activityRepository;

	@Autowired
	private UserEntryDao userEntryDao;

	@Autowired
	private EmployeeSearchService employeeSearchService;

	@Autowired
	private UserProfileConverter converter;

	@Autowired
	private UserProfileConverter userProfileConverter;

	@Autowired
	private PatientConverter patientConverter;

	@Autowired
	private UserProfileValidator validator;

	@Autowired
	private MviProperties mviProperties;

	@Autowired
	private MpiProperties mpiProperties;

	@Autowired
	private EauthHashRepository eauthHashRepository;

	@Autowired
	private EauthLogRepository eauthLogRepository;

	@Autowired
	private MessagesUtil messagesUtil;

	@Autowired
	private MviAsyncIntegrationService mviAsyncIntegrationService;

	@Autowired
	private PatientService patientService;

	@Autowired
	private MviSyncCommonErrorRepository mviSyncCommonErrorRepository;

	@Autowired
	private UserProfileDeactivationAuditServiceImpl deactivationAuditService;

	@Autowired
	private AccessControlService accessControlService;

	@Autowired
	private EmergencyContactRepository emergencyContactRepository;

	@Autowired
	private AllergiesRepository allergiesRepository;

	@Autowired
	private HealthInsurancesRepository healthInsurancesRepository;

	@Autowired
	private HealthCareProviderRepository healthCareProviderRepository;

	/**
	 * Return to WebServices
	 */
	public ResponseUtil getUserProfileResponseByUserName(String userName) {
		ResponseUtil response = new ResponseUtil();

		try {
			UserProfileDTO userProfile = getUserProfileByUserName(userName);
			response.setPojoObject(userProfile);
			if (null == userProfile.getId()) {
				response.setFailure(true);
				response.setFailureMessage("User Not Found");
			} else {
				response.setSuccess(true);
			}

		} catch (Exception e) {
			response.setFailure(true);
			// this might change to a more user friendly msg
			response.setFailureMessage(e.getMessage());
			response.setPojoObject(new UserProfileDTO());
			log.error("Exception occurred getting User Profile", e);
		}

		return response;
	}

	/**
	 * Return to WebServices
	 */
	@Transactional
	public void updateUserProfileResponse(UserProfileDTO profileDto, ResponseUtil response) {
		response.setValidationErrors(new LinkedHashMap<String, String>());
		try {
			saveUserProfile(profileDto, response);

			// check for validation errors
			if (!response.isFailure()) {
				response.setSuccess(true);
			}
		} catch (Exception e) {
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
			response.setPojoObject(profileDto);
			log.error("Exception occurred updating User Profile ", e);
		}
	}

	@Override
	@Transactional
	public void registerUser(UserProfileDTO profileDto, ResponseUtil response) {
		
		log.debug("registerUser, userName=" + profileDto.getUserName());
		
		response.setValidationErrors(new LinkedHashMap<String, String>());
		
		try {
			saveUserProfile(profileDto, response);

			// check errors after saveUserProfile
			if (response.isFailure()) {
				return;
			}

			// get stored userProfile in DB from response
			UserProfileDTO savedUserProfileDto = (UserProfileDTO) response.getPojoObject();
			UserProfile userProfile= new UserProfile();
			
			UserProfile savedUserProfile=converter.convertDTOProfile(userProfile, savedUserProfileDto);

			// create user in LDAP
			String userName = profileDto.getUserName();
			if (null != userName) {
				this.createUserInLdap(profileDto, response);

				// check errors after createUser
				if (response.isFailure()) {
					return ;
				}

				// Save the password in the password history
				this.savePasswordHistory(savedUserProfile, profileDto.getPassword(), false, response);

				// check errors after savePasswordHistory
				if (response.isFailure()) {
					return;
				}

				// Accept terms
				Timestamp termsModifiedTime = profileDto.getTermsModifiedTime();
				Timestamp now = new Timestamp(System.currentTimeMillis());
				this.acceptTerms(savedUserProfile, termsModifiedTime, now, response);

				if (log.isDebugEnabled()) {
					log.debug("acceptTerms have been stored successfully...");
				}
				
				// check errors after acceptTerms
				if (response.isFailure()) {
					return;
				}

				activityService.auditRegistrationEvent(savedUserProfile, response);

				// check errors after audit
				if (response.isFailure()) {
					return;
				}
			}

			response.setSuccess(true);
		} catch (MHVDuplicateUserException e) {
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
			response.setPojoObject(profileDto);
			log.error("Exception occurred updating User Profile ", e);
		} catch (Exception e) {
			// remove user from LDAP, if an exception occurs
			this.removeUserFromLdap(profileDto);
			
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
			response.setPojoObject(profileDto);
			log.error("Exception occurred updating User Profile ", e);
		}
		if (log.isDebugEnabled()) {
			log.debug("User registration is successful...");
		}
	}

	@Override
	@Transactional
	public void saveUserProfile(UserProfileDTO profileDto, ResponseUtil<UserProfileDTO> response) {
		this.saveUserProfile(profileDto, response, true);
	}

	@Override
	@Transactional
	public void saveUserProfile(UserProfileDTO userDto, ResponseUtil<UserProfileDTO> response, boolean doAudit) {

		UserProfile userProfile = null;
		boolean isRegistration = false;
		
		log.debug("**************userProfile SignInPartner: "+userDto.getSignInPartners());

		try {
			isRegistration = (null != userDto && null != userDto.getId()) ? false : true;

			// update profile
			if (!isRegistration) {
				userProfile = userProfileRepository.findByUserName(userDto.getUserName());

				if (null != userProfile) {
					if (doAudit) {
						activityService.auditUpdateProfileEvent(userProfile.getId(), ActivityActorTypeEnumeration.SELF, response);
					}
				} else {
					// TODO: need to add error if domainProfile is 'null'??
				}

				// check errors after audit
				if (response.isFailure()) {
					return;
				}
			} else {
				// user registration
				userProfile = new UserProfile();
			}

			validator.userProfileUpdateValidations(response, userDto, isRegistration);

			// no validation errors
			if (response.getValidationErrors() == null || response.getValidationErrors().size() == 0) {
				if (isRegistration) {
					userDto.setCreatedDate(new Timestamp(System.currentTimeMillis()));
				} else {
					if (!userDto.getRxTrackingEmailPref().equals(userProfile.getRxTrackingEmailPref())) {
						if (Boolean.TRUE.equals(userDto.getRxTrackingEmailPref())) {
							activityService.auditUpdateEmailProfileEvent(userProfile.getId(), ActivityActorTypeEnumeration.SELF.getDescription(), 
								ActivityActionTypeEnumeration.TURN_ON_RX_NOTIFICATIONS.getDescription(), response);
						} else {
							activityService.auditUpdateEmailProfileEvent(userProfile.getId(), ActivityActorTypeEnumeration.SELF.getDescription(), 
								ActivityActionTypeEnumeration.TURN_OFF_RX_NOTIFICATIONS.getDescription(), response);
						}
					}
					
					if (!userDto.getApptReminderEmailPref().equals(userProfile.getApptReminderEmailPref())) {
						if (Boolean.TRUE.equals(userDto.getApptReminderEmailPref())) {
							activityService.auditUpdateEmailProfileEvent(userProfile.getId(), ActivityActorTypeEnumeration.SELF.getDescription(), 
								ActivityActionTypeEnumeration.TURN_ON_VA_APPOINTMENT_REMINDER.getDescription(), response);
						} else {
							activityService.auditUpdateEmailProfileEvent(userProfile.getId(), ActivityActorTypeEnumeration.SELF.getDescription(), 
								ActivityActionTypeEnumeration.TURN_OFF_VA_APPOINTMENT_REMINDER.getDescription(), response);
						}
					}
					
					if (!userDto.getHealthSummarySentEmailPref().equals(userProfile.getHealthSummarySentEmailPref())) {
						if (Boolean.TRUE.equals(userDto.getHealthSummarySentEmailPref())) {
							activityService.auditUpdateEmailProfileEvent(userProfile.getId(), ActivityActorTypeEnumeration.SELF.getDescription(), "Turn On VA Health Summary Delivery Notification", response);
						}
						else {
							activityService.auditUpdateEmailProfileEvent(userProfile.getId(), ActivityActorTypeEnumeration.SELF.getDescription(), "Turn Off VA Health Summary Delivery Notification", response);
						}
					}
				}
				log.debug("**************userProfileDto SignInPartner: "+userDto.getSignInPartners());
				userProfile = converter.convertDTOProfile(userProfile, userDto);
				log.debug("**************userProfile SignInPartner: "+userProfile.getSignInPartners());
				// save user profile in USER_PROFILE table
				userProfile = userProfileRepository.save(userProfile);
				log.debug("**************userProfile SignInPartner after save: "+userProfile.getSignInPartners());
				response.setPojoObject(converter.convertDomainUserProfile(userProfile));
				
				/*if (isRegistration) {
					if (Boolean.TRUE.equals(userDto.getRxTrackingEmailPref())) {
						activityService.auditUpdateEmailProfileEvent(userProfile.getId(), ActivityActorTypeEnumeration.SELF.getDescription(), 
							ActivityActionTypeEnumeration.TURN_ON_RX_NOTIFICATIONS.getDescription(), response);
					} else {
						activityService.auditUpdateEmailProfileEvent(userProfile.getId(), ActivityActorTypeEnumeration.SELF.getDescription(), 
							ActivityActionTypeEnumeration.TURN_OFF_RX_NOTIFICATIONS.getDescription(), response);
					}
					
					if (Boolean.TRUE.equals(userDto.getApptReminderEmailPref())) {
						activityService.auditUpdateEmailProfileEvent(userProfile.getId(), ActivityActorTypeEnumeration.SELF.getDescription(), 
							ActivityActionTypeEnumeration.TURN_ON_VA_APPOINTMENT_REMINDER.getDescription(), response);
					} else {
						activityService.auditUpdateEmailProfileEvent(userProfile.getId(), ActivityActorTypeEnumeration.SELF.getDescription(), 
							ActivityActionTypeEnumeration.TURN_OFF_VA_APPOINTMENT_REMINDER.getDescription(), response);
					}
				}	*/			
			} else {
				response.setFailure(true);
				return;
			}

			boolean isVAPatient = (null != userDto.getIsPatient()) ? userDto.getIsPatient() : false;
			boolean isVeteran = (null != userDto.getIsVeteran()) ? userDto.getIsVeteran() : false;
			boolean isIdNull = (null == userDto.getId()) ? true : false;
			Long userProfileId = userProfile.getId();

			// check if MVI flag is enabled
			// MVI correlation should process only for userTypes VA Patient and Vet
			if (mviProperties.isMviEnabled()) {
				// not a VA Patient and not a Vet, and registering user (userId is null), then MHV user accountType is BASIC
				if (!isVAPatient && !isVeteran) {
					
					// user registration
					if (isIdNull) {
						// MHV AccountType is Basic
						response.getInfoMessages().put(messagesUtil.getMviBasicSuccessResponse(), String.format(messagesUtil.getMviBasicSuccessResponse(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow()));
					}
					// not a VA Patient and not a Vet, and updating profile, no MVI correlation required
					return;
				}
			} else {
				// not a VA patient - no correlation required
				if (!isVAPatient) {
					return;
				}
			}

			// VA Patient or a Vet or userId is not null(profile update)
			// Check to see if there is already a patient for the user profile
			//List<Patient> patientList = patientRepository.getPatientByUserProfileId(userProfileId);
			ResponseUtil patientResponse = patientService.getPatientByUserProfileId(userProfileId);
			PatientDTO extPatientDto = (null != patientResponse.getPojoObject()) ? (PatientDTO) patientResponse.getPojoObject() : null;
			Patient existPatient = (null != extPatientDto) ? patientConverter.convertDTOProfile(extPatientDto) : null;

			
			if (null != existPatient) {
				
/*				if (log.isDebugEnabled()) {
					log.debug("Patient exists ICN: " + existPatient.getIcn());
				}
*/				
				// patient exists but not having a co-relation
				if (!(existPatient.getCorrelationStatus() == PatientCorrelationStatusEnumeration.UNCORRELATED.getValue())) {
					// Patient already associated
					return;
				} else {
					mviAsyncIntegrationService.existingUserWithPendingDataMismatch(userProfile, response);

					if (response.isFailure()) {
						throw new MHVRuntimeException(messagesUtil.getMviParseResponseAeIssue());
					}

					//TODO: SRE - mvi.parse.response.ae.issue might need to be added failure message on response 
					Map<String, String> infoMessages = response.getInfoMessages();
					int infoSize = (null != infoMessages && infoMessages.size() > 0) ? infoMessages.size() : 0;
					log.info("infoSize : " + infoSize);
					if (infoSize > 0) {
						for (String msgKey : infoMessages.keySet()) {
							if(msgKey.equalsIgnoreCase("mvi.parse.response.ae.issue")) {
								//addInfo(response, "mvi.parse.response.ae.issue",new String[]{mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(), mviProperties.getContactLoggedMhvUrl()});
								response.getInfoMessages().put(messagesUtil.getMviParseResponseAeIssue(), String.format(messagesUtil.getMviParseResponseAeIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow()));
								return;
							}
						}
					}

					/*
					Iterator it = voidServiceResponse.getMessages().getInformationalMessages().iterator();
					while(it.hasNext()) {
						Message message = (Message)it.next();
						String msgKey = message.getKey();
						if(msgKey.equalsIgnoreCase("mvi.parse.response.ae.issue")) {
							addInfo(response, "mvi.parse.response.ae.issue",new String[]{mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(), mviProperties.getContactLoggedMhvUrl()});
							return response;
						}
					}*/

					// TODO: SRE, check if below patient read required or could be used existPatient
					List<Patient> patientList2 = patientRepository.getPatientByUserProfileId(userProfileId);
					Patient existPatient2 = (null != patientList2 && patientList2.size() > 0) ? patientList2.get(0) : null;

					if(existPatient2.getMatchedDateTime() != null) {
						if (!isRegistration) {
							response.getInfoMessages().put(messagesUtil.getMviUpdateAdvancedSuccessResponse(), String.format(messagesUtil.getMviUpdateAdvancedSuccessResponse(), mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow()));
						}
					} else if(existPatient2.getCorrelationStatus().equals(PatientCorrelationStatusEnumeration.UNCORRELATED.getValue())) {
						response.getInfoMessages().put(
								messagesUtil.getMviUpdateAdvancedFailureResponse(), 
							String.format(messagesUtil.getMviUpdateAdvancedFailureResponse(), mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(), mviProperties.getContactLoggedMhvUrl(), mviProperties.getTargetWindow()));
					}
					return;

					// patientRepository.getPatientForUser
				}
			}

			// No patient exists for the user profile in MHV.
			// Check the patient registry.
			checkPatientRegistry(userProfile, isRegistration, response);
			response.setPojoObject(converter.convertDomainUserProfile(userProfile));
		} catch (Exception e) {
			response.setFailure(true);
			// TODO: confirm the error message
			response.setFailureMessage("Error in processing your request");
			response.setPojoObject(userDto);
			log.error("Exception occurred updating User Profile ", e);
		}
	}


	@Transactional
	public void saveUserProfileMVICorrelationCronJob(UserProfileDTO profileDto, ResponseUtil response, String fccxIcn) {
		this.saveUserProfileMVICorrelationCronJob(profileDto, response, true, fccxIcn);
	}

	@Transactional
	public void saveUserProfileMVICorrelationCronJob(UserProfileDTO profileDto, ResponseUtil response, boolean doAudit, String fccxIcn) {
		boolean isRegistration = false;
		Long id = profileDto.getId();
		Date fccxDate = null;
		if(id == null) {
			isRegistration = true;
			if(fccxIcn != null) {
				fccxDate = new Date();
			}
		}

		Date birthDate = profileDto.getBirthDate();
		if(birthDate != null) {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
			String impreciseDateOfBirth = sdf.format(birthDate);
			//profileDto.setImpreciseBirthDate(impreciseDateOfBirth + ".120000");
		}

		UserProfile savedUserProfile = new UserProfile();
		savedUserProfile = converter.convertDTOProfile(savedUserProfile, profileDto);
		doUserProfileActivateSave(savedUserProfile, doAudit, fccxDate, response);
		if (!response.getFailureMessage().isEmpty()) {
			if(log.isInfoEnabled()) {
				log.info("Errors in doUserProfileSave");
			}
			return;
		}
		savedUserProfile = (UserProfile)response.getPojoObject();
		Long userId = savedUserProfile.getId();
		response.setPojoObject(savedUserProfile);
		log.debug("fccxDate:" + savedUserProfile.getFccx(), "userProfileId", userId+"");
		log.debug("fccxIcn:" + fccxIcn, "userProfileId", userId+"");

		//For FCCX Registration, we will accept all user types.
		if(mviProperties.isMviEnabled()) {
			if (((profileDto.getIsPatient() == null) || !profileDto.getIsPatient())
					&& ((profileDto.getIsVeteran() == null) || !profileDto.getIsVeteran())
					) {
				if(fccxIcn == null) {
					if(id == null)
						log.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
						response.setFailure(true);
						response.setFailureMessage(String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow()));
						response.getInfoMessages().put(messagesUtil.getMviParseResponseIssue(),
								String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow()));
						return;
					} else {
						log.debug("Didn't go to the basic account sucess page", "userProfileId", userId+"");
				}
			}
		} else {
			if ((profileDto.getIsPatient() == null) || !profileDto.getIsPatient().booleanValue()) {
				return;
			}
		}

		log.debug("Proceed to create patient account", "userProfileId", userId+"");

		// Check to see if there is already a patient for the user profile
		patientService.getPatientForUser(savedUserProfile, response);
		Patient existPat = (Patient)response.getPojoObject();
		if (existPat != null && !existPat.getCorrelationStatus().equals(PatientCorrelationStatusEnumeration.UNCORRELATED.getValue())) {
			//Patient already associated
			return;
		} else if (existPat != null){
			mviAsyncIntegrationService.existingUserWithPendingDataMismatch(savedUserProfile, response);
			Map<String, String> infoMessages = response.getInfoMessages();
			int infoSize = (null != infoMessages && infoMessages.size() > 0) ? infoMessages.size() : 0;
			log.info("infoSize : " + infoSize);
			if (infoSize > 0) {
				for (String msgKey : infoMessages.keySet()) {
					if(msgKey.equalsIgnoreCase("mvi.parse.response.ae.issue")) {
						response.getInfoMessages().put(messagesUtil.getMviParseResponseAeIssue(), String.format(messagesUtil.getMviParseResponseAeIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow()));
						return;
					}
				}
			}

			patientService.getPatientForUser(savedUserProfile, response);
			Patient existPat2 = (Patient)response.getPojoObject();
			if(existPat2.getMatchedDateTime() != null) {
				log.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
				response.setFailure(true);
				response.setFailureMessage(String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow()));
				response.getInfoMessages().put(messagesUtil.getMviParseResponseIssue(),
					String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow()));
				return;
			}
			else if(existPat2.getCorrelationStatus().equals(PatientCorrelationStatusUtils.isUncorrelated(existPat2))) {
				log.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
				response.setFailure(true);
				response.setFailureMessage(String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getContactLoggedMhvUrl()));
				response.getInfoMessages().put(messagesUtil.getMviParseResponseIssue(),
					String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getContactLoggedMhvUrl()));
				return;
			}
			return;
		}

		log.debug("No patient exists for the user profile in MHV.", "userProfileId", userId+"");

		// No patient exists for the user profile in MHV.
		// Check the patient registry.
		String firstName = profileDto.getFirstName();
		String lastName  = profileDto.getLastName();
		//String middleName  = profileDto.getMiddleName();
		String gender  = profileDto.getGender();
		if(gender.equalsIgnoreCase("Male")){
			gender = "M";
		}else{
			gender = "F";
		}

		String ssn = profileDto.getSsn();


		/*
		 * Checking the property file to see if we need to call getPatientFromRegistryWithMiddleName or getPatientFromRegistry
		 */
		if(mviProperties.isMviEnabled()) {
			if(savedUserProfile.getFccx() != null) {
				log.debug("patientService.createPatientForFccx", "fccxIcn", fccxIcn);
				patientService.createPatientForFccx(savedUserProfile, fccxIcn, response);
			} else {
				patientService.getPatientFromMVI(savedUserProfile, isRegistration, response);
			}

			if (response.isFailure()) {
				response.setPojoObject(savedUserProfile);
				log.debug("patientRegistryResponse.getMessages().hasErrorMessages()", "fccxIcn", fccxIcn);
				return;
			}
			Patient patient = (Patient)response.getPojoObject();
			if(patient == null) {
				if(id == null) {
					activityService.auditMviEvent(savedUserProfile, ActivityActorTypeEnumeration.SYSTEM, false, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED, ActivityTypeEnumeration.ACCOUNT_UPGRADE, response);
				} else {
					activityService.auditMviEvent(savedUserProfile, ActivityActorTypeEnumeration.SYSTEM, false, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED, ActivityTypeEnumeration.ACCOUNT_UPGRADE, response);
					boolean parseErrorExists = false;
					boolean aeErrorUpdateUserProfile = false;
					Map<String, String> infoMessages = response.getInfoMessages();
					int infoSize = (null != infoMessages && infoMessages.size() > 0) ? infoMessages.size() : 0;
					log.info("infoSize : " + infoSize);
					if (infoSize > 0) {
						for (String msgKey : infoMessages.keySet()) {
							if(msgKey.equalsIgnoreCase("mvi.parse.response.ae.issue")) {
								parseErrorExists = true;
							} else if(msgKey.equalsIgnoreCase("mvi.parse.response.ae.issue")) {
								aeErrorUpdateUserProfile = true;
							}
						}
					}
					if(parseErrorExists) {
						log.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
						response.setFailure(true);
						response.setFailureMessage(String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getContactLoggedMhvUrl()));
						response.getInfoMessages().put(messagesUtil.getMviParseResponseIssue(),
							String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getContactLoggedMhvUrl()));
						return;
					} else if(aeErrorUpdateUserProfile) {
						log.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
						response.setFailure(true);
						response.setFailureMessage(String.format(messagesUtil.getMviParseResponseAeIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow()));
						response.getInfoMessages().put(messagesUtil.getMviParseResponseAeIssue(),
							String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow()));
						return;
					} else {
						log.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
						response.setFailure(true);
						response.setFailureMessage(String.format(messagesUtil.getMviUpdateAdvancedFailureResponse(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getContactLoggedMhvUrl()));
						response.getInfoMessages().put(messagesUtil.getMviUpdateAdvancedFailureResponse(),
							String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getContactLoggedMhvUrl()));
						return;
					}
				}
				userProfileRepository.save(savedUserProfile);
				Map<String, String> infoMessages = response.getInfoMessages();
				int infoSize = (null != infoMessages && infoMessages.size() > 0) ? infoMessages.size() : 0;
				log.info("infoSize : " + infoSize);
				if (infoSize > 0) {
					for (String msgKey : infoMessages.keySet()) {
						if(msgKey.equalsIgnoreCase("mvi.parse.response.issue")) {
							MviSyncCommonError mviSyncCommonError = null;
							try {
								List<MviSyncCommonError> mviSyncCommonErrors = mviSyncCommonErrorRepository.getRequiredMviSyncByProfileId(savedUserProfile.getId());

								if (null != mviSyncCommonErrors && mviSyncCommonErrors.size() > 0) {
									mviSyncCommonError = mviSyncCommonErrors.get(0);
								}
							} catch(Exception e) {
								log.error("Error in fetching data from MviSyncCommonError " + e );
								response.setFailure(true);
								response.setFailureMessage("Error in fetching data from MviSyncCommonError " + e.getMessage());
								return;
							}

							// if mviSyncCommonError is null, create a new object
							if (mviSyncCommonError == null) {
								MviSyncCommonError mviSyncCommError2 = new MviSyncCommonError();
								mviSyncCommError2.setUserProfileId(savedUserProfile.getId());
								mviSyncCommError2.setCreatedDate(new Timestamp(System.currentTimeMillis()));

								try {
									mviSyncCommonErrorRepository.save(mviSyncCommError2);
								} catch(Exception e) {
									log.error("Error in storing MviSyncCommonError data" + e );
									response.setFailure(true);
									response.setFailureMessage("Error in storing MviSyncCommonError data : " + e.getMessage());
									return;
								}
								if (log.isDebugEnabled()) {
									log.debug("mviSyncCommonError details have been stored successfully");
								}
							}
						}
					}
				}
				//copyMessages(response, patientRegistryResponse);
				return;
			} else {
				patient.setUserProfile(savedUserProfile);
				patient.setCorrelationStatus(PatientCorrelationStatusEnumeration.MVIDATAMATCH.getValue());
				patient.setMatchedDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
				//copyMessages(response, patientRegistryResponse);
				patientService.savePatient(patient);
				if(id == null) {
					activityService.auditMviEvent(savedUserProfile, ActivityActorTypeEnumeration.SYSTEM, true, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED, ActivityTypeEnumeration.ACCOUNT_UPGRADE, response);
				} else {
					activityService.auditMviEvent(savedUserProfile, ActivityActorTypeEnumeration.SYSTEM, false, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED, ActivityTypeEnumeration.ACCOUNT_UPGRADE, response);
					log.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
					response.setFailure(true);
					response.setFailureMessage(String.format(messagesUtil.getMviUpdateAdvancedSuccessResponse(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow()));
					response.getInfoMessages().put(messagesUtil.getMviUpdateAdvancedSuccessResponse(),
						String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow()));
					return;
				}
				savedUserProfile.setIsMPIControlled(true);
				userProfileRepository.save(savedUserProfile);
			}
		} else {
			if(mpiProperties.isUseMiddleNameAndGender()){
				if (log.isDebugEnabled()) {
					log.debug("Middle name: " + savedUserProfile.getMiddleName()
					+ "gender: " + savedUserProfile.getGender()
					+ " for user id: " + savedUserProfile.getId()
					+ " and useMiddleNameAndGender property value from mpi.properties: "
					+ mpiProperties.isUseMiddleNameAndGender());
				}
				//patientService.getPatientFromRegistryWithMiddleName(firstName, lastName, middleName, gender, birthDate, ssn, userId, response);
			}else{
				if (log.isDebugEnabled()) {
					log.debug("In UserProfileServiceImpl::saveUserProfile::for user id: " + savedUserProfile.getId() + " not calling middle name service");
				}
				patientService.getPatientFromRegistry(firstName, lastName, birthDate, ssn, userId, response);
			}
			Patient patient = (Patient)response.getPojoObject();
			if (response.isFailure()) {
				return;
			}

			if (patient != null && response.isFailure()) {
				return;
			} else if (patient == null) {
				response.getInfoMessages().put(messagesUtil.getMviPatientNotFound(), String.format(messagesUtil.getPatientNotFound(),"patientNotFound"));
			} else {
				// Patient was found in registry so associate it with the user profile
				patient.setUserProfile(savedUserProfile);
				patientService.savePatient(patient);
			}

		}

		return;
	}

	/**
	 * Query DB
	 */
	@Override
	public UserProfileDTO getUserProfileByUserName(String userName) {
		UserProfile domainProfile = userProfileRepository.findByUserName(userName);
		UserProfileDTO profileDto = new UserProfileDTO();
		if (null != domainProfile) {
			profileDto = converter.convertDomainUserProfile(domainProfile);
		} else {
			log.error("domainProfile is null");
			throw new RuntimeException("Invalid User");
		}
		return profileDto;
	}

	@Override
	@Transactional
	public void savePasswordHistory(UserProfile userProfile, String password, Boolean tempFlag, ResponseUtil response) {

		try {
			UserPasswordHistory hist = new UserPasswordHistory();

			hist.setPassword(PasswordUtil.digest(password, "SHA"));
			hist.setTempPasswordFlag(tempFlag);
			hist.setUpdatedTime(new Timestamp(System.currentTimeMillis()));
			hist.setUserProfileId(userProfile.getId());
			hist.setOplock(1);

			userPasswdHistRepository.save(hist);
		} catch (Exception e) {
			log.error("Exception caught in auditing user profile", e);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
	}

	@Override
	@Transactional
	public void acceptTerms(UserProfile userProfile, Timestamp termsModifiedTime, Timestamp termsAcceptedTime, ResponseUtil response) {

/*		if (log.isDebugEnabled()) {
			log.debug("Before acceptTerms DB update :" + userProfile.getUserName() + ":userProfile.getAcceptTerms() : " + userProfile.getAcceptTerms());
			log.debug("Before acceptTerms DB update :" + userProfile.getUserName() + ":userProfile.getAcceptSMTerms() : " + userProfile.getAcceptSMTerms());
		}
*/
		List<UserAcceptTermsHistory> userAcceptHistoryList = null;
		List<TermsConditionsVerHistory> versionHistList = null;
		TermsConditionsVerHistory versionHist = null;
		UserAcceptTermsHistory usrAcceptTermsHist = null;

		try {
			if (null != termsModifiedTime) {
				userAcceptHistoryList = usrAcceptTermHistRepository.getUserAcceptTermsHistByUpdateTime(userProfile.getId(), termsModifiedTime);

				// no entries in userAcceptHistoryList
				if (null == userAcceptHistoryList || (null != userAcceptHistoryList && userAcceptHistoryList.size() == 0)) {
					
					versionHistList = termsCondVerHistRepository.getVersionByUpdateTime();
					if(versionHistList != null && versionHistList.size()>0) {
						versionHist = versionHistList.get(0);
					}else {
						throw new Exception("Unable to process Registration due to the invalid Terms and Conditions. Please contact the Help Desk.");
					}
					// no entries in TermsConditionsVerHistory
					/*if (null == versionHistList || (null != versionHistList && versionHistList.size() == 0)) {
						// this version has no record in the version table yet
						versionHist = new TermsConditionsVerHistory();
						versionHist.setUpdatedTime(termsModifiedTime);
						versionHist.setOplock(1);

						//termsCondVerHistRepository.save(versionHist);
						
					} else {
						// this version has a record
						
					}*/

					usrAcceptTermsHist = new UserAcceptTermsHistory();
					usrAcceptTermsHist.setOplock(1);
					usrAcceptTermsHist.setUserUpdatedTime(termsAcceptedTime);
					usrAcceptTermsHist.setAccepted(Boolean.TRUE);
					usrAcceptTermsHist.setUserProfileId(userProfile.getId());
					usrAcceptTermsHist.setTermsCondVerHist(versionHist);

				} else {
					// just update the answer
					usrAcceptTermsHist = userAcceptHistoryList.get(0);
					usrAcceptTermsHist.setAccepted(new Boolean(true));
					usrAcceptTermsHist.setUserUpdatedTime(termsAcceptedTime);
				}

				usrAcceptTermHistRepository.save(usrAcceptTermsHist);

				// check errors
				if (response.isFailure()) {
					return;
				}

				// below block is redundant, it was taken care in
				// saveUserProfile()
				// MHV Terms and Conditions Implementation
				// Secured Message Terms and Conditions Implementation
				/*
				savedUserProfile = userProfileRepository.getUserProfileById(userProfile.getId());

				if (null != userProfile.getAcceptSMTerms() && null != savedUserProfile) {
					savedUserProfile.setAcceptSMTerms(userProfile.getAcceptSMTerms());
					savedUserProfile.setAcceptTerms(true);
				    // Make sure that audit won't happen
					userProfileRepository.save(savedUserProfile);
				}*/

				// check errors
				if (response.isFailure()) {
					return;
				}
			}
		} catch (Exception e) {
			log.error("Exception caught in auditing user profile", e);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
/*		if (log.isDebugEnabled()) {
			log.debug("After acceptTerms DB update :" + userProfile.getUserName() + ":userProfile.getAcceptTerms() : " + userProfile.getAcceptTerms());
			log.debug("After acceptTerms DB update :" + userProfile.getUserName() + ":userProfile.getAcceptSMTerms() : " + userProfile.getAcceptSMTerms());
		}
*/	}

	@Override
	@Transactional
	public ResponseUtil findUserNameByHash(String ahash) {
		if(log.isInfoEnabled()) {
			log.info("UserProfileServiceImpl.findUserNameByHash()");
		}
		ResponseUtil response = new ResponseUtil();
		List<EauthHashDTO> eauthHashDTOS = null;
		try {
			List<EauthHash> eauthHashes = eauthHashRepository.findByHashValue(ahash);
			if (null != eauthHashes) {
				if(log.isInfoEnabled()) {
					log.info("UserProfileServiceImpl.findUserNameByHash() null != eauthHashes");
				}
				EauthHashConverter converter = new EauthHashConverter();
				eauthHashDTOS = converter.convertDomainEauthHashes(eauthHashes);
			}
			response.setSuccess(true);
			response.setPojoObject(eauthHashDTOS);
		} catch (Exception e) {
			log.error("Exception caught in deleting eauth hash", e);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}

		return response;
	}

	@Override
	@Transactional
	public ResponseUtil saveHash(Long userProfileId, String ahash) {
		ResponseUtil response = new ResponseUtil();
		List<EauthHashDTO> eauthHashDTOS = null;
		log.info("$%$$%$%saveHash hash: " +  ahash);
		log.info("$%$$%$%saveHash userProfileId: " +  userProfileId);
		try {
			EauthHash eauthHash = new EauthHash();
			UserProfile uProfile = new UserProfile();
			userProfileConverter.convertDTOProfile(uProfile, getUserProfileByID(userProfileId).getPojoObject());
			eauthHash.setUserProfile(uProfile);
			eauthHash.setHashValue(ahash);
			response.setPojoObject(eauthHashRepository.save(eauthHash));
			response.setSuccess(true);
		} catch (Exception e) {
			System.out.println("Exception caught in deleting eauth hash:"+ahash);
			log.error("Exception caught in deleting eauth hash", e);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
		return response;
	}
	
	@Override
	@Transactional
	public ResponseUtil saveHash(String userName, String ahash) {
		ResponseUtil response = new ResponseUtil();
		List<EauthHashDTO> eauthHashDTOS = null;
		log.info("$%$$%$%username: " +  userName);
		try {
			EauthHash eauthHash = new EauthHash();
			UserProfile uProfile = null;
			userProfileConverter.convertDTOProfile(uProfile, getUserProfileByUserName(userName));
			eauthHash.setUserProfile(uProfile);
			eauthHash.setHashValue(ahash);
			response.setPojoObject(eauthHashRepository.save(eauthHash));
			response.setSuccess(true);
		} catch (Exception e) {
			System.out.println("Exception caught in deleting eauth hash:"+ahash);
			log.error("Exception caught in deleting eauth hash", e);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
		return response;
	}
	
	@Override
	@Transactional
	public ResponseUtil deleteEauthHashByUserProfileId(Long userProfileId) {
		ResponseUtil response = new ResponseUtil();
		try {
			List<EauthHash> eauthHashes = eauthHashRepository.getEauthHashByUserProfileId(userProfileId);
			if (null != eauthHashes) {
				for (EauthHash eauth : eauthHashes) {
					eauthHashRepository.delete(eauth);
					activityService.auditAccountDeactivateEauthHashEvent(eauth.getUserProfile(), response);
				}
			}
			response.setSuccess(true);
		} catch (Exception e) {
			log.error("Exception caught in deleting eauth hash", e);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}

		return response;
	}

	@Override
	public ResponseUtil<List<EauthHashDTO>> findEAuthHashByUserProfileId(Long userProfileId) {
		ResponseUtil<List<EauthHashDTO>> response = new ResponseUtil<List<EauthHashDTO>>();
		List<EauthHashDTO> eauthHashDTOS = null;
		try {
			List<EauthHash> eauthHashes = eauthHashRepository.getEauthHashByUserProfileId(userProfileId);
			if (null != eauthHashes) {
				EauthHashConverter converter = new EauthHashConverter();
				eauthHashDTOS = converter.convertDomainEauthHashes(eauthHashes);
			}
			response.setSuccess(true);
			response.setPojoObject(eauthHashDTOS);
		} catch (Exception e) {
			log.error("Exception caught in Finding eauth hash", e);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
		return response;
	}

	private void createUserInLdap(UserProfileDTO profileDto, ResponseUtil response) {
		validator.validateUserCredentials(response, profileDto);

		if (response.getValidationErrors().size() > 0) {
			response.setFailure(true);
			return;
		}

		// This is needed as authentication is done against both the User (LDAP)
		// and Employee (Active Directory) authentication
		// providers (most like against LDAP first). Not allowing users to pick
		// a user name that is in use by an
		// employee, avoids user name conflicts upon authentication, and
		// subsequently possible user hijacking (see CR 2018).
		// NOTE: This check is snapshot and does not account for employee
		// accounts created after the snapshot.
		String userName = profileDto.getUserName();
		Boolean userAlreadyExists = employeeSearchService.searchByUserName(userName, false, response);

		if (userAlreadyExists == null || response.isFailure()) {
			// Unable to establish whether user exists, e.g. Active Directory is
			// unavailable
			// validator.addError(response,
			// UserManagementMessages.UNKNOWN_EXCEPTION_OCCURRED, null);
			log.error("User already exists in LDAP : userName " + userName);
			throw new MHVDuplicateUserException(messagesUtil.getUnknownExceptionOccurred());
		} else {
			// user already exists
			if (!userAlreadyExists) {
				// create user
				try {
					userEntryDao.createUser(profileDto);
/*					if (log.isDebugEnabled()) {
						log.debug("user has been stored in LDAP : " + userName );
					}
*/				} catch (DuplicateEntryException e) {
					log.error("Duplicate user in LDAP : " + e);
					userAlreadyExists = true;
				} catch (Exception e) {
					throw new MHVDuplicateUserException(messagesUtil.getUnknownExceptionOccurred());
				}
			}
			// throw an error for duplication userName in LDAP
			if (userAlreadyExists) {
				throw new MHVDuplicateUserException(String.format(messagesUtil.getUserAlreadyExists(), userName));
			}
		}

		if (response.getValidationErrors().size() > 0) {
			response.setFailure(true);
			return;
		}

/*		if (log.isDebugEnabled()) {
			log.debug("user stored successfully in LDAP : " + userName );
		}
*/	}


	private void removeUserFromLdap(UserProfileDTO profileDto) {
		try {
			userEntryDao.removeUser(profileDto.getUserName());
		} catch (Exception e) {
			log.error("Exception in deleting user ", e);
		}
/*		if (log.isDebugEnabled()) {
			log.debug("removed UserFromLdap " + profileDto.getUserName());
		}
*/	}

	@Transactional
	private void checkPatientRegistry(UserProfile userProfile, boolean isRegistration, ResponseUtil response) {
		if (log.isDebugEnabled()) {
			log.debug("Inside checkPatientRegistry...............");
		}
		Long userProfileId = userProfile.getId();
		String firstName = userProfile.getFirstName();
		String lastName  = userProfile.getLastName();
		String middleName  = userProfile.getMiddleName();
		String gender  = userProfile.getGender();
		if(gender.equalsIgnoreCase("Male")){
			gender = "M";
		}else{
			gender = "F";
		}

		Date birthDate = userProfile.getBirthDate();
		String ssn = userProfile.getSsn();

		// Checking the property file to see if we need to call getPatientFromRegistryWithMiddleName or getPatientFromRegistry
		if (mviProperties.isMviEnabled()) {
			//if(userProfile.getFccx() != null) {
			//	log.debug("patientService.createPatientForFccx", "fccxIcn", fccxIcn);
			//	patientService.createPatientForFccx(userProfile, fccxIcn, response);
			//} else {
				//get usertype form response.getuseraccounttype()
				patientService.getPatientFromMVI(userProfile, isRegistration, response);
			//}
			//if (response.isFailure()) {
			//	response.setPojoObject(userProfile);
			//	log.debug("patientRegistryResponse.getMessages().hasErrorMessages()", "fccxIcn", fccxIcn);
			//	return;
			//}

			Patient patient = (null != response.getPojoObject() && response.getPojoObject() instanceof Patient) ? (Patient) response.getPojoObject() : null;
/*			if (log.isDebugEnabled() && null != patient) {
				log.debug("Patient from MVI " + patient.getIcn());
			}
*/
			Map<String, String> patientRegistryResponseinfoMessages = response.getInfoMessages();
			int infoSize = (null != patientRegistryResponseinfoMessages && patientRegistryResponseinfoMessages.size() > 0) ? patientRegistryResponseinfoMessages.size() : 0;
			log.info("infoSize : " + infoSize);
			if (log.isDebugEnabled()) {
				if (infoSize > 0) {
					for (String msgKey : patientRegistryResponseinfoMessages.keySet()) {
						log.debug("msgKey : " + msgKey);
					}
				}
			}

			//TODO: Find reason to add (null != patient && patient.getId() == null)
			//if (patient == null || (null != patient && patient.getId() == null)) {
			if (patient == null) {
				log.info("patient == null || (null != patient && patient.getId() == null )");
				if (userProfileId == null) {
					activityService.auditMviEvent(userProfile, ActivityActorTypeEnumeration.SYSTEM, false, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED, ActivityTypeEnumeration.ACCOUNT_UPGRADE, response);
				} else {
					activityService.auditMviEvent(userProfile, ActivityActorTypeEnumeration.SYSTEM, false, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED, ActivityTypeEnumeration.ACCOUNT_UPGRADE, response);
					boolean parseErrorExists = false;
					boolean aeErrorUpdateUserProfile = false;

					if (infoSize > 0) {
						for (String msgKey : patientRegistryResponseinfoMessages.keySet()) {
							if(msgKey.equalsIgnoreCase("mvi.parse.response.issue")) {
								parseErrorExists = true;
							} else if(msgKey.equalsIgnoreCase("mvi.parse.response.ae.issue")) {
								aeErrorUpdateUserProfile = true;
							}
						}
					} else {
						if (parseErrorExists) {
							response.getInfoMessages().put(messagesUtil.getMviUpdateParseResponseIssue(),
									String.format(messagesUtil.getMviUpdateParseResponseIssue(), mviProperties.getContactLoggedMhvUrl()));
						} else if (aeErrorUpdateUserProfile) {
							response.getInfoMessages().put(messagesUtil.getMviParseResponseAeIssue(),
									String.format(messagesUtil.getMviParseResponseAeIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow()));
						} else {
							response.getInfoMessages().put(messagesUtil.getMviUpdateAdvancedFailureResponse(),
									String.format(messagesUtil.getMviUpdateAdvancedFailureResponse(), mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(),
											mviProperties.getContactLoggedMhvUrl(), mviProperties.getTargetWindow()));
						}
					}
				}

				try {
					userProfile = userProfileRepository.save(userProfile);
				} catch (Exception e) {
					log.error("Error in storing userProfile details", e);
				}

				if (infoSize > 0) {
					for (String msgKey : patientRegistryResponseinfoMessages.keySet()) {
/*						if (log.isDebugEnabled()) {
							log.debug("msgKey : " + msgKey);
						}
*/						if (null != msgKey && msgKey.equalsIgnoreCase("mvi.parse.response.issue")) {
							MviSyncCommonError mviSyncCommonError = null;
							try {
								List<MviSyncCommonError> mviSyncCommonErrors = mviSyncCommonErrorRepository.getRequiredMviSyncByProfileId(userProfileId);

								if (null != mviSyncCommonErrors && mviSyncCommonErrors.size() > 0) {
									mviSyncCommonError = mviSyncCommonErrors.get(0);
								}
							} catch(Exception e) {
								log.error("Error in fetching data from MviSyncCommonError " + e );
								response.setFailure(true);
								response.setFailureMessage("Error in fetching data from MviSyncCommonError " + e.getMessage());
								return;
							}

							// if mviSyncCommonError is null, create a new object
							if (mviSyncCommonError == null) {
								MviSyncCommonError mviSyncCommError2 = new MviSyncCommonError();
								mviSyncCommError2.setUserProfileId(userProfileId);
								mviSyncCommError2.setCreatedDate(new Timestamp(System.currentTimeMillis()));

								try {
									mviSyncCommonErrorRepository.save(mviSyncCommError2);
								} catch(Exception e) {
									log.error("Error in storing MviSyncCommonError data" + e );
									response.setFailure(true);
									response.setFailureMessage("Error in storing MviSyncCommonError data : " + e.getMessage());
									return;
								}
								if (log.isDebugEnabled()) {
									log.debug("mviSyncCommonError details have been stored successfully");
								}
							}
						}
					}
				}
				return;
			} else {
				log.info("got patients from MVI");
				// got patients from MVI
				patient.setOplock(1);
				patient.setUserProfile(userProfile);
				patient.setCorrelationStatus(PatientCorrelationStatusEnumeration.MVIDATAMATCH.getValue());
				patient.setMatchedDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
				//copyMessages(response, patientRegistryResponse);

				// store MVI patient details into MHV PATIENT table
				Patient savedPatient = patientService.savePatient(patient);

				if (userProfileId == null) {
					activityService.auditMviEvent(userProfile, ActivityActorTypeEnumeration.SYSTEM, true, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED, ActivityTypeEnumeration.ACCOUNT_UPGRADE, response);
				} else {
					activityService.auditMviEvent(userProfile, ActivityActorTypeEnumeration.SYSTEM, true, ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED, ActivityTypeEnumeration.ACCOUNT_UPGRADE, response);
					// check for messagesUtil.getMviAdvancedSuccessResponse() and not registration

					if (!isRegistration) {
						response.getInfoMessages().put(messagesUtil.getMviUpdateAdvancedSuccessResponse(), String.format(messagesUtil.getMviUpdateAdvancedSuccessResponse(), mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow()));
					}
				}

				// If IsMPIControlled is set to true, then User Details are locked for update
				userProfile.setIsMPIControlled(true);

				try {
					userProfileRepository.save(userProfile);
				} catch(Exception e) {
					log.error("Error in storing userProfile data" + e );
					response.setFailure(true);
					response.setFailureMessage("Error in storing userProfile data : " + e.getMessage());
					return;
				}

				//Adding for Correlation
		    	//PatientServiceResponse patientResponse = ServiceDelegateFactory.createPatientServiceDelegate().getPatientForUser(userProfile);
		    	//Patient patient = patientResponse.getPatient();

		    	if (null != savedPatient && savedPatient.getCorrelationStatus().equals(PatientCorrelationStatusEnumeration.MVIDATAMATCH.getValue())) {
		    		activityService.auditMviEvent(userProfile, ActivityActorTypeEnumeration.SYSTEM, true, ActivityActionTypeEnumeration.ACCOUNT_CORRELATION_REQUESTED, ActivityTypeEnumeration.REGISTRATION, response);
		    		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
System.out.println("############################################################## UserProfileServiceImpl.checkPatientRegistry calling mviAsyncIntegrationService.addPersonForCorrelation");		    		
		    		mviAsyncIntegrationService.addPersonForCorrelation(savedPatient, userProfile, true, response, MviUtil.getVersionInfo(userProfile));
System.out.println("############################################################## UserProfileServiceImpl.checkPatientRegistry after calling mviAsyncIntegrationService.addPersonForCorrelation");		    		
		    	}
			}
		} else {
			if(mpiProperties.isUseMiddleNameAndGender()){
/*				if (log.isDebugEnabled()) {
					log.debug("Middle name: " + userProfile.getMiddleName()
							+ "gender: " + userProfile.getGender()
							+ " for user ID: " + userProfileId
							+ " and useMiddleNameAndGender property value from mpi.properties: "
							+ mpiProperties.isUseMiddleNameAndGender());
				}
*/				patientService.getPatientFromRegistryWithMiddleName(firstName, lastName, middleName, gender, birthDate, ssn, userProfileId, response);
				if (response.isFailure()) {
					return;
				}

			} else {
/*				if (log.isDebugEnabled()) {
					log.debug("In UserProfileServiceImpl::saveUserProfile::for user ID: " + userProfileId + " not calling middle name service");
				}
*/				patientService.getPatientFromRegistry(firstName, lastName, birthDate, ssn, userProfileId, response);
				if (response.isFailure()) {
					return;
				}
			}

			Patient patient = (null != response.getPojoObject()) ? (Patient) response.getPojoObject() : null;
			/*
			if (patientRegistryResponse.getMessages().hasErrorMessages()) {
				response.getMessages().addMessages(patientRegistryResponse.
						getMessages());
				//  If this is a new user profile, the id needs to be reset
				// since the txn will now roll back
				response.getUserProfile().setId(id);
				return response;
			}*/
			/*
			if (patient != null && patient.getAllMessages().hasErrorMessages()) {
				response.getMessages().addMessages(patient.getAllMessages());
			} else*/
			if (patient == null) {
				response.setFailure(true);
				response.setFailureMessage(messagesUtil.getPatientNotFound());
				return;
				//  If this is a new user profile, the id needs to be reset since
				// the txn will now roll back
				//response.getUserProfile().setId(id);
			} else {
				// Patient was found in registry so associate it with the
				// user profile
				//PatientServiceResponse psr = ServiceFactory.createEntityMaintenanceService().save(patient);
				//copyMessages(response, psr);
				patient.setUserProfile(userProfile);
				patientService.savePatient(patient);
			}
		}
	}

	public void changeActivationState(UserProfile userProfile,
		UserProfileDeactivationReason reason, String changedBy, String notes, Date deathDate, ResponseUtil response) {

		//Admin Portal_CodeCR1959 - React/Deact Impl
		Precondition.assertNotNull("userProfile", userProfile);
		String originalLastName = userProfile.getLastName();

		if (reason != null) {
/*			if (log.isDebugEnabled()) {
				log.debug("Deactivating account '" + userProfile.getUserName()
					+ ", because " + reason.getName() + ". " + StringUtils.defaultString(notes));

			}*/
//			List<UserProfile> userProfiles = userProfileRepository.getProfileByNameBirthDateSsnIncludedDeleted(userProfile.getFirstName().toLowerCase(),
//																											   userProfile.getLastName().toLowerCase() + "%",
//																											   userProfile.getBirthDate(),
//																											   userProfile.getSsn());
			List<UserProfile> userProfiles = new ArrayList<UserProfile>();
            String lastNameAppend = "";

            Set<String> deletedLastNames = new HashSet<String>();
            for (Iterator iterator = userProfiles.iterator(); iterator
					.hasNext();) {
				UserProfile uProfile = (UserProfile) iterator.next();
				if(uProfile.getLastName().indexOf("DELETED") > -1) {
					deletedLastNames.add(uProfile.getLastName());
				}
			}

            if(deletedLastNames.size()==0) {
            	lastNameAppend = "DELETED";
            } else {
            	if(!deletedLastNames.contains(userProfile.getLastName()+"DELETEDONE")) {
                	lastNameAppend = "DELETEDONE";
            	} else if(!deletedLastNames.contains(userProfile.getLastName()+"DELETEDTWO")) {
                	lastNameAppend = "DELETEDTWO";
            	} else if(!deletedLastNames.contains(userProfile.getLastName()+"DELETEDTWO")) {
                	lastNameAppend = "DELETEDTWO";
            	} else if(!deletedLastNames.contains(userProfile.getLastName()+"DELETEDTHREE")) {
                	lastNameAppend = "DELETEDTHREE";
            	} else if(!deletedLastNames.contains(userProfile.getLastName()+"DELETEDFOUR")) {
                	lastNameAppend = "DELETEDFOUR";
            	} else if(!deletedLastNames.contains(userProfile.getLastName()+"DELETEDFIVE")) {
                	lastNameAppend = "DELETEDFIVE";
            	} else if(!deletedLastNames.contains(userProfile.getLastName()+"DELETEDSIX")) {
                	lastNameAppend = "DELETEDSIX";
            	} else if(!deletedLastNames.contains(userProfile.getLastName()+"DELETEDSEVEN")) {
                	lastNameAppend = "DELETEDSEVEN";
            	} else if(!deletedLastNames.contains(userProfile.getLastName()+"DELETEDEIGHT")) {
                	lastNameAppend = "DELETEDEIGHT";
            	} else if(!deletedLastNames.contains(userProfile.getLastName()+"DELETEDNINE")) {
                	lastNameAppend = "DELETEDNINE";
            	} else if(!deletedLastNames.contains(userProfile.getLastName()+"DELETEDTEN")) {
                	lastNameAppend = "DELETEDTEN";
            	} else if(!deletedLastNames.contains(userProfile.getLastName()+"DELETEDELEVEN")) {
                	lastNameAppend = "DELETEDELEVEN";
            	} else if(!deletedLastNames.contains(userProfile.getLastName()+"DELETEDTWELVE")) {
                	lastNameAppend = "DELETEDTWELVE";
            	}
            }
			if(reason.getName().equals("Deceased")) {
				userProfile.setLastName(userProfile.getLastName()+"DECEASED");
			} else {
				//US12.5 - Make sure to add "DELETE"
				userProfile.setLastName(userProfile.getLastName()+lastNameAppend);
			}
			userProfile.setDeactivationReason(reason);
			userProfile.setDeathDate(deathDate);
			//JAZZ: 19292 - Take out matched date, set mpi controlled flag to null during deactivation.
			userProfile.setIsMPIControlled(false);
		} else {
/*			if (log.isDebugEnabled()) {
				log.debug("No deactivation reason for user:" + userProfile.getUserName());
			}*/
			//addError(response, "mvi.helpdesk.devalidate.error.reason.missing", new String [] {"deactivateReason"});
			response.getInfoMessages().put(messagesUtil.getMviHelpdeskDevalidateErrorReasonMissing(), String.format(messagesUtil.getMviHelpdeskDevalidateErrorReasonMissing(),"deactivateReason"));
		}

		if ((notes == null)||(notes.length()==0)) {
			//addError(response, "mvi.helpdesk.devalidate.error.description.missing", new String [] {"deactivateNote"});
			response.getInfoMessages().put(messagesUtil.getMviHelpdeskDevalidateErrorDescriptionMissing(), String.format(messagesUtil.getMviHelpdeskDevalidateErrorDescriptionMissing(),"deactivateNote"));
		}
		//Admin Portal_CodeCR1959 - Deact/React Impl
		if (!response.isFailure()) {
			UserProfile savedUserProfile = doUserProfileActivateSave(userProfile, false, userProfile.getFccx(), response);
			if (response.isFailure()) {
				userProfile.setLastName(originalLastName);
				activityService.auditAccountDeactivateEvent(userProfile, ActivityActorTypeEnumeration.HELP_DESK_ADMINISTRATOR, false, response);
				log.error("UserProfileServiceImpl().changeActivationState user:" + savedUserProfile.getId() + ":FAILED");
			} else {
				//Note this audit is only for deact/react and goes to user_profile_deact_audit table; different from aal table.
				auditActivationStateChange(response, userProfile, reason, changedBy, notes);
				activityService.auditAccountDeactivateEvent(userProfile, ActivityActorTypeEnumeration.HELP_DESK_ADMINISTRATOR, true, response);
				//JAZZ:Task#20852 - Take out entry from eauthhash during deactivation for the user
				deleteHashByUserProfileId(userProfile, response);
				log.error("UserProfileServiceImpl().changeActivationState user:" + savedUserProfile.getId() + ":SUCCESS");
			}
		} else {
			userProfile.setLastName(originalLastName);
			activityService.auditAccountDeactivateEvent(userProfile, ActivityActorTypeEnumeration.HELP_DESK_ADMINISTRATOR, false, response);
		}
		return;
	}

	private UserProfile doUserProfileActivateSave(UserProfile entity, boolean doAudit, Date fccxDate, ResponseUtil response) {
		UserProfileDTO userProfileDto = null;
		if (entity != null) {
			Long id = entity.getId();
			if (id != null) {
				userProfileDto = converter.convertDomainUserProfile(userProfileRepository.getUserProfileById(id));
				if (doAudit) {
					activityService.auditUpdateProfileEvent(id, ActivityActorTypeEnumeration.SELF, response);
				}
			} else {
				userProfileDto = new UserProfileDTO();
				// Since this is a new entity, set the crate date to now.
				userProfileDto.setCreatedDate(new Timestamp(System.currentTimeMillis()));
			}

			if(fccxDate != null) {
            	entity.setFccx(fccxDate);
            }
			validator.userProfileUpdateValidations(response, userProfileDto, false);
			// no validation errors
			if(entity.getBirthDate() != null) {
            	SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            	String birthDate = sdf.format(entity.getBirthDate());
            	if(birthDate.substring(0,4).equals("1851") && birthDate.substring(4, 6).equals("01") && birthDate.substring(6).equals("01")) {
            		entity.setBirthDate(null);
            		response.getInfoMessages().put(messagesUtil.getImpreciseBirthDate(), String.format(messagesUtil.getImpreciseBirthDate(),"impreciseBirthDate"));
            	}
        	} else {
        		response.getInfoMessages().put(messagesUtil.getImpreciseBirthDate(), String.format(messagesUtil.getImpreciseBirthDate(),"impreciseBirthDate"));
        	}
			if (response.getValidationErrors().size() == 0) {
				entity = converter.convertDTOProfile(entity, userProfileDto);
				// save user profile in USER_PROFILE table
				userProfileRepository.save(entity);
				response.setPojoObject(entity);
			} else {
				response.setFailure(true);
			}
		}
		return entity;
	}

	//Admin Portal_CodeCR1959 - React/Deact Impl
	private void auditActivationStateChange(ResponseUtil response, UserProfile userProfile,
		UserProfileDeactivationReason reason, String changedBy, String notes)
	{
		UserProfileDeactivationAudit audit = new UserProfileDeactivationAudit();

		audit.setAction(reason != null ? UserProfileActivationActionEnumeration.DEACTIVATED.getValue() : UserProfileActivationActionEnumeration.ACTIVATED.getValue());
		audit.setUserProfile(userProfile);
		audit.setDeactivationReason(reason);
		audit.setChangeDate(new Timestamp(System.currentTimeMillis()));
		audit.setChangedBy(changedBy);
		audit.setNotes(notes);

		//copyMessages(response, ServiceFactory.createEntityMaintenanceService().save(audit));
		deactivationAuditService.saveAudit(audit, response);
	}

    /*
     * JAZZ:Task#20852 - Take out entry from eauthhash during deactivation for the user
     */
	public void deleteHashByUserProfileId(UserProfile userProfile, ResponseUtil response) {
		List<EauthHash> eauthHashList = eauthHashRepository.getEauthHashByUserProfileId(userProfile.getId());

		for (EauthHash eauthHash : eauthHashList) {
			eauthHashRepository.delete(eauthHash);
			activityService.auditAccountDeactivateEauthHashEvent(userProfile, response);
		}
	}

	public void getProfileForVAAFITraits(String firstName, String lastName, String gender, Date birthDate, ResponseUtil response) {
 		List<UserProfile> userProfiles = this.userProfileRepository.getProfileByNameBirthDateForVAAFI(firstName, lastName, gender);
 		if( userProfiles == null || userProfiles.size() == 0 ) {
 			response.setFailure(true);
 			response.setSuccess(false);
 		} else {
 			UserProfileDTO userProfileDTO = null;
 			for( UserProfile u : userProfiles ) {
 				UserProfileDTO uDTO = converter.convertDomainUserProfile(u);
 				userProfileDTO = uDTO;
 				break;
 			}

 			response.setPojoObject(userProfileDTO);
 			response.setFailure(false);
 			response.setSuccess(true);
 		}
 	}
 	
 	public void getProfileByNameBirthDate(String firstName, String lastName, String gender, Date birthDate, ResponseUtil response) {
 		List<UserProfile> userProfiles = this.userProfileRepository.getProfileByNameBirthDate(firstName, lastName, gender, birthDate);
 		if( userProfiles == null || userProfiles.size() == 0 ) {
 			response.setFailure(true);
 			response.setSuccess(false);
 		} else {
 			UserProfileDTO userProfileDTO = null;
 			for( UserProfile u : userProfiles ) {
 				UserProfileDTO uDTO = converter.convertDomainUserProfile(u);
 				userProfileDTO = uDTO;
 				break;
 			}
 			response.setPojoObject(userProfileDTO);
 			response.setFailure(false);
 			response.setSuccess(true);
 		}
 	}
 	
 	public void validateHintAnswers(Long userProfileId, String answer1, String answer2,ResponseUtil response) {
 		UserProfile userProfile = this.userProfileRepository.getUserProfileById(userProfileId);
 		
 	 	validator.validateHintAnswers(answer1,answer2,userProfile,response);
 		if (response.getValidationErrors() == null || response.getValidationErrors().size() == 0) {
			activityService.createUserActivity(Boolean.TRUE, ActivityActionTypeEnumeration.RECOVERED.getDescription(), ActivityTypeEnumeration.USER_ID.getDescription(), response, userProfile.getId());
			response.setFailure(false);
			response.setSuccess(true);
 		}else {
			activityService.createUserActivity(Boolean.FALSE, ActivityActionTypeEnumeration.RECOVERED.getDescription(), ActivityTypeEnumeration.USER_ID.getDescription(), response, userProfile.getId());
 			response.setFailure(true);
 			response.setSuccess(false);
 		}
 			
 	}

 	public void getProfileByNameUserNameBirthDate(String firstName, String lastName, String userName, String gender, Date birthDate, ResponseUtil response) {
 		List<UserProfile> userProfiles = this.userProfileRepository.getProfileByNameUserNameBirthDate(firstName, lastName, userName, gender);
 		if( userProfiles == null || userProfiles.size() == 0 ) {
 			response.setFailure(true);
 			response.setSuccess(false);
 		} else {
 			UserProfileDTO userProfileDTO = null;
 			for( UserProfile u : userProfiles ) {
 				UserProfileDTO uDTO = converter.convertDomainUserProfile(u);
 				userProfileDTO = uDTO;
 				break;
 			}

 			response.setPojoObject(userProfileDTO);
 			response.setFailure(false);
 			response.setSuccess(true);
 		}
 	}


	public void deleteUserProfile(Long userProfileId, ResponseUtil response) {
		try {
			usrAcceptTermHistRepository.deleteByUserProfileId(userProfileId);
			userPasswdHistRepository.deleteByUserProfileId(userProfileId);
			activityRepository.deleteByUserProfileId(userProfileId);
			userProfileRepository.delete(userProfileId);
		} catch (Exception e) {
			response.setFailure(true);
			response.setSuccess(false);
			response.setFailureMessage("Error in deleting user");
			log.error("Error in deleting user ", e);
		}
		response.setFailure(false);
		response.setSuccess(true);
	}

	@Override
	public ResponseUtil<UserProfileDTO> getUserProfileByID(Long id) {
		ResponseUtil<UserProfileDTO> response = new ResponseUtil<UserProfileDTO>();
		try {
			UserProfile domainProfile=null;
			if(id != null){
			    domainProfile = userProfileRepository.findOne(id);
				if (null != domainProfile) {
					UserProfileDTO profileDto = new UserProfileDTO();
					profileDto = converter.convertDomainUserProfile(domainProfile);
					response.setPojoObject(profileDto);
					response.setSuccess(true);
				}else{
					response.setFailureMessage("Invalid User");
				}
			}else{
				response.setFailureMessage("Invalid User");
			}
		} catch (Exception e) {
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
			log.error("Exception occurred getting User Profile", e);
		}
		return response;
	}

	public void useFccxLogin(ResponseUtil response) {
		if(mviProperties.getUseFccxLogin()) {
			response.setFailure(false);
			response.setSuccess(true);
		} else {
			response.setFailure(true);
			response.setSuccess(false);
		}
		return;
	}

	@Override
	public HealthInfoDTO getHealthInfo(Long userProfileId) {
		HealthInfoDTO dto = new HealthInfoDTO();
		log.debug("userProfileId: " + userProfileId);
		// find user profile
		UserProfile userProfile = userProfileRepository.findOne(userProfileId);
		log.debug("username = " + userProfile.getUserName());
		String name = userProfile.getFirstName();
		name += " ";
		name += userProfile.getLastName();
		name += (userProfile.getSuffix() != null ? (" " + userProfile.getSuffix()) : "");

		dto.setMhvId(userProfile.getMhvId());

		dto.setName(name);
		dto.setBloodType(userProfile.getBloodType());
		dto.setAddr1(userProfile.getAddressStreet1());
		dto.setAddr2(userProfile.getAddressStreet2());
		dto.setCity(userProfile.getAddressCity());
		dto.setState(userProfile.getAddressState());
		dto.setZip(userProfile.getAddressPostalCode());
		dto.setEmail(userProfile.getContactInfoEmail());

		dto.setHomePhone(userProfile.getContactInfoHomePhone());
		dto.setMobilePhone(userProfile.getContactInfoMobilePhone());
		dto.setWorkPhone(userProfile.getContactInfoWorkPhone());

		// get primary health care provider
		List<HealthCareProvider> providers = healthCareProviderRepository.findPrimaryProvider(userProfileId);
		if (providers != null && providers.size() >= 1) {
			HealthCareProvider p =  providers.get(0);

			dto.setPrimaryProvider(p.getFirstName() + " " + p.getLastName());
			dto.setPrimaryProviderPhone(p.getWorkPhone());
			dto.setPrimaryProviderPhoneExtension(p.getWorkPhoneExt());
		}

		// get primary insurance provider
		List<HealthInsurances> healthInsurances = healthInsurancesRepository.findByUserProfileId(userProfileId);

		if (healthInsurances != null && healthInsurances.size() >= 1) {
			HealthInsurances hi = healthInsurances.get(0);
			dto.setPrimaryInsurancePhone(hi.getCompanyPhone());
			dto.setPrimaryInsurance(hi.getCompanyName());
			dto.setPrimaryInsuranceId(hi.getInsuranceIdNumber());
			dto.setPrimaryInsuranceGroupNumber(hi.getGroupNumber());
		}

		// find primary emergency contact
		List<EmergencyContact> primaryContactList = emergencyContactRepository.findByUserProfileIdAndPrimary(userProfileId, true);

		if (primaryContactList != null && primaryContactList.size() >= 1) {
			EmergencyContact ec = primaryContactList.get(0);
			dto.setEmergencyContactName(ec.getFirstName() + " " + ec.getLastName());
			dto.setEmergencyContactEmail(ec.getEmail());
			dto.setEmergencyContactHomePhone(ec.getHomePhone());
			dto.setEmergencyContactMobilePhone(ec.getMobilePhone());
			dto.setEmergencyContactWorkPhone(ec.getWorkPhone());
			dto.setEmergencyContactWorkPhoneExtension(ec.getWorkPhoneExt());
		}

		// find allergies
		List<String> allergiesList = allergiesRepository.getAllergiesForUser(userProfileId);
		dto.setAllergies(allergiesList);
		log.debug(dto);
		return dto;
	}
	
	@Override
	public String getVapiiFormStatusForUser(
			Long userProfileId) throws Exception {
		//return "";
		//System.out.println("UserProfileServiceImpl.getVapiiFormStatusForUser() getVapiiWsdlUrl():" + getVapiiWsdlUrl());	
//		URL url = UserProfileServiceImpl.class.getResource("vapii-partner-services.wsdl");
//		if(url == null) {
//			System.out.println("url == null");
//		} else {
//			System.out.println("url != null");
//		}
		System.out.println("vapiiWsdl.getURL():" + mviProperties.getVapiiWsdlResource().getURL().toString());	
		VapiiPartnerServicesService vapiiPartnerService = new VapiiPartnerServicesService(mviProperties.getVapiiWsdlResource().getURL(), 
			new QName("http://www.DNS   /vapiiPartnerServices/schema/1.1", "VapiiPartnerServicesService"));
		System.out.println("vapiiPartnerService.getWSDLDocumentLocation(): "+vapiiPartnerService.getWSDLDocumentLocation().getPath());
		System.out.println("vapiiPartnerService.getServiceName().getNamespaceURI(): "+vapiiPartnerService.getServiceName().getNamespaceURI());
		
//		VapiiPartnerServicesService vapiiPartnerService = new VapiiPartnerServicesService();
//		VapiiPartnerServicesProxy proxy = new VapiiPartnerServicesProxy(getVapiiWsdlUrl());//Use this one!!!
//		GetFormStatusForUserRequest request = new GetFormStatusForUserRequest();
		GetFormStatusForUserRequest request = new GetFormStatusForUserRequest();
		User user = new User();
		user.setUserId(userProfileId.toString());
		user.setUserIdType(UserIdType.MHV);
		
//		User[] users = new User[1];
//		users[0] = new User();
//
//		users[0].setUserId(getVapiiUserId(userProfile));
//		if(LOG.isDebugEnabled()){
//			LOG.debug("**************************  UserProfileServiceImpl.getVapiiFormStatusForUser() getVapiiUserId(userProfile)="+getVapiiUserId(userProfile));
//		}
//
//		users[0].setUserIdType(getVapiiUserIdType());
//		if(LOG.isDebugEnabled()){
//			LOG.debug("**************************  UserProfileServiceImpl.getVapiiFormStatusForUser() getVapiiUserIdType()="+getVapiiUserIdType().getValue());
//		}
		
		request.getUsers().add(user);
//		
		//Jazz # 145667 - eRAR process is not upgrading a few users to Premium - adding the form type
//		request.setFormType(FormType.value1);
		request.setFormType("10-5345A-MHV");
		
//		StringServiceResponse stringResponse = new StringServiceResponse();
//		stringResponse.setString("");
//		try {
//			GetFormStatusForUserResponse response = proxy.getFormStatusForUser(request);
//			String responseStr = "";
//			if(response.getFormReferences()!=null && response.getFormReferences()[0].getFormStatus() != null) {
//				responseStr = response.getFormReferences()[0].getFormStatus().getValue();
//			}
//			stringResponse.setString(responseStr);
//			if(LOG.isDebugEnabled()){
//				LOG.debug("**************************  UserProfileServiceImpl.getVapiiFormStatusForUser() userProfile.getUserName():"+ userProfile.getUserName()+ "	formStatus:"+responseStr);
//			}
//			return stringResponse;
//		} catch(Throwable t) {
//			t.printStackTrace();
//			addError(stringResponse, t.getMessage());
//		}
//		return stringResponse;
		GetFormStatusForUserResponse response = vapiiPartnerService.getVapiiPartnerServicesSoap11().getFormStatusForUser(request);
		Iterator<Message> messages = response.getMessages().iterator();
	
		while (messages.hasNext()) {
			Message msg = messages.next();
			if(msg.getKey().equals("partnerService.user.notfound")) {
				throw new Exception("partnerService.user.notfound");
			}
		}
		
		if(response.getFormReferences() != null && response.getFormReferences().size() > 0) {
			return response.getFormReferences().get(0).getFormStatus().value();
		}
		
		return "";
	}
	
	@Override
	public void logEauthEvent(String ahash, String userName, String csid, String event) {
		EauthLog log = new EauthLog();
		log.setCsid(csid);
		log.setEauthEvent(event);
		log.setEventDate(new Date());
		log.setHash(ahash);
		log.setUserName(userName);
		eauthLogRepository.save(log);
	}
	
	public static void main(String[] args) throws MalformedURLException {
		VapiiPartnerServicesService vapiiPartnerService = new VapiiPartnerServicesService(
			new URL("https://int.vdc.aac.DNS   :444/wssweb/vii-app-1.1/ws/vapiiParterServices"), new QName("http://www.DNS   /vapiiPartnerServices/schema/1.1", "VapiiPartnerServicesService"));
		
		GetFormStatusForUserRequest request = new GetFormStatusForUserRequest();
		User user = new User();
		user.setUserId("12345");
		user.setUserIdType(UserIdType.MHV);
		request.getUsers().add(user);
		request.setFormType("10-5345A-MHV");
		
		GetFormStatusForUserResponse response = vapiiPartnerService.getVapiiPartnerServicesSoap11().getFormStatusForUser(request);
		if(response.getFormReferences() != null && response.getFormReferences().size() > 0) {
			System.out.println(response.getFormReferences().get(0).getFormStatus().value());
		}

	}
	
}