package gov.va.med.mhv.usermgmt.main.service.impl;

import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.usermgmt.data.model.UserProfileDeactivationAudit;
import gov.va.med.mhv.usermgmt.data.repository.UserProfileDeactivationAuditRepository;
import gov.va.med.mhv.usermgmt.exception.MHVRuntimeException;
import gov.va.med.mhv.usermgmt.service.UserProfileDeactivationAuditService;

@Component
public class UserProfileDeactivationAuditServiceImpl implements UserProfileDeactivationAuditService {

	private static Logger log = LogManager.getLogger(UserProfileDeactivationAuditServiceImpl.class);

	@Autowired
	private UserProfileDeactivationAuditRepository deactivationAuditRepository;

	@Override
	public UserProfileDeactivationAudit saveAudit(UserProfileDeactivationAudit audit, ResponseUtil response) {
		UserProfileDeactivationAudit storedDeactivationAudit = null;
		try {
			storedDeactivationAudit = deactivationAuditRepository.save(audit);
		} catch (Exception e) {
			log.error("Error in storing UserProfileDeactivationAudit details", e);
			response.setFailure(true);
			throw new MHVRuntimeException("Error in storing UserProfileDeactivationAudit details");
		}

		response.setFailure(false);
		response.setSuccess(true);
		response.setPojoObject(storedDeactivationAudit);

		return storedDeactivationAudit;
	}

	@Override
	public void findUserProfileDeactivationAuditByUser(Long userProfileId, ResponseUtil response) {
		List<UserProfileDeactivationAudit> deactivationAudits = null;
		UserProfileDeactivationAudit deactivationAudit = null;
		try {
			deactivationAudits = deactivationAuditRepository.findUserProfileDeactivationAuditByUser(userProfileId);

			if (null != deactivationAudits && deactivationAudits.size() > 0) {
				deactivationAudit = deactivationAudits.get(0);
			}
		} catch (Exception e) {
			log.error("Error in getting UserProfileDeactivationAudit details" + userProfileId, e);
			response.setFailure(true);
			throw new MHVRuntimeException("Error in getting UserProfileDeactivationAudit details" + userProfileId);
		}

		response.setFailure(false);
		response.setSuccess(true);
		response.setPojoObject(deactivationAudit);
	}

}
