package gov.va.med.mhv.usermgmt.main.service.impl;


import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.usermgmt.common.dto.UserAcceptTermsHistoryDTO;
import gov.va.med.mhv.usermgmt.converter.UserAcceptTermsHistoryConverter;
import gov.va.med.mhv.usermgmt.data.model.UserAcceptTermsHistory;
import gov.va.med.mhv.usermgmt.data.repository.UserAcceptTermsHistoryRepository;
import gov.va.med.mhv.usermgmt.service.UserAcceptTermsHistoryService;

@Component
public class UserAcceptTermsHistoryServiceImpl implements UserAcceptTermsHistoryService {

	protected static Logger log = LogManager.getLogger(UserAcceptTermsHistoryServiceImpl.class);

	@Autowired
	private UserAcceptTermsHistoryRepository userAcceptTermsHistoryRepository;

	private UserAcceptTermsHistoryConverter converter = new UserAcceptTermsHistoryConverter();

	@Override
	public List<UserAcceptTermsHistoryDTO> getUserAcceptTermsHistByUserProfileId(Long id) {
		List<UserAcceptTermsHistory> list = userAcceptTermsHistoryRepository.getUserAcceptTermsHistByUserProfileId(id);
		List<UserAcceptTermsHistoryDTO> dtoList = new ArrayList<UserAcceptTermsHistoryDTO>();
		if( list != null && list.size() > 0 ) {
			for( UserAcceptTermsHistory uh : list ) {
				UserAcceptTermsHistoryDTO eDto = converter.convertFrom(uh);
				dtoList.add(eDto);
			}
		}

		return dtoList;
	}

}
