package gov.va.med.mhv.usermgmt.main.service.impl;

import java.util.ArrayList;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.usermgmt.common.dto.MyLinksDTO;
import gov.va.med.mhv.usermgmt.data.model.MyLinks;
import gov.va.med.mhv.usermgmt.data.repository.MyLinksRepository;
import gov.va.med.mhv.usermgmt.exception.MHVRuntimeException;
import gov.va.med.mhv.usermgmt.main.service.converter.MyLinksConverter;
import gov.va.med.mhv.usermgmt.main.service.validator.MyLinksValidator;
import gov.va.med.mhv.usermgmt.service.MyLinksService;

@Component
public class MyLinksServiceImpl implements MyLinksService {
	private static Logger log = LogManager.getLogger(MyLinksServiceImpl.class);

	@Autowired
	private MyLinksRepository myLinksRepository;
	
	@Autowired
	private MyLinksConverter myLinksConverter;
	
	@Autowired
	private MyLinksValidator validator;
	
	@Override
	public String test(String sampleText) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public List<MyLinksDTO> getMyLinksByUserId(Long userprofileid) {
		
		List<MyLinksDTO> myLinksDtos = null;
		List<MyLinks> myLinks = null;
		try {
			myLinks = myLinksRepository.getMyLinksForUser(userprofileid);
		} catch(Exception e) {
			log.error("Error in fetching my links " + e);
			throw new MHVRuntimeException("Error in fetching  my links", e);
		}
		
		if (null != myLinks && myLinks.size() > 0) {
			myLinksDtos = new ArrayList<MyLinksDTO>();
			for (MyLinks myLink : myLinks) {
				myLinksDtos.add(myLinksConverter.convertDomainMyLinks(myLink));
			}
		}
		
		return myLinksDtos;
	}
	
	@Override
	public MyLinksDTO getMyLinksById(Long myLinkId) {
		MyLinksDTO myLinkDto = null;
		MyLinks myLink = null;
		try {
			myLink = myLinksRepository.findOne(myLinkId);
		} catch(Exception e) {
			log.error("Error in fetching med hits " + e);
			throw new MHVRuntimeException("Error in fetching  my links", e);
		}
		
		if (null != myLink) {
			myLinkDto = myLinksConverter.convertDomainMyLinks(myLink);
		}
		
		return myLinkDto;
	}

	@Override
	public ResponseUtil saveMyLink(MyLinksDTO myLinkDto) {
		ResponseUtil response = new ResponseUtil();
		
		MyLinks myLink = null;
		
		
		try {
			response = validator.fieldValidations(myLinkDto);
			
			// input validation errors
			if (response.getValidationErrors().size() > 0) {
				response.setFailure(true);
				return response;
			}
			
			myLink = myLinksConverter.convertDTOMyLinks(myLinkDto);
			myLink = myLinksRepository.save(myLink);
		
		} catch(Exception e) {
			log.error("Error in storing my link " + e);
			response.setFailure(true);
			response.setFailureMessage("Error in storing my link ");
			throw new MHVRuntimeException("Error in storing my link ", e);
		}
		
		response.setSuccess(true);
		response.setPojoObject(myLink);
		
		return response;
	}

	@Override
	public ResponseUtil deleteMyLink(Long myLinkId) {
	ResponseUtil response = new ResponseUtil();
		
		try {
			myLinksRepository.delete(myLinkId);
		} catch(Exception e) {
			log.error("Error in storing medication " + e);
			response.setFailure(true);
			response.setFailureMessage("Error in deleting mylink");
			throw new MHVRuntimeException("Error in deleting mylink ", e);
		}
		
		response.setSuccess(true);
		response.setPojoObject(Boolean.TRUE);
		return response;
	}

}
