package gov.va.med.mhv.usermgmt.main.service.impl;

import java.sql.Timestamp;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Calendar;
import java.util.Date;
import java.util.Date;
import java.util.HashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.HashSet;
import java.util.List;
import java.util.List;
import java.util.Map;
import java.util.Map;
import java.util.Set;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTO;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.converter.InPersonAuthenticationConverter;
import gov.va.med.mhv.common.data.model.Facility;
import gov.va.med.mhv.common.data.model.FacilityInfo;
import gov.va.med.mhv.common.data.model.InPersonAuthentication;
import gov.va.med.mhv.common.data.model.Patient;
import gov.va.med.mhv.common.data.model.PatientRegistryChange;
import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.common.data.model.UserProfileDeactivationReason;
//TODO: Remove Message
import gov.va.med.mhv.mvi.xsd.CS;
import gov.va.med.mhv.mvi.xsd.II;
import gov.va.med.mhv.mvi.xsd.MCCIIN000002UV01Document.MCCIIN000002UV01;
import gov.va.med.mhv.mvi.xsd.MCCIMT000200UV01Acknowledgement;
import gov.va.med.mhv.mvi.xsd.MCCIMT000200UV01AcknowledgementDetail;
import gov.va.med.mhv.mvi.xsd.MCCIMT000300UV01Acknowledgement;
import gov.va.med.mhv.mvi.xsd.PRPAIN201305UV02Document;
import gov.va.med.mhv.mvi.xsd.PRPAIN201305UV02Document.PRPAIN201305UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201306UV02Document.PRPAIN201306UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201306UV02MFMIMT700711UV01Subject1;
import gov.va.med.mhv.mvi.xsd.PRPAIN201310UV02Document.PRPAIN201310UV02;
import gov.va.med.mhv.mvi.xsd.PRPAIN201310UV02MFMIMT700711UV01Subject1;
import gov.va.med.mhv.mvi.xsd.PRPAMT201304UV02Patient;
import gov.va.med.mhv.mvi.xsd.PRPAMT201310UV02OtherIDs;
import gov.va.med.mhv.mvi.xsd.PRPAMT201310UV02Patient;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.AuthenticationStatusEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.GenderEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.PatientCorrelationStatusEnumeration;
import gov.va.med.mhv.usermgmt.data.model.MviAuthComm;
import gov.va.med.mhv.usermgmt.data.repository.FacilityInfoRepository;
import gov.va.med.mhv.usermgmt.data.repository.UserProfileRepository;
import gov.va.med.mhv.usermgmt.main.service.validator.UserProfileValidator;
import gov.va.med.mhv.usermgmt.service.ActivityService;
import gov.va.med.mhv.usermgmt.service.EmployeeSearchService;
import gov.va.med.mhv.usermgmt.service.FacilityInfoService;
import gov.va.med.mhv.usermgmt.service.InPersonAuthenticationService;
import gov.va.med.mhv.usermgmt.service.MviAuthCommService;
import gov.va.med.mhv.usermgmt.service.MviIntegrationService;
import gov.va.med.mhv.usermgmt.service.PatientService;
import gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser;
import gov.va.med.mhv.usermgmt.service.handler.MviInvocationUtilHandler;
import gov.va.med.mhv.usermgmt.service.handler.MviProperties;
import gov.va.med.mhv.usermgmt.util.MessagesUtil;
import gov.va.med.mhv.usermgmt.util.UserProfileDeactivationUtils;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVIAuthenticationRequest;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVICorrelationRequest;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVIGetCorrespondingRequest;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVIPatientSearchRequest;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVISearchByEdipiRequest;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVISearchByICNRequest;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVISearchReqUSAA;
import gov.va.med.mhv.usermgmt.util.mvi.CreateMVIUnCorrelationRequest;
import gov.va.med.mhv.usermgmt.util.mvi.MviConstants;
import gov.va.med.mhv.usermgmt.util.mvi.MviRequestTypeEnum;
import gov.va.med.mhv.usermgmt.util.mvi.MviResponseTypeEnum;
import gov.va.med.mhv.usermgmt.util.mvi.MviUtil;

/**
 * Service implementation class for the MviIntegration service
 *
 * @see gov.va.med.mhv.usermgmt.service.MviIntegrationService
 */
@Component
public class MviIntegrationServiceImpl implements MviIntegrationService {

	private static final Logger log = LogManager.getLogger(MviIntegrationServiceImpl.class);

	private static final String MVI_AUTH_ACTION = "MVI AUTH";
	private static final String MVI_UNAUTH_ACTION = "MVI UNAUTH";
	private static final String SUCCESS_RESULT = "SUCCESS";
	private static final String COMMUNICATION_ERROR_RESULT = "COMMUNICATION ERROR";
	private static final String AE_ERROR_RESULT = "AE ERROR";
	private static final String AL_ERROR_RESULT = "AL ERROR";

	// public static final String
	// wsdlURL="http://DNS   dev203f.vha.med.DNS   :8110/psim_webservice/IdMWebService?WSDL";
	public String wsdlURL = null;
	// public static final String
	// wsdlURL="http://DNS   .commserv.healthevet.DNS   :7930/psim_webservice/PSIMWebService?WSDL";
	// public static final String namespace ="http://DNS  oed.oit.DNS   ";
	// public static final String serviceName="VAIdM";
	// public static final String portName="VAIdMPort";

	@Autowired
	private MviInvocationUtilHandler mviInvokeHandler;

	@Autowired
	private CreateMVIUnCorrelationRequest createMVIUnCorrelationRequest;

	@Autowired
	private CreateMVIPatientSearchRequest createMVIPatientSearchRequest;

	@Autowired
	private CreateMVIGetCorrespondingRequest createMVIGetCorrespondingRequest;

	@Autowired
	private CreateMVICorrelationRequest createMVICorrelationRequest;

	@Autowired
	private CreateMVIAuthenticationRequest createMVIAuthenticationRequest;

	@Autowired
	private CreateMVISearchByICNRequest createMVISearchByICNRequest;

	@Autowired
	private CreateMVISearchByEdipiRequest createMVISearchByEdipiRequest;

	@Autowired
	private UserProfileRepository userProfileRepository;

	@Autowired
	private ActivityService activityService;

	@Autowired
	private MviProperties mviProperties;

	@Autowired
	private MessagesUtil messagesUtil;

	@Autowired
	private CreateMVISearchReqUSAA createMVISearchReqUSAA;

	@Autowired
	private MviAuthCommService mviAuthCommService;

	@Autowired
	private UserProfileValidator userProfileValidator;

	@Autowired
	private PatientService patientService;

	@Autowired
	private InPersonAuthenticationService ipaService;

	@Autowired
	private FacilityInfoService facilityInfoService;

	private EmployeeSearchService employeeSearchService;

	@Autowired
	private UserProfileDeactivationUtils userProfileDeactivationUtils;

	@Autowired
	private FacilityInfoRepository facilityInfoRepository;

	@Autowired
	private InPersonAuthenticationConverter inPersonAuthenticationConverter;
	/**
	 * Execute the SearchPersonInMVI service
	 *
	 * @throws Exception
	 * @see gov.va.med.mhv.usermgmt.service.MviIntegrationService#SearchPersonInMVI()
	 */
	// public PatientServiceResponse searchPersonInMVI(String firstName, String lastName, String middleName, String gender, Date birthDate, String ssn, Boolean
	// isPatient, Boolean isVeteran) {
	@Transactional
	public void searchPersonInMVI(UserProfile userProfile, Boolean atRegistration, ResponseUtil response, String versionInfo) {
		if (log.isDebugEnabled()) {
			log.info("********************************MviIntegrationServiceImpl.searchPersonInMVIByICN");		
		}
		Patient patient = new Patient();
		boolean flag = false;
		PRPAIN201306UV02 searchRes = null;
		// Service business logic here
		long startTime = System.currentTimeMillis();

		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
		if(versionInfo == null) {
			versionInfo = "dataEntererId=" + userProfile.getId() + MviUtil.VERSION_INFO_EXTENSION + ",family=" + MviUtil.VERSION_INFO_JOB_SEARCH_TRAITS;
		}

		Object searchReqXML = createMVIPatientSearchRequest.createPatientSearchXMLRequest(userProfile, mviProperties, versionInfo);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), searchReqXML);

		if (log.isDebugEnabled()) {
			log.debug("MVI responseXMLString : " + responseXMLString);
		}

		if (responseXMLString == null || (null!= responseXMLString && responseXMLString.equalsIgnoreCase("ERROR")) ) {
			log.error("Error in the MVI responseXMLString " + responseXMLString);
			/*addInfo(response, "mvi.parse.response.issue", new String[] {
				mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(), mviProperties.getContactMhvUrl()
			});*/
			//response.setFailure(true);
			//assign null to patient
			response.setPojoObject(null);
			response.setFailureMessage(String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getAdvancedUrl(),
					mviProperties.getTargetWindow(), mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
			response.getInfoMessages().put(messagesUtil.getMviParseResponseIssue(),
				String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getAdvancedUrl(),
					mviProperties.getTargetWindow(), mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
			return;
		}
		MVIMessageParser messageParser = new MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), (String) searchReqXML, responseXMLString);
		long endTime = System.currentTimeMillis();
		if (log.isDebugEnabled()) {
			log.debug("searchObj : " + searchObj);
			log.debug("Time taken to execute Search Call: " + (endTime - startTime));
		}

		if (searchObj != null) {
			searchRes = (PRPAIN201306UV02) searchObj;
		}

		if (searchRes == null) {
			log.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
			//response.setFailure(true);
			response.setFailureMessage(String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getAdvancedUrl(),
				mviProperties.getTargetWindow(), mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
			response.getInfoMessages().put(messagesUtil.getMviParseResponseIssue(),
				String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getAdvancedUrl(),
					mviProperties.getTargetWindow(), mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
			return;
		}

		if (log.isDebugEnabled()) {
			log.debug("searchRes----------------- : \n" + searchRes);
		}

		String icnFromResponse = null;
		CS queryResponseCode = searchRes.getControlActProcess().getQueryAck().getQueryResponseCode();

		if (log.isDebugEnabled()) {
			log.debug("queryResponseCode " + queryResponseCode);
		}

		PRPAIN201305UV02 searchXmlObj = null;
		// MVI response is good
		if (queryResponseCode.getCode().equals(MviResponseTypeEnum.GOOD_RESPONSE.getResType())) {
			try {
				PRPAIN201305UV02Document searchXmlObjRoot = PRPAIN201305UV02Document.Factory.parse((String) searchReqXML);
				searchXmlObj = searchXmlObjRoot.getPRPAIN201305UV02();

				if (log.isDebugEnabled()) {
					log.debug("searchXmlObj " + searchXmlObj);
				}
			} catch (Exception ex) {
				log.error("Error in parsing searchReqXML : " + searchReqXML, ex);
				response.setFailure(true);
				response.setFailureMessage("Error in parsing searchReqXML : " + searchReqXML + ex.getMessage());
				return;
			}

			icnFromResponse = getICNfromSearchResult(searchXmlObj, searchRes);
			if (log.isDebugEnabled()) {
				log.debug("icnFromResponse : " + icnFromResponse);
			}

			if (icnFromResponse == null) {
				log.error("ICNFromResponse is null");
				//response.setFailure(true);
				response.setFailureMessage(String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getAdvancedUrl(),
					mviProperties.getTargetWindow(), mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
				response.getInfoMessages().put(messagesUtil.getMviParseResponseIssue(),
					String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getAdvancedUrl(),
						mviProperties.getTargetWindow(), mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
				return;
			} else {
				// JAZZ Task#20972 - Check SSN from 1306 MVI response message and display error if SSN is different from MHV Patient
				String ssnFromMviResponse = null;
				ssnFromMviResponse = getSSNfromSearchResult(searchXmlObj, searchRes);
				String numberOnlySsn = StringUtils.replace(userProfile.getSsn(), "-", "");
				if (log.isDebugEnabled()) {
					log.debug("ssnFromMviResponse : " + ssnFromMviResponse);
					log.debug("numberOnlySsn : " + numberOnlySsn);
				}

				if (ssnFromMviResponse == null || !(numberOnlySsn.equals(ssnFromMviResponse))) {
					if (atRegistration) {
						//response.setFailure(true);
						response.setFailureMessage(String.format(messagesUtil.getMviPatientNotFound(),
							mviProperties.getBasicUrl(), mviProperties.getTargetWindow(),
							mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(),
							mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
						response.getInfoMessages().put(messagesUtil.getMviPatientNotFound(),
							String.format(messagesUtil.getMviPatientNotFound(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(),
								mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(),
								mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
						return;
					} else {
						//response.setFailure(true);
						response.setFailureMessage(String.format(messagesUtil.getMviUpdateAdvancedFailureResponse(),
							mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(),
							mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
						response.getInfoMessages().put(
							messagesUtil.getMviUpdateAdvancedFailureResponse(),
							String.format(messagesUtil.getMviUpdateAdvancedFailureResponse(),
								mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(),
								mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
						return;
					}
				}

				patientService.getPatientByIcn(icnFromResponse, response);
				//List<Patient> patients = (response.getPojoObject() == null) ? null : (List<Patient>) response.getPojoObject();
				if ( response.getPojoObject() != null &&  ((Patient)response.getPojoObject()).getId() != null) {
				// Patient Exists with the SAME ICN.. GET OUT!!
				//if (null != patients && patients.size() > 0 && (null != ((Patient) patients.get(0)).getIcn())) {
					if (log.isDebugEnabled()){
							log.debug("Patient ICN " + ((Patient)response.getPojoObject()).getIcn());
					}
					response.setFailure(true);
					response.setFailureMessage(String.format(messagesUtil.getMviAdvancedAccountExist(),
						mviProperties.getForgotUserIdUrl(), mviProperties.getTargetWindow(),
						mviProperties.getForgotPasswordUrl(), mviProperties.getTargetWindow(),
						mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
					response.getInfoMessages().put(messagesUtil.getMviAdvancedAccountExist(),
						String.format(messagesUtil.getMviAdvancedAccountExist(),
							mviProperties.getForgotUserIdUrl(), mviProperties.getTargetWindow(),
							mviProperties.getForgotPasswordUrl(), mviProperties.getTargetWindow(),
							mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
					return;
				}

				// Got ICN and now adding happy message and facilities if he is a patient
				patient.setIcn(icnFromResponse);

				// Merge Starts Here
				if (searchRes.getControlActProcess().getSubjectArray() != null) {
					PRPAIN201306UV02MFMIMT700711UV01Subject1[] subjectSearchArray = searchRes.getControlActProcess().getSubjectArray();
					if (subjectSearchArray[0].getRegistrationEvent() != null) {
						PRPAMT201310UV02Patient searchResultPatient = subjectSearchArray[0].getRegistrationEvent().getSubject1().getPatient();
						if (log.isDebugEnabled()) {
							log.debug("searchResultPatient " + searchResultPatient);
						}

						II[] searchPatientIdArray = searchResultPatient.getIdArray();
						if (log.isDebugEnabled()) {
							log.debug("searchPatientIdArray " + searchPatientIdArray);
						}

						patient = addFacilitiesForPatient(searchPatientIdArray, patient, userProfile, response);
					}
				}

				if (response.isFailure()) {
					response.setPojoObject(null);
					response.setFailure(true);
					return;
				} else {
					response.setPojoObject(patient);
					response.setFailure(false);
					response.getInfoMessages().put(messagesUtil.getMviAdvancedSuccessResponse(),
						String.format(messagesUtil.getMviAdvancedSuccessResponse(),
							mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow()));
				}
			}
		} else {
			patient = null;
			if (log.isDebugEnabled()) {
				log.debug("queryResponseCode.getCode() " + queryResponseCode.getCode());
			}

			if(queryResponseCode.getCode().equals(MviResponseTypeEnum.QUERY_ERROR.getResType())){
				response.setFailureMessage(String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(),
					mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(),
					mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
				response.getInfoMessages().put(messagesUtil.getMviParseResponseIssue(),
					String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(),
						mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(),
						mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
				log.error("Max Results Exceeded in MVI: " + queryResponseCode.getCode());
			} else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.APPLICATION_ERROR.getResType())){
				if(atRegistration) {
					response.setFailureMessage(String.format(messagesUtil.getMviParseResponseAeIssueReg(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow()));
					response.getInfoMessages().put(messagesUtil.getMviParseResponseAeIssueReg(),
						String.format(messagesUtil.getMviParseResponseAeIssueReg(),
							mviProperties.getBasicUrl(), mviProperties.getTargetWindow()));
				} else {
					response.setFailureMessage(String.format(messagesUtil.getMviParseResponseAeIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow()));
					response.getInfoMessages().put(messagesUtil.getMviParseResponseAeIssue(),
						String.format(messagesUtil.getMviParseResponseAeIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow()));
				}
				log.error("Application Error in MVI: " + queryResponseCode.getCode());
			} else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.NOT_FOUND.getResType())){
				response.setFailureMessage(String.format(messagesUtil.getMviPatientNotFound(),
					mviProperties.getBasicUrl(), mviProperties.getTargetWindow(),
					mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(),
					mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
				response.getInfoMessages().put(messagesUtil.getMviPatientNotFound(),
					String.format(messagesUtil.getMviPatientNotFound(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(),
						mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(),
						mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
				log.error("User not found in MVI: "+queryResponseCode.getCode());
			}
			//disable below failure message to display resultant message in 'UserRegistrationResult' page
			//response.setFailure(true);
			response.setPojoObject(null);
			return;
		}
		response.setPojoObject(patient);
		return;
	}

	private String getICNfromSearchResult(PRPAIN201305UV02 searchReqXML, PRPAIN201306UV02 searchRes) {

		String mcidUniqValueSent = searchReqXML.getControlActProcess().getQueryByParameter().getQueryId().getExtension();
		String mcidUniqValueRecd = searchRes.getControlActProcess().getQueryAck().getQueryId().getExtension();
		if (mcidUniqValueSent.equals(mcidUniqValueRecd)) {
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = searchRes.getControlActProcess().getSubjectArray();
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
			PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
			II idArray[] = patient.getIdArray();
			for (int i = 0; i < idArray.length; i++) {
				II patientId = idArray[i];
				String searchIdExtension = patientId.getExtension();
				if (searchIdExtension.contains("NI")) {
					String[] idExtn = searchIdExtension.split("\\^");
					String source = idExtn[2];
					String issuer = idExtn[3];
					if (source.equals("200M") && issuer.equals("USVHA")) {
						String patientICN = idExtn[0];
						return patientICN;
					}
				}
			}
		} else {
			log.info("Request MCID did NOT match with Response MCID");
		}
		return null;
	}

	private String getICNfromSearchResultAcctSync(PRPAIN201305UV02 searchReqXML, PRPAIN201306UV02 searchRes) {

		String mcidUniqValueSent = searchReqXML.getControlActProcess().getQueryByParameter().getQueryId().getExtension();
		String mcidUniqValueRecd = searchRes.getControlActProcess().getQueryAck().getQueryId().getExtension();
		if (mcidUniqValueSent.equals(mcidUniqValueRecd)) {
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = searchRes.getControlActProcess().getSubjectArray();
			if(subject1Array.length>0) {
				PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
				PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
				II idArray[] = patient.getIdArray();
				for (int i=0; i< idArray.length; i++) {
					II patientId = idArray[i];
					String searchIdExtension = patientId.getExtension();
					if (searchIdExtension.contains("NI")) {
						String[] idExtn = searchIdExtension.split("\\^");
						String source = idExtn[2];
						String issuer = idExtn[3];
						if(source.equals("200M") && issuer.equals("USVHA")) {
							String patientICN = idExtn[0];
							return patientICN;
						}
					}
				}
			}
		}
		else {
			if(log.isInfoEnabled()){
				log.info("Request MCID did NOT match with Response MCID");
			}
		}
		return null;
	}

	// JAZZ 113572 - Update User Profile in Admin Portal HelpDesk
	// ************************ BEGIN ***************************
	private String getFirstNameFromSearchResult(PRPAIN201305UV02 searchReqXML, PRPAIN201306UV02 searchRes) {
		String mcidUniqValueSent = searchReqXML.getControlActProcess().getQueryByParameter().getQueryId().getExtension();
		String mcidUniqValueRecd = searchRes.getControlActProcess().getQueryAck().getQueryId().getExtension();
		if (mcidUniqValueSent.equals(mcidUniqValueRecd)) {
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = searchRes.getControlActProcess().getSubjectArray();
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
			PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
			if (patient.getPatientPerson().getNameArray()[0].getGivenArray().length > 0) {
				String firstName = patient.getPatientPerson().getNameArray()[0].getGivenArray()[0];
				return firstName;
			}
		} else {
			log.info("Request MCID did NOT match with Response MCID");
		}
		return null;
	}

	private String getMiddleNameFromSearchResult(PRPAIN201305UV02 searchReqXML, PRPAIN201306UV02 searchRes) {
		String mcidUniqValueSent = searchReqXML.getControlActProcess().getQueryByParameter().getQueryId().getExtension();
		String mcidUniqValueRecd = searchRes.getControlActProcess().getQueryAck().getQueryId().getExtension();
		if (mcidUniqValueSent.equals(mcidUniqValueRecd)) {
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = searchRes.getControlActProcess().getSubjectArray();
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
			PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
			if (patient.getPatientPerson().getNameArray()[0].getGivenArray().length > 1) {
				String middleName = patient.getPatientPerson().getNameArray()[0].getGivenArray()[1];
				return middleName;
			}
		} else {
			log.info("Request MCID did NOT match with Response MCID");
		}
		return null;
	}

	private String getLastNameFromSearchResult(PRPAIN201305UV02 searchReqXML, PRPAIN201306UV02 searchRes) {
		String mcidUniqValueSent = searchReqXML.getControlActProcess().getQueryByParameter().getQueryId().getExtension();
		String mcidUniqValueRecd = searchRes.getControlActProcess().getQueryAck().getQueryId().getExtension();
		if (mcidUniqValueSent.equals(mcidUniqValueRecd)) {
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = searchRes.getControlActProcess().getSubjectArray();
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
			PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
			if (patient.getPatientPerson().getNameArray()[0].getFamilyArray().length > 0) {
				String lastName = patient.getPatientPerson().getNameArray()[0].getFamilyArray()[0];
				return lastName;
			}
		} else {

			log.info("Request MCID did NOT match with Response MCID");
		}
		return null;
	}

	private String getGenderFromSearchResult(PRPAIN201305UV02 searchReqXML, PRPAIN201306UV02 searchRes) {
		String mcidUniqValueSent = searchReqXML.getControlActProcess().getQueryByParameter().getQueryId().getExtension();
		String mcidUniqValueRecd = searchRes.getControlActProcess().getQueryAck().getQueryId().getExtension();
		if (mcidUniqValueSent.equals(mcidUniqValueRecd)) {
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = searchRes.getControlActProcess().getSubjectArray();
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
			PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
			String gender = patient.getPatientPerson().getAdministrativeGenderCode().getCode();
			return gender;
		} else {
			log.info("Request MCID did NOT match with Response MCID");
		}
		return null;
	}

	private String getBirthDateFromSearchResult(PRPAIN201305UV02 searchReqXML, PRPAIN201306UV02 searchRes) {
		String mcidUniqValueSent = searchReqXML.getControlActProcess().getQueryByParameter().getQueryId().getExtension();
		String mcidUniqValueRecd = searchRes.getControlActProcess().getQueryAck().getQueryId().getExtension();
		if (mcidUniqValueSent.equals(mcidUniqValueRecd)) {
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = searchRes.getControlActProcess().getSubjectArray();
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
			PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
			String birthDate = patient.getPatientPerson().getBirthTime().getValue();
			return birthDate;
		} else {
			log.info("Request MCID did NOT match with Response MCID");
		}
		return null;
	}

	// JAZZ 113572 - Update User Profile in Admin Portal HelpDesk
	// ************************ END ***************************

	private String getSSNfromSearchResult(PRPAIN201305UV02 searchReqXML, PRPAIN201306UV02 searchRes) {
		String mcidUniqValueSent = searchReqXML.getControlActProcess().getQueryByParameter().getQueryId().getExtension();
		String mcidUniqValueRecd = searchRes.getControlActProcess().getQueryAck().getQueryId().getExtension();
		if (mcidUniqValueSent.equals(mcidUniqValueRecd)) {
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = searchRes.getControlActProcess().getSubjectArray();
			PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
			PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
			PRPAMT201310UV02OtherIDs[] otherIds = patient.getPatientPerson().getAsOtherIDsArray();
			for (int i = 0; i < otherIds.length; i++) {
				PRPAMT201310UV02OtherIDs otherId = otherIds[i];
				// JAZZ Defect # 29216 - MVI correlation issue - User with Alias SSN will not be matched or correlated- Fix:Made sure that the SSN is compared
				// with equals instead of contains
				if (otherId.getClassCode().equals("SSN")) {
					II idArray[] = otherId.getIdArray();
					for (int j = 0; j < idArray.length; i++) {
						II id = idArray[j];
						return id.getExtension();
					}
				}
			}
		} else {
			log.info("Request MCID did NOT match with Response MCID");
		}
		return null;
	}

	// Outdated -
	private String getICNfromSearchResult(PRPAIN201306UV02 searchRes) {
		PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1Array[] = searchRes.getControlActProcess().getSubjectArray();
		PRPAIN201306UV02MFMIMT700711UV01Subject1 subject1 = subject1Array[0];
		PRPAMT201310UV02Patient patient = subject1.getRegistrationEvent().getSubject1().getPatient();
		II idArray[] = patient.getIdArray();
		for (int i = 0; i < idArray.length; i++) {
			II patientId = idArray[i];
			String searchIdExtension = patientId.getExtension();
			if (searchIdExtension.contains("NI")) {
				String[] idExtn = searchIdExtension.split("\\^");
				String source = idExtn[2];
				String issuer = idExtn[3];
				if (source.equals("200M") && issuer.equals("USVHA")) {
					String patientICN = idExtn[0];
					return patientICN;
				}
			}
		}
		return null;
	}

	public void createPatientForFccx(UserProfile userProfile, String fccxIcn, ResponseUtil response) {
		log.debug("createPatientForFccx()", "username", userProfile.getUserName());
		patientService.getPatientByIcn(fccxIcn, response);;
		Patient patient = (Patient) response.getPojoObject();
		patient.setIcn(fccxIcn);
		patient.setCorrelationStatus(PatientCorrelationStatusEnumeration.MVIDATAMATCH.getValue());
		patient.setMatchedDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
		patientService.savePatient(patient);
		patient.setUserProfile(userProfile);
		updateTreatmentFacilitiesForExistingPatients(patient, response);
		patient.setUserProfile(userProfile);
		response.setPojoObject(patient);
		return;
	}

	public String getEdipiFromMVI(Patient patient) {
		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
		String versionInfo = "family="+MviUtil.VERSION_INFO_JOB_GET_IDS;
		Object correspondingReqXML = createMVIGetCorrespondingRequest.createMVIGetCorrespondingRequest(patient.getIcn(), mviProperties, versionInfo);

		String corresResponseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(), correspondingReqXML);
		MVIMessageParser messageParser = new MVIMessageParser();
		PRPAIN201310UV02 searchCorresRes =
			(PRPAIN201310UV02) messageParser.mVIMessageParser(
				MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(), (String) correspondingReqXML, corresResponseXMLString);
		String responseStr = MviUtil.getEdipiSearchResult(searchCorresRes, mviProperties);
		return responseStr;
	}

	/**
	 * Update Treatment facilities for existing users that are in the following categories
	 */
	public void updateTreatmentFacilitiesForExistingPatients(Patient patient, ResponseUtil response) {
		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
		String versionInfo ="family=" + MviUtil.VERSION_INFO_JOB_GET_IDS;
		Object correspondingReqXML = createMVIGetCorrespondingRequest.createMVIGetCorrespondingRequest(patient.getIcn(), mviProperties, versionInfo);

		String corresResponseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(), correspondingReqXML);
		MVIMessageParser messageParser = new MVIMessageParser();
		PRPAIN201310UV02 searchCorresRes =
			(PRPAIN201310UV02) messageParser.mVIMessageParser(
				MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(), (String) correspondingReqXML, corresResponseXMLString);

		if (searchCorresRes != null && searchCorresRes.getControlActProcess().getSubjectArray() != null &&
			searchCorresRes.getControlActProcess().getSubjectArray().length > 0) {
			PRPAIN201310UV02MFMIMT700711UV01Subject1[] subjectArray = searchCorresRes.getControlActProcess().getSubjectArray();
			if (subjectArray[0].getRegistrationEvent() != null) {
				PRPAMT201304UV02Patient corresPatient = subjectArray[0].getRegistrationEvent().getSubject1().getPatient();
				II[] patientIdArray = corresPatient.getIdArray();
				processFacilityChanges(receivedFacilitiesFromMvi(patientIdArray, patient), patient, patient.getUserProfile(), response);
			}
			if (log.isDebugEnabled()) {
				log.debug("DEBUG MESSAGE: updateTreatmentFacilitiesForExistingPatients:searchCorresRes for patient: " + patient.getUserProfile().getUserName());
			}
			// TODO: unable to find mvi.treatment.facilities.rxrefill.success in any property file
			// addInfo(ptResponse, "mvi.treatment.facilities.rxrefill.success", new String[] {patient.getUserProfile().getUserName()});
		} else {
			log.error("ERROR: updateTreatmentFacilitiesForExistingPatients:searchCorresRes for patient: " + patient.getUserProfile().getUserName());
			// TODO: unable to find mvi.treatment.facilities.rxrefill.error in any property file
			// addError(ptResponse, "mvi.treatment.facilities.rxrefill.error", new String[] {patient.getUserProfile().getUserName()});
		}

		patient.setLastFacilitiesUpdateDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));

		// ptResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);

		Patient savedPatient = patientService.savePatientWithFacilities(patient);
		response.setPojoObject(savedPatient);
		return;
	}

	/**
	 * MHV_CodeCR1918 - US12.5 MVI Compliance Implementation - Implementation of the service call for MVI Uncorrelate from IPA page. The reason there are two
	 * separate methods for IPA and Helpdesk is that for IPA, we don't want to display error messages while we do in Helpdesk.
	 */

	public void deletePersonFromCorrelationForIPA(Patient patient, UserProfile userProfile, String adminUserName, ResponseUtil response) {
		MCCIIN000002UV01 searchCorrelRes = null;
		// Service business logic here
		if (patient == null || patient.getIcn() == null) {
			log.error("Not Invoking Correlation Call because Patient object OR ICN is NULL: ");
			if (patient != null)
				log.error("ICN is Empty: " + patient.getIcn());
			response.setFailure(true);
			response.setFailureMessage("Not Invoking Correlation Call because Patient object OR ICN is NULL: ");
			return;
		}

		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
		String versionInfo = null;
		if(adminUserName != null) {
			versionInfo = getVersionInfo(adminUserName);
		} else {
			versionInfo = "dataEntererId=" + userProfile.getId() + MviUtil.VERSION_INFO_EXTENSION + ",family=" + MviUtil.VERSION_INFO_JOB_UNLINK;
		}

		Object correlationReqXML = createMVIUnCorrelationRequest.createUnCorrelationXMLRequest(userProfile, patient, mviProperties, versionInfo);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), correlationReqXML);
		MVIMessageParser messageParser = new MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), (String) correlationReqXML, responseXMLString);

		if (searchObj == null) {
			log.error("UNABLE TO PARSE THE UNCORRELATION RESPONSE FROM MVI For the ICN: " + patient.getIcn());
			// Admin Portal_CodeCR1816 - Make sure that the updated status/dates of correlation are displayed.
			response.setPojoObject(patient);
			// addError(response, "mvi.ipa.correlation.communication.error",new String[]{} );
			response.getInfoMessages().put(messagesUtil.getMviIpaCorrelationCommunicationError(), messagesUtil.getMviIpaCorrelationCommunicationError());
			return;
		} else {
			searchCorrelRes = (MCCIIN000002UV01) searchObj;
			MCCIMT000200UV01Acknowledgement[] acknowledgementArray = searchCorrelRes.getAcknowledgementArray();
			MCCIMT000200UV01Acknowledgement acknowledgement = null;
			// Array should have only 1 ACK
			acknowledgement = acknowledgementArray[0];

			String authenticator = ActivityActorTypeEnumeration.MHV_AUTHENTICATOR.getDescription();
			if (adminUserName != null && adminUserName.equals("SYSTEM")) {
				authenticator = adminUserName;
			}

			if (acknowledgement.getTypeCode().getCode().equals("AA")) {
				MCCIMT000200UV01AcknowledgementDetail[] acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();
				MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail = acknowledgementDetailArray[0];

				// JAZZ:17653 - during uncorrelation, change the correlation status to matched.
				patient.setCorrelationStatus(PatientCorrelationStatusEnumeration.MVIDATAMATCH.getValue());
				// Defect 19541 - We don't need to set MPI Control to be false since we are in correlation status 7 MVI Match
				// userProfile.setIsMPIControlled(false);
				// UserProfileServiceResponse uResponse =
				// gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(userProfile);

				activityService.auditMviEvent(
					userProfile, authenticator, true, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE,
					response);
				log.error("MVIIntegrationServiceImpl.deletePersonFromCorrelationForIPA():Successful Uncorrelation For the ICN: " + patient.getIcn());
			} else {
				patient.setCorrelationStatus(PatientCorrelationStatusEnumeration.PENDINGUNCORRELATION.getValue());
				activityService.auditMviEvent(
					userProfile, authenticator, false, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE,
					response);
				log.error("MVIIntegrationServiceImpl.deletePersonFromCorrelationForIPA():Error In Uncorrelation For the ICN: " + patient.getIcn());
			}
			patient.setCorrelatedDateTime(null);
			patient.setCorrelateRequestDateTime(null);
			patient.setCorrelatedBy(null);
			Patient savedPatient = patientService.savePatient(patient);
			response.setPojoObject(savedPatient);
			return;
		}
	}

	/**
	 * JAZZ#112876 - US#4 Admin Portal Enhancements - Force Deactivation
	 */
	public void forceUncorrelation(Patient patient, UserProfile userProfile, String adminUserName, ResponseUtil response) {
		MCCIIN000002UV01 searchCorrelRes = null;
		// Service business logic here
		if (patient == null || patient.getIcn() == null) {
			log.error("Not Invoking Correlation Call because Patient object OR ICN is NULL: ");
			if (patient != null)
				log.error("ICN is Empty: " + patient.getIcn());
			response.setFailure(true);
			response.setFailureMessage("Not Invoking Correlation Call because Patient object OR ICN is NULL: ");
			return;
		}

		String versionInfo = null;
		if(adminUserName != null) {
			versionInfo = getVersionInfo(adminUserName);
		} else {
			versionInfo = "dataEntererId=" + userProfile.getId() + MviUtil.VERSION_INFO_EXTENSION + ",family=" + MviUtil.VERSION_INFO_JOB_UNLINK;
		}

		Object correlationReqXML = createMVIUnCorrelationRequest.createUnCorrelationXMLRequest(userProfile, patient, mviProperties, versionInfo);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), correlationReqXML);
		MVIMessageParser messageParser = new MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), (String) correlationReqXML, responseXMLString);

		if (searchObj == null) {
			log.error("UNABLE TO PARSE THE UNCORRELATION RESPONSE FROM MVI For the ICN: " + patient.getIcn());
			// Admin Portal_CodeCR1816 - Make sure that the updated status/dates of correlation are displayed.
			response.setPojoObject(patient);
			// addError(response, "mvi.ipa.correlation.communication.error",new String[]{} );
			response.getInfoMessages().put(messagesUtil.getMviIpaCorrelationCommunicationError(), messagesUtil.getMviIpaCorrelationCommunicationError());
			return;
		} else {
			searchCorrelRes = (MCCIIN000002UV01) searchObj;
			MCCIMT000200UV01Acknowledgement[] acknowledgementArray = searchCorrelRes.getAcknowledgementArray();
			MCCIMT000200UV01Acknowledgement acknowledgement = null;
			// Array should have only 1 ACK
			acknowledgement = acknowledgementArray[0];

			String authenticator = ActivityActorTypeEnumeration.HELP_DESK_ADMINISTRATOR.getDescription();
			if (adminUserName != null && adminUserName.equals("SYSTEM")) {
				authenticator = adminUserName;
			}

			String fullName = getPatientFullName(patient);

			if (acknowledgement.getTypeCode().getCode().equals("AA")) {
				activityService.auditMviEvent(
					userProfile, authenticator, true, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE,
					response);
				// JAZZ 18074 - Record Unmatched in AAL table.
				activityService.auditMviEvent(
					userProfile, authenticator, true, ActivityActionTypeEnumeration.REMOVE_UPGRADE_TO_ADVANCED, ActivityTypeEnumeration.ACCOUNT_UPGRADE,
					response);
				log.error("MVIIntegrationServiceImpl.deletePersonFromCorrelationForHelpDesk():Successful Uncorrelation For the ICN: " + patient.getIcn());
			} else {
				activityService.auditMviEvent(
					userProfile, authenticator, false, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE,
					response);
			}

			userProfile.setIsMPIControlled(false);
			// UserProfileServiceResponse uResponse =
			// gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(userProfile);

			try {
				userProfile = userProfileRepository.save(userProfile);
			} catch (Exception e) {
				log.error("Error in storing userProfile details : savePatient() " + userProfile.getUserName(), e);
				response.setFailure(true);
				response.setFailureMessage("Error in storing userProfile details : savePatient() " + userProfile.getUserName());
				activityService.auditMviEvent(
					userProfile, authenticator, false, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE,
					response);
				return;
			}

			/*
			if(userProfile.getMessages().hasErrorMessages()) {
				//addError(response, "mvi.ipa.uncorrelation.error",new String[]{fullName, "Error saving userProfile"} );
				Iterator iterator = userProfile.getMessages().getErrorMessages().iterator();
				while(iterator.hasNext()) {
					StringBuffer str = new StringBuffer("deletePersonFromCorrelationForHelpDesk() failed for user profile id: "+userProfile.getId() + " ERROR:");
					Message message = (Message)iterator.next();
					str.append(message.getKey());
					if (message.getInserts().size() > 0) {
						str.append("; inserts=[").append(message.getInserts()).
						append("]");
					}
					if (message.getProperties().size() > 0) {
						str.append("; properties=[").append(message.getProperties()).
						append("]");
					}
					if(log.isErrorEnabled()) {
						log.error(str);
					}
				}
				activityService.auditMviEvent(userProfile, authenticator,
					false, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE);
				//				if (log.isErrorEnabled()) {
				//					log.error("MVIIntegrationServiceImpl.deletePersonFromCorrelationForHelpDesk():Error In Uncorrelation For the ICN: "+patient.getIcn());
				//				}
				//				return response;
			}*/

			// JAZZ:17620 - during uncorrelation, change the correlation status to uncorrelated and matched date to null.
			patient.setCorrelationStatus(PatientCorrelationStatusEnumeration.UNCORRELATED.getValue());
			patient.setMatchedDateTime(null);
			patient.setCorrelatedDateTime(null);
			patient.setCorrelateRequestDateTime(null);
			patient.setCorrelatedBy(null);
			/*PatientServiceResponse pResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
			patient = pResponse.getPatient();
			response.setPatient(patient);*/
			Patient savedPatient = patientService.savePatient(patient);
			response.setPojoObject(savedPatient);
			return;
		}
	}

	/**
	 * Jazz # 128619 - Admin Portal Enhancement - Remove Correlation in MVI
	 */
	public void removeCorrelationInMVI(Patient patient, UserProfile userProfile, String adminUserName, ResponseUtil response) {
		MCCIIN000002UV01 searchCorrelRes = null;
		// Service business logic here
		if (patient == null || patient.getIcn() == null) {
			log.error("Not Invoking Correlation Call because Patient object OR ICN is NULL: ");
			response.setFailure(true);
			response.setFailureMessage("Not Invoking Correlation Call because Patient object OR ICN is NULL: ");
			return;
		}

		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
		String versionInfo = null;
		if(adminUserName != null) {
			versionInfo = getVersionInfo(adminUserName);
		} else {
			versionInfo = "dataEntererId=" + userProfile.getId() + MviUtil.VERSION_INFO_EXTENSION + ",family=" + MviUtil.VERSION_INFO_JOB_UNLINK;
		}
		Object correlationReqXML = createMVIUnCorrelationRequest.createUnCorrelationXMLRequest(userProfile, patient, mviProperties, versionInfo);

		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), correlationReqXML);
		MVIMessageParser messageParser = new MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), (String) correlationReqXML, responseXMLString);

		if (searchObj == null) {
			log.error("UNABLE TO PARSE THE UNCORRELATION RESPONSE FROM MVI For the ICN: " + patient.getIcn());
			// Admin Portal_CodeCR1816 - Make sure that the updated status/dates of correlation are displayed.
			// addError(response, "mvi.ipa.correlation.communication.error",new String[]{} );
			response.setPojoObject(patient);
			response.getInfoMessages().put(messagesUtil.getMviIpaCorrelationCommunicationError(), messagesUtil.getMviIpaCorrelationCommunicationError());
		} else {
			searchCorrelRes = (MCCIIN000002UV01) searchObj;
			MCCIMT000200UV01Acknowledgement[] acknowledgementArray = searchCorrelRes.getAcknowledgementArray();
			MCCIMT000200UV01Acknowledgement acknowledgement = null;
			// Array should have only 1 ACK
			acknowledgement = acknowledgementArray[0];

			String authenticator = ActivityActorTypeEnumeration.HELP_DESK_ADMINISTRATOR.getDescription();
			if (adminUserName != null && adminUserName.equals("SYSTEM")) {
				authenticator = adminUserName;
			}

			String fullName = getPatientFullNameWithICN(patient);

			if (acknowledgement.getTypeCode().getCode().equals("AA")) {
				MCCIMT000200UV01AcknowledgementDetail[] acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();
				MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail = acknowledgementDetailArray[0];

				// //JAZZ:17620 - during uncorrelation, change the correlation status to uncorrelated and matched date to null.
				// patient.setCorrelatedDateTime(null);
				// userProfile.setIsMPIControlled(false);
				// UserProfileServiceResponse uResponse =
				// gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(userProfile);
				//
				// userProfile = uResponse.getUserProfile();
				//
				// if(userProfile.getMessages().hasErrorMessages()) {
				// addError(response, "mvi.ipa.uncorrelation.error",new String[]{fullName, "Error saving userProfile"} );
				// Iterator iterator = userProfile.getMessages().getErrorMessages().iterator();
				// while(iterator.hasNext()) {
				// StringBuffer str = new StringBuffer("deletePersonFromCorrelationForHelpDesk() failed for user profile id: "+userProfile.getId() + " ERROR:");
				// Message message = (Message)iterator.next();
				// str.append(message.getKey());
				// if (message.getInserts().size() > 0) {
				// str.append("; inserts=[").append(message.getInserts()).
				// append("]");
				// }
				// if (message.getProperties().size() > 0) {
				// str.append("; properties=[").append(message.getProperties()).
				// append("]");
				// }
				// if(log.isErrorEnabled()) {
				// log.error(str);
				// }
				// }
				// activityService.auditMviEvent(userProfile, authenticator,
				// false, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE);
				// if (log.isErrorEnabled()) {
				// log.error("MVIIntegrationServiceImpl.deletePersonFromCorrelationForHelpDesk():Error In Uncorrelation For the ICN: "+patient.getIcn());
				// }
				// return response;
				// }
				//
				// //JAZZ:17620 - during uncorrelation, change the correlation status to uncorrelated and matched date to null.
				// patient.setCorrelationStatus(PatientCorrelationStatusUtils.UNCORRELATED);
				// patient.setMatchedDateTime(null);
				//
				// //CodeCR2022- Make sure that the save won't roll back.
				// activityService.auditMviEvent(userProfile, authenticator,
				// true, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE);
				// //JAZZ 18074 - Record Unmatched in AAL table.
				// activityService.auditMviEvent(userProfile, authenticator,
				// true, ActivityActionTypeEnumeration.REMOVE_UPGRADE_TO_ADVANCED, ActivityTypeEnumeration.ACCOUNT_UPGRADE);

				response.getInfoMessages().put(
					messagesUtil.getMviHelpdeskCorrelationremovalSuccess(), String.format(messagesUtil.getMviHelpdeskCorrelationremovalSuccess(), fullName));
				log.error("MVIIntegrationServiceImpl.removeCorrelationInMVI():Successful Remove correlation in MVI For the ICN: " + patient.getIcn());
			} else {
				// patient.setCorrelationStatus(PatientCorrelationStatusUtils.FAILED_UNCORRELATION);
				String error = acknowledgement.getTypeCode().getCode();
				error += ": " + acknowledgement.getAcknowledgementDetailArray()[0].getText();
				response.getInfoMessages().put(
					messagesUtil.getMviHelpdeskCorrelationremovalError(), String.format(messagesUtil.getMviHelpdeskCorrelationremovalError(), fullName, error));
				// activityService.auditMviEvent(userProfile, authenticator,
				// false, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE);
				log.error("MVIIntegrationServiceImpl.deletePersonFromCorrelationForHelpDesk():Error In Uncorrelation For the ICN: " + patient.getIcn() +
					"Error:" + error);
			}
			// patient.setCorrelatedDateTime(null);
			// patient.setCorrelateRequestDateTime(null);
			// patient.setCorrelatedBy(null);
			// gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
			response.setFailure(false);
			response.setSuccess(true);
			response.setPojoObject(patient);
		}
	}

	/*
	 * MHV_CodeCR1919 - US12.4.x MVI Compliance Implementation - Implementation of the service call for MVI Uncorrelate from
	 * Helpdesk page. The reason there are two separate methods for IPA and Helpdesk is that for IPA, we don't want to display error messages
	 * while we do in Helpdesk.
	 */
	public void deletePersonFromCorrelationForHelpDesk(Patient patient, UserProfile userProfile, String adminUserName, ResponseUtil response) {

		MCCIIN000002UV01 searchCorrelRes = null;

		// Service business logic here
		if (patient == null || patient.getIcn() == null) {
			log.error("Not Invoking Correlation Call because Patient object OR ICN is NULL: ");
			if (patient != null) {
				log.error("ICN is Empty: " + patient.getIcn());
			}
			response.setFailure(true);
			response.setFailureMessage("Not Invoking Correlation Call because Patient object OR ICN is NULL: ");
			return;
		}

		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
		String versionInfo = null;
		if(adminUserName != null) {
			versionInfo = getVersionInfo(adminUserName);
		} else {
			versionInfo = "dataEntererId=" + userProfile.getId() + MviUtil.VERSION_INFO_EXTENSION + ",family=" + MviUtil.VERSION_INFO_JOB_UNLINK;
		}
		String correlationReqXML = createMVIUnCorrelationRequest.createUnCorrelationXMLRequest(userProfile, patient, mviProperties, versionInfo);

		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), correlationReqXML);
		MVIMessageParser messageParser = new MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), (String) correlationReqXML, responseXMLString);

		if (searchObj == null) {
			log.error("UNABLE TO PARSE THE UNCORRELATION RESPONSE FROM MVI For the ICN: " + patient.getIcn());
			// Admin Portal_CodeCR1816 - Make sure that the updated status/dates
			// of correlation are displayed.
			response.setPojoObject(patient);
			response.setFailure(true);
			response.setFailureMessage(messagesUtil.getMviIpaCorrelationCommunicationError());
		} else {
			searchCorrelRes = (MCCIIN000002UV01) searchObj;
			MCCIMT000200UV01Acknowledgement[] acknowledgementArray = searchCorrelRes.getAcknowledgementArray();
			MCCIMT000200UV01Acknowledgement acknowledgement = null;
			// Array should have only 1 ACK
			acknowledgement = acknowledgementArray[0];

			String authenticator = ActivityActorTypeEnumeration.HELP_DESK_ADMINISTRATOR.getDescription();
			if (adminUserName != null && adminUserName.equals("SYSTEM")) {
				authenticator = adminUserName;
			}

			String fullName = getPatientFullName(patient);

			if (acknowledgement.getTypeCode().getCode().equals("AA")) {
				MCCIMT000200UV01AcknowledgementDetail[] acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();
				MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail = acknowledgementDetailArray[0];

				// JAZZ:17620 - during uncorrelation, change the correlation
				// status to uncorrelated and matched date to null.
				patient.setCorrelatedDateTime(null);
				userProfile.setIsMPIControlled(false);
				// UserProfileServiceResponse uResponse =
				// gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(userProfile);
				// userProfile = uResponse.getUserProfile();
				try {
					userProfile = userProfileRepository.save(userProfile);
				} catch (Exception e) {
					// if (userProfile.getMessages().hasErrorMessages()) {
					log.error("Error in storing userProfile in deletePersonFromCorrelationForHelpDesk() ", e);
					response.setFailure(true);
					response.setFailureMessage(String.format(messagesUtil.getMviIpaUncorrelationError(), fullName, "Error saving userProfile"));

					/*
					Iterator iterator = userProfile.getMessages().getErrorMessages().iterator();
					while (iterator.hasNext()) {
						StringBuffer str =
							new StringBuffer("deletePersonFromCorrelationForHelpDesk() failed for user profile id: " + userProfile.getId() + " ERROR:");
						Message message = (Message) iterator.next();
						str.append(message.getKey());
						if (message.getInserts().size() > 0) {
							str.append("; inserts=[").append(message.getInserts()).append("]");
						}
						if (message.getProperties().size() > 0) {
							str.append("; properties=[").append(message.getProperties()).append("]");
						}
						if (log.isErrorEnabled()) {
							log.error(str);
						}
					}*/

					activityService.auditMviEvent(
						userProfile, authenticator, false, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD,
						ActivityTypeEnumeration.ACCOUNT_UPGRADE, response);

					log.error("MVIIntegrationServiceImpl.deletePersonFromCorrelationForHelpDesk() : Error in Uncorrelation for the ICN: " + patient.getIcn());

					return;
				}

				// JAZZ:17620 - during uncorrelation, change the correlation
				// status to uncorrelated and matched date to null.
				patient.setCorrelationStatus(PatientCorrelationStatusEnumeration.UNCORRELATED.getValue());
				patient.setMatchedDateTime(null);

				// CodeCR2022- Make sure that the save won't roll back.
				response.setSuccessMessage(String.format(messagesUtil.getMviIpaUncorrelationSuccess(), fullName));

				activityService.auditMviEvent(
					userProfile, authenticator, true, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE,
					response);
				// JAZZ 18074 - Record Unmatched in AAL table.
				activityService.auditMviEvent(
					userProfile, authenticator, true, ActivityActionTypeEnumeration.REMOVE_UPGRADE_TO_ADVANCED, ActivityTypeEnumeration.ACCOUNT_UPGRADE,
					response);
				if (log.isInfoEnabled()) {
					log.info("MVIIntegrationServiceImpl.deletePersonFromCorrelationForHelpDesk():Successful Uncorrelation For the ICN: " + patient.getIcn());
				}
			} else {
				patient.setCorrelationStatus(PatientCorrelationStatusEnumeration.FAILEDCORRELATION.getValue());
				String error = acknowledgement.getTypeCode().getCode();
				error += ": " + acknowledgement.getAcknowledgementDetailArray()[0].getText();
				response.setFailure(true);
				response.setFailureMessage(String.format(messagesUtil.getMviIpaUncorrelationError(), fullName, error));

				activityService.auditMviEvent(
					userProfile, authenticator, false, ActivityActionTypeEnumeration.REMOVE_CONNECTION_TO_VA_RECORD, ActivityTypeEnumeration.ACCOUNT_UPGRADE,
					response);
				log.error("MVIIntegrationServiceImpl.deletePersonFromCorrelationForHelpDesk():Error In Uncorrelation For the ICN: " + patient.getIcn() +
					"Error:" + error);
			}
			patient.setCorrelatedDateTime(null);
			patient.setCorrelateRequestDateTime(null);
			patient.setCorrelatedBy(null);
			// gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
			Patient savedPatient = patientService.savePatient(patient);
			response.setPojoObject(savedPatient);
		}

		return;
	}

	//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
	public String getVersionInfo(String adminUserName) {
		ResponseUtil response = new ResponseUtil();

		if(adminUserName == null || adminUserName.length()==0||adminUserName.equalsIgnoreCase("System")) {
			return null;
		}

		employeeSearchService.searchByUserName(adminUserName, false, response);

		String versionInfo = null;
//		EmployeeSearchResult empRes = (EmployeeSearchResult)response.getPojoObject();
//		if(employeeSearchService.searchByUserName(adminUserName, false, response)) {
//			versionInfo = "dataEntererId=" + empRes.getUserName() + ",given=" +
//				empRes.getFirstName() + ",family=" + empRes.getLastName();
//			return versionInfo;
//		}

		return null;
	}

	/*
	 * (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.service.MviIntegrationService#addPersonForCorrelationForIPA(gov.va.med.mhv.usermgmt.transfer.Patient, gov.va.med.mhv.usermgmt.transfer.UserProfile, java.lang.String)
	 */
	public void addPersonForCorrelationForIPA(Patient patient, UserProfile userProfile, String adminUserName, ResponseUtil response, String versionInfo) {
		MCCIIN000002UV01 searchCorrelRes = null;
		// Service business logic here
		if (patient == null || patient.getIcn() == null) {
			log.error("Not Invoking Correlation Call because Patient object OR ICN is NULL: ");
			if (patient != null)
				log.error("ICN is Empty: " + patient.getIcn());
			response.setFailure(true);
			response.setFailureMessage("Not Invoking Correlation Call because Patient object OR ICN is NULL: ");
		}
		// patient.setCorrelationStatus(PatientCorrelationStatusUtils.PENDING_CORRELATION);
		patient.setCorrelateRequestDateTime(new Timestamp(System.currentTimeMillis()));
		// CR1514 - Save Correlation Performed By even when the correlation is not successful
		patient.setCorrelatedBy(adminUserName);
		// PatientServiceResponse psr = gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
		Patient savedPatient = patientService.savePatient(patient);
		response.setPojoObject(savedPatient);

		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
		if(versionInfo == null) {
			versionInfo = "dataEntererId=" + userProfile.getId() + MviUtil.VERSION_INFO_EXTENSION + ",family=" + MviUtil.VERSION_INFO_JOB_LINK;
		}

		Object correlationReqXML = createMVICorrelationRequest.createCorrelationXMLRequest(userProfile, patient, mviProperties, versionInfo);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.ADDCORRELATION_TYPE.getReqType(), correlationReqXML);
		MVIMessageParser messageParser = new MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.ADDCORRELATION_TYPE.getReqType(), (String) correlationReqXML, responseXMLString);

		if (searchObj == null) {
			log.error("UNABLE TO PARSE THE CORRELATION RESPONSE FROM MVI For the ICN: " + patient.getIcn());
			// Admin Portal_CodeCR1816 - Make sure that the updated status/dates of correlation are displayed.
			// addError(response, "mvi.ipa.correlation.communication.error",new String[]{} );
			// addError(response, "mvi.ipa.correlation.communication.error",new String[]{mviProperties.getContactMhvUrl()_FROM_ADMIN_PORTAL} );
			response.getInfoMessages().put(messagesUtil.getMviIpaCorrelationCommunicationError(), messagesUtil.getMviIpaCorrelationCommunicationError());
			return;
		} else {
			searchCorrelRes = (MCCIIN000002UV01) searchObj;
			MCCIMT000200UV01Acknowledgement[] acknowledgementArray = searchCorrelRes.getAcknowledgementArray();
			MCCIMT000200UV01Acknowledgement acknowledgement = null;
			// Array should have only 1 ACK
			// for (int i =0; i<=acknowledgementArray.length; i++) {
			acknowledgement = acknowledgementArray[0];
			// }
			if (acknowledgement.getTypeCode().getCode().equals("AA")) {
				MCCIMT000200UV01AcknowledgementDetail[] acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();
				MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail = acknowledgementDetailArray[0];
				patient.setCorrelatedDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
				patient.setCorrelationStatus(PatientCorrelationStatusEnumeration.CORRELATED.getValue());
				/*gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
				response.setPatient(patient);*/

				Patient savedPatient1 = patientService.savePatient(patient);
				response.setPojoObject(savedPatient1);

				String fullName = getPatientFullName(patient);

				response.getInfoMessages().put(messagesUtil.getMviIpaCorrelationSuccess(), String.format(messagesUtil.getMviIpaCorrelationSuccess(), fullName));

				// activityService.auditMviLoginEvent(userProfile.getId(),ActivityActorTypeEnumeration.SYSTEM,true,
				// ActivityActionTypeEnumeration.CONNECTED_TO_VA_RECORD);
				// MHV_CodeCR1856 - Made sure that MHV_AUTHENTICATOR displays instead of SYSTEM
				activityService.auditMviEvent(
					userProfile, ActivityActorTypeEnumeration.MHV_AUTHENTICATOR, true, ActivityActionTypeEnumeration.CONNECTED_TO_VA_RECORD,
					ActivityTypeEnumeration.ACCOUNT_UPGRADE, response);

				ipaService.getIPAPatientById(patient.getId(), response);
				InPersonAuthentication ipa = (InPersonAuthentication) response.getPojoObject();

				if (null != ipa && null != ipa.getStatus() && ipa.getStatus().equalsIgnoreCase(AuthenticationStatusEnumeration.AUTHENTICATED.getDescription())) {
					ipa.setMviAuthenticationStatus("PENDING_AUTH");
					ipa.setStatus(AuthenticationStatusEnumeration.AUTHENTICATED.getDescription());
					// ServiceFactory.createEntityMaintenanceService().save(ipa);
					InPersonAuthentication savedIpa = ipaService.saveIPA(ipa);

					patient.setPatientSynchronizations(null);
					// ServiceFactory.createEntityMaintenanceService().save(patient);
					Patient savedPatient2 = patientService.savePatient(patient);
					response.setPojoObject(savedPatient2);
				}

				updateTreatmentFacilitiesForExistingPatients(savedPatient, response);
			} else {
				// CR1514 - Make sure that Correlation Request Date, Correlation Requested by and Correlation Performed by
				// in the failed situations.
				response.setPojoObject(patient);
				patient.setCorrelationStatus(PatientCorrelationStatusEnumeration.FAILEDCORRELATION.getValue());
				// gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
				Patient savedPatient3 = patientService.savePatient(patient);
				response.setPojoObject(savedPatient3);
				String fullName = getPatientFullName(patient);
				String error = acknowledgement.getTypeCode().getCode();
				error += ": " + acknowledgement.getAcknowledgementDetailArray()[0].getText();
				// addError(response, "mvi.ipa.correlation.error", new String[] {fullName, error});
				response.getInfoMessages().put(messagesUtil.getMviIpaCorrelationError(), String.format(messagesUtil.getMviIpaCorrelationError(), fullName, error));
			}
		}
		return;
	}

	private PatientRegistryChange getChangeRecord(String forProperty, UserProfile userProfile) {
		if (log.isDebugEnabled()) {
			log.debug("found " + forProperty + " change for " + userProfile.getUserName());
		}

		PatientRegistryChange changeRecord = new PatientRegistryChange();
		changeRecord.setRecordedOnDate(new Timestamp(System.currentTimeMillis()));

		return changeRecord;
	}

	private String getPatientFullName(Patient patient) {
		StringBuffer fullName = new StringBuffer(patient.getUserProfile().getFirstName());

		// Admin Portal_CodeCR1789 - Make sure that there is a space in between
		// First and Last Names.
		if (patient.getUserProfile().getMiddleName() != null) {
			fullName.append(" " + patient.getUserProfile().getMiddleName());
		}
		fullName.append(" " + patient.getUserProfile().getLastName());
		return fullName.toString();
	}

	private String getPatientFullNameWithICN(Patient patient) {
		StringBuffer fullName = new StringBuffer(patient.getUserProfile().getFirstName());

		if (patient.getUserProfile().getMiddleName() != null) {
			fullName.append(" " + patient.getUserProfile().getMiddleName());
		}
		fullName.append(" " + patient.getUserProfile().getLastName());

		if (patient.getIcn().indexOf("A") > -1) {
			fullName.append(" with ICN number:" + patient.getInvalidatedIcn());
		} else {
			fullName.append(" with ICN number:" + patient.getIcn());
		}

		return fullName.toString();
	}

	private String getUserFullName(UserProfile userProfile) {
		StringBuffer fullName = new StringBuffer(userProfile.getFirstName());

		// Admin Portal_CodeCR1789 - Make sure that there is a space in between First and Last Names.
		if (null != userProfile.getMiddleName() && userProfile.getMiddleName().length() > 0) {
			fullName.append(" " + userProfile.getMiddleName());
		}
		fullName.append(" " + userProfile.getLastName());
		return fullName.toString();
	}

	// Note: A-Active; D-Deprecated from a Duplicate; M-Deprecated from a Mismatch; U-Deprecated from an Unlink; H-Deprecated from a Local Merge; P-Permanent
	public Patient addFacilitiesForPatient(II[] searchPatientIdArray, Patient patient, UserProfile userProfile, ResponseUtil response) {
		// boolean isReallyAPatient = false;
		List<String> stationNumberArray = new ArrayList<String>();
		Map<String, Facility> facilities = new HashMap<String, Facility>();
		
		for (int i = 0; i < searchPatientIdArray.length; i++) {
			II patientId = searchPatientIdArray[i];
			String searchIdExtension = patientId.getExtension();
			if (searchIdExtension != null && (searchIdExtension.contains("PI") || searchIdExtension.contains("NI") || searchIdExtension.contains("SS"))) {
				String[] idExtn = searchIdExtension.split("\\^");
				if (idExtn.length > 3) {
					String stationNumber = idExtn[2];
					String facilityStatus = idExtn[4];
					
					if (facilityStatus.equalsIgnoreCase("A") || facilityStatus.equalsIgnoreCase("4")) {
						if (!StringUtils.isBlank(stationNumber)) {
							
							stationNumberArray.add(stationNumber);
							if (log.isDebugEnabled()) {
								log.debug("FACILITY ID: " + idExtn[2]);
							}

							Facility facility = new Facility();
							facility.setName(stationNumber);
							facility.setPatient(patient);

							List<FacilityInfo> facilityInfos = this.facilityInfoRepository.queryByStationNumber(facility.getName());
							if(facilityInfos.size() == 1) {
								facility.setFacilityInfo(facilityInfos.get(0));
							}
							else {
								log.error(String.format("Error matching Facility Info object with name: %s.", facility.getName()));
							}	
							
							facilities.put(facility.getName(), facility);
						}
					}
				}
			}
		}
		
		patient.setFacilities(new HashSet<Facility>(facilities.values()));
		
		// isReallyAPatient = checkTreatmentFacilitiesExist(stationNumberArray);
		if (MviUtil.checkTreatmentFacilitiesExist(stationNumberArray)) {
			userProfile.setIsPatient(true);
		} else {
			userProfile.setIsPatient(false);
			userProfile.setIsVeteran(true);
		}

		try {
			userProfile = userProfileRepository.save(userProfile);
		} catch (Exception e) {
			log.error("Error in storing userProfile ", e);
			response.setFailure(true);
			// TODO: Fix links in error message
			/* addError(response, "mvi.parse.response.issue", new String[]{mviProperties.getBasicUrl(), mviProperties.getTargetWindow()} );*/
			response.getInfoMessages().put(
				messagesUtil.getMviParseResponseIssue(), String.format(messagesUtil.getMviParseResponseIssue(),
					mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getAdvancedUrl(),
					mviProperties.getTargetWindow(), mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
			response.setPojoObject(null);
			return null;
		}

		return patient;
	}

	public static Object createStubRequest() {
		// Search Patient
		String reqXML =
			"<?xml version=\"1.0\" encoding=\"UTF-8\"?>"
				+ "<PRPA_IN201305UV02 xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"urn:HL7-org:v3 ../../schema/HL7V3/NE2008/multicacheschemas/PRPA_IN201305UV02.xsd\" xmlns=\"urn:HL7-org:v3\" ITSVersion=\"XML_1.0\">"
				+ "<id root=\"1.2.840.114350.1.13.0.1.7.1.1\" extension=\"MCID-12345\" />" + "<creationTime value=\"20070428150301\" />"
				+ "<interactionId root=\"2.16.840.1.113883.1.6\" extension=\"PRPA_IN201305UV02\" />" + "<processingCode code=\"T\" />"
				+ "<processingModeCode code=\"I\" />" + "<acceptAckCode code=\"AL\" />" + "<receiver typeCode=\"RCV\">"
				+ "<device classCode=\"DEV\" determinerCode=\"INSTANCE\">" + "<id root=\"1.2.840.114350.1.13.999.234\" />"
				+ "<telecom value=\"http://servicelocation/PDQuery\" />" + "</device>" + "</receiver>" + "<sender typeCode=\"SND\">"
				+ "<device classCode=\"DEV\" determinerCode=\"INSTANCE\">" + "<id extension=\"200MH\" root=\"2.16.840.1.113883.4.349\"/>" + "</device>"
				+ "</sender>" + "<controlActProcess classCode=\"CACT\" moodCode=\"EVN\">"
				+ "<code code=\"PRPA_TE201305UV02\" codeSystem=\"2.16.840.1.113883.1.6\" />" + "<queryByParameter>"
				+ "<queryId root=\"1.2.840.114350.1.13.28.1.18.5.999\" extension=\"18204\" />" + "<statusCode code=\"new\" />"
				+ "<initialQuantity value=\"2\" />" +

				"<matchCriterionList>" + "<minimumDegreeMatch>" + "<value xsi:type=\"INT\" value=\"75\" />"
				+ "<semanticsText>Degree of match requested</semanticsText>" + "</minimumDegreeMatch>" + "</matchCriterionList>" + "<parameterList>"
				+ "<livingSubjectAdministrativeGender>" + "<value code=\"M\" />" + "<semanticsText>Gender</semanticsText>"
				+ "</livingSubjectAdministrativeGender>" + "<livingSubjectBirthTime>" + "<value value=\"19780512\" />"
				+ "<semanticsText>Date of Birth</semanticsText>" + "</livingSubjectBirthTime>" + "<livingSubjectId>"
				+ "<value root=\"2.16.840.1.113883.4.1\" extension=\"111-11-1111\" />" + "<semanticsText>SSN</semanticsText>" + "</livingSubjectId>"
				+ "<livingSubjectName>" + "<value use=\"L\">" + "<given>Daniel</given>" + "<given>Castle</given>" + "<prefix>PREFIX</prefix>"
				+ "<suffix>SUFFIX</suffix>" + "<family>Lopez</family>" + "</value>" + "<semanticsText>Legal Name</semanticsText>" + "</livingSubjectName>"
				+ "<patientAddress>" + "<value use=\"PHYS\">" + "<streetAddressLine>123 main st</streetAddressLine>"
				+ "<streetAddressLine>Laurel</streetAddressLine>" + "<streetAddressLine>Street3</streetAddressLine>"
				+ "<streetAddressLine>Street4</streetAddressLine>" + "<city>Miami</city>" + "<state>FL</state>" + "<postalCode>33123</postalCode>"
				+ "<country>USA</country>" + "</value>" + "<semanticsText />" + "</patientAddress>" + "</parameterList>" + "</queryByParameter>"
				+ "</controlActProcess>" + "</PRPA_IN201305UV02>";

		return reqXML;

	}

	// MHV_CodeCRTBD - Fixed the cronjob issue
	public void mviUnauthenticateUncorrelateForBatch(Patient patient, UserProfile userProfile, String adminUserName, ResponseUtil response) {
		String action = MVI_UNAUTH_ACTION;
		// MHV_CodeCR1918 - US12.4.x MVI Compliance Implementation - Set the correlation status to Pending Uncorrelation
		// in case if it fails to call Uncorrelation due to error. Make sure that we check the current correlation status and
		// it is correlated, pending correlation or pending uncorrelation
		// JAZZ: Task#19820 - Remove un-correlation call when user�s account is unauthenticated

		MCCIIN000002UV01 authenticateRes = null;
		if (patient == null || patient.getIcn() == null) {
			log.error("Not Invoking Authentication Call because Patient object OR ICN is NULL: ");
			if (patient != null)
				log.error("ICN is Empty: " + patient.getIcn());
			response.setFailure(true);
			response.setFailureMessage("Not Invoking Authentication Call because Patient object OR ICN is NULL: ");
			return;
		}

		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
		String versionInfo = "dataEntererId=" + userProfile.getId() + MviUtil.VERSION_INFO_EXTENSION + ", given=" +
				userProfile.getFirstName() + ", family=" + userProfile.getLastName();
		Object authenticationReqXML = createMVIAuthenticationRequest.createAuthenticationXMLRequest(userProfile, patient, false, mviProperties, versionInfo);

		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), authenticationReqXML);
		MVIMessageParser messageParser = new MVIMessageParser();
		Object authObj = null;

		try {
			authObj = messageParser.mVIMessageParser(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), (String) authenticationReqXML, responseXMLString);
		} catch (Throwable t) {
			log.error("error passing MviRequestTypeEnum.AUTHENTICATION_TYPE" + t);
		}

		if (authObj == null) {
			log.error("UNABLE TO PARSE THE CORRELATION RESPONSE FROM MVI For the ICN: " + patient.getIcn());

			//addError(response, "mvi.advanced.account.exist", new String[] { mviProperties.getForgotUserIdUrl(), mviProperties.getForgotPasswordUrl(), mviProperties.getContactMhvUrl()});
			response.getInfoMessages().put(messagesUtil.getMviAdvancedAccountExist(),
				String.format(messagesUtil.getMviAdvancedAccountExist(),
					mviProperties.getForgotUserIdUrl(), mviProperties.getTargetWindow(),
					mviProperties.getForgotPasswordUrl(), mviProperties.getTargetWindow(),
					mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));

			saveToCommunicationLog(userProfile.getId(), action, COMMUNICATION_ERROR_RESULT,
				"UNABLE TO PARSE THE AUTHENTICATION RESPONSE FROM MVI For the ICN: " + patient.getIcn(), true, response);
			response.setFailure(true);
		} else {
			authenticateRes = (MCCIIN000002UV01) authObj;
			MCCIMT000200UV01Acknowledgement[] acknowledgementArray = authenticateRes.getAcknowledgementArray();
			MCCIMT000200UV01Acknowledgement acknowledgement = null;
			acknowledgement = acknowledgementArray[0];
			if (acknowledgement.getTypeCode().getCode().equals("AA")) {
				MCCIMT000200UV01AcknowledgementDetail[] acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();
				MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail = acknowledgementDetailArray[0];
				if (log.isDebugEnabled()) {
					log.debug("Success: MviIntegrationServiceImpl.mviAuthenticate():unauthenticating patient with icn:" + patient.getIcn());
				}
				saveToCommunicationLog(userProfile.getId(), action, SUCCESS_RESULT, "", true, response);
				deletePersonFromCorrelationForIPA(patient, userProfile, adminUserName, response);
				if (log.isDebugEnabled()) {
					log.debug("Success: MviIntegrationServiceImpl.deletePersonFromCorrelationForIPA():unauthenticating patient with icn:" + patient.getIcn());
				}
				/*
				if (deletePersonFromCorrelationForIPA(patient, userProfile, adminUserName, response).getMessages().hasErrorMessages()) {
					response.setBoolean(false);
				} else {
					if (log.isDebugEnabled()) {
						log.debug("Success: MviIntegrationServiceImpl.deletePersonFromCorrelationForIPA():unauthenticating patient with icn:" +
							patient.getIcn());
					}
					response.setBoolean(true);
				}*/
			} else {
				log.debug("Failure: MviIntegrationServiceImpl.mviAuthenticate():unauthenticating patient with icn:" + patient.getIcn() +
					" acknowledgement.getTypeCode().getCode():" + acknowledgement.getTypeCode().getCode());

				String detail = "";
				if (acknowledgement.getAcknowledgementDetailArray().length > 0) {
					detail = acknowledgement.getAcknowledgementDetailArray()[0].getText();
				}
				if (acknowledgement.getTypeCode().getCode().equals("AE")) {
					saveToCommunicationLog(userProfile.getId(), action, AE_ERROR_RESULT, detail, true, response);

				} else if (acknowledgement.getTypeCode().getCode().equals("AL"))
					saveToCommunicationLog(userProfile.getId(), action, AL_ERROR_RESULT, detail, true, response);
				response.setSuccess(false);
				response.setFailure(true);
				response.setFailureMessage("Failure: MviIntegrationServiceImpl.mviAuthenticate():unauthenticating patient with icn:" + patient.getIcn() +
					" acknowledgement.getTypeCode().getCode():" + acknowledgement.getTypeCode().getCode());
			}
		}
		return;
	}

	// MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - Adding new method call for MVI
	public void mviAuthenticate(Patient patient, UserProfile userProfile, Boolean authenticate, Boolean batch, ResponseUtil response, String versionInfo) {
		log.debug("**********MviIntegrationServiceImpl.mviAuthenticate() - calling MVI");
		String action = MVI_UNAUTH_ACTION;
		if (authenticate) {
			action = MVI_AUTH_ACTION;
		} else {
			// MHV_CodeCR1918 - US12.4.x MVI Compliance Implementation - Set the correlation status to Pending Uncorrelation
			// in case if it fails to call Uncorrelation due to error. Make sure that we check the current correlation status and
			// it is correlated, pending correlation or pending uncorrelation
			// JAZZ: Task#19820 - Remove un-correlation call when user�s account is unauthenticated
		}

		MCCIIN000002UV01 authenticateRes = null;
		if (patient == null || patient.getIcn() == null) {
				log.error("Not Invoking Authentication Call because Patient object OR ICN is NULL: ");
				if (patient != null)
					log.error("ICN is Empty: " + patient.getIcn());
				response.setFailure(true);
				response.setFailureMessage("Not Invoking Correlation Call because Patient object OR ICN is NULL: ");
				return;
		}

		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
		if(versionInfo == null) {
			versionInfo = "dataEntererId=" + userProfile.getId() + MviUtil.VERSION_INFO_EXTENSION + ",family=" + MviUtil.VERSION_INFO_JOB_SET_ROI;
		}
		Object authenticationReqXML = createMVIAuthenticationRequest.createAuthenticationXMLRequest(
			userProfile, patient, authenticate, mviProperties, versionInfo);

		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), authenticationReqXML);
		MVIMessageParser messageParser = new MVIMessageParser();
		Object authObj = null;

		try {
			authObj = messageParser.mVIMessageParser(MviRequestTypeEnum.AUTHENTICATION_TYPE.getReqType(), (String) authenticationReqXML, responseXMLString);
		} catch (Throwable t) {
				log.error("error passing MviRequestTypeEnum.AUTHENTICATION_TYPE" + t);
		}

		if (authObj == null) {
				log.error("UNABLE TO PARSE THE CORRELATION RESPONSE FROM MVI For the ICN: " + patient.getIcn());
			// TODO - distinguish between parese error and communicator error
			saveToCommunicationLog(
				userProfile.getId(), action, COMMUNICATION_ERROR_RESULT,
				"UNABLE TO PARSE THE AUTHENTICATION RESPONSE FROM MVI For the ICN: " + patient.getIcn(), batch, response);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage("UNABLE TO PARSE THE CORRELATION RESPONSE FROM MVI For the ICN: " + patient.getIcn());
		} else {
			authenticateRes = (MCCIIN000002UV01) authObj;
			MCCIMT000200UV01Acknowledgement[] acknowledgementArray = authenticateRes.getAcknowledgementArray();
			MCCIMT000200UV01Acknowledgement acknowledgement = null;
			acknowledgement = acknowledgementArray[0];
			if (acknowledgement.getTypeCode().getCode().equals("AA")) {
				MCCIMT000200UV01AcknowledgementDetail[] acknowledgementDetailArray = acknowledgement.getAcknowledgementDetailArray();
				MCCIMT000200UV01AcknowledgementDetail acknowledgementDetail = acknowledgementDetailArray[0];
				response.setSuccess(true);
				if (authenticate) {
					if (log.isInfoEnabled()) {
						log.info("Success: MviIntegrationServiceImpl.mviAuthenticate():authenticating patient with icn:" + patient.getIcn());
					}
				} else {
					if (log.isInfoEnabled()) {
						log.info("Success: MviIntegrationServiceImpl.mviAuthenticate():unauthenticating patient with icn:" + patient.getIcn());
					}
				}
				saveToCommunicationLog(userProfile.getId(), action, SUCCESS_RESULT, "", batch, response);
			} else {
				if (authenticate) {
					if (log.isInfoEnabled()) {
						log.info("Failure: MviIntegrationServiceImpl.mviAuthenticate():authenticating patient with icn:" + patient.getIcn() +
							" acknowledgement.getTypeCode().getCode():" + acknowledgement.getTypeCode().getCode());
					}
				} else {
					if (log.isInfoEnabled()) {
						log.info("Failure: MviIntegrationServiceImpl.mviAuthenticate():unauthenticating patient with icn:" + patient.getIcn() +
							" acknowledgement.getTypeCode().getCode():" + acknowledgement.getTypeCode().getCode());
					}
				}
				response.setSuccess(false);
				response.setFailure(true);
				response.setFailureMessage("Failure: MviIntegrationServiceImpl.mviAuthenticate():unauthenticating patient with icn:" + patient.getIcn() +
							" acknowledgement.getTypeCode().getCode():" + acknowledgement.getTypeCode().getCode());

				String detail = "";
				if (acknowledgement.getAcknowledgementDetailArray().length > 0) {
					detail = acknowledgement.getAcknowledgementDetailArray()[0].getText();
				}
				if (acknowledgement.getTypeCode().getCode().equals("AE")) {
					saveToCommunicationLog(userProfile.getId(), action, AE_ERROR_RESULT, detail, batch, response);

				} else if (acknowledgement.getTypeCode().getCode().equals("AL")) {
					saveToCommunicationLog(userProfile.getId(), action, AL_ERROR_RESULT, detail, batch, response);
				}
			}
		}
		log.debug("**********MviIntegrationServiceImpl.mviAuthenticate() - calling MVI: response:"+response.isSuccess());
		return;
	}

	private void saveToCommunicationLog(Long userProfileId, String action, String result, String detail, Boolean batch, ResponseUtil response) {
		MviAuthComm mviAuthComm = new MviAuthComm();
		mviAuthComm.setUserProfileId(userProfileId);
		mviAuthComm.setAction(action);
		mviAuthComm.setResult(result);
		mviAuthComm.setDetail(detail);
		mviAuthComm.setCreatedTime(new Timestamp(System.currentTimeMillis()));
		if (batch) {
			mviAuthComm.setCronTime(new Timestamp(System.currentTimeMillis()));
		}
		// gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(mviAuthComm);

		mviAuthCommService.saveMviAuthComm(mviAuthComm, response);

		if (response.isFailure()) {
			return;
		}
	}

	private boolean duplicateCheck(UserProfile userProfile) {
		String firstName = StringUtils.lowerCase(userProfile.getFirstName());
		String lastName = StringUtils.lowerCase(userProfile.getLastName());

		if (userProfileRepository.getProfileByNameBirthDateSsnExcludeId(
			firstName, lastName, userProfile.getBirthDate(), userProfile.getSsn(), userProfile.getId()).size() > 0) {
			if (log.isDebugEnabled())
				log.debug("MviIntegrationServiceImpl.duplicateCheck(): Duplicate account found for the user: " + userProfile.getUserName());
			return true;
		}
		return false;
	}

	private boolean duplicateCheck(String firstName, String lastName, Date dob, String ssn, Long userProfileId) {
		if (userProfileRepository.getProfileByNameBirthDateSsnExcludeId(firstName, lastName, dob, ssn, userProfileId).size() > 0) {
			if (log.isDebugEnabled())
				log.debug("MviIntegrationServiceImpl.duplicateCheck(): Duplicate account found for the user: " + firstName + " " + lastName);
			return true;
		}
		return false;
	}

	/**
	 * Providing MATCH button in MHV Admin Portal IPA Search Detail page (non-Javadoc)
	 *
	 * @see gov.va.med.mhv.usermgmt.service.MviIntegrationService#matchPersonInIPA(gov.va.med.mhv.common.data.model.UserProfile)
	 */
	public void matchPersonInIPA(UserProfile userProfile, ResponseUtil response, MviProperties mviProperties, String versionInfo) {
		if (userProfile == null || userProfile.getGender() == null || userProfile.getSsn() == null || userProfile.getBirthDate() == null ||
			userProfile.getFirstName() == null || userProfile.getLastName() == null) {
			// addError(response, "mvi.ipa.match.keyattributes.null.error", new String[]{} );
			response.getInfoMessages().put(messagesUtil.getMviIpaMatchKeyattributesNullError(), messagesUtil.getMviIpaMatchKeyattributesNullError());
			response.setPojoObject(null);
			return;
		}

		if (duplicateCheck(userProfile)) {
			// addError(response, "mvi.ipa.match.duplicate.error", new String[]{} );
			// response.setPatient(null);
			response.getInfoMessages().put(messagesUtil.getMviIpaMatchDuplicateError(), messagesUtil.getMviIpaMatchDuplicateError());
			response.setPojoObject(null);
			return;
		}

		// MviProperties mviProp = MviProperties.getInstance();

		PRPAIN201306UV02 searchRes = null;

		Patient patient = null;
		// PatientServiceResponse patResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().getPatientForUser(userProfile);

		patientService.getPatientForUser(userProfile, response);
		if (response.isFailure()) {
			return;
		} else {
			patient = (Patient) response.getPojoObject();
		}

		//Jazz Id: 230989 - adding HL7v3 Version code in MVI Request Header.
		if(versionInfo == null) {
			versionInfo = "dataEntererId=" + userProfile.getId() + MviUtil.VERSION_INFO_EXTENSION + ",family=" + MviUtil.VERSION_INFO_JOB_SEARCH_TRAITS;
		}

		Object searchReqXML = createMVIPatientSearchRequest.createPatientSearchXMLRequest(userProfile, mviProperties, versionInfo);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), searchReqXML);

		if (responseXMLString != null && responseXMLString.equalsIgnoreCase("ERROR")) {
			// addError(response, "mvi.ipa.match.communication.error", new String[]{} );
			response.getInfoMessages().put(messagesUtil.getMviIpaMatchCommunicationError(), messagesUtil.getMviIpaMatchCommunicationError());
			response.setPojoObject(null);
			return;
		}

		MVIMessageParser messageParser = new MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), (String) searchReqXML, responseXMLString);

		MCCIMT000300UV01Acknowledgement acknowledgement = null;

		if (searchObj != null) {
			searchRes = (PRPAIN201306UV02) searchObj;
			MCCIMT000300UV01Acknowledgement[] acknowledgementArray = searchRes.getAcknowledgementArray();
			acknowledgement = acknowledgementArray[0];
		}

		if (searchRes == null) {
			log.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI in MHV Admin portal");
			response.getInfoMessages().put(messagesUtil.getMviIpaMatchCommunicationError(), String.format(messagesUtil.getMviIpaMatchCommunicationError()));
			response.setPojoObject(patient);
			return;
		}

		String ICNFromMviResponse = null;
		CS queryResponseCode = searchRes.getControlActProcess().getQueryAck().getQueryResponseCode();
		String fullName = getUserFullName(userProfile);

		PRPAIN201305UV02 searchXmlObj = null;

		if (queryResponseCode.getCode().equals(MviResponseTypeEnum.GOOD_RESPONSE.getResType())) {
			try {
				PRPAIN201305UV02Document searchXmlObjRoot = PRPAIN201305UV02Document.Factory.parse((String) searchReqXML);
				searchXmlObj = searchXmlObjRoot.getPRPAIN201305UV02();
			} catch (Exception ex) {
				// ex.printStackTrace();
				// addError(response, "unknown.exception");
				// response.setPatient(patient);
				// return response;
				log.error("Unknown Exception ", ex);
				response.setFailure(true);
				response.setFailureMessage(messagesUtil.getUnknownExceptionOccurred());
				response.setPojoObject(patient);
				return;
			}

			// JAZZ Task#20972 - Check SSN from 1306 MVI response message and display error if SSN is different from MHV Patient
			String SSNFromMviResponse = null;
			SSNFromMviResponse = getSSNfromSearchResult(searchXmlObj, searchRes);
			String numberOnlySsn = StringUtils.replace(userProfile.getSsn(), "-", "");
			if (SSNFromMviResponse == null || !(numberOnlySsn.equals(SSNFromMviResponse))) {
				// addError(response, "mvi.ipa.match.notfound.error",new String[]{fullName, ""} );
				// activityService.auditAccountUpgradeEvent(userProfile.getId(), false, ActivityActorTypeEnumeration.MHV_AUTHENTICATOR);
				// response.setPatient(patient);
				// return response;
				response.getInfoMessages().put(messagesUtil.getMviIpaMatchNotfoundError(), String.format(messagesUtil.getMviIpaMatchNotfoundError(), fullName));
				activityService.auditAccountUpgradeEvent(userProfile, false, ActivityActorTypeEnumeration.MHV_AUTHENTICATOR, response);
				response.setPojoObject(patient);
				return;
			}

			ICNFromMviResponse = getICNfromSearchResult(searchXmlObj, searchRes);
			if (ICNFromMviResponse == null) {
				String error = acknowledgement.getTypeCode().getCode();
				error += ": " + acknowledgement.getAcknowledgementDetailArray()[0].getText();
				response.getInfoMessages().put(messagesUtil.getMviIpaMatchError(), String.format(messagesUtil.getMviIpaMatchError(), fullName, error));
				response.setPojoObject(patient);
				return;
			} else {
				boolean isPatientCreated = false;
				if (patient == null) {
					patient = new Patient();
					isPatientCreated = true;
					patient.setUserProfile(userProfile);
				}

				// CR 1980 - Override the existing ICN with the ICN from MVI if there is no other patient with the new ICN.
				if ((patient.getIcn() == null) || !patient.getIcn().equals(ICNFromMviResponse)) {
					//patResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().getPatientByIcn(ICNFromMviResponse);
					patientService.getPatientByIcn(ICNFromMviResponse, response);
					Patient patientByIcn = (Patient) response.getPojoObject();
					if (patientByIcn != null && patientByIcn.getId() != null) {
						//addError(response, "mvi.ipa.match.icn.duplicate.error", new String[] { fullName });
						response.getInfoMessages().put(messagesUtil.getMviIpaMatchIcnDuplicateError(), String.format(messagesUtil.getMviIpaMatchIcnDuplicateError(), fullName));
						response.setPojoObject(patient);
						return;
					} else {
						patient.setIcn(ICNFromMviResponse);
						if (!isPatientCreated) {
							//gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().updatePatientRegistryInformation(patient);
							patientService.updatePatientRegistryInformation(patient, response);
						}
					}
				}

				if (log.isDebugEnabled())
					log.debug("Existing Patients ICN Matched with MVI Response ICN OR Dealing with Existing Veteran");
				if (searchRes.getControlActProcess().getSubjectArray() != null) {
					PRPAIN201306UV02MFMIMT700711UV01Subject1[] subjectSearchArray = searchRes.getControlActProcess().getSubjectArray();
					if (subjectSearchArray[0].getRegistrationEvent() != null) {
						PRPAMT201310UV02Patient searchResultPatient = subjectSearchArray[0].getRegistrationEvent().getSubject1().getPatient();
						II[] searchPatientIdArray = searchResultPatient.getIdArray();
						// Updating the facilities with the newer ones we received from MVI
						if (isPatientCreated) {
							patient = addFacilitiesForPatient(searchPatientIdArray, patient, userProfile, response);
						} else {
							processFacilityChanges(receivedFacilitiesFromMvi(searchPatientIdArray, patient), patient, userProfile, response);
						}

						if (response.isFailure()) {
							return;
						}
					}
				}
				if (ICNFromMviResponse == null) {
					String error = acknowledgement.getTypeCode().getCode();
					error += ": " + acknowledgement.getAcknowledgementDetailArray()[0].getText();
					//addError(response, "mvi.ipa.match.error", new String[] { fullName, error });
					response.getInfoMessages().put(messagesUtil.getMviIpaMatchError(), String.format(messagesUtil.getMviIpaMatchError(), fullName, error));
					response.setPojoObject(patient);
					return;
				}
				patient.setCorrelationStatus(PatientCorrelationStatusEnumeration.MVIDATAMATCH.getValue());
				patient.setMatchedDateTime(new Timestamp(Calendar.getInstance().getTime().getTime()));
				//PatientServiceResponse pResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
				//patient = pResponse.getPatient();

				Patient savedPatient = null;
				savedPatient = patientService.savePatient(patient);
				patient.setUserProfile(userProfile);

				if (null == savedPatient) {
					// addError(response, "mvi.ipa.match.error", new String[] {fullName, "Error saving patient"});
					response.getInfoMessages().put(messagesUtil.getMviIpaMatchError(), String.format(messagesUtil.getMviIpaMatchError(), fullName, "Error saving patient"));
					response.setPojoObject(patient);
					return;
				}

				Set facilitiesList = new HashSet();
				facilitiesList = patient.getFacilities();
				List<String> stationNumberArray = new ArrayList<String>();
				for (Object f : facilitiesList) {
					Facility facility = (Facility) f;
					stationNumberArray.add(facility.getName());
				}
				if (MviUtil.checkTreatmentFacilitiesExist(stationNumberArray))
					userProfile.setIsPatient(true);
				else {
					userProfile.setIsPatient(false);
					userProfile.setIsVeteran(true);
				}
				userProfile.setIsMPIControlled(true);

				//UserProfileServiceResponse uResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(userProfile);
				// userProfile = uResponse.getUserProfile();

				try {
					userProfile = userProfileRepository.save(userProfile);
				} catch(Exception e) {
					response.getInfoMessages().put(messagesUtil.getMviIpaMatchErrorUserprofileSave(), String.format(messagesUtil.getMviIpaMatchErrorUserprofileSave(), fullName, "Error saving User Profile"));
					return;
				}
				/*
				if (userProfile.getMessages().hasErrorMessages()) {
					addError(response, "mvi.ipa.match.error.userprofile.save", new String[] {
						fullName, "Error saving User Profile"
					});
					Iterator iterator = userProfile.getMessages().getErrorMessages().iterator();
					while (iterator.hasNext()) {
						StringBuffer str = new StringBuffer("matchPersonInIPA() failed for user profile id: " + userProfile.getId() + " ERROR:");
						Message message = (Message) iterator.next();
						str.append(message.getKey());
						if (message.getInserts().size() > 0) {
							str.append("; inserts=[").append(message.getInserts()).append("]");
						}
						if (message.getProperties().size() > 0) {
							str.append("; properties=[").append(message.getProperties()).append("]");
						}
						if (log.isErrorEnabled()) {
							log.error(str);
						}
					}

					response.setPatient(patient);
					return response;
				}*/

				response.setPojoObject(patient);
				// MVI Match success message
				// addInfo(response, "mvi.ipa.match.success",new String[]{fullName} );
				addPersonForCorrelationForIPA(patient, userProfile, ActivityActorTypeEnumeration.MHV_AUTHENTICATOR.getDescription(), response, versionInfo);
			}
		} else {
			if (queryResponseCode.getCode().equals(MviResponseTypeEnum.QUERY_ERROR.getResType())) {
				String error = acknowledgement.getTypeCode().getCode();
				error += ": " + acknowledgement.getAcknowledgementDetailArray()[0].getText();
				log.error("Max Results Exceeded in MVI for the MATCH call made from IPA page: " + queryResponseCode.getCode() + " for user: " + fullName);
				//addError(response, "mvi.ipa.match.queryerror.error", new String[] {fullName, error});
				response.getInfoMessages().put(messagesUtil.getMviIpaMatchQueryerrorError(), String.format(messagesUtil.getMviIpaMatchQueryerrorError(), fullName, error));
			} else if (queryResponseCode.getCode().equals(MviResponseTypeEnum.APPLICATION_ERROR.getResType())) {
				String error = acknowledgement.getTypeCode().getCode();
				error += ": " + acknowledgement.getAcknowledgementDetailArray()[0].getText();
				log.error("Application Error in MVI for the MATCH call made from IPA page: " + queryResponseCode.getCode() + " for user: " + fullName);
				//addError(response, "mvi.ipa.match.applicationerror.error", new String[] {fullName, error});
				response.getInfoMessages().put(messagesUtil.getMviIpaMatchApplicationerrorError(), String.format(messagesUtil.getMviIpaMatchApplicationerrorError(), fullName, error));
			} else if (queryResponseCode.getCode().equals(MviResponseTypeEnum.NOT_FOUND.getResType())) {
				String error = acknowledgement.getTypeCode().getCode();
				error += ": " + acknowledgement.getAcknowledgementDetailArray()[0].getText();
				log.error("User not found in MVI for the MATCH call made from IPA page: " + queryResponseCode.getCode() + " for user: " + fullName);
				//addError(response, "mvi.ipa.match.notfound.error", new String[] {fullName});
				response.getInfoMessages().put(messagesUtil.getMviIpaMatchNotfoundError(), String.format(messagesUtil.getMviIpaMatchNotfoundError(), fullName, error));
			}
			response.setPojoObject(patient);
			return;
		}
	}

	/*
	private PatientService getPatientService() {
		return ServiceFactory.createPatientService();
	}

	private InPersonAuthenticationService getIPAService() {
		return ServiceFactory.createInPersonAuthenticationService();
	}*/

	// JAZZ 113572 - Update User Profile in Admin Portal HelpDesk - Deactivate on 4 or more traits update
	public void deactivatePatientForMultiTraitUpdateError(Patient patient, ResponseUtil response) {
		//InPersonAuthentication ipa = ServiceFactory.createInPersonAuthenticationService().getIPAPatientById(patient.getId()).getInPersonAuthentication();

		ipaService.getIPAPatientById(patient.getId(), response);
		InPersonAuthentication ipa = (InPersonAuthentication) response.getPojoObject();

		if (log.isDebugEnabled()) {
			log.debug("PatientIdentityService.deactivatePatientForMultiTraitUpdateError()unauthenticate for user:" + patient.getUserProfile().getId());
		}

		if (ipa != null && ipa.getStatus().equalsIgnoreCase(AuthenticationStatusEnumeration.AUTHENTICATED.getDescription())) {
			InPersonAuthenticationDTO ipaDto = inPersonAuthenticationConverter.convertDomainInpersonAuthentication(ipa);
			// add patient info to IPA
			inPersonAuthenticationConverter.addPatientDto(ipa, ipaDto);

			ipaService.unauthenticate(ipaDto, response);
			//InPersonAuthenticationServiceResponse ipaServiceResponse = getIPAService().unauthenticate(ipa, response);
			InPersonAuthentication unauthenticatedIpa = (InPersonAuthentication) response.getPojoObject();
			if (!unauthenticatedIpa.getStatus().equalsIgnoreCase(AuthenticationStatusEnumeration.UNAUTHENTICATED.getDescription())) {
				activityService.auditMviUnauthenticateRequestEvent(patient.getUserProfile(), ActivityActorTypeEnumeration.SYSTEM, false, response);
			} else {
				activityService.auditMviUnauthenticateRequestEvent(patient.getUserProfile(), ActivityActorTypeEnumeration.SYSTEM, true, response);
			}
		}

		if (patient.getCorrelationStatus() == PatientCorrelationStatusEnumeration.CORRELATED.getValue()) {
			if (log.isDebugEnabled()) {
				log.debug("PatientIdentityService.deactivatePatientForMultiTraitUpdateError()uncorrelate for user:" + patient.getUserProfile().getId());
			}
			deletePersonFromCorrelationForHelpDesk(patient, patient.getUserProfile(), "", response);
			Patient savedPatient = (Patient) response.getPojoObject();
			if (null!= savedPatient && savedPatient.getCorrelationStatus() != PatientCorrelationStatusEnumeration.UNCORRELATED.getValue()) {
				activityService.auditMviCorrelateEvent(patient.getUserProfile(), ActivityActorTypeEnumeration.SYSTEM, false, response);
			} else {
				activityService.auditMviCorrelateEvent(patient.getUserProfile(), ActivityActorTypeEnumeration.SYSTEM, true, response);
			}
		}

		if (log.isDebugEnabled()) {
			log.debug("PatientIdentityService.deactivatePatientForMultiTraitUpdateError()deactivate for user:" + patient.getUserProfile().getId());
		}

		UserProfileDeactivationReason reason =
						userProfileDeactivationUtils.findReason(UserProfileDeactivationUtils.A31_POSSIBLE_ICN_MISMATCH_DO_NOT_REACTIVATE_NAME, response);

		/*PatientServiceResponse response =
			getPatientService().deactivatePatientForMultiTraitUpdateError(
				patient, "", ActivityActorTypeEnumeration.SYSTEM, reason, "A31 possible ICN Mismatch (do not reactivate)");*/
		patientService.deactivatePatientForMultiTraitUpdateError(patient, "", ActivityActorTypeEnumeration.SYSTEM.getDescription(), reason, "A31 possible ICN Mismatch (do not reactivate)", response);

		if (response.isFailure()) {
			activityService.auditAccountDeactivateEvent(patient.getUserProfile(), ActivityActorTypeEnumeration.SYSTEM, false, response);
		} else {
			activityService.auditAccountDeactivateEvent(patient.getUserProfile(), ActivityActorTypeEnumeration.SYSTEM, true, response);
		}

		return;
	}

	//TODO: Fix me - prasad
	public void updateUserProfile(UserProfile userProfile) {/*
		boolean changeMade = false;
		PatientServiceResponse response = new PatientServiceResponse();
		if (userProfile == null || userProfile.getGender() == null || userProfile.getSsn() == null || userProfile.getBirthDate() == null ||
			userProfile.getFirstName() == null || userProfile.getLastName() == null) {
			addError(response, "mvi.ipa.match.keyattributes.null.error", new String[] {});
			response.setPatient(null);
			return response;
		}

		if (duplicateCheck(userProfile)) {
			addError(response, "mvi.ipa.match.duplicate.error", new String[] {});
			response.setPatient(null);
			return response;
		}

		MviProperties mviProp = MviProperties.getInstance();

		PRPAIN201306UV02 searchRes = null;

		Patient patient = null;
		PatientServiceResponse patResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().getPatientForUser(userProfile);
		if (patResponse.getPatient() != null) {
			patient = patResponse.getPatient();
		}

		Object searchReqXML = CreateMVIPatientSearchRequest.createPatientSearchXMLRequest(userProfile);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), searchReqXML);

		if (responseXMLString != null && responseXMLString.equalsIgnoreCase("ERROR")) {
			addError(response, "mvi.ipa.match.communication.error", new String[] {});
			response.setPatient(patient);
			return response;
		}

		MVIMessageParser messageParser = new MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), (String) searchReqXML, responseXMLString);

		MCCIMT000300UV01Acknowledgement acknowledgement = null;

		if (searchObj != null) {
			searchRes = (PRPAIN201306UV02) searchObj;
			MCCIMT000300UV01Acknowledgement[] acknowledgementArray = searchRes.getAcknowledgementArray();
			acknowledgement = acknowledgementArray[0];
		}

		if (searchRes == null) {
			log.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI in MHV Admin portal");
			addInfo(response, "mvi.ipa.match.communication.error", new String[] {
				mviProperties.getAdvancedUrl(), mviProperties.getContactMhvUrl()
			});
			response.setPatient(patient);
			return response;
		}

		CS queryResponseCode = searchRes.getControlActProcess().getQueryAck().getQueryResponseCode();
		String fullName = getUserFullName(userProfile);

		PRPAIN201305UV02 searchXmlObj = null;

		if (queryResponseCode.getCode().equals(MviResponseTypeEnum.GOOD_RESPONSE.getResType())) {
			try {
				PRPAIN201305UV02Document searchXmlObjRoot = PRPAIN201305UV02Document.Factory.parse((String) searchReqXML);
				searchXmlObj = searchXmlObjRoot.getPRPAIN201305UV02();
			} catch (Exception ex) {
				ex.printStackTrace();
				addError(response, "unknown.exception");
				response.setPatient(patient);
				return response;
			}

			// JAZZ Task#20972 - Check SSN from 1306 MVI response message and display error if SSN is different from MHV Patient
			String ICNFromMviResponse = getICNfromSearchResult(searchXmlObj, searchRes);
			String SSNFromMviResponse = null;
			SSNFromMviResponse = getSSNfromSearchResult(searchXmlObj, searchRes);
			String firstNameFromMviResponse = getFirstNameFromSearchResult(searchXmlObj, searchRes);
			String middleNameFromMviResponse = getMiddleNameFromSearchResult(searchXmlObj, searchRes);
			String lastNameFromMviResponse = getLastNameFromSearchResult(searchXmlObj, searchRes);
			String genderFromMviResponse = getGenderFromSearchResult(searchXmlObj, searchRes);
			String birthDateFromMviResponse = getBirthDateFromSearchResult(searchXmlObj, searchRes);

			SimpleDateFormat dateformatYYYYMMDD = new SimpleDateFormat("yyyyMMdd");

			Date bdFromMviResponse = null;
			if (birthDateFromMviResponse != null) {
				try {
					bdFromMviResponse = dateformatYYYYMMDD.parse(birthDateFromMviResponse);
				} catch (Throwable t) {

				}
			}

			int traitUpdateCount = 0;

			if (log.isDebugEnabled()) {
				log.debug("PatientIdentityService.isFourOrMoreTraitsUpdate() for user profile id:" + userProfile.getId());
			}

			// If a trait is not the same, we increment the count. This applies to first name, middle name, last name, ssn, gender and DOB.
			if (!userProfile.getFirstName().equalsIgnoreCase(firstNameFromMviResponse)) {
				if (log.isDebugEnabled()) {
					log.debug("MviIntegrationServiceImpl.updateUserProfile() first name is different for user profile id:" + userProfile.getId());
				}
				traitUpdateCount++;
			}

			// Middle name can be null on both sides so we need to cover all permutations.
			if (userProfile.getMiddleName() == null && middleNameFromMviResponse != null) {
				if (log.isDebugEnabled()) {
					log.debug("MviIntegrationServiceImpl.updateUserProfile() middle name is different for user profile id:" + userProfile.getId());
				}
				traitUpdateCount++;
			} else if (null != userProfile.getMiddleName() && userProfile.getMiddleName().length() > 0 && middleNameFromMviResponse == null) {
				if (log.isDebugEnabled()) {
					log.debug("MviIntegrationServiceImpl.updateUserProfile() middle name is different for user profile id:" + userProfile.getId());
				}
				traitUpdateCount++;
			} else if (userProfile.getMiddleName() == null && middleNameFromMviResponse == null) {
				if (log.isDebugEnabled()) {
					log.debug("MviIntegrationServiceImpl.updateUserProfile() no middle name for user profile id:" + userProfile.getId());
				}
			} else if (!userProfile.getMiddleName().equalsIgnoreCase(middleNameFromMviResponse)) {
				if (log.isDebugEnabled()) {
					log.debug("MviIntegrationServiceImpl.updateUserProfile() middle name is different for user profile id:" + userProfile.getId());
				}
				traitUpdateCount++;
			}

			if (!userProfile.getLastName().equalsIgnoreCase(lastNameFromMviResponse)) {
				if (log.isDebugEnabled()) {
					log.debug("MviIntegrationServiceImpl.updateUserProfile() last name is different for user profile id:" + userProfile.getId());
				}
				traitUpdateCount++;
			}

			String userProfileDOB = null;
			try {
				userProfileDOB = dateformatYYYYMMDD.format(userProfile.getBirthDate());
				if (!userProfileDOB.equals(birthDateFromMviResponse)) {
					if (log.isDebugEnabled()) {
						log.debug("MviIntegrationServiceImpl.updateUserProfile() birth date is different for user profile id:" + userProfile.getId());
					}
					traitUpdateCount++;
				}
			} catch (Exception e) {
				e.printStackTrace();
				addError(response, "unknown.exception");
				response.setPatient(patient);
				return response;
			}

			if (!userProfile.getGender().getName().equalsIgnoreCase(genderFromMviResponse)) {
				if (log.isDebugEnabled()) {
					log.debug("MviIntegrationServiceImpl.updateUserProfile() gender is different for user profile id:" + userProfile.getId());
				}
				traitUpdateCount++;
			}

			String ssn = userProfile.getSsn().replaceAll("-", "");
			if (!ssn.equals(SSNFromMviResponse)) {
				if (log.isDebugEnabled()) {
					log.debug("PatientIdentityService.isFourOrMoreTraitsUpdate() ssn is different for user profile id:" + userProfile.getId());
				}
				traitUpdateCount++;
			}

			if (traitUpdateCount > 3) {
				PatientServiceResponse deactivateResponse = deactivatePatientForMultiTraitUpdateError(patient);
				if (deactivateResponse.getMessages().hasErrorMessages()) {
					deactivateResponse.getMessages().addMessages(deactivateResponse.getMessages());
				} else {
					addInfo(deactivateResponse, "four.or.more.traits.update");
				}

				return deactivateResponse;
			} else if (duplicateCheck(firstNameFromMviResponse, lastNameFromMviResponse, bdFromMviResponse, SSNFromMviResponse, userProfile.getId())) {
				addError(response, "mvi.ipa.match.duplicate.error", new String[] {});
				return response;
			}

			if (!userProfile.getFirstName().equalsIgnoreCase(firstNameFromMviResponse)) {
				userProfile.setFirstName(firstNameFromMviResponse);
				changeMade = true;
			}

			if ((userProfile.getMiddleName() == null && middleNameFromMviResponse != null) ||
				(null != userProfile.getMiddleName() && userProfile.getMiddleName().length() > 0 && !userProfile.getMiddleName().equalsIgnoreCase(middleNameFromMviResponse)) ||
				(null != userProfile.getMiddleName() && userProfile.getMiddleName().length() > 0 && middleNameFromMviResponse == null)) {
				userProfile.setMiddleName(middleNameFromMviResponse);
				changeMade = true;
			}

			if (!userProfile.getLastName().equalsIgnoreCase(lastNameFromMviResponse)) {
				userProfile.setLastName(lastNameFromMviResponse);
				changeMade = true;
			}

			fullName = getUserFullName(userProfile);

			if (!ssn.equalsIgnoreCase(SSNFromMviResponse)) {
				userProfile.setSsn(formatSSN(SSNFromMviResponse));
				changeMade = true;
			}

			if (!userProfile.getGender().getName().startsWith(genderFromMviResponse)) {
				if (genderFromMviResponse.equals("M")) {
					userProfile.setGender(GenderEnumeration.getEnum(GenderEnumeration.MALE));
				} else {
					userProfile.setGender(GenderEnumeration.getEnum(GenderEnumeration.FEMALE));
				}
				changeMade = true;
			}

			try {
				if (!userProfileDOB.startsWith(birthDateFromMviResponse)) {
					userProfile.setBirthDate(dateformatYYYYMMDD.parse(birthDateFromMviResponse));
				}
			} catch (Exception e) {
				e.printStackTrace();
				addError(response, "unknown.exception");
				response.setPatient(patient);
				return response;
			}

			if (patient != null && !patient.getIcn().equals(ICNFromMviResponse)) {
				patient.setIcn(ICNFromMviResponse);
			}
			mviInvokeHandler = new MviInvocationUtilHandler();
			PatientServiceResponse ptResponse = new PatientServiceResponse();
			Object correspondingReqXML = CreateMVIGetCorrespondingRequest.createMVIGetCorrespondingRequest(patient.getIcn());

			String corresResponseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(), correspondingReqXML);
			messageParser = new MVIMessageParser();
			PRPAIN201310UV02 searchCorresRes =
				(PRPAIN201310UV02) messageParser.mVIMessageParser(
					MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(), (String) correspondingReqXML, corresResponseXMLString);

			if (searchCorresRes != null && searchCorresRes.getControlActProcess().getSubjectArray() != null) {
				PRPAIN201310UV02MFMIMT700711UV01Subject1[] subjectArray = searchCorresRes.getControlActProcess().getSubjectArray();
				if (subjectArray[0].getRegistrationEvent() != null) {
					PRPAMT201304UV02Patient corresPatient = subjectArray[0].getRegistrationEvent().getSubject1().getPatient();
					II[] patientIdArray = corresPatient.getIdArray();

					if (processFacilityChanges(receivedFacilitiesFromMvi(patientIdArray), patient, patient.getUserProfile(), ptResponse)) {
						changeMade = true;
					}
				}
				if (log.isDebugEnabled()) {
					log.debug("DEBUG MESSAGE: updateTreatmentFacilitiesForExistingPatients:searchCorresRes for patient: " +
						patient.getUserProfile().getUserName());
				}
				addInfo(ptResponse, "mvi.treatment.facilities.rxrefill.success", new String[] {
					patient.getUserProfile().getUserName()
				});
			} else {
				if (log.isErrorEnabled()) {
					log.error("ERROR: updateTreatmentFacilitiesForExistingPatients:searchCorresRes for patient: " + patient.getUserProfile().getUserName());
				}
				addError(ptResponse, "mvi.treatment.facilities.rxrefill.error", new String[] {
					patient.getUserProfile().getUserName()
				});
			}

			patient.setUserProfile(userProfile);
			PatientServiceResponse pUpdateresponse =
				gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().updatePatientRegistryInformation(patient);
			if (pUpdateresponse.getMessages().hasErrorMessages()) {
				response.getMessages().addMessages(pUpdateresponse.getMessages());
			} else {
				response.setPatient(patient);
			}
		} else {
			if (queryResponseCode.getCode().equals(MviResponseTypeEnum.QUERY_ERROR.getResType())) {
				String error = acknowledgement.getTypeCode().getCode();
				error += ": " + acknowledgement.getAcknowledgementDetailArray()[0].getText();
				addError(response, "mvi.ipa.match.queryerror.error", new String[] {
					fullName, error
				});
				if (log.isErrorEnabled())
					log.error("Max Results Exceeded in MVI for the MATCH call made from IPA page: " + queryResponseCode.getCode() + " for user: " + fullName);
			} else if (queryResponseCode.getCode().equals(MviResponseTypeEnum.APPLICATION_ERROR.getResType())) {
				String error = acknowledgement.getTypeCode().getCode();
				error += ": " + acknowledgement.getAcknowledgementDetailArray()[0].getText();
				addError(response, "mvi.ipa.match.applicationerror.error", new String[] {
					fullName, error
				});
				if (log.isErrorEnabled())
					log.error("Application Error in MVI for the MATCH call made from IPA page: " + queryResponseCode.getCode() + " for user: " + fullName);
			} else if (queryResponseCode.getCode().equals(MviResponseTypeEnum.NOT_FOUND.getResType())) {
				String error = acknowledgement.getTypeCode().getCode();
				error += ": " + acknowledgement.getAcknowledgementDetailArray()[0].getText();
				addError(response, "mvi.helpdesk.update.profile.not.found", new String[] {
					fullName
				});
				if (log.isErrorEnabled())
					log.error("User not found in MVI for the MATCH call made from IPA page: " + queryResponseCode.getCode() + " for user: " + fullName);
			}
			response.setPatient(patient);
			return response;
		}

		if (changeMade) {
			if (!response.getMessages().hasErrorMessages()) {
				addInfo(response, "user.profie.updated", new String[] {
					fullName
				});
			}
		} else {
			addInfo(response, "no.user.profie.update.required");
		}
		return response;
	*/}

	private static String formatSSN(String ssn) {
		StringBuffer ssnBuff = new StringBuffer(ssn);
		ssnBuff.insert(3, '-');
		ssnBuff.insert(6, '-');
		return ssnBuff.toString();
	}

	public Map<String, Facility> receivedFacilitiesFromMvi(II[] searchPatientIdArray, Patient patient) {
		Map<String, Facility> receivedfacilityNames = new HashMap<String, Facility>();
		for (int i = 0; i < searchPatientIdArray.length; i++) {
			II patientId = searchPatientIdArray[i];
			String searchIdExtension = patientId.getExtension();
			if (searchIdExtension.contains("PI") || searchIdExtension.contains("NI") || searchIdExtension.contains("SS")) {
				String[] idExtn = searchIdExtension.split("\\^");
				if (idExtn.length > 3) {
					String stationNumber = idExtn[2];
					String facilityStatus = idExtn[4];
					if (facilityStatus.equalsIgnoreCase("A") || facilityStatus.equalsIgnoreCase("4")) {
						if (!StringUtils.isBlank(stationNumber)) {
							Facility facility = new Facility();
							facility.setName(stationNumber);
							facility.setPatient(patient);
							
							List<FacilityInfo> facilityInfos = this.facilityInfoRepository.queryByStationNumber(facility.getName());
							if(facilityInfos.size() == 1) {
								facility.setFacilityInfo(facilityInfos.get(0));
							}
							else {
								log.error(String.format("Error matching Facility Info object with name: %s.", facility.getName()));
							}	
							receivedfacilityNames.put(stationNumber, facility);
						}
					}
				}
			}
		}
		return receivedfacilityNames;
	}

	private Map<String, Facility> collectStationNumbers(Patient patient) {
		assert patient != null : "Must provide a patient";
		Map<String, Facility> facilityNames = new HashMap<String, Facility>();
		if(patient.getFacilities() !=null) {
			for (Object f : patient.getFacilities()) {
				Facility facility = (Facility) f;
				facilityNames.put(facility.getName(), facility);
			}
		}
		return facilityNames;
	}

	private boolean processFacilityChanges(Map<String, Facility> receivedfacilityNames, Patient existingPatient, UserProfile userProfile, ResponseUtil response) {
		boolean changeMade = false;
		Map<String, Facility> oldFacilities = collectStationNumbers(existingPatient);
		if (!CollectionUtils.isEqualCollection(receivedfacilityNames.keySet(), oldFacilities.keySet())) {
			PatientRegistryChange changeRec = getChangeRecord("Facilities", userProfile);
			if(existingPatient.getFacilities() != null) {
				changeRec.setOldFacilityCount(existingPatient.getFacilities().size());
			}
			existingPatient.addPatientRegistryChange(changeRec);
			Set<Facility> facilities = new HashSet<Facility>();
			for (String stationNumber : receivedfacilityNames.keySet()) {
				Facility facility = oldFacilities.get(stationNumber);
				if (facility == null) {
					if (log.isDebugEnabled()) {
						log.debug("Adding facility in evault from MVI " + stationNumber + "'");
					}
					facility = receivedfacilityNames.get(stationNumber);
					changeMade = true;
				} else {
					if (log.isDebugEnabled()) {
						log.debug("Keeping facility exists in evault'" + stationNumber + "' (" + facility.getId() + ")");
					}
				}

				List existingFacilities = facilityInfoService.queryByStationNumber(stationNumber);
				if (existingFacilities == null || existingFacilities.size() == 0) {
					// addError(response, "facility.not.found", new String[] { stationNumber });
					response.getInfoMessages().put(messagesUtil.getFacilityNotFound(), String.format(messagesUtil.getFacilityNotFound(), stationNumber));
				} else if (existingFacilities.size() > 1) {
					// addError(response, "facility.multiple.found", new String[] {stationNumber});
					response.getInfoMessages().put(
						messagesUtil.getFacilityMultipleFound(), String.format(messagesUtil.getFacilityMultipleFound(), stationNumber));
				}

				facilities.add(facility);
			}
			if (log.isDebugEnabled()) {
				for (String stationNumber : oldFacilities.keySet()) {
					Facility facility = receivedfacilityNames.get(stationNumber);
					if (facility == null) {
						log.debug("Removing facilities from evault with respect to the MVI response '" + stationNumber + "'");
					}
				}
			}
			existingPatient.setFacilities(facilities);

		}
		return changeMade;
	}

	/**
	 * Jazz #110471 RemoteID Proofing - User logs in to Access VA - Design and Analysis
	 **/
	public void searchPersonInMVIByICN(String icn, ResponseUtil response) {
		Patient patient = null;
		UserProfile userProfile = null;
		boolean flag = false;
		PRPAIN201310UV02 searchRes = null;
		// Service business logic here
		long startTime = System.currentTimeMillis();

		String versionInfo = ",family=" + MviUtil.VERSION_INFO_JOB_SEARCH_TRAITS;

		// Object searchReqXML = CreateMVISearchByEdipiRequest.createMVISearchByEdipiRequest(edipiValue);
		Object searchReqXML = createMVISearchByICNRequest.createMVISearchByICNRequest(icn, mviProperties, versionInfo);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.SEARCHBY_EDIPI_TYPE.getReqType(), searchReqXML);
		if (responseXMLString == null || responseXMLString.equalsIgnoreCase("ERROR")) {
			/*addInfo(response, "mvi.parse.response.issue", new String[] {
				mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(), mviProperties.getContactMhvUrl()
			});*/
			response.setFailure(true);
			response.setFailureMessage("MVI_COMM_ISSUE");
			response.getInfoMessages().put(messagesUtil.getMviParseResponseIssue(),
				String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(),
					mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(),
					mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
			// response.setPatient(null);
			// response.setValue(MviConstants.MVI_COMM_ISSUE);
			return;
		}
		MVIMessageParser messageParser = new MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.SEARCHBY_EDIPI_TYPE.getReqType(), (String) searchReqXML, responseXMLString);
		long endTime = System.currentTimeMillis();
		if (log.isDebugEnabled())
			log.debug("Time taken to execute Search Call for DSLogOn: " + (endTime - startTime));
		if (searchObj != null)
			searchRes = (PRPAIN201310UV02) searchObj;
		if (searchRes == null) {
			log.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
			response.setFailure(true);
			response.setFailureMessage("MVI_COMM_ISSUE");
			return;
		}
		// String ICNFromEdipiResponse = null;
		String DFNFromEdipiResponse = null;
		CS queryResponseCode = searchRes.getControlActProcess().getQueryAck().getQueryResponseCode();
		if (queryResponseCode.getCode().equals(MviResponseTypeEnum.GOOD_RESPONSE.getResType())) {
			// ICNFromEdipiResponse = MviUtil.getICNfromEdipiSearchResult(searchRes);
			DFNFromEdipiResponse = MviUtil.getDFNfromEdipiSearchResultIf200MH(searchRes, mviProperties);
			if (DFNFromEdipiResponse == null) {
				// TODO: No DFN returned from MVI for Edipi Search
				if (log.isInfoEnabled())
					log.info("No DFN found in ICNResponse- means no 200MH exists");
				return;
			} else if (DFNFromEdipiResponse.equalsIgnoreCase(MviConstants.MULTIPLE_IDS_ERROR)) {
				// JAZZ Story#39187 - US REQ#2 When MHV system checks to see if the user has one active advanced account known to MVI, in the event
				// multiple accounts are returned from MVI, the system shall display a user-friendly error message in
				// a yellow box at the top of �We Cannot Connect Your Account� page.
				response.setFailure(true);
				response.setFailureMessage(MviConstants.MULTIPLE_IDS_ERROR);
				return;
			} else {
				/*UserProfileServiceResponse userProfileSerRes =
					gov.va.med.mhv.usermgmt.service.ServiceFactory.createUserProfileService().getUserProfileById(Long.parseLong(DFNFromEdipiResponse));
				if (userProfileSerRes != null)
					userProfile = userProfileSerRes.getUserProfile();*/

				userProfile = userProfileRepository.getUserProfileById(Long.parseLong(DFNFromEdipiResponse));
				if (userProfile != null) {
					//PatientServiceResponse patResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().getPatientForUser(userProfile);

					/*if (patResponse.getPatient() != null && patResponse.getPatient().getPatientPK() != null) {
						// DS LogOn Patient Exists with the SAME ICN in MHV
						response.setPatient(patResponse.getPatient());
						return response;
					}*/
					PRPAIN201310UV02 searchCorresRes = (PRPAIN201310UV02) messageParser.mVIMessageParser(MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(),(String)searchReqXML, responseXMLString);

					if(searchCorresRes != null && searchCorresRes.getControlActProcess().getSubjectArray() != null && searchCorresRes.getControlActProcess().getSubjectArray().length > 0) {
						PRPAIN201310UV02MFMIMT700711UV01Subject1[] subjectArray = searchCorresRes.getControlActProcess().getSubjectArray();
						if(subjectArray[0].getRegistrationEvent() != null) {
							PRPAMT201304UV02Patient corresPatient = subjectArray[0].getRegistrationEvent().getSubject1().getPatient();
							II[] patientIdArray = corresPatient.getIdArray();

							log.debug("checking treatingFaciltiesExist", "userProfileId", userProfile.getId()+"");
							if(isReceivedFacilitiesFromMvi(patientIdArray)) {
								response.setSuccessMessage("treatingFaciltiesExist");
							}
						}
					}
					patientService.getPatientForUser(userProfile, response);
					if (response.isFailure()) {
						return;
					} else {
						patient = (Patient) response.getPojoObject();
					}
				} else {
					// TODO: UserProfile NOT FOUND in MHV
					log.error("200MH Found in ICNResponse but DFN Do NOT exist in MHV: " + DFNFromEdipiResponse);
					response.setFailure(true);
					response.setFailureMessage("200MH Found in ICNResponse but DFN Do NOT exist in MHV: " + DFNFromEdipiResponse);
					return;
				}
			}
		} else {
			patient = null;
			if (queryResponseCode.getCode().equals(MviResponseTypeEnum.QUERY_ERROR.getResType())) {
					log.error("Max Results Exceeded in MVI 1310 ICN Call: " + queryResponseCode.getCode());
			} else if (queryResponseCode.getCode().equals(MviResponseTypeEnum.APPLICATION_ERROR.getResType())) {
					log.error("Application Error in MVI in 1310 ICN Call: " + queryResponseCode.getCode());
			} else if (queryResponseCode.getCode().equals(MviResponseTypeEnum.NOT_FOUND.getResType())) {
					log.error("User not found in MVI in 1310 ICN Call: " + queryResponseCode.getCode());
			}
			response.setPojoObject(null);
			return;

		}
		// gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
		response.setPojoObject(patient);
		return;

	}

	public void searchPersonInMVIByICNAccountSync(String icn, ResponseUtil response) {
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		Patient patient = null;
		UserProfile userProfile = null;
		boolean flag = false;
		PRPAIN201310UV02 searchRes = null;
		// Service business logic here
		long startTime = System.currentTimeMillis();
		//Object searchReqXML = CreateMVISearchByEdipiRequest.createMVISearchByEdipiRequest(edipiValue);
		Object searchReqXML = createMVISearchByICNRequest.createMVISearchByICNRequest(icn, mviProperties, null);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.SEARCHBY_EDIPI_TYPE.getReqType(), searchReqXML);
		if (responseXMLString.equalsIgnoreCase("ERROR")) {
			response.getInfoMessages().put(messagesUtil.getMviParseResponseIssue(), String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(), mviProperties.getContactMhvUrl()));
			response.setPojoObject(patient);
			return;
		}
		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.SEARCHBY_EDIPI_TYPE.getReqType(), (String)searchReqXML, responseXMLString);
		long endTime = System.currentTimeMillis();
		if(log.isDebugEnabled())
			log.debug("Time taken to execute Search Call for DSLogOn: " +(endTime-startTime));
		if(searchObj != null)
			searchRes = (PRPAIN201310UV02)searchObj;
		if(searchRes ==null) {
			log.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
			return;
		}
		//String ICNFromEdipiResponse = null;
		PRPAIN201306UV02 searchResAS = null;

		PRPAIN201305UV02 searchXmlObj = null;
		String DFNFromEdipiResponse = null;
		CS queryResponseCode = searchRes.getControlActProcess().getQueryAck().getQueryResponseCode();
		if(queryResponseCode.getCode().equals(MviResponseTypeEnum.GOOD_RESPONSE.getResType())) {
			//ICNFromEdipiResponse = MviUtil.getICNfromEdipiSearchResult(searchRes);
			DFNFromEdipiResponse = MviUtil.getDFNfromEdipiSearchResultIf200MH(searchRes, mviProperties);
			if(DFNFromEdipiResponse == null) {
				// TODO: No DFN returned from MVI for Edipi Search
				if (log.isInfoEnabled()) {
					log.info("No DFN found in ICNResponse- means no 200MH exists");
				}
				//System.out.println("*******Patient from MVI Integration no DFN: " + response.getPatient());
				//response.setValue("No DFN found in ICNResponse- means no 200MH exists");
				response.setPojoObject(patient);
				return;
			} else if(DFNFromEdipiResponse.equalsIgnoreCase(MviConstants.MULTIPLE_IDS_ERROR)) {
				//JAZZ Story#39187 - US REQ#2 When MHV system checks to see if the user has one active advanced account known to MVI, in the event
				//multiple accounts are returned from MVI, the system shall display a user-friendly error message in
				//a yellow box at the top of “We Cannot Connect Your Account” page.
				//response.setValue(MviConstants.MULTIPLE_IDS_ERROR);
				response.setPojoObject(patient);
				return;
			} else {
				log.debug("DFN From EDI PI Response: " + DFNFromEdipiResponse, "icn", icn);
//				UserProfileServiceResponse userProfileSerRes = gov.va.med.mhv.usermgmt.service.ServiceFactory.createUserProfileService().getUserProfileById(Long.parseLong(DFNFromEdipiResponse));
//				if (userProfileSerRes != null){
//					userProfile = userProfileSerRes.getUserProfile();
//				}
				userProfileRepository.getUserProfileById(Long.parseLong(DFNFromEdipiResponse));
				if (response.isFailure()) {
					userProfile = (UserProfile)response.getPojoObject();
					Object searchReqXMLAS = createMVIPatientSearchRequest.createPatientSearchXMLRequest(userProfile, mviProperties, null);
					String responseXMLStringAS = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), searchReqXMLAS);
					//gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParserAS = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
					Object searchObjAS = messageParser.mVIMessageParser(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), (String)searchReqXMLAS, responseXMLStringAS);
					if(searchObjAS != null) {
						searchResAS = (PRPAIN201306UV02)searchObjAS;
					}
					try {
						PRPAIN201305UV02Document searchXmlObjRoot = PRPAIN201305UV02Document.Factory.parse((String) searchReqXMLAS);
						searchXmlObj = searchXmlObjRoot.getPRPAIN201305UV02();
					}catch (Exception ex) {
						ex.printStackTrace();
						response.getInfoMessages().put(messagesUtil.getUnknownExceptionOccurred(), String.format(messagesUtil.getUnknownExceptionOccurred(),"unknownException"));
						response.setPojoObject(patient);
						return;
					}
					Patient mviPatient = new Patient();
					UserProfile mviUserProfile = new UserProfile();
					log.debug("Getting ICN from MVI Response" + DFNFromEdipiResponse, "icn", icn);
					String ICNFromMviResponse = getICNfromSearchResultAcctSync(searchXmlObj, searchResAS);
					String SSNFromMviResponse = getSSNfromSearchResult(searchXmlObj, searchResAS);
					String firstNameFromMviResponse = getFirstNameFromSearchResult(searchXmlObj, searchResAS);
					String lastNameFromMviResponse = getLastNameFromSearchResult(searchXmlObj, searchResAS);
					String middleNameFromMviResponse = getMiddleNameFromSearchResult(searchXmlObj, searchResAS);
					String genderFromMviResponse = getGenderFromSearchResult(searchXmlObj, searchResAS);
					String birthDateFromMviResponse = getBirthDateFromSearchResult(searchXmlObj, searchResAS);

					SimpleDateFormat dateformatYYYYMMDD = new SimpleDateFormat("yyyyMMdd");

					Date bdFromMviResponse = null;
					if(birthDateFromMviResponse != null) {
						try {
							bdFromMviResponse = dateformatYYYYMMDD.parse(birthDateFromMviResponse);
						}catch(Throwable t) {

						}
					}
					mviUserProfile.setFirstName(firstNameFromMviResponse);
					mviUserProfile.setLastName(lastNameFromMviResponse);
					mviUserProfile.setMiddleName(middleNameFromMviResponse);
					GenderEnumeration gender = GenderEnumeration.valueOf(genderFromMviResponse);
					mviUserProfile.setGender(gender.getDescription());
					mviUserProfile.setBirthDate(bdFromMviResponse);
					mviUserProfile.setSsn(SSNFromMviResponse);
					mviPatient.setIcn(ICNFromMviResponse);
					mviPatient.setUserProfile(mviUserProfile);
					response.setPojoObject(mviPatient);
					return;

					//UserProfileServiceResponse userProfileSerRes = gov.va.med.mhv.usermgmt.service.ServiceFactory.createUserProfileService().getUserProfileById(Long.parseLong(DFNFromEdipiResponse));
	//				if (userProfileSerRes != null)
	//					userProfile = userProfileSerRes.getUserProfile();
	//				if (userProfile != null) {
	//
	//					PRPAIN201310UV02 searchCorresRes = (PRPAIN201310UV02) messageParser.mVIMessageParser(MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(),(String)searchReqXML, responseXMLString);
	//
	//					if(searchCorresRes != null && searchCorresRes.getControlActProcess().getSubjectArray() != null && searchCorresRes.getControlActProcess().getSubjectArray().length > 0) {
	//						PRPAIN201310UV02MFMIMT700711UV01Subject1[] subjectArray = searchCorresRes.getControlActProcess().getSubjectArray();
	//						if(subjectArray[0].getRegistrationEvent() != null) {
	//							PRPAMT201304UV02Patient corresPatient = subjectArray[0].getRegistrationEvent().getSubject1().getPatient();
	//							II[] patientIdArray = corresPatient.getIdArray();
	//							response.setValue("treatingFaciltiesExist");
	//						}
	//					}
	//
	//					PatientServiceResponse patResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().getPatientForUser(userProfile);
	//					if ( patResponse.getPatient() != null && patResponse.getPatient().getPatientPK() != null) {
	//						//DS LogOn Patient Exists with the SAME ICN in MHV
	//						response.setPatient(patResponse.getPatient());
	//						//System.out.println("*******Patient from response in MVI Integration Service: " + response.getPatient());
	//						//System.out.println("*******Patient from response in MVI Integration Service: " + response.getPatient().getIcn());
	//						//response.setValue("DS LogOn Patient Exists with the SAME ICN in MHV");
	//						return response;
	//					}
	//				}
	//				else {
	//					// TODO: UserProfile NOT FOUND in MHV
	//					if (LOG.isErrorEnabled()) {
	//						LOG.error("200MH Found in ICNResponse but DFN Do NOT exist in MHV: " +DFNFromEdipiResponse);
	//					}
	//					//response.setValue("200MH Found in ICNResponse but DFN Do NOT exist in MHV: " +queryResponseCode.getCode());
	//					response.setPatient(patient);
	//					return response;
	//				}
				}
			}
		} else {
			patient = null;
			if(queryResponseCode.getCode().equals(MviResponseTypeEnum.QUERY_ERROR.getResType())){
				if(log.isErrorEnabled()) {
					log.error("Max Results Exceeded in MVI 1310 ICN Call: "+queryResponseCode.getCode());
				}
				//response.setValue("Max Results Exceeded in MVI 1310 ICN Call: " +queryResponseCode.getCode());
			} else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.APPLICATION_ERROR.getResType())){
				if(log.isErrorEnabled()) {
					log.error("Application Error in MVI in 1310 ICN Call: "+queryResponseCode.getCode());
				}
				//response.setValue("Application Error in MVI in 1310 ICN Call: " +queryResponseCode.getCode());
			} else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.NOT_FOUND.getResType())){
				if(log.isErrorEnabled()) {
					log.error("User not found in MVI in 1310 ICN Call: "+queryResponseCode.getCode());
				}
				//response.setValue("User not found in MVI in 1310 ICN Call: " +queryResponseCode.getCode());
			}
			response.setPojoObject(patient);
			return;
		}
		return;
	}

	public void searchPersonInMVIForDSLogon(String edipiValue, ResponseUtil response) {
		Patient patient = null;
		UserProfile userProfile = null;
		boolean flag = false;
		PRPAIN201310UV02 searchRes = null;
		// Service business logic here
		long startTime = System.currentTimeMillis();

		String versionInfo = ",family=" + MviUtil.VERSION_INFO_JOB_SEARCH_TRAITS;

		Object searchReqXML = createMVISearchByEdipiRequest.createMVISearchByEdipiRequest(edipiValue, mviProperties, versionInfo);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.SEARCHBY_EDIPI_TYPE.getReqType(), searchReqXML);
		if (responseXMLString.equalsIgnoreCase("ERROR")) {
			/*addInfo(response, "mvi.parse.response.issue", new String[] {
				mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(), mviProperties.getContactMhvUrl()
			});*/
			// response.setPatient(null);
			response.setFailure(true);
			response.setFailureMessage("MVI_COMM_ISSUE");
			response.getInfoMessages().put(messagesUtil.getMviParseResponseIssue(),
				String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(),
					mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(),
					mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
			//response.setValue(MviConstants.MVI_COMM_ISSUE);
			return;
		}
		MVIMessageParser messageParser = new MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.SEARCHBY_EDIPI_TYPE.getReqType(), (String) searchReqXML, responseXMLString);
		long endTime = System.currentTimeMillis();
		if (log.isDebugEnabled())
			log.debug("Time taken to execute Search Call for DSLogOn: " + (endTime - startTime));
		if (searchObj != null)
			searchRes = (PRPAIN201310UV02) searchObj;
		if (searchRes == null) {
			log.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
			response.setFailure(true);
			response.setFailureMessage("MVI_COMM_ISSUE");
			return;
		}
		// String ICNFromEdipiResponse = null;
		String DFNFromEdipiResponse = null;
		CS queryResponseCode = searchRes.getControlActProcess().getQueryAck().getQueryResponseCode();
		if (queryResponseCode.getCode().equals(MviResponseTypeEnum.GOOD_RESPONSE.getResType())) {
			// ICNFromEdipiResponse = MviUtil.getICNfromEdipiSearchResult(searchRes);
			DFNFromEdipiResponse = MviUtil.getDFNfromEdipiSearchResultIf200MH(searchRes, mviProperties);
			if (DFNFromEdipiResponse == null) {
				// TODO: No DFN returned from MVI for Edipi Search
				if (log.isInfoEnabled())
					log.info("No DFN found in EDIPIResponse- means no 200MH exists");
				return;
			} else if (DFNFromEdipiResponse.equalsIgnoreCase(MviConstants.MULTIPLE_IDS_ERROR)) {
				// JAZZ Story#39187 - US REQ#2 When MHV system checks to see if the user has one active advanced account known to MVI, in the event
				// multiple accounts are returned from MVI, the system shall display a user-friendly error message in
				// a yellow box at the top of �We Cannot Connect Your Account� page.
				//response.setValue(MviConstants.MULTIPLE_IDS_ERROR);
				response.setFailure(true);
				response.setFailureMessage(MviConstants.MULTIPLE_IDS_ERROR);
				return;
			} else {
				/*UserProfileServiceResponse userProfileSerRes =
					gov.va.med.mhv.usermgmt.service.ServiceFactory.createUserProfileService().getUserProfileById(Long.parseLong(DFNFromEdipiResponse));
				if (userProfileSerRes != null)
					userProfile = userProfileSerRes.getUserProfile();*/
				userProfile = userProfileRepository.getUserProfileById(Long.parseLong(DFNFromEdipiResponse));
				if (userProfile != null) {
					/*PatientServiceResponse patResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().getPatientForUser(userProfile);
					if (patResponse.getPatient() != null && patResponse.getPatient().getPatientPK() != null) {
						// DS LogOn Patient Exists with the SAME ICN in MHV
						response.setPatient(patResponse.getPatient());
						return response;
					}*/

					patientService.getPatientForUser(userProfile, response);
					if (response.isFailure()) {
						return;
					} else {
						patient = (Patient) response.getPojoObject();
					}
				} else {
					// TODO: UserProfile NOT FOUND in MHV
						log.error("200MH Found in EDIPIResponse but DFN Do NOT exist in MHV: " + DFNFromEdipiResponse);
					return;
				}
			}
		} else {
			patient = null;
			if (queryResponseCode.getCode().equals(MviResponseTypeEnum.QUERY_ERROR.getResType())) {
					log.error("Max Results Exceeded in MVI 1310 EDIPI Call: " + queryResponseCode.getCode());
			} else if (queryResponseCode.getCode().equals(MviResponseTypeEnum.APPLICATION_ERROR.getResType())) {
					log.error("Application Error in MVI in 1310 EDIPI Call: " + queryResponseCode.getCode());
			} else if (queryResponseCode.getCode().equals(MviResponseTypeEnum.NOT_FOUND.getResType())) {
					log.error("User not found in MVI in 1310 EDIPI Call: " + queryResponseCode.getCode());
			}
			response.setPojoObject(null);
			return;

		}
		// gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
		response.setPojoObject(patient);
		return;
	}

	public void searchPersonInMVIForUSAA(String fName, String mName, String lName, String DOB, String gender, String SSN, ResponseUtil response) {
		Patient patient = null;
		UserProfile userProfile = null;
		boolean flag = false;
		PRPAIN201306UV02 searchRes = null;
		// Service business logic here
		long startTime = System.currentTimeMillis();

		String versionInfo = "family=" + MviUtil.VERSION_INFO_JOB_SEARCH_TRAITS;

		Object searchReqXML = createMVISearchReqUSAA.createPatientSearchXMLRequest(fName, mName, lName, DOB, gender, SSN, mviProperties, versionInfo);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), searchReqXML);
		if (responseXMLString.equalsIgnoreCase("ERROR")) {
			// addInfo(response, "mvi.parse.response.issue",new String[]{mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getAdvancedUrl(),
			// mviProperties.getTargetWindow(), mviProperties.getContactMhvUrl()} );
			response.getInfoMessages().put(
				messagesUtil.getMviParseResponseIssue(),
				String.format(
					messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(),
					mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(),
					mviProperties.getContactMhvUrl(), mviProperties.getTargetWindow()));
			// response.setPatient(null);
			response.setFailure(true);
			response.setFailureMessage("MVI_COMM_ISSUE");
			response.setPojoObject(null);
			return;
		}
		MVIMessageParser messageParser = new MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), (String) searchReqXML, responseXMLString);
		long endTime = System.currentTimeMillis();
		if (log.isDebugEnabled())
			log.debug("Time taken to execute Search Call for USAA: " + (endTime - startTime));
		if (searchObj != null)
			searchRes = (PRPAIN201306UV02) searchObj;
		if (searchRes == null) {
			log.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
			response.setFailure(true);
			response.setFailureMessage("MVI_COMM_ISSUE");
			return;
		}
		// String ICNFromEdipiResponse = null;
		String DFNFromEdipiResponse = null;
		CS queryResponseCode = searchRes.getControlActProcess().getQueryAck().getQueryResponseCode();
		if (queryResponseCode.getCode().equals(MviResponseTypeEnum.GOOD_RESPONSE.getResType())) {
			// ICNFromEdipiResponse = MviUtil.getICNfromEdipiSearchResult(searchRes);
			DFNFromEdipiResponse = MviUtil.getDFNfromMVISearchResultIf200MH(searchRes, mviProperties);
			if (DFNFromEdipiResponse == null) {
				// TODO: No DFN returned from MVI for 1306 Search
				log.error("No DFN found in USAASearch Response- means no 200MH exists");
				response.setFailure(true);
				response.setFailureMessage("No DFN found in USAASearch Response- means no 200MH exists");
				return;
			} else if (DFNFromEdipiResponse.equalsIgnoreCase(MviConstants.MULTIPLE_IDS_ERROR)) {
				// JAZZ Story#39187 - US REQ#2 When MHV system checks to see if the user has one active advanced account known to MVI, in the event
				// multiple accounts are returned from MVI, the system shall display a user-friendly error message in
				// a yellow box at the top of �We Cannot Connect Your Account� page.
				//response.setValue(MviConstants.MULTIPLE_IDS_ERROR);
				response.setFailure(true);
				response.setFailureMessage(MviConstants.MULTIPLE_IDS_ERROR);
				return;
			} else {
				/*UserProfileServiceResponse userProfileSerRes =
					gov.va.med.mhv.usermgmt.service.ServiceFactory.createUserProfileService().getUserProfileById(Long.parseLong(DFNFromEdipiResponse));
				if (userProfileSerRes != null)
					userProfile = userProfileSerRes.getUserProfile();*/
				userProfile = userProfileRepository.getUserProfileById(Long.parseLong(DFNFromEdipiResponse));
				if (userProfile != null) {
					/*PatientServiceResponse patResponse = gov.va.med.mhv.usermgmt.service.ServiceFactory.createPatientService().getPatientForUser(userProfile);
					if (patResponse.getPatient() != null && patResponse.getPatient().getPatientPK() != null) {
						// DS LogOn Patient Exists with the SAME ICN in MHV
						response.setPatient(patResponse.getPatient());
						return response;
					}*/
					patientService.getPatientForUser(userProfile, response);
					if (response.isFailure()) {
						return;
					} else {
						patient = (Patient) response.getPojoObject();
					}
				} else {
					// TODO: UserProfile NOT FOUND in MHV
					log.error("200MH Found in USAASearch Response but DFN Do NOT exist in MHV: " + DFNFromEdipiResponse);
					response.setFailure(true);
					response.setFailureMessage("200MH Found in USAASearch Response but DFN Do NOT exist in MHV: " + DFNFromEdipiResponse);
					return;
				}
			}
		} else {
			patient = null;
			if (queryResponseCode.getCode().equals(MviResponseTypeEnum.QUERY_ERROR.getResType())) {
				log.error("Max Results Exceeded in MVI 1306 SEARCH Call: " + queryResponseCode.getCode());
			} else if (queryResponseCode.getCode().equals(MviResponseTypeEnum.APPLICATION_ERROR.getResType())) {
				log.error("Application Error in MVI in 1306 SEARCH Call: " + queryResponseCode.getCode());
			} else if (queryResponseCode.getCode().equals(MviResponseTypeEnum.NOT_FOUND.getResType())) {
				log.error("User not found in MVI in 1306 SEARCH Call: " + queryResponseCode.getCode());
			}
			response.setPojoObject(null);
			return;

		}
		// gov.va.med.mhv.usermgmt.service.ServiceFactory.createEntityMaintenanceService().save(patient);
		response.setPojoObject(patient);
		return;
	}

	/*
	 * Update Treatment facilities for existing users that are in the following categories
	 */
	public void treatmentFacilitiesExist(String icn, ResponseUtil response){
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		//BooleanServiceResponse booleanResponse = new BooleanServiceResponse();
		response.setSuccess(false);
		response.setFailure(true);
		Object correspondingReqXML = createMVIGetCorrespondingRequest.createMVIGetCorrespondingRequest(icn, mviProperties, null);

		String corresResponseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(), correspondingReqXML);
		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		PRPAIN201310UV02 searchCorresRes = (PRPAIN201310UV02) messageParser.mVIMessageParser(MviRequestTypeEnum.GETCORRESPONDING_TYPE.getReqType(),(String)correspondingReqXML, corresResponseXMLString);

		if(searchCorresRes != null && searchCorresRes.getControlActProcess().getSubjectArray() != null && searchCorresRes.getControlActProcess().getSubjectArray().length > 0) {
			PRPAIN201310UV02MFMIMT700711UV01Subject1[] subjectArray = searchCorresRes.getControlActProcess().getSubjectArray();
			if(subjectArray[0].getRegistrationEvent() != null) {
				PRPAMT201304UV02Patient corresPatient = subjectArray[0].getRegistrationEvent().getSubject1().getPatient();
				II[] patientIdArray = corresPatient.getIdArray();
				//booleanResponse.setBoolean(isReceivedFacilitiesFromMvi(patientIdArray));
				if(isReceivedFacilitiesFromMvi(patientIdArray)) {
					response.setSuccess(true);
					response.setFailure(false);
				} else {
					response.setFailure(true);
					response.setSuccess(false);
				}
			}
		}
		return;
	}

	public boolean isReceivedFacilitiesFromMvi(II[] searchPatientIdArray) {
		for (int i=0; i< searchPatientIdArray.length; i++) {
			II patientId = searchPatientIdArray[i];
			String searchIdExtension = patientId.getExtension();
			if (log.isInfoEnabled()) {
				log.info("********** MviIntegrationServiceImpl isReceivedFacilitiesFromMvi(): for searchIdExtension:" + searchIdExtension);
			}
			if (searchIdExtension.contains("PI") || searchIdExtension.contains("NI") ||
				searchIdExtension.contains("SS")) {
				String[] idExtn = searchIdExtension.split("\\^");
				if(idExtn.length>3) {
					String stationNumber = idExtn[2];
					String facilityStatus = idExtn[4];
					if(facilityStatus.equalsIgnoreCase("A") || facilityStatus.equalsIgnoreCase("4")) {
						if(!StringUtils.isBlank(stationNumber) ) {
							List<FacilityInfo> existingFacilities = facilityInfoRepository.queryByStationNumber(stationNumber);
							if(existingFacilities == null || existingFacilities.size() == 0){
								//TODO - Add log message
							}
							else if(existingFacilities.size() > 1){
								//TODO - Add log message
							} else {
								return true;
							}
						}
					}
				}
			}
		}
		return false;
	}

	public void searchPersonInMVIForUSAAAcctSync(UserProfile userProfile, ResponseUtil response) {
		MviInvocationUtilHandler mviInvokeHandler = new MviInvocationUtilHandler();
		Patient patient = null;
		boolean flag = false;
		PRPAIN201306UV02 searchRes = null;
		// Service business logic here
		long startTime = System.currentTimeMillis();
		Object searchReqXML = createMVIPatientSearchRequest.createPatientSearchXMLRequest(userProfile, mviProperties, null);
		String responseXMLString = mviInvokeHandler.invokeMvi(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), searchReqXML);
		if (responseXMLString.equalsIgnoreCase("ERROR")) {
			response.getInfoMessages().put(messagesUtil.getMviParseResponseIssue(), String.format(messagesUtil.getMviParseResponseIssue(), mviProperties.getBasicUrl(), mviProperties.getTargetWindow(), mviProperties.getAdvancedUrl(), mviProperties.getTargetWindow(), mviProperties.getContactMhvUrl()));
			response.setPojoObject(patient);
			return;
		}
		gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser messageParser = new gov.va.med.mhv.usermgmt.service.handler.MVIMessageParser();
		Object searchObj = messageParser.mVIMessageParser(MviRequestTypeEnum.SEARCH_TYPE.getReqType(), (String)searchReqXML, responseXMLString);
		long endTime = System.currentTimeMillis();
		if(log.isDebugEnabled())
			log.debug("Time taken to execute Search Call for USAA: " +(endTime-startTime));
		if(searchObj != null) {
			searchRes = (PRPAIN201306UV02)searchObj;
		}
		if(searchRes ==null) {
			log.error("UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI");
			response.setFailure(true);
			return;
		}
		//String ICNFromEdipiResponse = null;
		String DFNFromEdipiResponse = null;
		CS queryResponseCode = searchRes.getControlActProcess().getQueryAck().getQueryResponseCode();
		if(queryResponseCode.getCode().equals(MviResponseTypeEnum.GOOD_RESPONSE.getResType())) {
			//ICNFromEdipiResponse = MviUtil.getICNfromEdipiSearchResult(searchRes);
			DFNFromEdipiResponse = MviUtil.getDFNfromMVISearchResultIf200MH(searchRes, mviProperties);
			if(DFNFromEdipiResponse == null) {
				// TODO: No DFN returned from MVI for 1306 Search
				if (log.isErrorEnabled()) {
					log.error("No DFN found in USAASearch Response- means no 200MH exists");
				}
				response.setPojoObject(patient);
				return;
			} else if(DFNFromEdipiResponse.equalsIgnoreCase(MviConstants.MULTIPLE_IDS_ERROR)) {
				//JAZZ Story#39187 - US REQ#2 When MHV system checks to see if the user has one active advanced account known to MVI, in the event
				//multiple accounts are returned from MVI, the system shall display a user-friendly error message in
				//a yellow box at the top of “We Cannot Connect Your Account” page.
				//response.setValue(MviConstants.MULTIPLE_IDS_ERROR);
				response.setPojoObject(patient);
				return;
			} else {
				userProfile = userProfileRepository.getUserProfileById(Long.parseLong(DFNFromEdipiResponse));
				if (userProfile == null) {
					if (log.isErrorEnabled()) {
						log.error("200MH Found in USAASearch Response but DFN Do NOT exist in MHV: " +DFNFromEdipiResponse);
					}
				} else {
					response.setPojoObject(patient);
					return;
				}
			}
		}
		else {
			if(queryResponseCode.getCode().equals(MviResponseTypeEnum.QUERY_ERROR.getResType())){
				if(log.isErrorEnabled()) {
					log.error("Max Results Exceeded in MVI 1306 SEARCH Call: "+queryResponseCode.getCode());
				}
				response.setPojoObject(patient);
			}
			else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.APPLICATION_ERROR.getResType())){
				if(log.isErrorEnabled()) {
					log.error("Application Error in MVI in 1306 SEARCH Call: "+queryResponseCode.getCode());
				}
				response.setPojoObject(patient);
			}
			else if(queryResponseCode.getCode().equals(MviResponseTypeEnum.NOT_FOUND.getResType())){
				if(log.isErrorEnabled()) {
					log.error("User not found in MVI in 1306 SEARCH Call: "+queryResponseCode.getCode());
				}
				//response.setValue("ERROR:Application Error in MVI in 1306 SEARCH Call: "+queryResponseCode.getCode());
				response.setPojoObject(patient);
			}
			return;

		}
		response.setPojoObject(patient);
		return;
	}
}