package gov.va.med.mhv.usermgmt.main.service.impl;

import java.util.Collection;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTO;
import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTOLight;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.converter.InPersonAuthenticationConverter;
import gov.va.med.mhv.common.data.converter.InPersonAuthenticationLightConverter;
import gov.va.med.mhv.common.data.converter.PatientConverter;
import gov.va.med.mhv.common.data.model.InPersonAuthentication;
import gov.va.med.mhv.common.data.model.InPersonAuthenticationLight;
import gov.va.med.mhv.common.data.model.Patient;
import gov.va.med.mhv.usermgmt.common.dto.DirectMessageDTO;
import gov.va.med.mhv.usermgmt.common.enums.AuthenticationStatusEnumeration;
import gov.va.med.mhv.usermgmt.data.model.DirectMessage;
import gov.va.med.mhv.usermgmt.data.repository.InPersonAuthenticationLightRepository;
import gov.va.med.mhv.usermgmt.data.repository.InPersonAuthenticationRepository;
import gov.va.med.mhv.usermgmt.exception.MHVRuntimeException;
import gov.va.med.mhv.usermgmt.service.InPersonAuthenticationService;
import gov.va.med.mhv.usermgmt.service.MviIntegrationService;
import gov.va.med.mhv.usermgmt.service.PatientService;

@Component
public class InPersonAuthenticationServiceImpl implements InPersonAuthenticationService {
	
	private static final InPersonAuthenticationConverter IPA_CONVERTER = new InPersonAuthenticationConverter();
	private static final InPersonAuthenticationLightConverter IPALIGHT_CONVERTER = new InPersonAuthenticationLightConverter();
	private static final PatientConverter PATIENT_CONVERTER = new PatientConverter();

	private static Logger log = LogManager.getLogger(InPersonAuthenticationServiceImpl.class);

	@Autowired
	private InPersonAuthenticationRepository inpersonAuthenticationRepository;
	
	@Autowired
	private InPersonAuthenticationLightRepository inpersonAuthenticationLightRepository;

	@Autowired
	PatientService patientService;
	
	@Autowired
	InPersonAuthenticationConverter converter;
	
	@Autowired
	MviIntegrationService mviService;
	
	@Autowired
	PatientConverter patientConverter;
	
	@Override
	@Transactional
	public void getIPAPatientById(Long patientId, ResponseUtil response) {
		List<InPersonAuthentication> ipaPatients = null;
		InPersonAuthentication ipaPatient = null;
		try {
			ipaPatients = inpersonAuthenticationRepository.getAuthenticationForPatient(patientId);

			if (null != ipaPatients && ipaPatients.size() > 0) {
				ipaPatient = ipaPatients.get(0);
			}
		} catch (Exception e) {
			log.error("Error in getting patinet details from getAuthenticationForPatient() " + patientId, e);
			throw new MHVRuntimeException("Error in getting patinet details from getAuthenticationForPatient() " + patientId);
		}

		response.setFailure(false);
		response.setSuccess(true);
		response.setPojoObject(ipaPatient);
		return;
	}

	@Override
	public void getIPAByuserProfileid(Long userProfileid, ResponseUtil response) {
		// TODO Auto-generated method stub
		return;
	}

	@Override
	public void getIPAedPatientForUser(String userName, ResponseUtil response) {
		// TODO Auto-generated method stub
		return;
	}

	@Override
	public void deferAuthentication(InPersonAuthenticationDTO ipa, ResponseUtil response) {
			log.debug("ipa.getParticipationFormSigned()"+ipa.getParticipationFormSigned());
	        Boolean formSigned = ipa.getParticipationFormSigned() == null
	            ? Boolean.FALSE : ipa.getParticipationFormSigned();
	        Boolean idPresented = ipa.getIdentificationPresented() == null
	            ? Boolean.FALSE : ipa.getIdentificationPresented();
	        String status = "";
	        if (formSigned.booleanValue() && idPresented.booleanValue()) {
	            status = AuthenticationStatusEnumeration.PREREQUISITESCOMPLETE.getDescription();
	        } else {
	            status = AuthenticationStatusEnumeration.INPROCESS.getDescription();
	        }
	        ipa.setRemovalReason(null);
	        ipa.setStatus(status);
	        saveInPersonAuthentication(ipa);
	        
	}
	
	@Override
	public void deferAuthenticationLight(InPersonAuthenticationDTOLight ipa, ResponseUtil response) {
		log.debug("ipa.getParticipationFormSigned()"+ipa.getParticipationFormSigned());
        Boolean formSigned = ipa.getParticipationFormSigned() == null
            ? Boolean.FALSE : ipa.getParticipationFormSigned();
        Boolean idPresented = ipa.getIdentificationPresented() == null
            ? Boolean.FALSE : ipa.getIdentificationPresented();
        String status = "";
        if (formSigned.booleanValue() && idPresented.booleanValue()) {
            status = AuthenticationStatusEnumeration.PREREQUISITESCOMPLETE.getDescription();
        } else {
            status = AuthenticationStatusEnumeration.INPROCESS.getDescription();
        }
        ipa.setRemovalReason(null);
        ipa.setStatus(status);
        saveInPersonAuthenticationLight(ipa);
        //TODO: Set Audit Entry
//        Auditor.auditIPAInProcessEvent(ipa,
//                ActivityActorTypeEnumeration.MHV_AUTHENTICATOR);
		
	}

	@Override
	public void terminateAuthentication(InPersonAuthenticationDTO ipa, ResponseUtil response) {
		// TODO Auto-generated method stub
		return;
	}

	@Override
	public void authenticateMany(Collection patientIds, ResponseUtil response) {
		// TODO Auto-generated method stub
		return;
	}

	@Override
	public void finalizeAuthentication(InPersonAuthenticationDTO ipa, String error, ResponseUtil response) {
		// TODO Auto-generated method stub
		return;
	}

	@Override
	public void getAuthenticationForPatient(Long patientId, ResponseUtil response) {
		// TODO Auto-generated method stub
		return;
	}

	@Override
	public void unauthenticate(InPersonAuthenticationDTO ipa, ResponseUtil response) {/*
																						Precondition.assertNotNull("ipa", ipa);
																						Precondition.assertNotNull("ipa.patient", ipa.getPatient());

																						MviProperties mviProp = MviProperties.getInstance();
																						if(mviProp.getIsMviEnabled()) {
																						return mviUnauthenticate(ipa);
																						}
																						
																						InPersonAuthenticationServiceResponse response = 
																						new InPersonAuthenticationServiceResponse();
																						
																						boolean isEnabled = MpiProperties.getInstance().isUnlinkEnabled();
																						boolean isCorrelated = PatientCorrelationStatusUtils.isCorrelated(
																						ipa.getPatient());
																						
																						if (isEnabled 
																						&& !(isCorrelated || isPendingSynchronization(ipa.getPatient()))) 
																						{
																						addError(response, MessageKeys.CANNOT_UNAUTHENTICATE_PATIENT);
																						return response;
																						}
																						InPersonAuthentication originalIpa = copyProperties(ipa, null);
																						AuthenticationStatus status = (isEnabled && isCorrelated) 
																						? InPersonAuthenticationStatusUtils.PENDING_REMOVAL 
																						: InPersonAuthenticationStatusUtils.UNAUTHENTICATED;
																						ipa.setParticipationFormSigned(Boolean.FALSE);
																						ipa.setIdentificationPresented(Boolean.FALSE);
																						ipa.setApprovedForRecordsAccess(Boolean.FALSE);
																						ipa.setDefermentReason(null);
																						ipa.setAuthenticatingFacility(null);
																						ipa.setAuthenticationDate(null);
																						ipa = saveIPA(ipa, status);

																						response.setInPersonAuthentication(ipa);
																						copyMessages(response, ipa);
																						if (!hasErrorMessages(response)) {
																						VoidServiceResponse patientServiceResponse = ServiceFactory.
																						createPatientService().uncorrelate(ipa.getPatient());
																						copyMessages(response, patientServiceResponse);
																						}
																						if (hasErrorMessages(response)) {
																						ipa = copyProperties(originalIpa, ipa); 
																						}
																						return response; 
																						*/
	}

	@Override
	public void finalizeUnauthentication(InPersonAuthenticationDTO ipa, String error, ResponseUtil response) {
		// TODO Auto-generated method stub
		return;
	}
	
	@Override
	public InPersonAuthenticationLight saveInPersonAuthenticationLight(InPersonAuthenticationDTOLight ipa) {
		InPersonAuthenticationLight ip = null;
		try {
			if(log.isDebugEnabled()) {
				log.debug("!!!!!!!!!ipa.getStartUpgradeManualDateTime():"+ipa.getStartUpgradeManualDateTime().toString());
			}
			
			ip = IPALIGHT_CONVERTER.convertInpersonAuthenticationDTOLight(ipa);
			
			ip = this.inpersonAuthenticationLightRepository.save(ip);
		} catch (Exception e) {
			log.error("Error in storing InPersonAuthentication details", e);
			throw new MHVRuntimeException("Error in storing InPersonAuthentication details");
		}
		return ip;

	}
	
	@Override
	public InPersonAuthentication saveInPersonAuthentication(InPersonAuthenticationDTO ipa) {
		InPersonAuthentication ip = null;
		try {
			ip = IPA_CONVERTER.convertInpersonAuthenticationDTO(ipa);
			ip = this.inpersonAuthenticationRepository.save(ip);
		} catch (Exception e) {
			log.error("Error in storing InPersonAuthentication details", e);
			throw new MHVRuntimeException("Error in storing InPersonAuthentication details");
		}
		return ip;

	}

	@Override
	public InPersonAuthentication saveIPA(InPersonAuthentication ipa) {
		InPersonAuthentication storedObject = null;
		try {
			storedObject = inpersonAuthenticationRepository.save(ipa);
		} catch (Exception e) {
			log.error("Error in storing InPersonAuthentication details", e);
			throw new MHVRuntimeException("Error in storing InPersonAuthentication details");
		}
		return storedObject;
	}


	@Override
	public InPersonAuthenticationLight saveIPALight(InPersonAuthenticationLight ipa) {
		log.debug("*********************** InPersonAuthenticationServiceImpl saveIPALight");
		InPersonAuthenticationLight storedObject = null;
		try {
			storedObject = inpersonAuthenticationLightRepository.save(ipa);
		} catch (Exception e) {
			log.error("Error in storing InPersonAuthentication details", e);
			throw new MHVRuntimeException("Error in storing InPersonAuthentication details");
		}
		return storedObject;
	}
	
	@Override
	public void forceUnauthenticateUnCorrelate(InPersonAuthenticationDTO ipa, ResponseUtil response) {
		// TODO Auto-generated method stub
		return;
	}

	@Override
	public void isPatientAuthenticated(Long patientId, ResponseUtil<Boolean> response) {

		List<InPersonAuthentication> ipaPatients = null;
		InPersonAuthentication ipaPatient = null;
		try {
			ipaPatients = inpersonAuthenticationRepository.getAuthenticationForPatient(patientId);

			if (null != ipaPatients && ipaPatients.size() > 0) {
				ipaPatient = ipaPatients.get(0);
			} else {
				response.setFailure(true);
				response.setFailureMessage("ipaPatient is null");
				return;
			}
			
			if (null != ipaPatient.getStatus() 
					&& ipaPatient.getStatus().equalsIgnoreCase(AuthenticationStatusEnumeration.AUTHENTICATED.getDescription())) {
				response.setPojoObject(Boolean.TRUE);
			} else {
				response.setPojoObject(Boolean.FALSE);
			}
		} catch (Exception e) {
			log.error("Error in getting patinet details from getAuthenticationForPatient() " + patientId, e);
			throw new MHVRuntimeException("Error in getting patinet details from getAuthenticationForPatient() " + patientId);
		}

		response.setFailure(false);
		response.setSuccess(true);
		
		return;
	}

	@Override
	public void authenticateFull(InPersonAuthenticationDTO ipa, ResponseUtil response) {
		Patient patient = PATIENT_CONVERTER.convertDTOProfile(ipa.getPatient());
		log.debug("********** InPersonAuthenticationServiceImpl.authenticate() calling mviService.mviAuthenticate()");
		mviService.mviAuthenticate(patient, patient.getUserProfile(), true, false, response, null);
		log.debug("********** InPersonAuthenticationServiceImpl.authenticate() called mviService.mviAuthenticate(): response:"+response.isSuccess());
		if (response.isSuccess()) {
        	ipa.setMviAuthenticationStatus("OK");
			if(log.isInfoEnabled()){
				log.info("********** InPersonAuthetnicationService().mviAuthenticate ipa.setMviAuthenticationStatus:OK");
				
			}
			Boolean formSigned = ipa.getParticipationFormSigned() == null
	            ? Boolean.FALSE : ipa.getParticipationFormSigned();
	        Boolean idPresented = ipa.getIdentificationPresented() == null
	            ? Boolean.FALSE : ipa.getIdentificationPresented();
	        String status = "";
	        if (formSigned.booleanValue() && idPresented.booleanValue()) {
	            status = AuthenticationStatusEnumeration.INPROCESS.getDescription();
	        } else {
	            status = AuthenticationStatusEnumeration.AUTHENTICATED.getDescription();
	        }
        } else {
        	ipa.setMviAuthenticationStatus("PENDING_AUTH");
			if(log.isInfoEnabled()){
				log.info("********** InPersonAuthetnicationService().mviAuthenticate ipa.setMviAuthenticationStatus:PENDING_AUTH");
			}
        }

		if(log.isInfoEnabled()){
			log.info("********** InPersonAuthetnicationService().mviAuthenticate ipa.setMviAuthenticationStatus:" + ipa.getMviAuthenticationStatus());
		}

        
        InPersonAuthentication ip = new InPersonAuthentication();
        ip = saveInPersonAuthentication(ipa);
		return;
	}

	

	@Override
	public void authenticate(InPersonAuthenticationDTOLight ipa, ResponseUtil response) {
		// TODO Auto-generated method stub
		
		
	}
}
