/**
 * 
 */
package gov.va.med.mhv.usermgmt.main.service.impl;

import java.util.Hashtable;

import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.usermgmt.common.dto.EmployeeSearchResult;
import gov.va.med.mhv.usermgmt.exception.MHVRuntimeException;
import gov.va.med.mhv.usermgmt.persist.ldap.LdapEnvironment;
import gov.va.med.mhv.usermgmt.service.EmployeeSearchService;
import gov.va.med.mhv.usermgmt.util.MessagesUtil;

/**
 * @author DNS   THUMMP
 */
@Component
public class EmployeeSearchServiceImpl implements EmployeeSearchService {

	protected static Logger log = LogManager.getLogger(EmployeeSearchServiceImpl.class);

	@Autowired
	private LdapEnvironment ldapEnvironment;

	@Autowired
	private MessagesUtil messagesUtil;

	@Override
	public Boolean searchByUserName(String userName, boolean collectionResponse, ResponseUtil response) {
		Boolean userAlreadyExists = false;

		if (userName != null) {
			userName = userName.replaceAll("\\*", ""); // no user entered
														// wildcard characters
			userName = userName.trim(); // trim spaces
		}

		// create the search stringf
		String searchFilter = "(&(objectClass=user)(sAMAccountName=" + userName + "))";

		// url=ldap://IP               
		// adminPrincipal=DNS  TIN\\mhvadmin
		// adminPassword=P@ssw0rd
		// searchBase=DC=DNS  TIN,DC=DEV

		Hashtable<String, String> AD_LDAP_ENVIRONMENT = new Hashtable<String, String>();
		AD_LDAP_ENVIRONMENT.put(Context.INITIAL_CONTEXT_FACTORY, ldapEnvironment.getAdIntialCtxFactory());
		AD_LDAP_ENVIRONMENT.put(Context.SECURITY_AUTHENTICATION, ldapEnvironment.getAdSecurityAuthentication());
		AD_LDAP_ENVIRONMENT.put(Context.PROVIDER_URL, ldapEnvironment.getAdUrl());
		AD_LDAP_ENVIRONMENT.put(Context.SECURITY_PRINCIPAL, ldapEnvironment.getAdAdminPrincipal());
		AD_LDAP_ENVIRONMENT.put(Context.SECURITY_CREDENTIALS, ldapEnvironment.getAdAdminPassword());

		LdapContext ldapContext = null;
		
		// perform search
		try {
			ldapContext = new InitialLdapContext(AD_LDAP_ENVIRONMENT, null);

			NamingEnumeration searchResults = ldapContext.search(ldapEnvironment.getAdSearchBase(), searchFilter, null);
			// no results found
			if (searchResults.hasMoreElements() == false) {
				userAlreadyExists = false;
				// response.setFailure(true);
				// validator.addError(response,
				// UserManagementMessages.SEARCH_NO_RESULTS, null);
			} else {
				while (searchResults.hasMoreElements()) {
					SearchResult searchResult = (SearchResult) searchResults.next();
					Attributes searchResultAttributes = searchResult.getAttributes();
					if (searchResultAttributes != null) {
						userAlreadyExists = true;
						// if we are using this helper method to populate
						// results
						// for collection response, we add search result into
						// response in different manner
						/*if (collectionResponse) {
							((EmployeeSearchResultCollectionServiceResponse) 
											response).addEmployeeSearchResult(
												convertToEmployeeSearchResult(searchResultAttributes));
						} else {
							((EmployeeSearchResultServiceResponse) response).
							setEmployeeSearchResult(
								convertToEmployeeSearchResult(searchResultAttributes));
						}*/
						
						response.setFailure(false);
						response.setSuccess(true);
						response.setPojoObject(convertToEmployeeSearchResult(searchResultAttributes));
					}
				}
			}
		} catch (NamingException e) {
			log.error("Failed to connect to Active Directory", e);
			// validator.addError(response,
			// UserManagementMessages.SEARCH_FAILED, null);
			throw new MHVRuntimeException(messagesUtil.getEmployeeSearchFailed());
		} finally {
			try {
				if (ldapContext != null) {
					ldapContext.close(); // attempt to close connection
					// regardless
				}
			} catch (NamingException e) {
				log.error("Failed to close connection to Active Directory", e);
				// validator.addError(response,
				// UserManagementMessages.SEARCH_FAILED, null);
				throw new MHVRuntimeException(messagesUtil.getEmployeeSearchFailed());
			} finally {
				ldapContext = null; // release handle to connection regardless
			}
		}

		return userAlreadyExists;
	}

	@Override
	public void searchByName(String firstName, String lastName, ResponseUtil response) {

		// TODO Auto-generated method stub
		return;
	}

    private static final EmployeeSearchResult convertToEmployeeSearchResult(
            Attributes attributes) throws NamingException {
            EmployeeSearchResult employeeSearchResult = new EmployeeSearchResult();

            if (attributes.get("sAMAccountName") != null)
                employeeSearchResult.setUserName((String) attributes.get(
                    "sAMAccountName").get());

            if (attributes.get("givenName") != null)
                employeeSearchResult.setFirstName((String) attributes.get(
                    "givenName").get());

            if (attributes.get("sn") != null)
                employeeSearchResult.setLastName((String) attributes.get("sn")
                    .get());

            if (attributes.get("title") != null)
                employeeSearchResult.setTitle((String) attributes.get("title")
                    .get());

            if (attributes.get("physicalDeliveryOfficeName") != null)
                employeeSearchResult.setOffice((String) attributes.get(
                    "physicalDeliveryOfficeName").get());

            if (attributes.get("department") != null)
                employeeSearchResult.setDepartment((String) attributes.get(
                    "department").get());

            if (attributes.get("company") != null)
                employeeSearchResult.setCompany((String) attributes.get("company")
                    .get());

            if (attributes.get("telephoneNumber") != null)
                employeeSearchResult.setPhone((String) attributes.get(
                    "telephoneNumber").get());

            if (attributes.get("mail") != null)
                employeeSearchResult
                    .setEmail((String) attributes.get("mail").get());

            employeeSearchResult.setFullName(employeeSearchResult.getLastName()
                + ", " + employeeSearchResult.getFirstName());

            return employeeSearchResult;
        }
}
