package gov.va.med.mhv.usermgmt.main.service.impl;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.dto.EmergencyContactDTO;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.usermgmt.converter.EmergencyContactConverter;
import gov.va.med.mhv.usermgmt.data.model.EmergencyContact;
import gov.va.med.mhv.usermgmt.data.repository.EmergencyContactRepository;
import gov.va.med.mhv.usermgmt.main.service.validator.EmergencyContactValidator;
import gov.va.med.mhv.usermgmt.service.EmergencyContactService;

@Component
public class EmergencyContactServiceImpl implements EmergencyContactService {
	protected static Logger log = LogManager.getLogger(EmergencyContactServiceImpl.class);

	@Autowired
	private EmergencyContactRepository emergencyContactRepository;

	private EmergencyContactConverter converter = new EmergencyContactConverter();
	private EmergencyContactValidator validator = new EmergencyContactValidator();

	@Override
	public void saveEmergencyContact(EmergencyContactDTO emergencyContactDto, ResponseUtil response) {
		log.debug("saveEmergencyContact");
		
		if (response.getValidationErrors() == null) {
			response.setValidationErrors(new LinkedHashMap<String, String>());
		}
		
		validator.fieldValidation(response, emergencyContactDto);
		
		EmergencyContact e = converter.convertTo(emergencyContactDto);
		
		if (response.getValidationErrors() != null && response.getValidationErrors().isEmpty()) {
			if (e.isPrimary()) {
				// this is a primary contact, lets first get the existing
				// primary contact and set it to false;
				List<EmergencyContact> list = emergencyContactRepository.findByUserProfileIdAndPrimary(e.getUserProfileId(), true);
				if (list != null && list.size() > 0) {
					for (EmergencyContact ec : list) {
						ec.setPrimary(false);
						emergencyContactRepository.save(ec);
					}
				}
			}
			EmergencyContact result = emergencyContactRepository.save(e);
			
			EmergencyContactDTO resultDTO = converter.convertFrom(result);
			
			response.setPojoObject(resultDTO);
			response.setFailure(false);
			response.setSuccess(true);
		} else {
			response.setPojoObject(null);
			response.setFailure(true);
			response.setSuccess(false);
			return;
		}
	}

	@Override
	public void deleteEmergencyContact(EmergencyContactDTO emergencyContactDto, ResponseUtil response) {

		log.debug("deleteEmergencyContact");

		EmergencyContact e = emergencyContactRepository.findByEmergencyContactId(emergencyContactDto.getId());

		if (e != null) {
			emergencyContactRepository.delete(e);
			response.setSuccess(true);
		} else {
			response.getValidationErrors().put("DELETE_ERROR", "Entity to delete not found.");
			response.setSuccess(false);
		}
	}

	@Override
	public EmergencyContactDTO findByPrimaryKey(EmergencyContactDTO emergencyContact) {

		log.debug("findByPrimaryKey");

		EmergencyContact ec = emergencyContactRepository.findByEmergencyContactId(emergencyContact.getId());
		EmergencyContactDTO ecDto = converter.convertFrom(ec);
		return ecDto;
	}

	@Override
	public ResponseUtil findResponseByPrimaryKey(EmergencyContactDTO emergencyContact) {
		EmergencyContactDTO ecDto = findByPrimaryKey(emergencyContact);

		ResponseUtil response = new ResponseUtil();
		response.setPojoObject(ecDto);
		response.setSuccess(true);
		return response;
	}

	@Override
	public List<EmergencyContactDTO> findByUserProfileId(Long id) {
		log.debug("findByUserProfileId id=" + id);

		List<EmergencyContact> list = emergencyContactRepository.findByUserProfileId(id);
		List<EmergencyContactDTO> dtoList = new ArrayList<EmergencyContactDTO>();
		if (list != null && list.size() > 0) {
			for (EmergencyContact ec : list) {
				EmergencyContactDTO eDto = converter.convertFrom(ec);
				dtoList.add(eDto);
			}
		}

		return dtoList;
	}

	@Override
	public ResponseUtil findResponseByUserProfileId(Long id) {
		log.debug("findResponseByUserProfileId id=" + id);

		ResponseUtil response = new ResponseUtil();

		List<EmergencyContactDTO> list = findByUserProfileId(id);
		response.setPojoObject(list);
		response.setSuccess(true);
		return response;
	}

	@Override
	public EmergencyContactDTO getEmergencyContact(Long emergencyContactId) {
		EmergencyContactDTO emergencyContactDTO = null;
		EmergencyContact emergencyContact = emergencyContactRepository.findByEmergencyContactId(emergencyContactId);
		emergencyContactDTO = converter.convertFrom(emergencyContact);
		return emergencyContactDTO;
	}

}
