package gov.va.med.mhv.usermgmt.main.service.impl;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;

import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.usermgmt.common.dto.DirectMessageDTO;
import gov.va.med.mhv.usermgmt.service.EmailService;

//@Component
//@Scope("request")
//@PropertySource("classpath:${MHV_ENV_PROPERTY}.usermgmt.properties")
public class EmailServiceImpl implements EmailService {
	
//	 @Value("${direct.messageurl}")
//	    private String directMessageurl;
//	 
//	 @Value("${direct.sendurl}")
//	    private String directSendurl;
	 
	public boolean send(String from, String fromName, String subject, String message, String to, String messageContentType) {
        HttpURLConnection connDirect = null;
        boolean completed = false;
        try {
            URL urlDirect = new URL("https://api.demo.direct.DNS   /direct/send/format/json");

            connDirect = (HttpURLConnection)urlDirect.openConnection();
            java.util.Date dt = new java.util.Date();
            SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss z");
            String dstr = sdf.format(dt);
            //String reqstr = "POST\n" + dstr + "\n" + directSendpath;
            //Mac sha256_HMAC = Mac.getInstance("HmacSHA256");
            //SecretKeySpec secret_key = new SecretKeySpec((directPrivatekey).getBytes(),"HmacSHA256");
            //sha256_HMAC.init(secret_key);
            //byte[] sha = sha256_HMAC.doFinal(reqstr.getBytes());
            //String encsha = new sun.misc.BASE64Encoder().encode(sha);
            //String auth = "DAAS " + (directPublickey) + ":" + encsha;
            //connDirect.setRequestProperty("Authorization", auth);
            connDirect.setRequestProperty("Date", dstr);
            String charset = "UTF-8";
            String boundary = Long.toString(System.currentTimeMillis(), 16);
            String lineEnd = "\r\n";
            String twoHyphens = "";

            // Allow Inputs
            connDirect.setDoInput(true);

            // Allow Outputs
            connDirect.setDoOutput(true);

            // Don't use a cached copy.
            connDirect.setUseCaches(false);

            // Use a post method.
            connDirect.setRequestMethod("POST");

            connDirect.setRequestProperty("Connection", "Keep-Alive");
            connDirect.setRequestProperty("Accept-Charset", charset);
            connDirect.setRequestProperty("Charset", charset);
            connDirect.setRequestProperty("ENCTYPE", "multipart/form-data");
            connDirect.setRequestProperty("Cache-Control", "no-cache");
            connDirect.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary); //boundary was misspelled here as boundry

            String newBody = "";
            DataOutputStream ds = new DataOutputStream(connDirect.getOutputStream());
//            if(body!=null){
//            	String firstLast = getFirstName() + " " + getLastName();
//            	newBody = body.replace("[vvv]", firstLast);
//            }

       		//put plain text post data into an array so we can build the raw request
            Map<String, String> post_fields = new HashMap<String, String>();
            post_fields.put("sender",from);
            post_fields.put("to",to);
            //if (cc != null && cc.length() > 0) {post_fields.put("cc",cc); }
            if (subject != null && subject.length() > 0) { post_fields.put("subject",subject); }
            if (newBody != null && newBody.length() > 0) { post_fields.put("body",newBody); }
            //if (mailtype != null && mailtype.length() > 0) { post_fields.put("mailtype",mailtype); }
            //if (priority != null && priority.length() > 0) { post_fields.put("priority",priority); }

          //setRequestProperty seems to set headers for the overall request, but the POST body comes after those
    		//so loop through normal POST fields and add to raw request body instead
    		for(Map.Entry<String, String> entry : post_fields.entrySet()) {
    			ds.writeBytes(twoHyphens + boundary + lineEnd);
    			ds.writeBytes("Content-Disposition: form-data; name=\""+entry.getKey()+"\"" + lineEnd + lineEnd + entry.getValue() + lineEnd);
    		}
    		//add last boundary for normal fields
    		ds.writeBytes(twoHyphens + boundary + lineEnd);

    		//if you have more than one file loop through them here
    		int i = 1;
    		//for(String filename: files.keySet()) {
    			 //ds.writeBytes("Content-Disposition: form-data; name=\"files"+i+"\";filename=\"" + filename +"\"" + lineEnd);
    			//added generic content type for the file and specified transfer encoding, this appears to be necessary for files
    			//ds.writeBytes("Content-Type: application/octet-stream" + lineEnd);
    			//ds.writeBytes("Content-Transfer-Encoding: binary" + lineEnd);
    			//ds.writeBytes(lineEnd);
    			//ds.write(files.get(filename));
    			//if(i < files.size()) { ds.writeBytes(twoHyphens + boundary + lineEnd); } //if not last file, write a (non-final) boundary
    			i++;
    		//}
    		//final boundary for the POST request (hyphens before and after)
    		ds.writeBytes(twoHyphens + boundary + twoHyphens + lineEnd);

    		ds.flush();
    		ds.close();
    		completed = true;

//            if (connDirect.getResponseCode() == 200 ) {
//            	BufferedReader br = new BufferedReader(new InputStreamReader((connDirect.getInputStream())));
//                String output;
//                String resp = "";
//                while ((output = br.readLine()) != null) {
//                    resp += output;
//                }
//
//                String messageId = "";
//                String messageStatus = "";
//                if(resp.indexOf("\"id")>0){
//                	messageId = resp.substring(resp.indexOf("\"id\":\"")+6, resp.indexOf("\",\"message"));
//                	messageStatus = resp.substring(resp.indexOf("\"message\":\"")+11, resp.indexOf(".\"}"));
//
//                	DirectMessageDTO directMessageRecord = new DirectMessageDTO();
//                	directMessageRecord.setMessageId(messageId);
//                	directMessageRecord.setSentToEmailAddress(to);
//                	directMessageRecord.setUserProfileId(this.getUserProfileId());
//                	directMessageRecord.setDirectMessageStatus(messageStatus);
//                	Calendar calendar = Calendar.getInstance();
//                    java.sql.Timestamp ourJavaTimestampObject = new java.sql.Timestamp(calendar.getTime().getTime());
//                    directMessageRecord.setCreatedDate(ourJavaTimestampObject);
//                    directMessageServiceProxy.saveDirectMessage(directMessageRecord);
//                }else{
//                	//System.out.println("$$$$$No Request ID in the response$$$$$");
//                }
//    			rtc = CCD_VIA_DIRECT_SUCCESS;
    			//TODO: new helper method to support activityDTOForSystem and dynamic detail
    			//acctActCreatorService.createAccountActivityLog(ActivityHelper.createActivityDTOForSelf(getUserProfileId(), false, ActivityTypeEnumeration.DOWNLOAD, ActivityActionTypeEnumeration.VA_HEALTH_SUMMARY_DOWNLOAD_REQUESTED, ""));
    			//Auditor.auditShareCCDRequestEvent(getCurrentUserId(),ActivityActorTypeEnumeration.SYSTEM,true, ActivityActionTypeEnumeration.MESSAGE_SENT, "Request to send VA Health Summary to " + to + " completed");
//            }else if(connDirect.getResponseCode() == 400){
//				
//            	rtc = CCD_VIA_DIRECT_INVALID_DIRECT_ADDR;
//            	//TODO: new helper method to support activityDTOForSystem and dynamic detail
//            	//Auditor.auditShareCCDRequestEvent(getCurrentUserId(),ActivityActorTypeEnumeration.SYSTEM,false, ActivityActionTypeEnumeration.MESSAGE_SENT, "Request to send VA Health Summary to " + to + " completed");
//            }else{
//            	//TODO: new helper method to support activityDTOForSystem and dynamic detail
//            	//Auditor.auditShareCCDRequestEvent(getCurrentUserId(),ActivityActorTypeEnumeration.SYSTEM,false, ActivityActionTypeEnumeration.MESSAGE_SENT, "Request to send VA Health Summary to " + to + " completed");
//            	throw new RuntimeException("\nFailed : HTTP error code : " + connDirect.getResponseCode() + "\nHTTP response : " + connDirect.getResponseMessage());
//            }
        //} catch (NoSuchAlgorithmException e) {
        //    e.printStackTrace();
        //} catch (InvalidKeyException e) {
        //    e.printStackTrace();
        } catch (MalformedURLException e) {
        	completed = false;
            e.printStackTrace();
        } catch (IOException e) {
        	completed = false;
            e.printStackTrace();
        } finally {
            if (connDirect != null) {
            	connDirect.disconnect();
            }
        }
        //return rtc;
        return completed;
    }

}
