package gov.va.med.mhv.usermgmt.main.service.impl;

import java.sql.Timestamp;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.dto.ActivitySearchCriteriaDTO;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.PerformerTypeEnumeration;
import gov.va.med.mhv.usermgmt.converter.ActivityDTOConverter;
import gov.va.med.mhv.usermgmt.converter.ActivityListConverter;
import gov.va.med.mhv.usermgmt.data.model.Activity;
import gov.va.med.mhv.usermgmt.data.repository.ActivityRepository;
import gov.va.med.mhv.usermgmt.data.repository.UserProfileRepository;
import gov.va.med.mhv.usermgmt.main.service.validator.ActivityValidator;
import gov.va.med.mhv.usermgmt.service.AccountActivityLogService;
import gov.va.med.mhv.usermgmt.service.ActivityService;

public class ActivityServiceImpl implements ActivityService, AccountActivityLogService {

	protected static Logger log = LogManager.getLogger(ActivityServiceImpl.class);

	@Autowired
	private ActivityRepository activityRepository;

	@Autowired
	private UserProfileRepository userProfileRepository;

	@Autowired
	private ActivityListConverter activitiesConverter;

	@Autowired
	private ActivityDTOConverter activityDTOConverter;

	@Autowired
	private ActivityValidator validator;

	@Transactional
	public boolean createLoginActivity(String userName, Long userProfileId,Boolean loginStatus) {
		boolean success = true;

		if (null == userProfileId | null == loginStatus) {
			success = false;
			return success;
		}
		try {
			if(!loginStatus){
				Activity loginAuditRow = new Activity();
				loginAuditRow.setAction(ActivityActionTypeEnumeration.LOGIN_WITH_MY_HEALTHEVET.getDescription());
				loginAuditRow.setActivityType(ActivityActionTypeEnumeration.LOGIN.getDescription());
				loginAuditRow.setUserProfileId(userProfileId);
				loginAuditRow.setStatus(loginStatus);
				loginAuditRow.setPerformerType(PerformerTypeEnumeration.valueOf("Self").toString());
				loginAuditRow.setDetailValue("None");
				loginAuditRow.setCompletionTime(new Date());
				activityRepository.save(loginAuditRow);
			}else{
				List<Activity> loginActivities = activityRepository.getLoginActivities(userProfileId);
				Activity loginActivity = loginActivities.get(0);
				if(!loginActivity.getStatus()){
					loginActivity.setStatus(loginStatus);
					activityRepository.save(loginActivity);
				}
			}
		} catch (Exception e) {
			success = false;
			log.error("Exception caught creating Login Activity", e);
		}
		return success;
	}

	
	@Override
	@Transactional
	public void auditOnlineAuthenticationEvent(Long subjectId, Boolean successful, String activityName, String actionName, String detail, ResponseUtil response){
		try {
			Activity userProfileAudit = new Activity();

			userProfileAudit.setAction(actionName);
			userProfileAudit.setActivityType(activityName);
			userProfileAudit.setCompletionTime(new Timestamp(System.currentTimeMillis()));
			userProfileAudit.setPerformerType(ActivityActorTypeEnumeration.SELF.getDescription());
			userProfileAudit.setUserProfileId(subjectId);
			if(detail != null) {
				userProfileAudit.setDetailValue(abbreviateString(detail,255));
			}
			userProfileAudit.setStatus(successful);

			activityRepository.save(userProfileAudit);
		} catch (Exception e) {
			log.error("Exception caught in auditing user profile", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
	}
	
	
	
	@Override
	@Transactional
	public void auditDSLogonMappingEvent(Long subjectId, Boolean successful, String actor, String activityType, String actionType, ResponseUtil response){
		try {
			Activity userProfileAudit = new Activity();

			userProfileAudit.setAction(actionType);
			userProfileAudit.setActivityType(activityType);
			userProfileAudit.setCompletionTime(new Timestamp(System.currentTimeMillis()));
			userProfileAudit.setPerformerType(actor);
			userProfileAudit.setUserProfileId(subjectId);
			userProfileAudit.setDetailValue("");
			userProfileAudit.setStatus(successful);

			activityRepository.save(userProfileAudit);
		} catch (Exception e) {
			e.printStackTrace();
			log.error("Exception caught in auditing user profile", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
	}

	@Override
		@Transactional
		public void auditDSLogonActivity(Long subjectId, Boolean successful, String actor, String actionType, String activityDetailValue, ResponseUtil response){
			try {
				Activity userProfileAudit = new Activity();
	
				userProfileAudit.setAction(ActivityActionTypeEnumeration.LOGIN_WITH_DSLOGON.getDescription());
				userProfileAudit.setActivityType(actionType);
				userProfileAudit.setCompletionTime(new Timestamp(System.currentTimeMillis()));
				userProfileAudit.setPerformerType(actor);
				userProfileAudit.setUserProfileId(subjectId);
				if(activityDetailValue != null) {
					userProfileAudit.setDetailValue(abbreviateString(activityDetailValue,255));
				}
				userProfileAudit.setStatus(successful);
	
				activityRepository.save(userProfileAudit);
			} catch (Exception e) {
				e.printStackTrace();
				log.error("Exception caught in auditing user profile", e);
				response.setSuccess(false);
				response.setFailure(true);
				response.setFailureMessage(e.getMessage());
			}
	}	
	
	@Override
	public void createAccountActivityLog(ActivityDTO activity,
			ResponseUtil response) throws MHVException {
		createAccountActivityLog(activity);
		
	}
	
	//JAZZ#32762 US02 The MHV System shall create an AAL entry for the onlineupgrade process.
	@Override
	@Transactional
	public void auditManualAuthenticationEvent(Long subjectId, Boolean successful, String actionName, String detail, ResponseUtil response){
		try {
			Activity userProfileAudit = new Activity();

			userProfileAudit.setAction(actionName);
			userProfileAudit.setActivityType(ActivityTypeEnumeration.ACCOUNT_UPGRADE.getDescription());
			userProfileAudit.setCompletionTime(new Timestamp(System.currentTimeMillis()));
			userProfileAudit.setPerformerType(ActivityActorTypeEnumeration.SELF.getDescription());
			userProfileAudit.setUserProfileId(subjectId);
			if(detail != null) {
				userProfileAudit.setDetailValue(abbreviateString(detail,255));
			}
			userProfileAudit.setStatus(true);

			activityRepository.save(userProfileAudit);
		} catch (Exception e) {
			log.error("Exception caught in auditing user profile", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
	}
	
	@Override
	@Transactional
	public void auditUpgradeEvent(Long subjectId, String actor, String actionType, String activityDetailValue, ResponseUtil response){
		try {
			Activity userProfileAudit = new Activity();

			userProfileAudit.setAction(ActivityActionTypeEnumeration.ACCOUNT_UPGRADE_REQUESTED.getDescription());
			userProfileAudit.setActivityType(actionType);
			userProfileAudit.setCompletionTime(new Timestamp(System.currentTimeMillis()));
			userProfileAudit.setPerformerType(actor);
			userProfileAudit.setUserProfileId(subjectId);
			if(activityDetailValue != null) {
				userProfileAudit.setDetailValue(abbreviateString(activityDetailValue,255));
			}
			userProfileAudit.setStatus(true);

			activityRepository.save(userProfileAudit);
		} catch (Exception e) {
			log.error("Exception caught in auditing user profile", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
	}
	
	@Override
	@Transactional
	public void auditUpdateProfileEvent(Long userProfileId, ActivityActorTypeEnumeration actor, ResponseUtil response) {

		try {
			Activity userProfileAudit = new Activity();

			userProfileAudit.setAction(ActivityActionTypeEnumeration.UPDATE.getDescription());
			userProfileAudit.setActivityType(ActivityTypeEnumeration.PROFILES.getDescription());
			userProfileAudit.setCompletionTime(new Timestamp(System.currentTimeMillis()));
			userProfileAudit.setPerformerType(actor.getDescription());
			userProfileAudit.setUserProfileId(userProfileId);
			userProfileAudit.setDetailValue("Update MHV User Profile");
			userProfileAudit.setStatus(Boolean.TRUE);

			activityRepository.save(userProfileAudit);
		} catch (Exception e) {
			log.error("Exception caught in auditing user profile", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
	}
	
	@Override
	@Transactional
	public void createUserActivity(Boolean status, String action, String activityType, ResponseUtil response, Long userProfileId){
		
		log.debug("Creating Account Activity Log - Forgot USERID and Password");
		
		try {
			Activity recoverActivity = new Activity();
			recoverActivity.setAction(action);
			recoverActivity.setActivityType(activityType);
			recoverActivity.setStatus(status);
			recoverActivity.setPerformerType("Self");
			recoverActivity.setCompletionTime(new Date());
			recoverActivity.setUserProfileId(userProfileId);
			activityRepository.save(recoverActivity);
		}  catch (Exception e) {
			log.error("Exception caught in auditing Change Password", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
		if (log.isDebugEnabled()) {
			log.debug("audir change password is successful...");
		}
	}

	@Override
	@Transactional
	public void auditRegistrationEvent(UserProfile userProfile, ResponseUtil response) {
		if (log.isDebugEnabled()) {
			log.debug("inside auditRegistrationEvent......");
		}

		try {
			Activity activity = new Activity();

			activity.setAction(ActivityActionTypeEnumeration.ACCOUNT_CREATED.getDescription());
			activity.setActivityType(ActivityTypeEnumeration.REGISTRATION.getDescription());
			activity.setCompletionTime(new Timestamp(System.currentTimeMillis()));
			activity.setPerformerType(ActivityActorTypeEnumeration.SELF.getDescription());
			activity.setUserProfileId(userProfile.getId());
			activity.setDetailValue("User Registration");
			activity.setStatus(Boolean.TRUE);

			activityRepository.save(activity);
		} catch (Exception e) {
			log.error("Exception caught in auditing user profile", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
		if (log.isDebugEnabled()) {
			log.debug("auditRegistrationEvent is successful...");
		}
	}

	@Override
	@Transactional
	public void auditMviEvent(
		UserProfile userProfile, ActivityActorTypeEnumeration actor, Boolean successful, ActivityActionTypeEnumeration activityActionType,
		ActivityTypeEnumeration activityType, ResponseUtil response) {
		try {
			Activity activity = new Activity();

			activity.setAction(activityActionType.getDescription());
			activity.setActivityType(activityType.getDescription());
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(actor.getDescription());
			activity.setUserProfileId(userProfile.getId());
			activity.setStatus(successful);
			activity.setDetailValue("Austin MHV");

			activityRepository.save(activity);
		} catch (Exception e) {
			log.error("Exception caught in auditing user profile", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
	}

	@Override
	@Transactional
	public void auditUpdateEmailProfileEvent(Long userProfileId, String actor, String action, ResponseUtil response) {
		try {
			Activity activity = new Activity();
			activity.setAction(action);
			activity.setActivityType(ActivityTypeEnumeration.PROFILES.getDescription());
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(actor);
			activity.setStatus(Boolean.TRUE);
			activity.setUserProfileId(userProfileId);

			activityRepository.save(activity);
		} catch (Exception e) {
			log.error("Exception caught in auditing user profile", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
	}

	@Override
	@Transactional
	public void auditUpdateEmailProfileEvent(Long userProfileId, String actor, String action, ResponseUtil response, String activityDetails) {
		try {
			Activity activity = new Activity();
			activity.setAction(action);
			if(activityDetails != null) {
				activity.setDetailValue(abbreviateString(activityDetails,255));
			}
			activity.setActivityType(ActivityTypeEnumeration.PROFILES.getDescription());
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(actor);
			activity.setStatus(Boolean.TRUE);
			activity.setUserProfileId(userProfileId);

			activityRepository.save(activity);
		} catch (Exception e) {
			log.error("Exception caught in auditing user profile", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
	}

	@Override
	@Transactional
	public void auditMviEvent(
		UserProfile userProfile, String actor, Boolean successful, ActivityActionTypeEnumeration activityActionType, ActivityTypeEnumeration activityType,
		ResponseUtil response) {
		auditMviEvent(userProfile, ActivityActorTypeEnumeration.fromString(actor), successful, activityActionType, activityType, response);
	}

	@Override
	@Transactional
	public void getActivitiesForSubject(ActivitySearchCriteriaDTO searchCriteria, ResponseUtil<List<ActivityDTO>> response) {
		try {
			response.setValidationErrors(new LinkedHashMap<String, String>());
			validator.activitySearchValidations(response, searchCriteria);
			if (response.getValidationErrors().size() == 0) {
				List<Activity> activities = null;

				if (searchCriteria.getPerformerType().equals(ActivityActorTypeEnumeration.EVERYONE.getDescription())) {
					activities =
						activityRepository.getActivitiesEveryone(searchCriteria.getFromDate(), searchCriteria.getToDate(), searchCriteria.getUserName());
				} else if (searchCriteria.getPerformerType().equals(ActivityActorTypeEnumeration.EVERYONE_BUT_SELF.getDescription())) {
					activities =
						activityRepository.getActivitiesEveryoneButSelf(searchCriteria.getFromDate(), searchCriteria.getToDate(), searchCriteria.getUserName());
				} else {
					activities =
						activityRepository.getActivitiesForSubject(
							searchCriteria.getFromDate(), searchCriteria.getToDate(), searchCriteria.getPerformerType(), searchCriteria.getUserName());
				}


				response.setPojoObject(activitiesConverter.convert(activities));
				response.setSuccess(true);
			}
		} catch (Exception e) {
			log.error("Exception caught in get activities", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
	}

	@Override
	@Transactional
	public void auditAccountDeactivateEauthHashEvent(UserProfile userProfile, ResponseUtil response) {
		try {
			Activity activity = new Activity();
			activity.setAction(ActivityActionTypeEnumeration.ACCOUNT_DISCONNECTED.getDescription());
			activity.setActivityType(ActivityTypeEnumeration.DSLOGON_CAC_USAA_ORC.getDescription());
			activity.setCompletionTime(new Timestamp(System.currentTimeMillis()));
			activity.setPerformerType(ActivityActorTypeEnumeration.SELF.getDescription());
			activity.setUserProfileId(userProfile.getId());
			activity.setDetailValue("Deactivation");
			activity.setStatus(Boolean.TRUE);

			activityRepository.save(activity);
		} catch (Exception e) {
			log.error("Exception caught in auditing Account Deactivate Auth Hash Event", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
	}

	@Override
	@Transactional
	public void auditMviLoginEvent(
		UserProfile userProfile, ActivityActorTypeEnumeration actor, Boolean successful, ActivityActionTypeEnumeration activityActionType, ResponseUtil response) {
		try {
			Activity activity = new Activity();

			activity.setAction(activityActionType.getDescription());
			activity.setActivityType(ActivityTypeEnumeration.LOGIN_LOGOUT.getDescription());
			activity.setCompletionTime(new Timestamp(System.currentTimeMillis()));
			activity.setPerformerType(actor.getDescription());
			activity.setUserProfileId(userProfile.getId());
			activity.setDetailValue("Austin MHV");
			activity.setStatus(successful);

			activityRepository.save(activity);
		} catch (Exception e) {
			log.error("Exception caught in auditing auditMviLoginEvent", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
	}

	@Override
	@Transactional
	public void auditAccountUpgradeEvent(UserProfile userProfile, Boolean successful, ActivityActorTypeEnumeration performer, ResponseUtil response) {
		try {
			Activity activity = new Activity();

			activity.setAction(ActivityActionTypeEnumeration.UPGRADE_TO_ADVANCED.getDescription());
			activity.setActivityType(ActivityTypeEnumeration.ACCOUNT_UPGRADE.getDescription());
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(performer.getDescription());
			activity.setUserProfileId(userProfile.getId());
			activity.setStatus(successful);
			activity.setDetailValue("Austin MHV");

			activityRepository.save(activity);
		} catch (Exception e) {
			log.error("Exception caught in auditing auditAccountUpgradeEvent", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
	}

	/**
	 * MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - AAL impl -->
	 */
	@Override
	@Transactional
	public void auditMviUnauthenticateRequestEvent(UserProfile userProfile, ActivityActorTypeEnumeration actor, Boolean successful, ResponseUtil response) {
		try {
			Activity activity = new Activity();

			activity.setAction(ActivityActionTypeEnumeration.UNAUTHENTICATION_REQUEST.getDescription());
			activity.setActivityType(ActivityTypeEnumeration.ACCOUNT_UPGRADE.getDescription());
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(actor.getDescription());
			activity.setUserProfileId(userProfile.getId());
			activity.setStatus(successful);
			activity.setDetailValue(null);

			activityRepository.save(activity);
		} catch (Exception e) {
			log.error("Exception caught in auditing auditMviUnauthenticateRequestEvent", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}

	}

	/**
	 * MHV_CodeCR1514 - US12.4 MVI Compliance Implementation - AAL impl -->
	 */
	@Override
	@Transactional
	public void auditMviCorrelateEvent(UserProfile userProfile, ActivityActorTypeEnumeration actor, Boolean successful, ResponseUtil response) {
		try {
			Activity activity = new Activity();

			activity.setAction(ActivityActionTypeEnumeration.CONNECTED_TO_VA_RECORD.getDescription());
			activity.setActivityType(ActivityTypeEnumeration.ACCOUNT_UPGRADE.getDescription());
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(actor.getDescription());
			activity.setUserProfileId(userProfile.getId());
			activity.setStatus(successful);
			activity.setDetailValue("Austin MHV");

			activityRepository.save(activity);
		} catch (Exception e) {
			log.error("Exception caught in auditing auditMviCorrelateEvent", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
	}

	@Override
	@Transactional
	public void auditAccountDeactivateEvent(UserProfile userProfile, ActivityActorTypeEnumeration actor, Boolean successful, ResponseUtil response) {
		try {
			Activity activity = new Activity();

			activity.setAction(ActivityActionTypeEnumeration.DEACTIVATE.getDescription());
			activity.setActivityType(ActivityTypeEnumeration.ACCOUNT_MANAGEMENT.getDescription());
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(actor.getDescription());
			activity.setUserProfileId(userProfile.getId());
			activity.setStatus(successful);
			activity.setDetailValue(null);

			activityRepository.save(activity);
		} catch (Exception e) {
			log.error("Exception caught in auditing auditAccountDeactivateEvent", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
	}

	@Override
	@Transactional
	public boolean createLogoutActivity(String userName, Long userProfileId) {
		boolean success = true;

		if (null == userName | null == userProfileId) {
			success = false;
			return success;
		}
		try {
			Activity loginAuditRow = new Activity();
			loginAuditRow.setAction(ActivityActionTypeEnumeration.LOGOUT_WITH_MY_HEALTHEVET.getDescription());
			loginAuditRow.setActivityType(ActivityActionTypeEnumeration.LOGOUT.getDescription());
			loginAuditRow.setUserProfileId(userProfileId);
			loginAuditRow.setStatus(Boolean.TRUE);
			loginAuditRow.setPerformerType(PerformerTypeEnumeration.valueOf("Self").toString());
			loginAuditRow.setDetailValue("None");
			loginAuditRow.setCompletionTime(new Date());
			activityRepository.save(loginAuditRow);
		} catch (Exception e) {
			success = false;
			log.error("Exception caught creating Logout Activity", e);
		}
		return success;

	}

	@Override
	@Transactional
	public void auditDownloadDataRequestEvent(long userProfileId, ActivityActorTypeEnumeration actor, boolean successful, ActivityActionTypeEnumeration activityActionType, ResponseUtil response){
		try {
			Activity activity = new Activity();
			activity.setAction(activityActionType.getDescription());
			activity.setActivityType(ActivityTypeEnumeration.DOWNLOAD.getDescription());
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(actor.getDescription());
			activity.setUserProfileId(userProfileId);
			activity.setStatus(successful);
			activityRepository.save(activity);
		} catch (Exception e) {
			log.error("Exception caught in auditing auditDownloadDataRequestEvent", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
	}

	@Override
	public void createAccountActivityLog(ActivityDTO activity) throws MHVException {
		try {
			this.activityRepository.save(this.activityDTOConverter.convert(activity));
		} catch (Exception ex) {
			String message = "Error creating activity log entry.";
			log.error(message, ex);
			throw new MHVException(message, ex);
		}
	}

	@Override
	public List<ActivityDTO> getAccountActvity(ActivitySearchCriteriaDTO activitySearchCriteria) throws MHVException {

		ResponseUtil<List<ActivityDTO>> response = new ResponseUtil<List<ActivityDTO>>();

		try {
			this.getActivitiesForSubject(activitySearchCriteria, response);
			if(response.isSuccess()) {
				return response.getPojoObject();
			}
			else {
				throw new MHVException(response);
			}
		} catch (MHVException ex) {
			throw ex;
		} catch (Exception ex) {
			String message = "Error getting account actviity for user.";
			log.error(message);
			throw new MHVException(message, ex);
		}
	}

	@Transactional
	public void auditShareDataWithHRAEvent(String userName) throws MHVException {
		log.debug(" DEBUG SERVER -- Create HRA Event Activity ");
		try {
			UserProfile profile = userProfileRepository.findByUserName(userName);

			if (null == profile) {
				throw new MHVException("UserProfile is null");
			}

			this.auditShareDataWithHRAEvent(profile.getId(),
					ActivityActorTypeEnumeration.SELF,
					true, true,
					ActivityActionTypeEnumeration.ACCESS_HEALTHELIVING_ASSESSMENT.getDescription());

		} catch (Exception e) {
			log.error("Exception Caught in logging HRA Event Activity", e);
			throw new MHVException("Exception Caught in logging HRA Event Activity", e);
		}
	}

	private void auditShareDataWithHRAEvent(Long userProfileId, ActivityActorTypeEnumeration actor, boolean accept, Boolean successful, String activityActionType){
		try {
			Activity activity = new Activity();

			if (accept) {
				activity.setAction(ActivityActionTypeEnumeration.CONTINUE.getDescription());
			} else {
				activity.setAction(ActivityActionTypeEnumeration.CANCEL.getDescription());
			}
			activity.setActivityType(ActivityTypeEnumeration.SHARE.getDescription());
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(actor.getDescription());
			activity.setUserProfileId(userProfileId);
			activity.setStatus(successful);
			if(activityActionType != null) {
				activity.setDetailValue(abbreviateString(activityActionType,255));
			}
			activityRepository.save(activity);
		} catch (Exception e) {
			log.error("Exception caught in auditing auditShareDataWithHRAEvent", e);
		}
	}


	@Override
	public void auditViewAppointments(String userName,	Long userProfileId) {

		Activity viewAppointments = new Activity();
		viewAppointments.setAction(ActivityActionTypeEnumeration.VIEW.getDescription());
		viewAppointments.setActivityType(ActivityActionTypeEnumeration.APPOINTMENTS.getDescription());
		UserProfile userProfile= userProfileRepository.findOne(userProfileId);
		viewAppointments.setUserProfileId(userProfile.getId());
		viewAppointments.setStatus(Boolean.TRUE);
		viewAppointments.setPerformerType(PerformerTypeEnumeration.valueOf("Self").toString());
		viewAppointments.setCompletionTime(new Date());
		activityRepository.save(viewAppointments);
	}

	@Override
	public void auditUpdateEmailProfileEvent(Long subjectId, String actor, String action) {
		// TODO Auto-generated method stub

	}
	
	@Override
	public void auditNotificationEvent(Long subjectId, Boolean successful, ActivityActionTypeEnumeration activityActionType, String activityActionDetail){
		Activity activity = new Activity();
		activity.setAction(activityActionType.toString());
		if(activityActionDetail != null) {
			activity.setDetailValue(abbreviateString(activityActionDetail,255));
		}
		activity.setActivityType(ActivityTypeEnumeration.NOTIFICATIONS.getDescription());
		activity.setCompletionTime(new Timestamp(new Date().getTime()));
		activity.setPerformerType(PerformerTypeEnumeration.valueOf("System").toString());
		activity.setUserProfileId(subjectId);
		activity.setStatus(successful);
		activityRepository.save(activity);
	}
	
	@Override
	public void auditSendVAHealthSummaryEvent(Long subjectId, Boolean successful, ActivityActionTypeEnumeration activityActionType, String activityActionDetail){
		Activity activity = new Activity();
		activity.setAction(activityActionType.toString());
		if(activityActionDetail != null) {
			activity.setDetailValue(abbreviateString(activityActionDetail,255));
		}
		activity.setActivityType(ActivityTypeEnumeration.SEND_VA_HEALTH_SUMMARY.getDescription());
		activity.setCompletionTime(new Timestamp(new Date().getTime()));
		activity.setPerformerType(PerformerTypeEnumeration.valueOf("System").toString());
		activity.setUserProfileId(subjectId);
		activity.setStatus(successful);
		activityRepository.save(activity);
	}
	
	@Override
	public void auditMviEvent(Long subjectId, String actor, Boolean successful, String activityActionType, String activityType, ResponseUtil response){
		try {
			Activity activity = new Activity();

			activity.setAction(activityActionType);
			activity.setActivityType(activityType);
			activity.setCompletionTime(new Date());
			activity.setPerformerType(actor);
			activity.setUserProfileId(subjectId);
			activity.setStatus(successful);
			activity.setDetailValue(null);

			activityRepository.save(activity);
		} catch (Exception e) {
			log.error("Exception caught in auditing auditMviUnauthenticateRequestEvent", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
		
	}


	@Override
	public void auditDSLogonMappingActivity(Long subjectId, Boolean successful,
			String actor, String actionType, String activityDetailValue,
			ResponseUtil response) {
		
		try {
			Activity activity = new Activity();
			activity.setAction(actionType);
			if(activityDetailValue != null) {
				activity.setDetailValue(abbreviateString(activityDetailValue,255));
			}
			activity.setActivityType(ActivityActionTypeEnumeration.LOGIN.getDescription());
			activity.setCompletionTime(new Timestamp(new Date().getTime()));
			activity.setPerformerType(actor);
			activity.setUserProfileId(subjectId);
			activity.setStatus(successful);
			activityRepository.save(activity);
		} catch(Exception e){
			log.error("Exception caught in auditing auditDSLogonMappingActivity", e);
			response.setSuccess(false);
			response.setFailure(true);
			response.setFailureMessage(e.getMessage());
		}
		
	}
	
	@Override
	public void createFailedLoginActivity(Long userProfileId) throws MHVException{
		boolean loginActivity= createLoginActivity(null, userProfileId, Boolean.FALSE);
		if(!loginActivity){
			String errorMessage = "Exception Caught Creatring Failed login Activity";
			throw new MHVException(errorMessage);
		}
	}
	
	private static String abbreviateString(String input, int maxLength) {
	    if (input.length() <= maxLength) 
	        return input;
	    else 
	        return input.substring(0, maxLength-2) + "..";
	}

}
