/**
 *
 */
package gov.va.med.mhv.usermgmt.main.service.impl;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.dto.FacilityInfoDTO;
import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTO;
import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTOLight;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.enumeration.ErrorEnum;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.common.data.converter.FacilityInfoConveter;
import gov.va.med.mhv.common.data.converter.InPersonAuthenticationConverter;
import gov.va.med.mhv.common.data.converter.InPersonAuthenticationLightConverter;
import gov.va.med.mhv.common.data.converter.PatientConverter;
import gov.va.med.mhv.common.data.converter.UserProfileConverter;
import gov.va.med.mhv.common.data.model.FacilityInfo;
import gov.va.med.mhv.common.data.model.InPersonAuthentication;
import gov.va.med.mhv.common.data.model.InPersonAuthenticationLight;
import gov.va.med.mhv.common.data.model.Patient;
import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.dto.EauthHashDTO;
import gov.va.med.mhv.usermgmt.service.AccountValidatorService;
import gov.va.med.mhv.usermgmt.service.ActivityService;
import gov.va.med.mhv.usermgmt.service.FacilityInfoService;
import gov.va.med.mhv.usermgmt.service.InPersonAuthenticationService;
import gov.va.med.mhv.usermgmt.service.MviAsyncIntegrationService;
import gov.va.med.mhv.usermgmt.service.MviIntegrationService;
import gov.va.med.mhv.usermgmt.service.PatientService;
import gov.va.med.mhv.usermgmt.service.UserPasswordService;
import gov.va.med.mhv.usermgmt.service.UserProfileService;
import gov.va.med.mhv.usermgmt.service.handler.MviProperties;

/**
 * @author DNS   egberb
 *
 */
@Component
public class AccountValidatorServiceImpl implements AccountValidatorService {
    private static final String VERSION_INFO_ID = "^PI^200MH^USVHA";
	private static Logger log = LogManager.getLogger(AccountValidatorServiceImpl.class);

	@Autowired
	private MviProperties mviProperties;

	@Autowired
	private UserProfileService userProfileService;

	@Autowired
	private PatientService patientService;

	@Autowired
	private MviIntegrationService mviIntegrationService;

	@Autowired
	private MviAsyncIntegrationService	mviAsyncIntegrationService;

	@Autowired
	private InPersonAuthenticationService inPersonAuthenticationService;

	@Autowired
	private FacilityInfoService facilityInfoService;

	@Autowired
	private ActivityService activityService;

	@Autowired
	private UserPasswordService userPasswordService;

	@Autowired
	private PatientConverter patientConverter;

	@Autowired
	private InPersonAuthenticationConverter inPersonAuthenticationConverter;

	@Autowired
	private InPersonAuthenticationLightConverter inPersonAuthenticationLightConverter;

	@Autowired
	private UserProfileConverter userProfileConverter;


	@Override
	public String getVapiiFormUrl() {
		return mviProperties.getVapiiFormurl();
	}

	/* (non-Javadoc)
	 * @see gov.va.med.mhv.usermgmt.service.ActiveUserCheckerService#isUserActive(java.lang.String)
	 */
	@Override
	public Boolean isUserInactive(String userName) throws MHVException {
		try {
			// By definition, an inactive user is a user that exists in the system but whose
			UserProfileDTO userprofile = this.userProfileService.getUserProfileByUserName(userName);
			return (userprofile != null && userprofile.getId()!= null && userprofile.getDeactivationReason() != null);
		} catch (RuntimeException e) {
			if("Invalid User".equalsIgnoreCase(e.getMessage())) {
				// This is expected - If we get a RuntimeException with the message
				// "Invalid User" in the error message, the user is not known by the system
				// but is still not inactive.
				return false;
			}

			throw new MHVException(e);
		} catch (Throwable t) {
			throw new MHVException(t);
		}
	}

	@Override
	public void saveHash(Long userProfileId, String ahash){
		log.info("(*&*&*(& ahash:"+ahash);
		log.info("(*&*&*(& userProfileId:"+userProfileId.toString());
		ResponseUtil<List<EauthHashDTO>> response = this.userProfileService.saveHash(userProfileId, ahash);
	}

//	@Override
//	public void saveHash(String userName, String ahash){
//		log.info("%^&*SaveHashByUsername:"+userName);
//		ResponseUtil<List<EauthHashDTO>> response = this.userProfileService.saveHash(userName, ahash);
//	}

	@Override
	public String findUserNameByHash(String ahash) {
		ResponseUtil<List<EauthHashDTO>> response = this.userProfileService.findUserNameByHash(ahash);
		if(response.isSuccess()) {
			List<EauthHashDTO> eauthHashDTOs = response.getPojoObject();
			if(eauthHashDTOs!=null && eauthHashDTOs.iterator().hasNext()) {
				Long userProfileId = eauthHashDTOs.iterator().next().getUserProfileId();
				ResponseUtil<UserProfileDTO> uresponse = userProfileService.getUserProfileByID(userProfileId);
				if(uresponse.isSuccess()) {
					return uresponse.getPojoObject().getUserName();
				}
			}
		}
		return null;
	}

	@Override
	public UserProfileDTO findUserProfileByusername(String username) {
		return this.userProfileService.getUserProfileByUserName(username);
	}

	@Override
	public PatientDTO getPatientForUser(Long userProfileId) {
		ResponseUtil<PatientDTO> response = this.patientService.getPatientByUserProfileId(userProfileId);
		if(response.isSuccess()) {
			return response.getPojoObject();
		}
		return null;
	}

	@Override
	public PatientDTO getPatientByIcn(String icn) throws MHVException {
		ResponseUtil<Patient> response = new ResponseUtil<Patient>();
		patientService.getPatientByIcn(icn, response);
		if(response.isSuccess()) {
			if(response.getPojoObject() != null) {
				return patientConverter.convertDomainPatient(response.getPojoObject());
			}
		}
		return null;
	}

	@Override
	public PatientDTO searchPersonInMVIByICN(String icn) throws MHVException {
		ResponseUtil<Patient> response = new ResponseUtil<Patient>();
		this.mviIntegrationService.searchPersonInMVIByICN(icn, response);

		if(response.isFailure()) {
			if(log.isInfoEnabled() ) {
				log.info("******************** MVI Error e.getInfoMessages() != null");
				log.info("******************** e.getInfoMessages().size():"+response.getInfoMessages().size());
			}

			if(response.getInfoMessages() != null && response.getInfoMessages().size() > 0) {
				if(log.isInfoEnabled() ) {
					log.info("response.getInfoMessages().keySet().iterator().next().toString():" + response.getFailureMessage());
				}
				if(response.getFailureMessage().equals("MVI_COMM_ISSUE")) {
					throw new MHVException("MVI_COMM_ISSUE");
				}
			}
			throw new MHVException(response.getFailureMessage());
		}

		if(response.getPojoObject() != null) {
			return patientConverter.convertDomainPatient(response.getPojoObject());
		}

		return null;
	}

	@Override
	public PatientDTO searchPersonInMVIForDSLogon(String edipiValue) throws MHVException {
		ResponseUtil<Patient> response = new ResponseUtil<Patient>();
		mviIntegrationService.searchPersonInMVIForDSLogon(edipiValue, response);

		if(response.isFailure()) {
			if(log.isInfoEnabled() ) {
				log.info("******************** MVI Error e.getInfoMessages() != null");
				log.info("******************** e.getInfoMessages().size():"+response.getInfoMessages().size());
			}

			if(response.getInfoMessages() != null && response.getInfoMessages().size() > 0) {
				if(log.isInfoEnabled() ) {
					log.info("response.getInfoMessages().keySet().iterator().next().toString():" + response.getFailureMessage());
				}

				if(response.getFailureMessage().equals("MVI_COMM_ISSUE")) {
					throw new MHVException("MVI_COMM_ISSUE");
				}
			}
			throw new MHVException(response.getFailureMessage());
		}

		if(response.getPojoObject() != null) {
			return patientConverter.convertDomainPatient(response.getPojoObject());
		}
		return null;
	}

	@Override
	public PatientDTO searchPersonInMVIForUSAA(String fName, String mName, String lName, String DOB, String gender, String SSN) throws MHVException {
		ResponseUtil<Patient> response = new ResponseUtil<Patient>();
		mviIntegrationService.searchPersonInMVIForUSAA(fName, mName, lName, DOB, gender, SSN, response);

		if(response.isFailure()) {
			if(log.isInfoEnabled() ) {
				log.info("******************** MVI Error e.getInfoMessages() != null");
				log.info("******************** e.getInfoMessages().size():"+response.getInfoMessages().size());
			}

			if(response.getInfoMessages() != null && response.getInfoMessages().size() > 0) {
				if(log.isInfoEnabled() ) {
					log.info("response.getInfoMessages().keySet().iterator().next().toString():" + response.getFailureMessage());
				}

				if(response.getFailureMessage().equals("MVI_COMM_ISSUE")) {
					throw new MHVException("MVI_COMM_ISSUE");
				}
			}
			throw new MHVException(response.getFailureMessage());
		}

		if(response.getPojoObject() != null) {
			return patientConverter.convertDomainPatient(response.getPojoObject());
		}
		return null;
	}

	@Override
	public PatientDTO matchPerson(Long userProfileId) throws MHVException {
		ResponseUtil<UserProfileDTO> response = userProfileService.getUserProfileByID(userProfileId);
		UserProfileDTO userProfileDTO = response.getPojoObject();
		String versionInfo = "family=Job -Search for user traits";
		ResponseUtil<Patient> resp = new ResponseUtil<Patient>();

		UserProfile userProfile = null;
		userProfileConverter.convertDTOProfile(userProfile, userProfileDTO);
		mviIntegrationService.matchPersonInIPA(userProfile, resp, mviProperties, versionInfo);

		if(resp.getPojoObject() != null) {
			return patientConverter.convertDomainPatient(resp.getPojoObject());
		} else {
			throw new MHVException(response.getFailureMessage());
		}
	}

	@Override
	public PatientDTO addPersonForCorrelation(Long userProfileId) throws MHVException {
		ResponseUtil<PatientDTO> response = patientService.getPatientByUserProfileId(userProfileId);
		PatientDTO patientDTO = response.getPojoObject();
		Patient patient = patientConverter.convertDTOProfile(patientDTO);
		ResponseUtil resp = new ResponseUtil();
		mviIntegrationService.addPersonForCorrelationForIPA(patient, patient.getUserProfile(),
			null, resp, getVersionInfo(patientDTO.getUserProfile()));
		if(resp.getPojoObject() != null) {
			return patientConverter.convertDomainPatient((Patient)resp.getPojoObject());
		} else {
			throw new MHVException(response.getFailureMessage());
		}
	}

	@Override
	public PatientDTO removeCorrelation(Long userProfileId) throws MHVException {
		ResponseUtil<PatientDTO> response = patientService.getPatientByUserProfileId(userProfileId);
		PatientDTO patientDTO = response.getPojoObject();
		Patient patient = patientConverter.convertDTOProfile(patientDTO);
		ResponseUtil resp = new ResponseUtil();
		mviIntegrationService.removeCorrelationInMVI(patient, patient.getUserProfile(), null, resp);
		if(resp.getPojoObject() != null) {
			return patientConverter.convertDomainPatient((Patient)resp.getPojoObject());
		} else {
			throw new MHVException(response.getFailureMessage());
		}
	}

	@Override
	public UserProfileDTO findUserProfileById(Long id) {
		ResponseUtil<UserProfileDTO> response = userProfileService.getUserProfileByID(id);
		return response.getPojoObject();
	}

	private String getVersionInfo(UserProfileDTO userProfile) {
		return "dataEntererId=" + userProfile.getId() + VERSION_INFO_ID + ",given=" + userProfile.getFirstName() + ",family=" + userProfile.getLastName();
	}

	@Override
	public PatientDTO updateTreatmentFacilitiesForExistingPatients(Long userProfileId) throws MHVException {
		ResponseUtil<PatientDTO> response = patientService.getPatientByUserProfileId(userProfileId);
		PatientDTO patientDTO = response.getPojoObject();
		Patient patient = patientConverter.convertDTOProfile(patientDTO);
		ResponseUtil resp = new ResponseUtil();
		mviIntegrationService.updateTreatmentFacilitiesForExistingPatients(patient, response);
		if(resp.getPojoObject() != null) {
			return patientConverter.convertDomainPatient((Patient)resp.getPojoObject());
		} else {
			throw new MHVException(response.getFailureMessage());
		}
	}

	@Override
	public void processLastLogin(Long userProfileId, String csId) {
		UserProfileDTO userProfile = findUserProfileById(userProfileId);
		userProfile.setSignInPartners(csId);

		//JAZZ # 111941 - Remote ID Proofing - Last Login
		if(userProfile.getCurrentLogin()!=null) {
			userProfile.setLastLogin(userProfile.getCurrentLogin());
		}
		//Jazz136316 Logout box date time change
		userProfile.setCurrentLogin(new Date());
		userProfileService.saveUserProfile(userProfile, new ResponseUtil(), false);
	}

	@Override
	public UserProfileDTO getUserProfileForVAAFITraits(String firstName, String lastName, Date dob, String gender) throws MHVException {
		ResponseUtil<UserProfileDTO> response = new ResponseUtil<UserProfileDTO>();
		userProfileService.getProfileByNameBirthDate(firstName, lastName, gender, dob, response);
		if(response.getPojoObject() != null) {
			return response.getPojoObject();
		} else {
			throw new MHVException(response.getFailureMessage());
		}
	}

	@Override
	public InPersonAuthenticationDTOLight getAuthenticationForPatient(Long patientId) throws MHVException {
		ResponseUtil<InPersonAuthentication> response = new ResponseUtil<InPersonAuthentication>();
		inPersonAuthenticationService.getIPAPatientById(patientId, response);
		if(response.isFailure()) {
			if(log.isInfoEnabled() ) {
				log.info("***********************AccountValidator.getAuthenticationForPatient() response.isFailure()");
			}
			throw new MHVException(response.getFailureMessage());
		} else if(response.getPojoObject() != null) {
			log.info("***********************AccountValidator.getAuthenticationForPatient() response.getPojoObject() != null");
			return new InPersonAuthenticationDTOLight(inPersonAuthenticationConverter.convertDomainInpersonAuthentication(response.getPojoObject()));
		} else {
			log.info("***********************AccountValidator.getAuthenticationForPatient() response.getPojoObject() == null");
			return null;
		}
	}

	@Override
	public FacilityInfoDTO getAustinMHVFacilityInfo() throws MHVException {
		List<FacilityInfo> facInfoList = facilityInfoService.queryByStationNumber("200MH");
		if(log.isDebugEnabled()) {
			log.debug("!!!!!!!!!!!facilityInfoList size:"+facInfoList.size());
		}
		if(facInfoList != null && facInfoList.size() > 0) {
			FacilityInfo fi = facInfoList.get(0);
			if(log.isDebugEnabled()) {
				log.debug("!!!!!!!!!!!facilityInfoList(0):"+fi.getStationNumber());
			}
			return new FacilityInfoConveter().convertDomainFacilityInfo(fi);
		}
		return null;
	}

	@Override
	public InPersonAuthenticationDTOLight saveIPA(InPersonAuthenticationDTOLight ipaDTO) throws MHVException {
		log.debug("*************************************** AccountValidatorServiceImpl ipaDTO.getPatientId()" + ipaDTO.getPatientId());
		if(ipaDTO.getPatientId() == null) {
			throw new RuntimeException();
		}

		InPersonAuthenticationLight ipa  =
			inPersonAuthenticationService.saveIPALight(inPersonAuthenticationLightConverter.convertInpersonAuthenticationDTOLight(ipaDTO));
		if(ipa != null) {
			return inPersonAuthenticationLightConverter.convertDomainInpersonAuthentication(ipa);
		}
		return null;
	}

	@Override
	public InPersonAuthenticationDTO ipaAuthenticateFull(InPersonAuthenticationDTO ipaDTO) throws MHVException {
		ResponseUtil<InPersonAuthenticationDTO> response = new ResponseUtil<InPersonAuthenticationDTO>();
		log.debug("********** AccountValidatorServiceImpl.ipaAuthenticateFull() calling inPersonAuthenticationService.authenticate()");
		log.info("********** AccountValidatorServiceImpl.ipaAuthenticateFull() calling inPersonAuthenticationService.authenticate()");
		log.error("********** AccountValidatorServiceImpl.ipaAuthenticateFull() calling inPersonAuthenticationService.authenticate()");
		inPersonAuthenticationService.authenticateFull(ipaDTO, response);
		log.debug("********** AccountValidatorServiceImpl.ipaAuthenticateFull() called inPersonAuthenticationService.authenticate(): response: "+response.isSuccess());
		log.info("********** AccountValidatorServiceImpl.ipaAuthenticateFull() called inPersonAuthenticationService.authenticate(): response: "+response.isSuccess());
		log.error("********** AccountValidatorServiceImpl.ipaAuthenticateFull() called inPersonAuthenticationService.authenticate(): response: "+response.isSuccess());
		if(response.isFailure()) {
			new MHVException(response.getFailureMessage());
		}
		return (InPersonAuthenticationDTO)response.getPojoObject();
	}

	@Override
	public InPersonAuthenticationDTOLight ipaAuthenticate(InPersonAuthenticationDTOLight ipaDTO) throws MHVException {
		ResponseUtil response = new ResponseUtil();
		inPersonAuthenticationService.authenticate(ipaDTO, response);

		if(response.isFailure()) {
			new MHVException(response.getFailureMessage());
		}
		return (InPersonAuthenticationDTOLight)response.getPojoObject();
	}

	@Override
	public InPersonAuthenticationDTOLight deferAuthentication(InPersonAuthenticationDTOLight ipaDTO) throws MHVException {
		ResponseUtil response = new ResponseUtil();
		inPersonAuthenticationService.deferAuthenticationLight(ipaDTO, response);

		if(response.isFailure()) {
			new MHVException(response.getFailureMessage());
		}
		return (InPersonAuthenticationDTOLight)response.getPojoObject();
	}


	@Override
	public void auditOnlineAuthenticationEvent(Long subjectId, Boolean successful, String activityName, String actionName, String detail){
System.out.println("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<Inside auditOnlineAuthenticationEvent");
		ResponseUtil response = new ResponseUtil();
		activityService.auditOnlineAuthenticationEvent(subjectId, successful, activityName, actionName, detail, response);
	}

	@Override
	public void auditOnlineAuthenticationEvent2(Long subjectId){
System.out.println("<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<Inside auditOnlineAuthenticationEvent2 subjectId:" + subjectId);
	}

	@Override
	public void auditDSLogonMappingEvent(Long subjectId, Boolean successful, String activityType, String actor, String actionType){
		ResponseUtil response = new ResponseUtil();
		activityService.auditDSLogonMappingEvent(subjectId, successful, actor, activityType, actionType, response);
	}
	
	@Override
	public void auditDSLogonMappingActivity(Long subjectId, Boolean successful, String actor, String actionType, String activityDetailValue){
		ResponseUtil response = new ResponseUtil();
		activityService.auditDSLogonMappingActivity(subjectId, successful, actor, actionType, activityDetailValue, response);
	}

	@Override
	public void	auditUpgradeEvent(Long subjectId, String actor, String actionType, String activityDetailValue){
		ResponseUtil response = new ResponseUtil();
		//activityService.auditUpgradeEvent(subjectId, actor, actionType, activityDetailValue, response);
	}

	@Override
	public String getVapiiFormStatusForUser(Long userProfileId) throws MHVException {
		try {
			return userProfileService.getVapiiFormStatusForUser(userProfileId);
		} catch (Exception e) {
			e.printStackTrace();
			throw new MHVException(e.getMessage());
		}
	}

	@Override
	public void auditManualAuthenticationEvent(Long subjectId, Boolean successful, String actionName, String detail){
		ResponseUtil response = new ResponseUtil();
		activityService.auditManualAuthenticationEvent(subjectId, successful, actionName, detail, response);
	}

	@Override
	public boolean checkPassowrd(UserProfileDTO userProfileDTO) {
		ResponseUtil response = new ResponseUtil();
		userPasswordService.checkPassword(userProfileDTO, response);
		return response.isSuccess();
	}

	@Override
	public UserProfileDTO saveUserProfile(UserProfileDTO userProfileDTO) throws MHVException  {
		ResponseUtil response = new ResponseUtil();
		userProfileService.saveUserProfile(userProfileDTO, response);
		if(response.isFailure()) {
			new MHVException(response.getFailureMessage());
		}
		return (UserProfileDTO)response.getPojoObject();
	}

	@Override
	public void auditMviEvent(Long subjectId, String actor, Boolean successful, String activityActionType, String activityType) {
		ResponseUtil response = new ResponseUtil();
		activityService.auditMviEvent(subjectId, actor, successful, activityActionType, activityType, response);
	}

	@Override
	public void logEauthEvent(String ahash, String userName, String csid, String event) {
		try {
			//userProfileService.logEauthEvent(ahash, userName, csid, event);
		} catch(Throwable t) {
			t.printStackTrace();
			throw t;
		}
	}

	@Override
	public String getSreAutoLoginUrl() {
		return mviProperties.getSreAutLoginUrl();
	}

	@Override
	public String getSreAnonymousUrl() {
		return mviProperties.getSreAnonymousUrl();
	}

	@Override
	public UserProfileDTO getUserProfile(String firstName, String lastName, String gender, Date birthDate) throws MHVException {
		ResponseUtil<UserProfileDTO> response = new ResponseUtil<UserProfileDTO>();

		try {
			userProfileService.getProfileByNameBirthDate(firstName, lastName, gender, birthDate, response);
		}
		catch (Exception e) {
			MHVException mhvex = new MHVException(ErrorEnum.USER_NOT_FOUND_105, e);
			log.error("Exception caught during patient lookup: ", e);
			throw mhvex;
		}

		if(response.isFailure()) {
			throw new MHVException(response.getInfoMessages(), response.getValidationErrors(), response.getFailureMessage());
		}

		return response.getPojoObject();
		}

	@Override
		public UserProfileDTO getUserProfileForUserName(String firstName, String lastName, String userName, String gender, Date birthDate) throws MHVException {
			ResponseUtil<UserProfileDTO> response = new ResponseUtil<UserProfileDTO>();

			try {
				userProfileService.getProfileByNameUserNameBirthDate(firstName, lastName, userName, gender, birthDate, response);
			}
			catch (Exception e) {
				MHVException mhvex = new MHVException(ErrorEnum.USER_NOT_FOUND_105, e);
				log.error("Exception caught during patient lookup: ", e);
				throw mhvex;
			}

			if(response.isFailure()) {
				throw new MHVException(response.getInfoMessages(), response.getValidationErrors(), response.getFailureMessage());
			}

			return response.getPojoObject();
		}

	@Override
	public UserProfileDTO changePassword(UserProfileDTO userProfileJSON, Boolean isForgotPwd)
			throws MHVException {
		ResponseUtil<UserProfileDTO> response = new ResponseUtil<UserProfileDTO>();

		try {
			this.userPasswordService.changePassword(userProfileJSON, response,isForgotPwd);
			UserProfile savedUserProfile = new UserProfile();
			savedUserProfile = userProfileConverter.convertDTOProfile(savedUserProfile, userProfileJSON);
			this.userProfileService.savePasswordHistory(savedUserProfile, userProfileJSON.getPassword(), false, response);
		} catch(Exception ex) {
			String errorMessage = "An error was encountered while changing the users password.";
			log.error(errorMessage, ex);
			throw new MHVException(errorMessage, ex);
		}

		if (response.isFailure()) { 

			log.debug("ChangePasswordController - saveContactAction - fail");
			Map<String, String> map = response.getValidationErrors();
			if (map != null) {
				for (Map.Entry<String, String> entry : map.entrySet()) {
					if (null != entry) {
						log.debug("entry.getKey() : " + entry.getKey());
						log.debug("entry.getValue() : "
								+ entry.getValue());
					}

					throw new MHVException(String.format("Validation error happened during password change operations. Key: %s, Value: %s",
							entry.getKey(), entry.getValue()));
				}
			} else {
				throw new MHVException(response.getFailureMessage());
			}
		}

		return response.getPojoObject();
	}
	
	@Override
	public Boolean validateHintAnswers(Long userprofileId, String answer1, String answer2) throws MHVException {
		ResponseUtil<UserProfileDTO> response = new ResponseUtil<UserProfileDTO>();

		try {
			userProfileService.validateHintAnswers(userprofileId,answer1,answer2,response);
		}
		catch (Exception e) {
			MHVException mhvex = new MHVException(ErrorEnum.USER_NOT_FOUND_105, e);
			log.error("Exception caught during patient lookup: ", e);
			throw mhvex;
		}

		if(response.isFailure()) {
			throw new MHVException(response.getInfoMessages(), response.getValidationErrors(), response.getFailureMessage());
		}

		return Boolean.TRUE;
	}

	@Override
	public void createAccountActivityLog(ActivityDTO activity)
			throws MHVException {
		ResponseUtil response = new ResponseUtil();
		activityService.createAccountActivityLog(activity, response);
		
	}

}
