package gov.va.med.mhv.usermgmt.main.service.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.stereotype.Component;

import gov.va.med.mhv.usermgmt.common.dto.MyLinksDTO;
import gov.va.med.mhv.usermgmt.data.model.MyLinks;

@Component
public class MyLinksConverter {
	
	public static MyLinksDTO convertDomainMyLinks(MyLinks myLinks) {
		MyLinksDTO myLinksDto = new MyLinksDTO();
		
		myLinksDto.setId(myLinks.getId());
		myLinksDto.setOplock(myLinks.getOplock());
		myLinksDto.setDisplayName(myLinks.getDisplayName());
		myLinksDto.setLink(myLinks.getLink());
		myLinksDto.setStatus(myLinks.getStatus());
		myLinksDto.setUserProfileId(myLinks.getUserProfileId());
		
		return myLinksDto;
	}
	
	public MyLinks convertDTOMyLinks(MyLinksDTO myLinksDto) {
		MyLinks myLinks = new MyLinks();
		
		myLinks.setId(myLinksDto.getId());
		myLinks.setOplock(myLinksDto.getOplock());
		myLinks.setDisplayName(myLinksDto.getDisplayName());
		myLinks.setLink(myLinksDto.getLink());
		myLinks.setStatus(myLinksDto.getStatus());
		myLinks.setUserProfileId(myLinksDto.getUserProfileId());
		
		return myLinks;
	}
	
	public List<MyLinksDTO> convertMyLinkRecords(List<MyLinks> myLinks) {
		List<MyLinksDTO> dtos = new ArrayList<MyLinksDTO>();
		for (MyLinks myLinkRecord : myLinks) {
			MyLinksDTO dto = convertDomainMyLinks(myLinkRecord);
			dtos.add(dto);
		}
		return dtos;
	}
	
}
