package gov.va.med.mhv.usermgmt.main.service.adapter.impl;

import java.util.ArrayList;
import java.util.Collection;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.data.model.Facility;
import gov.va.med.mhv.common.data.model.Patient;
import gov.va.med.mhv.common.data.model.UserProfile;
import gov.va.med.mhv.usermgmt.common.enums.Gender;
import gov.va.med.mhv.usermgmt.main.registry.Address;
import gov.va.med.mhv.usermgmt.main.registry.ContactInformation;
import gov.va.med.mhv.usermgmt.main.registry.Name;
import gov.va.med.mhv.usermgmt.main.registry.PersonalInfo;
import gov.va.med.mhv.usermgmt.main.registry.Status;
import gov.va.med.mhv.usermgmt.service.PatientCorrelationService;

@Component
public class PatientCorrelationServiceAdapter {

	private static final Log log = LogFactory.getLog(PatientCorrelationServiceAdapter.class);

	@Autowired
	private PatientCorrelationService patientCorrelationService;

	public Status correlate(Patient patient) {
		return patientCorrelationService.correlatePatient(toPatient(patient));
	}

	private gov.va.med.mhv.usermgmt.main.registry.Patient toPatient(Patient patient) {
		gov.va.med.mhv.usermgmt.main.registry.Patient registryPatient = new gov.va.med.mhv.usermgmt.main.registry.Patient();
		registryPatient.setIcn(patient.getIcn());

		// TODO : where is user id ???????
		// registryPatient.setUserId(patient.getUserProfile().getId());
		registryPatient.setPersonalInfo(toPersonalInfo(patient.getUserProfile()));
		registryPatient.setFacilities(toFacilities(patient.getFacilities()));
		return registryPatient;
	}

	private ArrayList<gov.va.med.mhv.usermgmt.main.registry.Facility> toFacilities(Collection<Facility> facilities) {
		ArrayList<gov.va.med.mhv.usermgmt.main.registry.Facility> registryFacilities = new ArrayList<gov.va.med.mhv.usermgmt.main.registry.Facility>();
		if (facilities != null) {
			if (facilities != null) {
				for (Facility facility : facilities) {
					registryFacilities.add(toFacility(facility));
				}
			}
		}
		return registryFacilities;
	}

	private gov.va.med.mhv.usermgmt.main.registry.Facility toFacility(Facility facility) {
		gov.va.med.mhv.usermgmt.main.registry.Facility registryFacility = new gov.va.med.mhv.usermgmt.main.registry.Facility();
		// DFN is a currently a placeholder for future extensions

		// TODO : where id DFN coming from ?????????
		// registryFacility.setDfn(null);
		// We currently do not use the facilityId
		registryFacility.setFacilityId(null);
		// NOTE: name denotes the station number
		registryFacility.setStationNumber(facility.getName());
		return registryFacility;
	}

	private PersonalInfo toPersonalInfo(UserProfile userProfile) {
		PersonalInfo personalInfo = new PersonalInfo();
		personalInfo.setName(toName(userProfile));
		personalInfo.setMothersMaidenName(null); // unknown in MHV
		personalInfo.setDateOfBirth(userProfile.getBirthDate());
		personalInfo.setImpreciseDateOfBirth(userProfile.getBirthDate().toString() + "120000");
		personalInfo.setPlaceOfBirth(null); // unknown in MHV
		personalInfo.setGender(toGender(userProfile.getGender()));
		personalInfo.setSsn(userProfile.getSsn());
		personalInfo.setMultipleBirthIndicator(null); // unknown in MHV
		personalInfo.setAlias(null); // unknown in MHV
		personalInfo.setEtnicity(null); // unknown in MHV
		personalInfo.setRace(null); // unknown in MHV
		personalInfo.setPermanentAddress(toAddress(userProfile));
		personalInfo.setContactInformation(toContactInformation(userProfile));
		return personalInfo;
	}

	private Name toName(UserProfile userProfile) {
		Name name = new Name();
		name.setFirstName(userProfile.getFirstName());
		name.setMiddleName(userProfile.getMiddleName());
		name.setLastName(userProfile.getLastName());
		name.setPrefix((userProfile.getTitle() != null) ? userProfile.getTitle() : null);
		name.setSuffix((userProfile.getSuffix() != null) ? userProfile.getSuffix() : null);
		return name;
	}

	private Address toAddress(UserProfile userProfile) {
		Address address = new Address();
		address.setStreetAddress1(userProfile.getAddressStreet1());
		address.setStreetAddress2(userProfile.getAddressStreet2());
		address.setStreetAddress3(null); // Unknown
		address.setCity(userProfile.getAddressCity());
		address.setStateProvence((userProfile.getAddressState() != null) ? userProfile.getAddressState() : userProfile.getAddressProvince());
		address.setZipPostalCode(userProfile.getAddressPostalCode());
		address.setCountyCode(null); // Unknown
		address.setCountryCode((userProfile.getAddressCountry() != null) ? userProfile.getAddressCountry() : null);
		address.setBadAddressIndicator(null); // Unknown
		return address;
	}

	private ContactInformation toContactInformation(UserProfile userProfile) {
		ContactInformation contactInfo = new ContactInformation();
		contactInfo.setHomePhone(userProfile.getContactInfoHomePhone());
		return contactInfo;
	}

	private Gender toGender(String gender) {
		if (gender == null) {
			return null;
		}
		if (gender.equals("Male")) {
			return Gender.Male;
		}
		if (gender.equals("Female")) {
			return Gender.Female;
		}
		return null;
	}

	public Status uncorrelate(Patient patient) {
		return patientCorrelationService.uncorrelatePatient(toPatient(patient));
	}

	private String describe(Patient patient) {
		if (patient == null) {
			return "<unknown patient>";
		}
		StringBuilder builder = new StringBuilder();
		builder.append("Patient[");
		builder.append("icn=").append(patient.getIcn());
		builder.append(";user_name=");
		builder.append((patient.getUserProfile() != null) ? patient.getUserProfile().getUserName() : "<no user profile>");
		builder.append("]");
		return builder.toString();
	}
}
