package gov.va.med.mhv.usermgmt.main.registry;

import java.io.PrintWriter;
import java.io.StringWriter;

import gov.va.med.mhv.usermgmt.data.model.Trace;
import gov.va.med.mhv.usermgmt.service.EventTracingService;


public class ProcessingHelper {
    
	public static final String PATIENT_IDENTITY_SERVICE_PROXY = 
        "patientIdentityServiceProxy";

	private EventTracingService tracingService;
	
	//TODO: Revisit this
	/*
	public PatientIdentityServiceRemote getPatientIdentityService() {
        return (PatientIdentityServiceRemote) IntegrationContext.getBean(
		    PATIENT_IDENTITY_SERVICE_PROXY);
	} */
	
	public EventTracingService getTracingService() {
		return tracingService;
	}
	
	public void setTracingService(EventTracingService tracingService) {
		this.tracingService = tracingService;
	}
	
	public String getStackTrace(Throwable t)
	{
		StringWriter sw = new StringWriter();
		PrintWriter pw = new PrintWriter(sw);
		pw.print(t.getMessage());
		pw.print("\n\r");
		t.printStackTrace(pw);
		pw.flush();
		return sw.toString();
	}
	
	public Result constructResult(EventId id, Status status)
	{
		Result result = new Result();
		result.setStatus(status);
		result.setId(id);	
		return result;
	}
	
	private Result processTraceException(Trace trace, gov.va.med.mhv.usermgmt.common.enums.StatusType statusType, String description)
	{
		Status resultStatus = new Status();
		resultStatus.setStatusType(statusType);
		resultStatus.setStatusDescription(description);
		tracingService.updateTraceStatus(trace.getId(), gov.va.med.mhv.usermgmt.common.enums.TracingStatusType.failure.toString(), resultStatus, null, true);
		EventId eventId = new EventId();
		eventId.setId(trace.getEvent().getId());
		eventId.setCorrelationId(trace.getEvent().getCorrelationId());
		return constructResult(eventId, resultStatus);
	}
	
	public Result processTraceError(Trace trace, Throwable t)
	{
		String description = t.getMessage()+" : " + getStackTrace(t);
		return processTraceException(trace, gov.va.med.mhv.usermgmt.common.enums.StatusType.Error, description);
	}
	
	public Result processTraceError(Trace trace, String description)
	{
		return processTraceException(trace, gov.va.med.mhv.usermgmt.common.enums.StatusType.Error, description);
	}
	
	public Result processTraceReject(Trace trace, Throwable t)
	{
		String description = t.getMessage()+" : " + getStackTrace(t);
		return processTraceException(trace, gov.va.med.mhv.usermgmt.common.enums.StatusType.Reject, description);
	}
	
	public Result processTraceReject(Trace trace, String description)
	{
		return processTraceException(trace, gov.va.med.mhv.usermgmt.common.enums.StatusType.Reject, description);
	}
	
	public Result processTraceFail(Trace trace, Throwable t)
	{
		String description = t.getMessage()+" : " + getStackTrace(t);
		return processTraceException(trace, gov.va.med.mhv.usermgmt.common.enums.StatusType.Fail, description);
	}
	
	public Result processTraceFail(Trace trace, String description)
	{
		return processTraceException(trace, gov.va.med.mhv.usermgmt.common.enums.StatusType.Fail, description);
	}
	
	public Result constructOkResult(Trace trace)
	{
		Status resultStatus = new Status();
		resultStatus.setStatusType(gov.va.med.mhv.usermgmt.common.enums.StatusType.Ok);
		resultStatus.setStatusDescription(null);
		EventId eventId = new EventId();
		eventId.setId(trace.getEvent().getId());
		eventId.setCorrelationId(trace.getEvent().getCorrelationId());
		return constructResult(eventId, resultStatus);
	}
	
	public Result processTrace(Trace trace, gov.va.med.mhv.usermgmt.common.enums.TracingStatusType status, boolean synchronizeEventStatus)
	{
		return processTrace(trace, status, null, synchronizeEventStatus);
	}
	
	
	public Result processTrace(Trace trace, gov.va.med.mhv.usermgmt.common.enums.TracingStatusType status, String correlationId, boolean synchronizeEventStatus)
	{
		getTracingService().updateTraceStatus(trace.getId(), status.toString(), null, correlationId, synchronizeEventStatus);
		return constructOkResult(trace);
	}
	
	public Result processTrace(Trace trace, gov.va.med.mhv.usermgmt.common.enums.TracingStatusType status, String correlationId, Long userId, boolean synchronizeEventStatus)
	{
		getTracingService().updateTraceStatus(trace.getId(), status.toString(), null, correlationId, userId, synchronizeEventStatus);
		return constructOkResult(trace);
	}
	
	
	//TODO :  Revisit this
	
/*	public Patient getMhvPatient(String icn) 
	{
		Patient result = null;
		if (icn==null)
			return result;
		
		PatientIdentityServiceRemote proxy = getPatientIdentityService();
		try {
			result = proxy.getPatientForICN(icn);
		} catch (java.rmi.RemoteException e) {
			throw new RemoteException(e);
		}
		//end temporary code for testing
		return result;
	} 
	
	public Patient mhvPatientToInyegrationPatient(Patient mhvPatient)
	{
		Patient intPatient = new Patient();
		intPatient.setIcn(mhvPatient.getIcn());
		return intPatient;
	}
	
	public Long stationNumber2institutionId(String stationNumber)
	{
		gov.va.med.term.access.Institution institution = 
			gov.va.med.term.access.Institution.factory.obtainByStationNumber(stationNumber);
	    if (institution == null) 
	    {
	            return null;
	    }
	    return institution.getId();
	}
	
	public String institutionId2stationNumber(Long institutionId)
	{
		gov.va.med.term.access.Institution institution = 
			gov.va.med.term.access.Institution.factory.obtainFromKeyValue(institutionId);
	    if (institution == null) 
	    {
	            return null;
	    }
	    return institution.getStationNumber();
	}

    public String countryNameToCode(String countryName) {
        if ((countryName == null) || "".equals(countryName.trim())) {
            return null;
        }
        Criteria equalsCountryNameCriterion = new Criteria.EqualIgnoreCase(
            "ShortName", countryName);
        gov.va.med.term.access.Country[] countries = Country.factory.obtain(
            equalsCountryNameCriterion);
        if (countries == null) {
            return null;
        }
        return (countries.length > 0) ? countries[0].getAlpha3Code() : null;
    }

    public String countryCodeToName(String countryCode) {
    	if ((countryCode == null) || "".equals(countryCode.trim())) {
    		return null;
    	}
    	gov.va.med.term.access.Country country = Country.factory.
           	obtainByAlpha3Code(countryCode);
        return (country != null) ? country.getShortName() : null;
    }
*/
}
