/**
 * 
 */
package gov.va.med.mhv.usermgmt.main.registry;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public class Name extends ModelObject {
    
    private String lastName = null;
    private String firstName = null;
    private String middleName = null;
    private String prefix = null;
    private String suffix = null;
    
    /**
     * @return Returns the firstName.
     */
    public String getFirstName() {
        return firstName;
    }
    /**
     * @param firstName The firstName to set.
     */
    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }
    /**
     * @return Returns the lastName.
     */
    public String getLastName() {
        return lastName;
    }
    /**
     * @param lastName The lastName to set.
     */
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }
    /**
     * @return Returns the middleName.
     */
    public String getMiddleName() {
        return middleName;
    }
    /**
     * @param middleName The middleName to set.
     */
    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }
    /**
     * @return Returns the prefix.
     */
    public String getPrefix() {
        return prefix;
    }
    /**
     * @param prefix The prefix to set.
     */
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
    /**
     * @return Returns the suffix.
     */
    public String getSuffix() {
        return suffix;
    }
    /**
     * @param suffix The suffix to set.
     */
    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    @Override
    public int hashCode() {
        Object[] fields = { lastName, firstName, middleName };
        return hashCode(fields);
    }
    
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Name other = (Name) obj;
        return areEqual(lastName, other.lastName)
            && areEqual(firstName, other.firstName)
            && areEqual(middleName, other.middleName)
            && areEqual(prefix, other.prefix)
            && areEqual(suffix, other.suffix);
    }
}
