package gov.va.med.mhv.usermgmt.main.registry;

import org.springframework.context.support.ClassPathXmlApplicationContext;

public class IntegrationContext {
	private static ClassPathXmlApplicationContext context;
	private static String[] configs = new String[] { 
        "classpath:/config/beans/dao-context.xml",
        "classpath:/config/beans/db-context.xml" ,
        "classpath:/config/beans/tx-context.xml",        
        "classpath:/config/beans/common-context.xml" ,
    };
	
	public static String[] getConfigs() {
		return configs;
	}

	public static void setConfigs(String[] configs) {
		IntegrationContext.configs = configs;
		//flush context
		context=null;
	}

	public static ClassPathXmlApplicationContext getContext() {
		if (context == null) {
			context = new ClassPathXmlApplicationContext(configs);
		}

		return context;
	}

	public static Object getBean(String name) {
		return getContext().getBean(name);
	}
}
