package gov.va.med.mhv.usermgmt.main.registry;

import gov.va.med.mhv.usermgmt.common.enums.TracingStatusType;
import gov.va.med.mhv.usermgmt.data.model.Trace;
import gov.va.med.mhv.usermgmt.service.ITraceProcessor;


public abstract class BaseProcessor implements ITraceProcessor {
	private ProcessingHelper processingHelper;
	
	public ProcessingHelper getProcessingHelper() {
		return processingHelper;
	}
	
	public void setProcessingHelper(ProcessingHelper processingHelper) {
		this.processingHelper = processingHelper;
	}

    public abstract Result processTrace(Trace trace) throws Exception;
    
	protected Result processTrace(Trace trace, TracingStatusType status, 
        boolean synchronizeEventStatus)
    {
        return getProcessingHelper().processTrace(trace, status, 
            synchronizeEventStatus);
    }
    
    protected Result processTrace(Trace trace, TracingStatusType status, 
        String correlationId, boolean synchronizeEventStatus)
    {
        return getProcessingHelper().processTrace(trace, status, correlationId, 
            synchronizeEventStatus);
    }
    
    protected Result processTrace(Trace trace, TracingStatusType status, 
        String correlationId, Long userId, boolean synchronizeEventStatus)
    {
        return getProcessingHelper().processTrace(trace, status, correlationId, 
            userId, synchronizeEventStatus);
    }
	
    protected Result processTraceError(Trace trace, Throwable t) {
        return getProcessingHelper().processTraceError(trace, t);
    }
    
    protected Result processTraceError(Trace trace, String description) {
        return getProcessingHelper().processTraceError(trace, description);
    }

}
