/**
 * 
 */
package gov.va.med.mhv.usermgmt.main.registry;

import gov.va.med.mhv.usermgmt.common.enums.Indicator;

/**
 * @author Rob Proper (Aquilent Inc.)
 *
 */
public class Address extends ModelObject {
    
    private String streetAddress1 = null;
    private String streetAddress2 = null;
    private String streetAddress3 = null;
    private String city = null;
    private String stateProvence = null;
    private String zipPostalCode = null;
    private String countyCode = null;
    private String countryCode = null;
    private Indicator badAddressIndicator = null;
    
    
    /**
     * @return Returns the city.
     */
    public String getCity() {
        return city;
    }

    /**
     * @param city The city to set.
     */
    public void setCity(String city) {
        this.city = city;
    }

    /**
     * @return Returns the countryCode.
     */
    public String getCountryCode() {
        return countryCode;
    }

    /**
     * @param countryCode The countryCode to set.
     */
    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    /**
     * @return Returns the countyCode.
     */
    public String getCountyCode() {
        return countyCode;
    }

    /**
     * @param countyCode The countyCode to set.
     */
    public void setCountyCode(String countyCode) {
        this.countyCode = countyCode;
    }

    /**
     * @return Returns the stateProvence.
     */
    public String getStateProvence() {
        return stateProvence;
    }

    /**
     * @param stateProvence The stateProvence to set.
     */
    public void setStateProvence(String stateProvence) {
        this.stateProvence = stateProvence;
    }

    /**
     * @return Returns the streetAddress1.
     */
    public String getStreetAddress1() {
        return streetAddress1;
    }

    /**
     * @param streetAddress1 The streetAddress1 to set.
     */
    public void setStreetAddress1(String streetAddress1) {
        this.streetAddress1 = streetAddress1;
    }

    /**
     * @return Returns the streetAddress2.
     */
    public String getStreetAddress2() {
        return streetAddress2;
    }

    /**
     * @param streetAddress2 The streetAddress2 to set.
     */
    public void setStreetAddress2(String streetAddress2) {
        this.streetAddress2 = streetAddress2;
    }

    /**
     * @return Returns the streetAddress3.
     */
    public String getStreetAddress3() {
        return streetAddress3;
    }

    /**
     * @param streetAddress3 The streetAddress3 to set.
     */
    public void setStreetAddress3(String streetAddress3) {
        this.streetAddress3 = streetAddress3;
    }

    /**
     * @return Returns the zipPostalCode.
     */
    public String getZipPostalCode() {
        return zipPostalCode;
    }

    /**
     * @param zipPostalCode The zipPostalCode to set.
     */
    public void setZipPostalCode(String zipPostalCode) {
        this.zipPostalCode = zipPostalCode;
    }

    
    /**
     * @return Returns the badAddressIndicator.
     */
    public Indicator getBadAddressIndicator() {
        return badAddressIndicator;
    }

    /**
     * @param badAddressIndicator The badAddressIndicator to set.
     */
    public void setBadAddressIndicator(Indicator badAddressIndicator) {
        this.badAddressIndicator = badAddressIndicator;
    }

    @Override
    public int hashCode() {
        Object[] fields = { streetAddress1, city, zipPostalCode };
        return hashCode(fields);
    }
    
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final Address other = (Address) obj;
        return areEqual(streetAddress1, other.streetAddress1)
            && areEqual(streetAddress2, other.streetAddress2)
            && areEqual(streetAddress3, other.streetAddress3)
            && areEqual(city, other.city)
            && areEqual(stateProvence, other.stateProvence)
            && areEqual(zipPostalCode, other.zipPostalCode)
            && areEqual(countyCode, other.countyCode)
            && areEqual(countryCode, other.countryCode)
            && areEqual(badAddressIndicator, other.badAddressIndicator);
    }
}
