package gov.va.med.mhv.usermgmt.service.impl;

import gov.va.med.mhv.usermgmt.bizobj.BusinessObjectFactory;
import gov.va.med.mhv.usermgmt.bizobj.HealthSummaryAssembler;
import gov.va.med.mhv.usermgmt.bizobj.HealthSummaryBO;
import gov.va.med.mhv.usermgmt.bizobj.HealthSummaryStatusAssembler;
import gov.va.med.mhv.usermgmt.bizobj.HealthSummaryStatusBO;
import gov.va.med.mhv.usermgmt.service.HealthSummaryCollectionServiceResponse;
import gov.va.med.mhv.usermgmt.service.HealthSummaryServiceResponse;
import gov.va.med.mhv.usermgmt.transfer.HealthSummary;
import gov.va.med.mhv.usermgmt.transfer.HealthSummaryStatus;

import java.lang.Long;
import java.util.List;

import org.tigris.atlas.messages.DefaultMessage;

import gov.va.med.mhv.usermgmt.service.HealthSummaryService;

/**
 * Service implementation class for the HealthSummary service
 * @see gov.va.med.mhv.usermgmt.service.HealthSummaryService
 */
public class HealthSummaryServiceImpl implements HealthSummaryService {

	/**
	 * Execute the GetHealthSummaryByHealthStatusSummaryId service
	 * @see gov.va.med.mhv.usermgmt.service.HealthSummaryService#GetHealthSummaryByHealthStatusSummaryId()
	 */
	public HealthSummaryCollectionServiceResponse getHealthSummaryByHealthStatusSummaryId(Long userProfileId, Long healthSummaryStatusId) {
		HealthSummaryCollectionServiceResponse response = new HealthSummaryCollectionServiceResponse();
		List<HealthSummaryBO> healthSummaryList = HealthSummaryBO.getHealthSummaryByHealthSummaryStatusId(userProfileId, healthSummaryStatusId);
		for(HealthSummaryBO healthSummaryBO : healthSummaryList) {
			response.addHealthSummary(healthSummaryBO.getHealthSummaryValues());
		}
		return response;
	}


	/**
	 * Execute the GetHealthSummaryByUserProfileId service
	 * @see gov.va.med.mhv.usermgmt.service.HealthSummaryService#GetHealthSummaryByUserProfileId()
	 */
	public HealthSummaryCollectionServiceResponse getHealthSummaryByUserProfileId(Long userProfileId) {
		HealthSummaryCollectionServiceResponse response = new HealthSummaryCollectionServiceResponse();
		List<HealthSummaryBO> healthSummaryList = HealthSummaryBO.getHealthSummaryByUserProfileId(userProfileId);
		for(HealthSummaryBO healthSummaryBO : healthSummaryList) {
			response.addHealthSummary(healthSummaryBO.getHealthSummaryValues());
		}
		return response;
	}


	/**
	 * Execute the SaveHealthSummary service
	 * @see gov.va.med.mhv.usermgmt.service.HealthSummaryService#SaveHealthSummary()
	 */
	public HealthSummaryServiceResponse saveHealthSummary(HealthSummary healthSummary) {
		HealthSummaryServiceResponse response = new HealthSummaryServiceResponse();
		try {
			HealthSummaryBO bo = BusinessObjectFactory.createHealthSummaryBO();
			bo.setHealthSummaryValues(healthSummary);
			bo.save();
			if( bo.getAllMessages( ).hasErrorMessages( ) ) {	     
	            response.getMessages( ).addMessages( bo.getAllMessages( ) );
	        }	
		} catch(Exception x) {
			DefaultMessage msg = new DefaultMessage();
			msg.addProperty(x.getLocalizedMessage());
			response.getMessages().addMessage(msg);
		}
		return response;
	}
}