package gov.va.med.mhv.usermgmt.integration.service.delegate;

import java.util.ArrayList;

import gov.va.med.mhv.integration.registry.transfer.Facility;
import gov.va.med.mhv.integration.registry.transfer.Patient;
import gov.va.med.mhv.integration.registry.transfer.PersonalInfo;
import gov.va.med.mhv.integration.registry.transfer.Status;

/**
 * Service delegate for the Patient service
 */
public interface PatientIdentityServiceDelegate {

    // N.B. - This MUST be namespaced to ensure uniqueness when multiple 
    // apps are present
    /** 
     * Name which uniquely identifies the PatientIdentity service. 
     **/
    public static final String SERVICE_NAME = 
        "gov.va.med.mhv.integration.registry.PatientIdentityService";

    Patient getPatientForICN(String icn);
    Status finalizeCorrelation(Patient patient, Status status);
    Status finalizeUncorrelation(Patient patient, Status status);
    Status updateFacilities(Patient patient, ArrayList<Facility> newFacilities);
    Status updatePersonalInfo(Patient patient, PersonalInfo personalInfo);
    Status changeIcn(Patient patient , String newIcn);
    Status removeCorrelation(Patient patient);
    Status mergePatients(Patient fromPatient, Patient toPatient, 
        String referenceId);
    //JAZZ # 128617: MVI A43 Move message processing.
    Status deactivatePatient(Patient pat, String referenceId, String reason, String deactivationNote);
}