package gov.va.med.mhv.usermgmt.persist.ldap.spring;

import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.usermgmt.persist.UserEntryDao;
import gov.va.med.mhv.usermgmt.persist.ldap.LdapEnvironment;

import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.ldap.LdapContext;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ldap.core.DistinguishedName;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.stereotype.Component;

/**
 * UserDao implementation that writes to a directory server.
 *
 * @author Jon Crater Apr 4, 2006 3:51:19 PM
 */

@Component
public class UserSpringLDAPDaoImpl implements UserEntryDao {

	private static Logger log = LogManager.getLogger(UserSpringLDAPDaoImpl.class);

	@Autowired
	private LdapEnvironment env;

	@Autowired
	private LdapTemplate ldapTemplate;

	/**
	 * Reset the password of the user represented by the userName parameter.
	 * 
	 * @param userName
	 * @param newPassword
	 */
	public void resetPassword(String userName, String newPassword) {
		
		LdapContext context = (LdapContext)ldapTemplate.getContextSource().getReadWriteContext();
		
		final ModificationItem[] modifications = new ModificationItem[1];
		modifications[0] = new ModificationItem(DirContext.REPLACE_ATTRIBUTE, new BasicAttribute(env.getUserPasswordAttribute(), newPassword));
		
		try {
			context.modifyAttributes(buildDn(userName), modifications);
		} catch (NamingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 

	}

	/**
	 * Change the userName of the user represented by the oldUserName parameter.
	 * 
	 * @param oldUserName
	 * @param newUserName
	 */
	//TODO: Implement it when needed
	public void changeUserName(String oldUserName, String newUserName) {
/*		 this.connect(newUserName);
		 ldapUpdate.addCommand(LdapEntryModification.wipeAndReplace(LdapUtil.buildUserDn(env,
		 oldUserName), Collections.EMPTY_MAP));
		 ldapUpdate.executeUpdate();*/
	}

	/**
	 * Create a user entry in the directory.
	 * 
	 * @param userName
	 *            The value that will be written to the uid, cn and sn
	 *            attributes of the newly created entry.
	 * @param password
	 *            The value that will be encrypted and written to the password
	 *            attribute of the newly created entry.
	 */

	/**
	 * (non-Javadoc)
	 *
	 * @see ldap.advance.example.UserRepository#createUser(ldap.advance.example.User)
	 */

	public void createUser(UserProfileDTO user) {
		log.info("executing {createUser}");
		String userName = user.getUserName();

		Attribute objectClass = new BasicAttribute("objectClass");
		{
			objectClass.add("top");
			objectClass.add("uidObject");
			objectClass.add("person");
			objectClass.add("organizationalPerson");
		}

		Attributes userAttributes = new BasicAttributes();
		userAttributes.put(objectClass);
		userAttributes.put(env.getUserNameAttribute(), userName);
		userAttributes.put(env.getUserPasswordAttribute(), user.getPassword());
		userAttributes.put(env.getCommonNameAttribute(), userName);
		userAttributes.put(env.getSurNameAttribute(), userName);

		ldapTemplate.bind(buildDn(userName), null, userAttributes);
	}

	/**
	 * Remove the user with the specified userName from the directory.
	 * 
	 * @param userName
	 *            The username to delete.
	 */

	public void removeUser(String dn) {
		// ldapTemplate.unbind(bindDN(userName));
		ldapTemplate.unbind(dn);
	}

	@SuppressWarnings("deprecation")
	private Name buildDn(String uId) {
		DistinguishedName dn = new DistinguishedName();
		dn.add("ou","People");
	    dn.add("uid", uId );      

		return dn;
	}


	//TODO: implement this when needed
	public boolean checkPassword(String userName, String password) {
		log.info("executing {authenticate}");
		return ldapTemplate.authenticate(env.getUserBaseDn(), "(uid="+ userName + ")", password);
	}

	
}