package gov.va.med.mhv.usermgmt.data.repository;

import gov.va.med.mhv.usermgmt.data.model.Activity;

import java.util.Date;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;


@Repository
public interface ActivityRepository extends JpaRepository<Activity, Long>{
	 
	 List<Activity> findByUserProfileId(@Param("userProfileId")Long userProfileId);
	 
	 List<Activity> findByUserProfileIdAndActivityType(@Param("userProfileId") Long userProfileId, @Param("activityType") String activityType);
	 
	 @Query("select a from Activity a where a.completionTime between :fromDate  and  :toDate and  "
		 		+ " a.performerType = :performerType and a.userProfileId in (select up.id from UserProfile up where up.userName = :userName) order by a.completionTime desc")	
	 List<Activity>  getActivitiesForSubject(@Param ("fromDate") Date fromDate,@Param ("toDate") Date toDate,
			                 @Param ("performerType")  String performerType, @Param ("userName") String userName);
	 
	 
	 @Query("select a from Activity a where a.completionTime between :fromDate  and  :toDate and  "
		 		+ "a.userProfileId in (select up.id from UserProfile up where up.userName = :userName) order by a.completionTime desc")	
	 List<Activity>  getActivitiesEveryone(@Param ("fromDate") Date fromDate,@Param ("toDate") Date toDate,@Param ("userName") String userName);

      
	 @Query("select a from Activity a where a.completionTime between :fromDate  and  :toDate and  "
		 		+ " a.performerType <> 'Self' and a.userProfileId in (select up.id from UserProfile up where up.userName = :userName) order by a.completionTime desc")	
	 List<Activity>  getActivitiesEveryoneButSelf(@Param ("fromDate") Date fromDate,@Param ("toDate") Date toDate,@Param ("userName") String userName);

	 @Modifying
	 @Transactional
	 @Query("Delete from Activity u where u.userProfileId= :userProfileId")
	 void deleteByUserProfileId(@Param("userProfileId") Long userProfileId);
	 
	 @Query("select a from Activity a where a.userProfileId = :userProfileId and a.activityType='Login' and a.performerType='Self' order by a.completionTime desc")  
	 List<Activity> getLoginActivities(@Param("userProfileId") Long userProfileId);

}
