package gov.va.med.mhv.usermgmt.data.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import gov.va.med.mhv.common.data.model.AbstractBaseEntity;
import gov.va.med.mhv.common.data.model.UserProfile;

@Entity
@Table(name = "USER_PROFILE_ACCESS_CONTROL")
public class UserProfileAccessControl extends AbstractBaseEntity {

	private static final long serialVersionUID = -7823317184848665135L;

	@Id
	@Column(name = "USER_PROFILE_ACCESS_CONTROL_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "PERMISSIONS")
	private Long permissions;

	@Column(name = "USER_PROFILE_ID", insertable = false, updatable = false)
	private Long userProfileId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "USER_PROFILE_ID")
	private UserProfile userProfile;

	@Column(name = "ACCESS_FEATURE_ID", insertable = false, updatable = false)
	private Long accessFeatureId;

	@ManyToOne(fetch = FetchType.LAZY)
	@JoinColumn(name = "ACCESS_FEATURE_ID")
	private AccessFeature accessFeature;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Long getPermissions() {
		return permissions;
	}

	public void setPermissions(Long permissions) {
		this.permissions = permissions;
	}

	public Long getUserProfileId() {
		return userProfileId;
	}

	public void setUserProfileId(Long userProfileId) {
		this.userProfileId = userProfileId;
	}

	public UserProfile getUserProfile() {
		return userProfile;
	}

	public void setUserProfile(UserProfile userProfile) {
		this.userProfile = userProfile;
	}

	public Long getAccessFeatureId() {
		return accessFeatureId;
	}

	public void setAccessFeatureId(Long accessFeatureId) {
		this.accessFeatureId = accessFeatureId;
	}
	
	public AccessFeature getAccessFeature() {
		return accessFeature;
	}
	
	public void setAccessFeature(AccessFeature accessFeature) {
		this.accessFeature = accessFeature;
	}
}
