package gov.va.med.mhv.usermgmt.data.model;

import java.util.Date;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

import gov.va.med.mhv.common.data.model.AbstractBaseEntity;

@Entity
@Table(name="MPI_EVENTS")
public class MpiEvent extends AbstractBaseEntity{
	
	private static final long serialVersionUID = -5839553971604731710L;
	
	@Id
	@GeneratedValue(strategy=GenerationType.AUTO)
	@Column(name="ID")
	private  Long id;
	
	@Column(name="OPLOCK")
	private Long oplock;
	
	@Column(name="CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;
	
	@Column(name="MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;
	
	@Column(name="CORRELATION_ID")
	private String correlationId;
	
	@Column(name="USER_ID")
	private Long userId;
	
	@Column(name="STATUS")
	private String status;
	
	@Column(name="EVENT_TYPE")
	private String eventType;
	
	@OneToMany(mappedBy="event",cascade=CascadeType.ALL,fetch=FetchType.LAZY)
	private Set<Trace> traces;
	
	public Long getId() {
		return id;
	}
	public void setId(Long id) {
		this.id = id;
	}
	public Long getOplock() {
		return oplock;
	}
	public void setOplock(Long oplock) {
		this.oplock = oplock;
	}
	public Date getCreatedDate() {
		return createdDate;
	}
	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}
	public Date getModifiedDate() {
		return modifiedDate;
	}
	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}
	public String getCorrelationId() {
		return correlationId;
	}
	public void setCorrelationId(String correlationId) {
		this.correlationId = correlationId;
	}
	public Long getUserId() {
		return userId;
	}
	public void setUserId(Long userId) {
		this.userId = userId;
	}
	public String getStatus() {
		return status;
	}
	public void setStatus(String status) {
		this.status = status;
	}
	public String getEventType() {
		return eventType;
	}
	public void setEventType(String eventType) {
		this.eventType = eventType;
	}
	public Set<Trace> getTraces() {
		return traces;
	}
	public void setTraces(Set<Trace> traces) {
		this.traces = traces;
	}
	
	public void addTrace(Trace trace) {
		trace.setEvent(this);
		this.getTraces().add(trace);
	}
}
