package gov.va.med.mhv.usermgmt.data.model;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import gov.va.med.mhv.common.data.model.AbstractBaseEntity;

@Entity
@Table(name = "ACCESS_FEATURE")
public class AccessFeature extends AbstractBaseEntity {

	private static final long serialVersionUID = 1864236299206794302L;

	@Id
	@Column(name = "ACCESS_FEATURE_ID")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock;

	@Column(name = "NAME")
	private String name;

	@Column(name = "ACCESS_DOMAIN_ID", insertable = false, updatable = false)
	private Long accessDomainId;

	@ManyToOne //(fetch = FetchType.LAZY)
	@JoinColumn(name = "ACCESS_DOMAIN_ID")
	private AccessDomain accessDomain;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public Long getAccessDomainId() {
		return accessDomainId;
	}

	public void setAccessDomainId(Long accessDomainId) {
		this.accessDomainId = accessDomainId;
	}

	public AccessDomain getAccessDomain() {
		return accessDomain;
	}

	public void setAccessDomain(AccessDomain accessDomain) {
		this.accessDomain = accessDomain;
	}
}
