/**
 * 
 */
package gov.va.med.mhv.usermgmt.converter;

import java.util.ArrayList;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.data.model.Activity;

/**
 * @author DNS   egberb
 *
 */
@Component
public class ActivityDTOListConverter implements Converter<List<ActivityDTO>, List<Activity>> {

	@Autowired
	private ActivityDTOConverter activityDtoConverter;
	
	@Override
	public List<Activity> convert(List<ActivityDTO> source) {
		List<Activity> destination = new ArrayList<Activity>();
		
		for(ActivityDTO a : source) {
			destination.add(activityDtoConverter.convert(a));
		}
		
		return destination;
	}
}
