package gov.va.med.mhv.core.messages;


/**
 * Enumeration class for message severities.  There is a severity enumerated
 * value available for each possible severity that a message could have.
 * Severity instances may be obtained using the static <code>getSeverity</code>
 * method, passing in one of the constant strings provided by this class.
 */
public enum Severity {

	ERROR("Error"),
	INFORMATIONAL("Informational");
	
	private final String enumValue;
	
	/** Constructor is private - use <code>getSeverity</code> to obtain instances. */
	private Severity(String severity) {
		this.enumValue = severity;
	}

}
