package gov.va.med.mhv.usermgmt.ws;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

@Path("/xxx/")
@Service("emergencyContactService")
public interface EmergencyContactWService {

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/emergencycontact/getContactsResponse/{userProfileid}")
	public String getEmergencyContactsResponse(@PathParam("userProfileid") String userProfileid);
	
	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/emergencycontact/getContacts/{userProfileid}")
	public String getEmergencyContacts(@PathParam("userProfileid") String userProfileid);
	
	@POST
	@Path("/emergencycontact/saveContact")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public String saveEmergencyContact(String emergencyContactJSON);
	
	@POST
	@Path("/emergencycontact/deleteContact")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public String deleteEmergencyContact(String emergencyContactJSON);
	
	@GET
	@Path("/emergencycontact/ping/{message}")
	@Produces("text/plain")
	public String ping(@PathParam("message") String message);

}
