package gov.va.med.mhv.usermgmt.service.provider;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import com.fasterxml.jackson.databind.ObjectMapper;

import gov.va.med.mhv.usermgmt.common.dto.ActivitySearchCriteriaDTO;

public class ActivitySearchCriteriaParamConverterProvider implements ParamConverterProvider {
	
	private ObjectMapper mapper;
	
	@Override
	public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
		if( ActivitySearchCriteriaDTO.class.equals(rawType) ) {
			return (ParamConverter<T>) new AcivitySearchCriteriaParamConverter(getMapper());
		}
		
		return null;
	}
	
	public void setMapper(ObjectMapper mapper) {
		this.mapper = mapper;
	}
	
	public ObjectMapper getMapper() {
		return mapper;
	}

}

class AcivitySearchCriteriaParamConverter implements ParamConverter<ActivitySearchCriteriaDTO> {
	
	private static final Logger LOG = LogManager.getLogger(AcivitySearchCriteriaParamConverter.class);
	
	private ObjectMapper mapper;
	
	public AcivitySearchCriteriaParamConverter(ObjectMapper mapper) {
		this.mapper = mapper;
	}
	
	@Override
	public ActivitySearchCriteriaDTO fromString(String value) {
		try {
			LOG.info(String.format("Desrializing value: %s", value));
			return mapper.readValue(value, ActivitySearchCriteriaDTO.class);
		} catch (Exception ex) {
			throw new WebApplicationException(ex, Status.INTERNAL_SERVER_ERROR);
		}
	}
	
	@Override
	public String toString(ActivitySearchCriteriaDTO value) {
		try {
			String strValue = mapper.writeValueAsString(value);
			LOG.info(String.format("Serializing value: %s", strValue));
			return strValue;
		} catch (Exception ex) {
			throw new WebApplicationException(ex, Status.INTERNAL_SERVER_ERROR);
		}
	}
	
	
}