package gov.va.med.mhv.usermgmt.service;

import java.util.Date;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.common.api.dto.EmergencyContactDTO;
import gov.va.med.mhv.common.api.dto.InPersonAuthenticationDTO;
import gov.va.med.mhv.common.api.dto.PatientDTO;
import gov.va.med.mhv.common.api.dto.UserProfileDTO;
import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.usermgmt.common.dto.EauthHashDTO;
import gov.va.med.mhv.usermgmt.common.dto.FieldTestDTO;
import gov.va.med.mhv.usermgmt.common.dto.HealthCareProviderDTO;
import gov.va.med.mhv.usermgmt.common.dto.UserAcceptTermsHistoryDTO;
import gov.va.med.mhv.usermgmt.common.dto.HealthInfoDTO;

@Path("/")
@Service("userMgmtService")
public interface UserMgmtService {

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/userprofile")
	public UserProfileDTO getUserProfile(@QueryParam("firstName") String firstName, @QueryParam("lastName") String lastName, @QueryParam("gender") String gender, @QueryParam("birthDae")Date birthDate) throws MHVException;
	
	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/validatehintanswers")
	public Boolean validateHintAnswers(@QueryParam("userProfileId") Long userProfileId, @QueryParam("answer1") String answer1, @QueryParam("answer2") String answer2) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/userprofile/{userName}")
	public UserProfileDTO getUserProfile(@PathParam("userName") String userName) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/userprofile/byId/{userProfileId}")
	public UserProfileDTO getUserProfileById(@PathParam("userProfileId") Long id) throws MHVException;

	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/userprofile")
	public UserProfileDTO saveUserProfile(UserProfileDTO userProfile) throws MHVException;

	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/eauthhashdelete/{userProfileId}")
	public void deleteEauthHashByUserProfileId(@PathParam("userProfileId") Long userProfileId) throws MHVException;

	@GET
	@Path("/eauthhash/{userProfileId}")
	@Produces(MediaType.APPLICATION_JSON)
	public List<EauthHashDTO> findEAuthHashByUserProfileId(@PathParam("userProfileId") Long userProfileId) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/fieldTestGroups/{userName}")
	public List<FieldTestDTO> getFieldTestGroupsByUserName(@PathParam("userName") String userName) throws MHVException;

	@GET
	@Path("/postLoginUpdateUser/{userProfileId}")
	@Produces(MediaType.APPLICATION_JSON)
	public UserProfileDTO postLoginUpdateUser(@PathParam("userProfileId")Long userProfileId) throws MHVException;

	@GET
	@Path("/healthInfo/{userProfileId}")
	@Produces(MediaType.APPLICATION_JSON)
	public HealthInfoDTO getHealthInfo(@PathParam("userProfileId")Long userProfileId) throws MHVException;

	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/changepassword/{isForgotUserPwd}")
	public UserProfileDTO changePassword(UserProfileDTO userProfileJSON,@PathParam("isForgotUserPwd")Boolean isForgotUserPwd) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/emergencycontacts/{userProfileId}")
	public List<EmergencyContactDTO> getEmergencyContacts(@PathParam("userProfileId") Long userProfileId) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/emergencycontact/{emergencyContactId}")
	public EmergencyContactDTO getEmergencyContact(@PathParam("emergencyContactId") Long emergencyContactId) throws MHVException;

	@POST
	@Path("/emergencycontact")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public void saveEmergencyContact(EmergencyContactDTO emergencyContact) throws MHVException;

	@POST
	@Path("/emergencycontact/deleteContact")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public void deleteEmergencyContact(EmergencyContactDTO emergencyContact) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/provider/{userProfileId}")
	public List<HealthCareProviderDTO> getHealthCareProviders(@PathParam("userProfileId") Long userProfileId) throws MHVException;

	@POST
	@Path("/provider")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public void saveHealthCareProvider(HealthCareProviderDTO provider) throws MHVException;

	@DELETE
	@Path("/provider")
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	public void deleteHealthCareProvider(Long providerId) throws MHVException;

	@GET
	@Path("/patient/{userProfileId}")
	@Produces(MediaType.APPLICATION_JSON)
	public PatientDTO getPatient(@PathParam("userProfileId") Long userProfileId) throws MHVException;

	@GET
	@Path("/ispatientauthenticated/{patientId}")
	@Produces(MediaType.APPLICATION_JSON)
	public Boolean isPatientIPA(@PathParam("patientId")Long patientId) throws MHVException;

	@GET
	@Path("/inpersonauthentication/{patientId}")
	@Produces(MediaType.APPLICATION_JSON)
	public InPersonAuthenticationDTO getPatientIPA(@PathParam("patientId")Long patientId) throws MHVException;

	@GET
	@Path("/rxipacheck/{patientId}")
	@Produces(MediaType.APPLICATION_JSON)
	public String DoRxIPACheck(@PathParam("patientId")Long patientId) throws MHVException;


	@PUT
	@Path("/treatmentfacilities/{patientId}")
	public PatientDTO updateTreatmentFacilitiesForExistingPatients(@PathParam("patientId")Long patientId) throws MHVException;

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/userTcAccepted/{userProfileId}")
	public Date getLatestUserTcAcceptedTimeStamp(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	
	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/isTempPasswdExpired/{userProfileId}")
	public Boolean isTempPasswdExpired(@PathParam("userProfileId") Long userProfileId) throws MHVException;
	
	
	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/isLatestPwdTemporary/{userProfileId}")
	public Boolean isLatestPasswordInHistTableTemporay(@PathParam("userProfileId") Long userProfileId) throws MHVException;

 	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/checkvar/{patientid}")
 	public Boolean checkVAREligibilityForPatient(@PathParam("patientid") Long patientid) throws MHVException;
 	
 	
	@POST
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/changeTempPassword/{isForgotUserPwd}")
	public UserProfileDTO changeTemporaryPassword(UserProfileDTO userProfileJSON,@PathParam("isForgotUserPwd") Boolean isForgotUserPwd) throws MHVException;


}
