package gov.va.med.mhv.usermgmt.service;

import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.usermgmt.common.dto.MyLinksDTO;

@Path("/")
@Service("myLinksService")
public interface MyLinksService {
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/ping/{sampleText}")
	public String test(@PathParam("sampleText") String sampleText);

	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/mylinks/byuser/{userId}")
	public List<MyLinksDTO> getMyLinksByUserId(@PathParam("userId") Long userId);
	
	@GET
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/mylinks/bylink/{myLinkId}")
	public MyLinksDTO getMyLinksById(@PathParam("myLinkId") Long myLinkId);
	
	@POST
	@Produces(MediaType.APPLICATION_JSON)
	@Consumes(MediaType.APPLICATION_JSON)
	@Path("/mylinks")
	public ResponseUtil saveMyLink(MyLinksDTO mylink);
	
	@DELETE
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/mylinks/{myLinkId}")
	public ResponseUtil deleteMyLink(@PathParam("myLinkId") Long myLinkId);	

	
}
