package gov.va.med.mhv.usermgmt.service;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

import org.springframework.stereotype.Service;

import gov.va.med.mhv.common.api.util.ResponseUtil;


@Path("/")
@Service("ipaWebService")
public interface InPersonAuthenticationWebService {

	/**
	 * Execute the GetIPAPatientById operation
	 * 
	 * @param patientId
	 * @return InPersonAuthenticationServiceResponse
	 */
	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/ipa/{patientId}")
	public String getIPAPatientById(@PathParam("patientId") Long patientId);

	@GET
	@Consumes(MediaType.APPLICATION_JSON)
	@Produces(MediaType.APPLICATION_JSON)
	@Path("/ispatientauthenticated/{patientId}")
	public ResponseUtil isPatientAuthenticated(@PathParam("patientId") Long patientId);
}
